/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tef3;

import app.tuxguitar.io.tef3.base.TEAnchorPosition;
import app.tuxguitar.io.tef3.base.TEChordDefinition;
import app.tuxguitar.io.tef3.base.TEComponentAccent;
import app.tuxguitar.io.tef3.base.TEComponentBase;
import app.tuxguitar.io.tef3.base.TEComponentBeamBreak;
import app.tuxguitar.io.tef3.base.TEComponentChord;
import app.tuxguitar.io.tef3.base.TEComponentConnection;
import app.tuxguitar.io.tef3.base.TEComponentCrescendo;
import app.tuxguitar.io.tef3.base.TEComponentDrumChange;
import app.tuxguitar.io.tef3.base.TEComponentEnding;
import app.tuxguitar.io.tef3.base.TEComponentGraceNoteMetadata;
import app.tuxguitar.io.tef3.base.TEComponentLineBreak;
import app.tuxguitar.io.tef3.base.TEComponentNote;
import app.tuxguitar.io.tef3.base.TEComponentRest;
import app.tuxguitar.io.tef3.base.TEComponentScaleDiagram;
import app.tuxguitar.io.tef3.base.TEComponentSpacingMarker;
import app.tuxguitar.io.tef3.base.TEComponentStemLength;
import app.tuxguitar.io.tef3.base.TEComponentSymbol;
import app.tuxguitar.io.tef3.base.TEComponentSyncopation;
import app.tuxguitar.io.tef3.base.TEComponentTempoChange;
import app.tuxguitar.io.tef3.base.TEComponentTextEvent;
import app.tuxguitar.io.tef3.base.TEComponentVoiceChange;
import app.tuxguitar.io.tef3.base.TEFileMetadata;
import app.tuxguitar.io.tef3.base.TEFontPreset;
import app.tuxguitar.io.tef3.base.TELyrics;
import app.tuxguitar.io.tef3.base.TEMeasure;
import app.tuxguitar.io.tef3.base.TENoteDuration;
import app.tuxguitar.io.tef3.base.TEPosition;
import app.tuxguitar.io.tef3.base.TEPrintMetadata;
import app.tuxguitar.io.tef3.base.TEReadingListEntry;
import app.tuxguitar.io.tef3.base.TESong;
import app.tuxguitar.io.tef3.base.TESongMetadata;
import app.tuxguitar.io.tef3.base.TETimeSignature;
import app.tuxguitar.io.tef3.base.TETrack;
import app.tuxguitar.util.TGException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class TEInputStream {
    private TESong song;
    private InputStream stream;
    private static final int SIZE_OF_FOOTER = 4;

    public TEInputStream(InputStream stream) {
        this.stream = stream;
    }

    public TESong readSong() throws TGException {
        byte[] remainingBytes;
        int footer;
        this.song = new TESong();
        if (!this.readFileHeader()) {
            throw new TGException("Cannot decode tef v3 header");
        }
        this.readSongMetadata();
        if (this.song.getFileMetadata().getHasChords()) {
            this.readChordDefinitions();
        }
        int sizeOfMeasure = this.readShort() - 4;
        int measureCount = this.readShort();
        this.skip(4);
        this.readMeasures(measureCount, sizeOfMeasure);
        this.readTracks();
        this.readPrintMetadata();
        if (this.song.getFileMetadata().getHasReadingList()) {
            this.readReadingList();
        }
        if ((footer = (remainingBytes = this.readComponents())[0] << 24 | remainingBytes[1] << 16 | remainingBytes[2] << 8 | remainingBytes[3] & 0xFF) != -1) {
            throw new TGException(String.format("Unexpected footer! Expected: 0x%X. Received: 0x%X", -1, footer));
        }
        this.close();
        return this.song;
    }

    public boolean readFileHeader() {
        byte[] headerBytes = new byte[256];
        if (256 != this.readBytes(headerBytes)) {
            return false;
        }
        byte majorVersion = headerBytes[3];
        if (3 != majorVersion) {
            return false;
        }
        for (int i = 16; i < 24; ++i) {
            if (0 == headerBytes[i]) continue;
            return false;
        }
        if (116 != headerBytes[56]) {
            return false;
        }
        if (98 != headerBytes[57]) {
            return false;
        }
        if (101 != headerBytes[58]) {
            return false;
        }
        if (100 != headerBytes[59]) {
            return false;
        }
        int wOldNum = this.bytesToShort(headerBytes, 202);
        if (4 != wOldNum) {
            return false;
        }
        byte wFormatLo = headerBytes[204];
        if (4 != wFormatLo) {
            return false;
        }
        byte wFormatHi = headerBytes[205];
        if (10 != wFormatHi) {
            return false;
        }
        int initialBpm = this.bytesToShort(headerBytes, 6);
        int toneChorus = this.bytesToShort(headerBytes, 8);
        int toneReverb = this.bytesToShort(headerBytes, 10);
        TEFileMetadata.TEFileMetadataSyncopation syncopation = TEFileMetadata.TEFileMetadataSyncopation.getEnumFromInt((short)this.bytesToShort(headerBytes, 12));
        int posOfTextEvents = this.bytesToInt(headerBytes, 84);
        int posOfChords = this.bytesToInt(headerBytes, 88);
        int posOfReadingList = this.bytesToInt(headerBytes, 128);
        int posOfUrl = this.bytesToInt(headerBytes, 132);
        int posOfCopyright = this.bytesToInt(headerBytes, 140);
        TEFileMetadata fileMetadata = new TEFileMetadata(majorVersion, initialBpm, toneChorus, toneReverb, syncopation, posOfTextEvents != 0, posOfChords != 0, posOfCopyright != 0, posOfReadingList != 0, posOfUrl != 0);
        if (this.song != null) {
            this.song.setFileMetadata(fileMetadata);
        }
        return true;
    }

    private void readSongMetadata() {
        String songTitle = this.readShortString();
        String authorName = this.readShortString();
        String comments = this.readShortString();
        String notes = this.readShortString();
        String url = "";
        if (this.song.getFileMetadata().getHasUrl()) {
            url = this.readShortString();
        }
        String copyright = "";
        if (this.song.getFileMetadata().getHasCopyright()) {
            copyright = this.readShortString();
        }
        String lyricFullString = this.readShortString();
        List<TELyrics> lyrics = this.parseLyricString(lyricFullString);
        ArrayList<String> textEvents = new ArrayList<String>();
        if (this.song.getFileMetadata().getHasTextEvents()) {
            int totalTextEvents = this.readShort();
            for (int i = 0; i < totalTextEvents; ++i) {
                textEvents.add(this.readShortString());
            }
        }
        TESongMetadata songMetadata = new TESongMetadata(songTitle, authorName, comments, notes, url, copyright, lyrics, textEvents);
        this.song.setSongMetadata(songMetadata);
    }

    private List<TELyrics> parseLyricString(String fullLyricString) {
        String[] tracks;
        ArrayList<TELyrics> lyrics = new ArrayList<TELyrics>();
        for (String track : tracks = fullLyricString.split(">")) {
            int trackNumber = 0;
            int fontPresetInt = 0;
            int yPosition = 0;
            int unkOne = 0;
            int unkTwo = 0;
            String[] trackLines = track.split("\r\n");
            StringBuilder stringBuilder = new StringBuilder();
            block8: for (int line = 0; line < trackLines.length; ++line) {
                String trackLine = trackLines[line];
                if (line == 0) {
                    String[] trackMetadataParts = trackLine.split(" ");
                    int linePartType = 0;
                    for (String trackPart : trackMetadataParts) {
                        if (trackPart.length() == 0) continue;
                        switch (linePartType) {
                            case 0: {
                                trackNumber = trackPart.charAt(0) - 65;
                                ++linePartType;
                                break;
                            }
                            case 1: {
                                fontPresetInt = Integer.parseInt(trackPart.substring(1));
                                ++linePartType;
                                break;
                            }
                            case 2: {
                                boolean isNegative = trackPart.charAt(0) == '-';
                                yPosition = Integer.parseInt(trackPart.substring(1));
                                if (isNegative) {
                                    yPosition *= -1;
                                }
                                ++linePartType;
                                break;
                            }
                            case 3: {
                                unkOne = Integer.parseInt(trackPart.substring(1));
                                ++linePartType;
                                break;
                            }
                            case 4: {
                                unkTwo = Integer.parseInt(trackPart.substring(1));
                                ++linePartType;
                                break;
                            }
                        }
                        if (linePartType > 4) continue block8;
                    }
                    continue;
                }
                stringBuilder.append(trackLine);
                stringBuilder.append("\r\n");
            }
            stringBuilder.setLength(Math.max(stringBuilder.length() - 2, 0));
            TEFontPreset fontPreset = TEFontPreset.getEnumFromInt(fontPresetInt);
            TELyrics lyric = new TELyrics(trackNumber, fontPreset, yPosition, stringBuilder.toString());
            lyrics.add(lyric);
        }
        return lyrics;
    }

    private void readChordDefinitions() {
        int chordStructSize = this.readShort();
        int totalChords = this.readShort();
        ArrayList<TEChordDefinition> chordDefinitions = new ArrayList<TEChordDefinition>();
        for (int chordIndex = 0; chordIndex < totalChords; ++chordIndex) {
            byte[] chordBytes = new byte[chordStructSize];
            this.readBytes(chordBytes);
            ByteArrayInputStream chordStream = new ByteArrayInputStream(chordBytes);
            int numOfStringsInChord = 7;
            int[] chordFrets = new int[numOfStringsInChord];
            TEChordDefinition.TEChordFretSymbol[] chordSymbols = new TEChordDefinition.TEChordFretSymbol[numOfStringsInChord];
            for (int stringNum = 0; stringNum < numOfStringsInChord; ++stringNum) {
                BitSet fretBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(chordStream)});
                int fret = this.bitsetToInt(fretBitset.get(0, 5));
                TEChordDefinition.TEChordFretSymbol symbol = TEChordDefinition.TEChordFretSymbol.getEnumFromInt(this.bitsetToInt(fretBitset.get(5, 8)));
                chordFrets[stringNum] = fret;
                chordSymbols[stringNum] = symbol;
            }
            this.skip(chordStream, numOfStringsInChord);
            int chordNameMaxLength = 17;
            String chordName = this.readNullTerminatedString(chordStream, chordNameMaxLength - 1);
            this.skip(chordStream, chordNameMaxLength - chordName.length() - 1);
            int anchorFret = this.readByte(chordStream);
            this.skip(chordStream, 4);
            this.close(chordStream);
            TEChordDefinition chordDefinition = new TEChordDefinition(chordFrets, chordSymbols, chordName, anchorFret);
            chordDefinitions.add(chordDefinition);
        }
        this.song.setChordDefinitions(chordDefinitions);
    }

    private void readMeasures(int measureCount, int sizeOfMeasure) {
        ArrayList<TEMeasure> measures = new ArrayList<TEMeasure>();
        for (int i = 0; i < measureCount; ++i) {
            byte[] measureBytes = new byte[sizeOfMeasure];
            this.readBytes(measureBytes);
            ByteArrayInputStream measureStream = new ByteArrayInputStream(measureBytes);
            TEMeasure measure = new TEMeasure();
            BitSet flagByte = BitSet.valueOf(new byte[]{(byte)this.readByte(measureStream)});
            measure.setDoNotPrintMetric(flagByte.get(0));
            measure.setFreeBarOne(flagByte.get(1));
            measure.setFreeBarTwo(flagByte.get(2));
            measure.setPickupMeasure(flagByte.get(3));
            measure.setAdlibMeasure(flagByte.get(4));
            measure.setMinorKey(flagByte.get(5));
            measure.setDottedBarLine(flagByte.get(6));
            measure.setHalfBarLine(flagByte.get(7));
            this.skip(measureStream, 1);
            measure.setKeySignature(this.readByte(measureStream));
            this.skip(measureStream, 1);
            int tsDenominator = this.readByte(measureStream);
            int tsNumerator = this.readByte(measureStream);
            TETimeSignature timeSignature = new TETimeSignature(tsNumerator, tsDenominator);
            measure.setTimeSignature(timeSignature);
            measure.setLeftWidthPadding(this.readByte(measureStream));
            this.skip(measureStream, 1);
            this.close(measureStream);
            measures.add(measure);
        }
        this.song.setMeasures(measures);
    }

    private void readTracks() {
        int maxTrackSize = this.readShort();
        int trackCount = this.readShort();
        int totalStringsAllTracks = 0;
        ArrayList<TETrack> tracks = new ArrayList<TETrack>();
        for (int i = 0; i < trackCount; ++i) {
            byte[] instrumentBytes = new byte[maxTrackSize];
            this.readBytes(instrumentBytes);
            ByteArrayInputStream instrumentStream = new ByteArrayInputStream(instrumentBytes);
            int stringCount = this.readByte(instrumentStream);
            totalStringsAllTracks += stringCount;
            this.skip(instrumentStream, 7);
            int midiInstrumentType = this.readByte(instrumentStream);
            this.skip(instrumentStream, 2);
            TETrack.TETrackTransposition transposition = TETrack.TETrackTransposition.getEnumFromInt(this.readByte(instrumentStream));
            int capo = this.readByte(instrumentStream);
            this.skip(instrumentStream, 1);
            TETrack.TETrackMiddleCoffset middleCoffset = TETrack.TETrackMiddleCoffset.getEnumFromInt(this.readByte(instrumentStream) - 12);
            BitSet flagByte1 = BitSet.valueOf(new byte[]{(byte)this.readByte(instrumentStream)});
            TETrack.TETrackClef clef = TETrack.TETrackClef.getEnumFromInt(this.bitsetToInt(flagByte1.get(0, 3)));
            boolean grandStaff = flagByte1.get(3);
            boolean squareBracket = flagByte1.get(4);
            this.skip(instrumentStream, 1);
            int pan = this.readByte(instrumentStream);
            int volume = this.readByte(instrumentStream);
            BitSet flagByte2 = BitSet.valueOf(new byte[]{(byte)this.readByte(instrumentStream)});
            boolean doubleStrings = flagByte2.get(0);
            boolean letRing = flagByte2.get(1);
            boolean pedalSteelGuitar = flagByte2.get(2);
            boolean multipleAudioChannels = flagByte2.get(3);
            boolean rhythmTrack = flagByte2.get(4);
            byte[] tuning = new byte[stringCount];
            this.readBytes(instrumentStream, tuning);
            this.skip(instrumentStream, 12 - stringCount);
            String instrumentName = this.readNullTerminatedString(instrumentStream, maxTrackSize);
            TETrack track = new TETrack(stringCount, midiInstrumentType, transposition, capo, middleCoffset, clef, grandStaff, squareBracket, pan, volume, doubleStrings, letRing, pedalSteelGuitar, multipleAudioChannels, rhythmTrack, tuning, instrumentName);
            tracks.add(track);
            this.close(instrumentStream);
        }
        this.song.setTotalStringCount(totalStringsAllTracks);
        this.song.setTracks(tracks);
    }

    private void readPrintMetadata() {
        int printDataLength = this.readByte();
        this.skip(1);
        String unkWithPageFooter = this.readNullTerminatedString(printDataLength);
        this.skip(printDataLength - unkWithPageFooter.length() - 1);
        int maxHeaderSize = 128;
        String firstPageHeader = this.readNullTerminatedString(maxHeaderSize - 1);
        this.skip(maxHeaderSize - firstPageHeader.length() - 1);
        String secondaryPageHeader = this.readNullTerminatedString(maxHeaderSize - 1);
        this.skip(maxHeaderSize - secondaryPageHeader.length() - 1);
        TEPrintMetadata printMetadata = new TEPrintMetadata(unkWithPageFooter, firstPageHeader, secondaryPageHeader);
        this.song.setPrintMetadata(printMetadata);
    }

    private void readReadingList() {
        int sizeOfReadingListEntry = this.readShort();
        int totalReadingListEntries = this.readShort();
        ArrayList<TEReadingListEntry> readingListEntries = new ArrayList<TEReadingListEntry>();
        for (int i = 0; i < totalReadingListEntries; ++i) {
            byte[] readingListBytes = new byte[sizeOfReadingListEntry];
            this.readBytes(readingListBytes);
            ByteArrayInputStream readingListStream = new ByteArrayInputStream(readingListBytes);
            int startMeasure = this.readShort(readingListStream);
            int endMeasure = this.readShort(readingListStream);
            String name = this.readNullTerminatedString(readingListStream, sizeOfReadingListEntry - 5);
            TEReadingListEntry readingListEntry = new TEReadingListEntry(startMeasure, endMeasure, name);
            readingListEntries.add(readingListEntry);
        }
        this.song.setReadingListEntries(readingListEntries);
    }

    private byte[] readComponents() throws TGException {
        int remainingBytes;
        byte[] componentBytes = new byte[12];
        this.song.setComponents(new ArrayList<TEComponentBase>());
        while ((remainingBytes = this.readBytes(componentBytes)) == 12) {
            ByteArrayInputStream componentStream = new ByteArrayInputStream(componentBytes);
            int location = this.readInt(componentStream);
            TEPosition position = TEPosition.createPositionFromLocation(this.song, location);
            int componentTypeFull = this.readByte(componentStream);
            switch (componentTypeFull) {
                case 51: {
                    this.readRestComponent(componentStream, position);
                    break;
                }
                case 53: {
                    this.readChordComponent(componentStream, position);
                    break;
                }
                case 54: {
                    this.readLineBreakComponent(componentStream, position);
                    break;
                }
                case 55: {
                    this.readAccentComponent(componentStream, position);
                    break;
                }
                case 56: {
                    this.readCrescendoComponent(componentStream, position);
                    break;
                }
                case 57: {
                    this.readTextEventComponent(componentStream, position);
                    break;
                }
                case 61: {
                    this.readConnectionComponent(componentStream, position);
                    break;
                }
                case 117: {
                    this.readScaleDiagramComponent(componentStream, position);
                    break;
                }
                case 120: {
                    this.readDrumChangeComponent(componentStream, position);
                    break;
                }
                case 125: {
                    int firstByte = this.readByte(componentStream);
                    if (firstByte == 0) {
                        this.readSpacingMarkerComponent(componentStream, position, firstByte);
                        break;
                    }
                    this.readGraceNoteMetadataComponent(componentStream, position, firstByte);
                    break;
                }
                case 126: {
                    this.readVoiceChangeComponent(componentStream, position);
                    break;
                }
                case 182: {
                    this.readSymbolComponent(componentStream, position);
                    break;
                }
                case 183: {
                    this.readEndingComponent(componentStream, position);
                    break;
                }
                case 189: {
                    this.readBeamBreakComponent(componentStream, position);
                    break;
                }
                case 190: {
                    this.readStemLengthComponent(componentStream, position);
                    break;
                }
                case 253: {
                    this.readSyncopationComponent(componentStream, position);
                    break;
                }
                case 254: {
                    this.readTempoChangeComponent(componentStream, position);
                    break;
                }
                default: {
                    int componentTypeLowerBits = componentTypeFull & 0x1F;
                    if (componentTypeLowerBits > 0 && componentTypeLowerBits <= 25) {
                        this.readNoteComponent(componentStream, position, componentTypeFull);
                        break;
                    }
                    throw new TGException(String.format("Unexpected component! Received: 0x%X", componentTypeFull));
                }
            }
            this.close(componentStream);
        }
        if (remainingBytes != 4) {
            throw new TGException(String.format("Unexpected size for footer! Received: %s. Valid bytes: %d", Arrays.toString(componentBytes), remainingBytes));
        }
        return componentBytes;
    }

    private void readNoteComponent(ByteArrayInputStream componentStream, TEPosition position, int componentType) {
        int fret = (componentType & 0x1F) - 1;
        BitSet noteFlags = BitSet.valueOf(new byte[]{(byte)componentType});
        boolean isGraceNote = noteFlags.get(6);
        boolean isPitchShifted = noteFlags.get(7);
        BitSet bitsetDurationDynamic = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        TENoteDuration duration = TENoteDuration.getEnumFromInt(this.bitsetToInt(bitsetDurationDynamic.get(0, 5)));
        TEComponentNote.TEComponentNoteDynamics dynamics = TEComponentNote.TEComponentNoteDynamics.getEnumFromInt(this.bitsetToInt(bitsetDurationDynamic.get(5, 8)));
        BitSet bitSetEffectAttributes = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        TEComponentNote.TEComponentNoteEffect1 noteEffect1 = TEComponentNote.TEComponentNoteEffect1.getEnumFromInt(this.bitsetToInt(bitSetEffectAttributes.get(0, 4)));
        TEComponentNote.TEComponentNoteAttributes attributes = TEComponentNote.TEComponentNoteAttributes.getEnumFromInt(this.bitsetToInt(bitSetEffectAttributes.get(4, 6)));
        TEComponentNote.TEComponentNoteAlterations alterations = TEComponentNote.TEComponentNoteAlterations.getEnumFromInt(this.bitsetToInt(bitSetEffectAttributes.get(6, 8)));
        BitSet bitSetPitchShiftGraceNote = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        TEComponentNote.TEComponentNotePitchShift pitchShift = TEComponentNote.TEComponentNotePitchShift.getEnumFromInt(this.bitsetToInt(bitSetPitchShiftGraceNote.get(0, 3)));
        TEComponentNote.TEComponentNoteGraceNoteEffect graceNoteEffect = TEComponentNote.TEComponentNoteGraceNoteEffect.getEnumFromInt(this.bitsetToInt(bitSetPitchShiftGraceNote.get(5, 8)));
        int graceNoteFret = this.bitsetToInt(bitSetPitchShiftGraceNote.get(0, 5));
        BitSet bitSetEffects = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        TEComponentNote.TEComponentNoteEffect2 noteEffect2 = TEComponentNote.TEComponentNoteEffect2.getEnumFromInt(this.bitsetToInt(bitSetEffects.get(0, 4)));
        TEComponentNote.TEComponentNoteEffect3 noteEffect3 = TEComponentNote.TEComponentNoteEffect3.getEnumFromInt(this.bitsetToInt(bitSetEffects.get(4, 8)));
        BitSet bitSetFonts = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        TEFontPreset fontPreset = TEFontPreset.getEnumFromInt(this.bitsetToInt(bitSetFonts.get(0, 4)));
        boolean stabilo = bitSetFonts.get(4);
        BitSet bitSetFingerStroke = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int fingeringCombo = this.bitsetToInt(bitSetFingerStroke.get(0, 5));
        TEComponentNote.TEComponentNoteFingering firstFinger = TEComponentNote.TEComponentNoteFingering.getEnumFromInt(fingeringCombo % 6 - 1);
        TEComponentNote.TEComponentNoteFingering secondFinger = TEComponentNote.TEComponentNoteFingering.getEnumFromInt(fingeringCombo / 6);
        TEComponentNote.TEComponentNoteStroke stroke = TEComponentNote.TEComponentNoteStroke.getEnumFromInt(this.bitsetToInt(bitSetFingerStroke.get(5, 8)));
        BitSet bitsetNoteAttributes = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean hasNoStemNoFlag = bitsetNoteAttributes.get(2);
        boolean isExcludedFromBeaming = bitsetNoteAttributes.get(3);
        boolean isMoveToLeft = bitsetNoteAttributes.get(4) && !bitsetNoteAttributes.get(0);
        boolean isMoveToRight = bitsetNoteAttributes.get(4) && bitsetNoteAttributes.get(0);
        boolean isTieUpward = bitsetNoteAttributes.get(5) && !bitsetNoteAttributes.get(1);
        boolean isTieDownward = bitsetNoteAttributes.get(5) && bitsetNoteAttributes.get(1);
        boolean isOttavaBassa = bitsetNoteAttributes.get(6) && !hasNoStemNoFlag;
        boolean isOttavaAlta = bitsetNoteAttributes.get(6) && hasNoStemNoFlag;
        TEComponentNote note = new TEComponentNote(position, fret, isGraceNote, isPitchShifted, duration, dynamics, noteEffect1, attributes, alterations, pitchShift, graceNoteEffect, graceNoteFret, noteEffect2, noteEffect3, fontPreset, stabilo, firstFinger, secondFinger, stroke, hasNoStemNoFlag, isExcludedFromBeaming, isMoveToLeft, isMoveToRight, isTieUpward, isTieDownward, isOttavaBassa, isOttavaAlta);
        this.song.getComponents().add(note);
    }

    private void readTempoChangeComponent(ByteArrayInputStream componentStream, TEPosition position) {
        int bpm = this.readShort(componentStream);
        BitSet bitsetRallentando = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int rallentandoDuration = this.bitsetToInt(bitsetRallentando.get(0, 4));
        this.skip(componentStream, 4);
        TEComponentTempoChange tempoChange = new TEComponentTempoChange(position, bpm, rallentandoDuration);
        this.song.getComponents().add(tempoChange);
    }

    private void readVoiceChangeComponent(ByteArrayInputStream componentStream, TEPosition position) {
        int midiPatch = this.readByte(componentStream);
        int bankLSB = this.readByte(componentStream);
        int bankMSB = this.readByte(componentStream) / 2;
        this.skip(componentStream, 4);
        TEComponentVoiceChange voiceChange = new TEComponentVoiceChange(position, midiPatch, bankMSB, bankLSB);
        this.song.getComponents().add(voiceChange);
    }

    private void readDrumChangeComponent(ByteArrayInputStream componentStream, TEPosition position) {
        int drumPatch = this.readByte(componentStream);
        int volume = this.readByte(componentStream);
        int character = this.readByte(componentStream);
        this.skip(componentStream, 4);
        TEComponentDrumChange drumChange = new TEComponentDrumChange(position, drumPatch, volume, character);
        this.song.getComponents().add(drumChange);
    }

    private void readCrescendoComponent(ByteArrayInputStream componentStream, TEPosition position) {
        BitSet flagBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean decrescendo = flagBitset.get(4);
        int durationInSixteenthNotes = this.readByte(componentStream);
        int yPosition = this.readByte(componentStream);
        this.skip(componentStream, 3);
        TEAnchorPosition anchorPosition = TEAnchorPosition.getEnumFromInt(this.readByte(componentStream));
        TEComponentCrescendo crescendo = new TEComponentCrescendo(position, decrescendo, durationInSixteenthNotes, yPosition, anchorPosition);
        this.song.getComponents().add(crescendo);
    }

    private void readAccentComponent(ByteArrayInputStream componentStream, TEPosition position) {
        this.skip(componentStream, 1);
        int volume = this.readByte(componentStream);
        int yPosition = this.readByte(componentStream);
        int xPosition = this.readByte(componentStream);
        this.skip(componentStream, 2);
        TEAnchorPosition anchorPosition = TEAnchorPosition.getEnumFromInt(this.readByte(componentStream));
        TEComponentAccent accent = new TEComponentAccent(position, volume, yPosition, xPosition, anchorPosition);
        this.song.getComponents().add(accent);
    }

    private void readConnectionComponent(ByteArrayInputStream componentStream, TEPosition position) {
        BitSet durationDashBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int duration = this.bitsetToInt(durationDashBitset.get(0, 7)) + 1;
        boolean dashed = durationDashBitset.get(7);
        BitSet amplitudeNumberBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int amplitude = this.bitsetToInt(amplitudeNumberBitset.get(0, 4));
        int number = this.bitsetToInt(amplitudeNumberBitset.get(4, 8));
        int yPosition = this.readByte(componentStream);
        this.skip(componentStream, 3);
        BitSet bottomUpBracketBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean bottomUp = bottomUpBracketBitset.get(6);
        boolean bracket = bottomUpBracketBitset.get(7);
        TEComponentConnection connection = new TEComponentConnection(position, duration, dashed, amplitude, number, yPosition, bottomUp, bracket);
        this.song.getComponents().add(connection);
    }

    private void readLineBreakComponent(ByteArrayInputStream componentStream, TEPosition position) {
        this.skip(componentStream, 2);
        BitSet verticalSpacingBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int verticalSpacing = this.bitsetToInt(verticalSpacingBitset.get(4, 8));
        int nextLineIndex = this.readByte(componentStream);
        int measure = this.readShort(componentStream);
        BitSet lineBreakFlagsBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean truncateCurrentLine = lineBreakFlagsBitset.get(0);
        boolean pageBreak = lineBreakFlagsBitset.get(1);
        boolean doubleBar = lineBreakFlagsBitset.get(2);
        boolean timeSign = lineBreakFlagsBitset.get(3);
        TEComponentLineBreak lineBreak = new TEComponentLineBreak(position, verticalSpacing, nextLineIndex, measure, truncateCurrentLine, pageBreak, doubleBar, timeSign);
        this.song.getComponents().add(lineBreak);
    }

    private void readSyncopationComponent(ByteArrayInputStream componentStream, TEPosition position) {
        BitSet syncopationTypeBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int syncopationType = this.bitsetToInt(syncopationTypeBitset.get(0, 4)) - 8;
        this.skip(componentStream, 6);
        TEComponentSyncopation syncopation = new TEComponentSyncopation(position, syncopationType);
        this.song.getComponents().add(syncopation);
    }

    private void readSymbolComponent(ByteArrayInputStream componentStream, TEPosition position) {
        int symbol = this.readByte(componentStream);
        this.skip(componentStream, 1);
        int yPosition = this.readByte(componentStream);
        int xPosition = this.readByte(componentStream);
        this.skip(componentStream, 2);
        TEAnchorPosition anchorPosition = TEAnchorPosition.getEnumFromInt(this.readByte(componentStream));
        TEComponentSymbol symbolComponent = new TEComponentSymbol(position, symbol, yPosition, xPosition, anchorPosition);
        this.song.getComponents().add(symbolComponent);
    }

    private void readEndingComponent(ByteArrayInputStream componentStream, TEPosition position) {
        this.skip(componentStream, 1);
        BitSet endingBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int endingNumber = this.bitsetToInt(endingBitset.get(0, 3));
        TEComponentEnding.TEComponentEndingFlag endingFlags = TEComponentEnding.TEComponentEndingFlag.getEnumFromInt(this.bitsetToInt(endingBitset.get(3, 6)));
        boolean openBracket = endingBitset.get(6);
        boolean closeBracket = endingBitset.get(7);
        int yPosition = this.readByte(componentStream);
        int xPosition = this.readByte(componentStream);
        this.skip(componentStream, 3);
        TEComponentEnding ending = new TEComponentEnding(position, endingNumber, endingFlags, openBracket, closeBracket, yPosition, xPosition);
        this.song.getComponents().add(ending);
    }

    private void readScaleDiagramComponent(ByteArrayInputStream componentStream, TEPosition position) {
        this.skip(componentStream, 2);
        int yPosition = this.readByte(componentStream);
        int xPosition = this.readByte(componentStream);
        this.skip(componentStream, 2);
        TEAnchorPosition anchorPosition = TEAnchorPosition.getEnumFromInt(this.readByte(componentStream));
        TEComponentScaleDiagram scaleDiagram = new TEComponentScaleDiagram(position, yPosition, xPosition, anchorPosition);
        this.song.getComponents().add(scaleDiagram);
    }

    private void readBeamBreakComponent(ByteArrayInputStream componentStream, TEPosition position) {
        this.skip(componentStream, 7);
        TEComponentBeamBreak beamBreak = new TEComponentBeamBreak(position);
        this.song.getComponents().add(beamBreak);
    }

    private void readStemLengthComponent(ByteArrayInputStream componentStream, TEPosition position) {
        this.skip(componentStream, 2);
        int yPosition = this.readByte(componentStream);
        this.skip(componentStream, 4);
        TEComponentStemLength stemLength = new TEComponentStemLength(position, yPosition);
        this.song.getComponents().add(stemLength);
    }

    private void readSpacingMarkerComponent(ByteArrayInputStream componentStream, TEPosition position, int firstByte) {
        this.skip(componentStream, 2);
        int xPosition = this.readByte(componentStream);
        this.skip(componentStream, 3);
        TEComponentSpacingMarker spacingMarker = new TEComponentSpacingMarker(position, xPosition);
        this.song.getComponents().add(spacingMarker);
    }

    private void readRestComponent(ByteArrayInputStream componentStream, TEPosition position) {
        TENoteDuration duration = TENoteDuration.getEnumFromInt(this.readByte(componentStream));
        BitSet bitSetEffectAttributes = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean isUpperVoice = bitSetEffectAttributes.get(5) && !bitSetEffectAttributes.get(4);
        boolean isLowerVoice = bitSetEffectAttributes.get(5) && bitSetEffectAttributes.get(4);
        int yPosition = this.readByte(componentStream);
        boolean isSecondaryBeamBreak = this.readByte(componentStream) == 7;
        this.skip(componentStream, 2);
        BitSet bitsetRestAttributes = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean hiddenInNotation = bitsetRestAttributes.get(0);
        boolean hasNoStemNoFlag = bitsetRestAttributes.get(2);
        boolean isExcludedFromBeaming = bitsetRestAttributes.get(3);
        boolean isMoveToLeft = bitsetRestAttributes.get(4) && !hiddenInNotation;
        boolean isMoveToRight = bitsetRestAttributes.get(4) && hiddenInNotation;
        boolean hiddenInTablature = bitsetRestAttributes.get(5);
        TEComponentRest rest = new TEComponentRest(position, duration, isUpperVoice, isLowerVoice, yPosition, isSecondaryBeamBreak, hiddenInNotation, hasNoStemNoFlag, isExcludedFromBeaming, isMoveToLeft, isMoveToRight, hiddenInTablature);
        this.song.getComponents().add(rest);
    }

    private void readGraceNoteMetadataComponent(ByteArrayInputStream componentStream, TEPosition position, int firstByte) {
        TEComponentGraceNoteMetadata.TEComponentGraceNoteMetadataDuration duration = TEComponentGraceNoteMetadata.TEComponentGraceNoteMetadataDuration.getEnumFromInt(firstByte);
        this.skip(componentStream, 1);
        BitSet graceNoteStringBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int graceNoteString = this.bitsetToInt(graceNoteStringBitset.get(0, 7));
        boolean onDifferentString = graceNoteStringBitset.get(7);
        BitSet doubleNoteOneBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int doubleNoteOne = this.bitsetToInt(doubleNoteOneBitset.get(0, 7));
        boolean hasDoubleNoteOne = doubleNoteOneBitset.get(7);
        BitSet doubleNoteTwoBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        int doubleNoteTwo = this.bitsetToInt(doubleNoteTwoBitset.get(0, 7));
        boolean hasDoubleNoteTwo = doubleNoteTwoBitset.get(7);
        int xPosition = this.readByte(componentStream);
        BitSet flags = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        boolean noFlags = flags.get(0);
        boolean noSlur = flags.get(1);
        boolean stemDown = flags.get(2);
        boolean sharpOrFlat = flags.get(5);
        boolean acciaccatura = flags.get(6);
        TEComponentGraceNoteMetadata graceNoteMetadata = new TEComponentGraceNoteMetadata(position, duration, graceNoteString, onDifferentString, doubleNoteOne, hasDoubleNoteOne, doubleNoteTwo, hasDoubleNoteTwo, xPosition, noFlags, noSlur, stemDown, sharpOrFlat, acciaccatura);
        this.song.getComponents().add(graceNoteMetadata);
    }

    private void readChordComponent(ByteArrayInputStream componentStream, TEPosition position) {
        int chordIndex = this.readShort(componentStream);
        int yPosition = this.readByte(componentStream);
        int xPosition = this.readByte(componentStream);
        this.skip(componentStream, 2);
        TEAnchorPosition anchorPosition = TEAnchorPosition.getEnumFromInt(this.readByte(componentStream));
        TEComponentChord chord = new TEComponentChord(position, chordIndex, yPosition, xPosition, anchorPosition);
        this.song.getComponents().add(chord);
    }

    private void readTextEventComponent(ByteArrayInputStream componentStream, TEPosition position) {
        int textIndex = this.readShort(componentStream);
        int yPosition = this.readByte(componentStream);
        int xPosition = this.readByte(componentStream);
        BitSet fontPresetCenteredBitset = BitSet.valueOf(new byte[]{(byte)this.readByte(componentStream)});
        TEFontPreset fontPreset = TEFontPreset.getEnumFromInt(this.bitsetToInt(fontPresetCenteredBitset.get(0, 4)));
        boolean centeredText = fontPresetCenteredBitset.get(4);
        TEComponentTextEvent.TEComponentTextEventBorderType borderType = TEComponentTextEvent.TEComponentTextEventBorderType.getEnumFromInt(this.bitsetToInt(fontPresetCenteredBitset.get(0, 4)));
        TEAnchorPosition anchorPosition = TEAnchorPosition.getEnumFromInt(this.readByte(componentStream));
        TEComponentTextEvent textEvent = new TEComponentTextEvent(position, textIndex, yPosition, xPosition, fontPreset, centeredText, borderType, anchorPosition);
        this.song.getComponents().add(textEvent);
    }

    protected int bitsetToInt(BitSet bitset) {
        int value = 0;
        int bit = 0;
        while ((bit = bitset.nextSetBit(bit)) != -1) {
            value += 1 << bit;
            ++bit;
        }
        return value;
    }

    protected int readBytes(byte[] bytes) {
        return this.readBytes(this.stream, bytes);
    }

    protected int readBytes(InputStream stream, byte[] bytes) {
        try {
            return stream.read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    protected int readByte() {
        return this.readByte(this.stream);
    }

    protected int readByte(InputStream stream) {
        try {
            return stream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int readShort() {
        return this.readShort(this.stream);
    }

    protected int readShort(InputStream stream) {
        try {
            byte[] b = new byte[2];
            stream.read(b);
            return (b[1] & 0xFF) << 8 | b[0] & 0xFF;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int readInt() {
        return this.readInt(this.stream);
    }

    protected int readInt(InputStream stream) {
        try {
            byte[] b = new byte[4];
            stream.read(b);
            return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected String readShortString() {
        return this.readShortString(this.stream);
    }

    protected String readShortString(InputStream stream) {
        int byteRead;
        int strLength = this.readShort(stream);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < strLength && (byteRead = this.readByte(stream)) != 0; ++i) {
            char c = (char)byteRead;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    protected String readNullTerminatedString() {
        return this.readNullTerminatedString(this.stream, 256);
    }

    protected String readNullTerminatedString(int maxLength) {
        return this.readNullTerminatedString(this.stream, maxLength);
    }

    protected String readNullTerminatedString(InputStream stream) {
        return this.readNullTerminatedString(stream, 256);
    }

    protected String readNullTerminatedString(InputStream stream, int maxLength) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int lastByte;
            while ((lastByte = stream.read()) != 0 && lastByte != 0 && stringBuilder.length() <= maxLength) {
                char c = (char)lastByte;
                stringBuilder.append(c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    protected void skip(int count) {
        this.skip(this.stream, count);
    }

    protected void skip(InputStream stream, int count) {
        for (int i = 0; i < count; ++i) {
            this.readByte(stream);
        }
    }

    protected void close() {
        this.close(this.stream);
    }

    protected void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int bytesToShort(byte[] bytes, int offset) {
        return bytes[offset] | bytes[offset + 1] << 8;
    }

    private int bytesToInt(byte[] bytes, int offset) {
        return bytes[offset] | bytes[offset + 1] << 8 | bytes[offset + 2] << 16 | bytes[offset + 3] << 24;
    }
}

