/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.gm.port;

import app.tuxguitar.gm.port.GMReceiver;
import app.tuxguitar.player.base.MidiPlayerException;

public class GMReceiverProxy
implements GMReceiver {
    private GMReceiver receiver;

    public GMReceiverProxy(GMReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public void sendAllNotesOff() throws MidiPlayerException {
        this.receiver.sendAllNotesOff();
    }

    @Override
    public void sendNoteOn(int channel, int key, int velocity) throws MidiPlayerException {
        if (this.isValidChannel(channel)) {
            this.receiver.sendNoteOn(channel, key, velocity);
        }
    }

    @Override
    public void sendNoteOff(int channel, int key, int velocity) throws MidiPlayerException {
        if (this.isValidChannel(channel)) {
            this.receiver.sendNoteOff(channel, key, velocity);
        }
    }

    @Override
    public void sendProgramChange(int channel, int value) throws MidiPlayerException {
        if (this.isValidChannel(channel)) {
            this.receiver.sendProgramChange(channel, value);
        }
    }

    @Override
    public void sendControlChange(int channel, int controller, int value) throws MidiPlayerException {
        if (this.isValidChannel(channel)) {
            this.receiver.sendControlChange(channel, controller, value);
        }
    }

    @Override
    public void sendPitchBend(int channel, int value) throws MidiPlayerException {
        if (this.isValidChannel(channel)) {
            this.receiver.sendPitchBend(channel, value);
        }
    }

    public boolean isValidChannel(int channel) {
        return channel >= 0 && channel < 16;
    }
}

