#!/bin/bash
#
# Stansoft Postgres environment file
#
# Do not edit this file, it will be overwritten on upgrade.
# LOCAL CHANGES BELONG IN postgres.local.
#
export SSDIR=$(cd $(dirname $(realpath $BASH_SOURCE))/.. && pwd)
export LD_LIBRARY_PATH=$SSDIR/pgsql/lib:$LD_LIBRARY_PATH
export PGPORT=`grep ^stansoft /etc/services | grep -o '[0-9]*'`
export PGDATA=$SSDIR/data
export PATH=$SSDIR/bin:$SSDIR/pgsql/bin:$PATH

# Set Aubit environment - needed if running a 4ge program from the commmand line
export AUBITDIR=$SSDIR/aubit4gl
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$AUBITDIR/lib
export A4GL_SQLTYPE=pg8
# Use libpq
#export A4GL_LEXTYPE=C
# Use libecpg
export A4GL_LEXTYPE=EC
export A4GL_LEXDIALECT=POSTGRES
# So forms and help file are found
export DBPATH=$DBPATH:$SSDIR/bin

# The DBDATE environment variable specifies the end-user format of DATE values.
# For the U.S. English locale, the default for DBDATE is MDY4/
# Use one of the following to set a different date format. Do not set
# it here, because this file will be overwritten on upgrade, instead
# add it to file postgres.local in this directory.
#export DBDATE=MDY4/   # MM/DD/YYYY
#export DBDATE=DMY2-   # DD-MM-YY
#export DBDATE=DMY4/   # DD/MM/YYYY 

# PostgreSQL uses PGDATESTYLE for psql
# This will be set in $PGDATA/postgresql.conf during install
# but this is only used for the where clause, to
# display a different format use:
# select to_char(date_field :: date, 'dd/mm/yyyy') 
#export PGDATESTYLE=DMY
#export PGDATESTYLE=MDY
#export PGDATESTYLE=YMD

# Source in any local overrides
. "${BASH_SOURCE%.*}".local 2> /dev/null

