#!/bin/bash
#
# Stansoft Informix environment file
#
export SSDIR=$(cd $(dirname $(realpath $BASH_SOURCE))/.. && pwd)
export PATH=$SSDIR/bin:$PATH
# So forms and help file are found
export DBPATH=$SSDIR/bin:$DBPATH

# Informix variables
export DBCENTURY=""C""
export INFORMIXTERM=terminfo
# Set in $INFORMIXDIR/ol_informix.sh
#export INFORMIXDIR=/opt/informix

# Set Aubit environment - needed if running a 4ge program from the commmand line
export LD_LIBRARY_PATH=$INFORMIXDIR/lib:$INFORMIXDIR/lib/esql:$LD_LIBRARY_PATH
export AUBITDIR=$SSDIR/aubit4gl
export LD_LIBRARY_PATH=$AUBITDIR/lib:$LD_LIBRARY_PATH

#export SSMENU=CMP

# The DBDATE environment variable specifies the end-user format of DATE values.
# For the U.S. English locale, the default for DBDATE is MDY4/
# Uncomment one of the following to use a different date format.
# Do not set it here, because this file will be overwritten on upgrade, instead
# add it to file stansoft.local in this directory. 
#export DBDATE=MDY4/   # MM/DD/YYYY
#export DBDATE=DMY2-   # DD-MM-YY
#export DBDATE=DMY4/   # DD/MM/YYYY 

# Source in any local overrides
. "${BASH_SOURCE%.*}".local 2> /dev/null

