-- If this is run after menu permissions have been setup in menu_secure
-- the permissions will be wrong since the serial column menu_field.itemlink
-- may have changed.

-- Any new menu items need to be added in here since this file is used for new
-- database creation. New items also need to be added to menu-upd.sql, which 
-- is used during upgrades by menu-upd in sypupdate. The menu update program
-- will give user stansoft access to the menu item, you need to run the
-- menu security program to give other users access or do it manually with sql.

drop index i_menuhead;
drop table menu_head;
create table menu_head (menucode char(3),
                        title char(50),
                        prevmenu char(3)
                       );

create unique index i_menuhead on menu_head (menucode);


drop index i_menufield;
drop table menu_field;
create table menu_field (menucode char(3),
                         itemdesc char(27),
                         exectype char(1),
                         execline char(40),
                         itemgrp  char(2), 
                         itemlink serial
                        ); 

create unique index i_menufield on menu_field (itemlink, menucode);


drop index i_menusecure;
drop table menu_secure;
create table menu_secure (itemlink integer,
                          usercode char(10)
                         );

create unique index i_menusecure on menu_secure (itemlink, usercode);



insert into menu_head (menucode, title, prevmenu)
values ('MM', 'Master Menu', null);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Sales', 'M', 'SI', 'A', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Accounts Receivable', 'M', 'AR', 'B', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Accounts Payable', 'M', 'AP', 'C', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Retail Sales', 'M', 'RS', 'D', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Fuel Management', 'M', 'FM', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Fuel Dispatch', 'M', 'FD', 'F', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Payroll', 'M', 'PR', 'G', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Inventory', 'M', 'IN', 'H', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'General Ledger', 'M', 'GL', 'I', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'Tax Control', 'M', 'TX', 'J', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('MM', 'System Management', 'M', 'SY', 'K', default);



insert into menu_head (menucode, title, prevmenu)
values ('PR', 'Payroll', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Payment Entry', 'P', 'pyepay.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Payment Selection', 'P', 'pyrpay.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Direct Deposit', 'P', 'pyrpayach.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Tax Liability Report', 'P', 'pyrtaxlb.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Payment Register Report', 'P', 'pyrreg.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Earning Register Report', 'P', 'pyrearn.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', '941 Report', 'P', 'pyr941.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'MESC 1017 Report', 'P', 'pyrmiqtr.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Gross Wage Report', 'P', 'pyrgrwage.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Workers Comp Report', 'P', 'pyrwkcomp.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'W-2 Report', 'P', 'pyrw2.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'P60 Report', 'P', 'pyrp60.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'P45 Report', 'P', 'pyrp45.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Employee List Report', 'P', 'pyremplst.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Work Status Report', 'P', 'pyrwrksta.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Outstanding Payments Report', 'P', 'pyrospay.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Direct Deposit Report', 'P', 'pyrdd.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Time Off Report', 'P', 'pyrempoff.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Employee Letter Report', 'P', 'pyrletter.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Employee Maint', 'P', 'pyfemp.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Payment Void', 'P', 'pyfvoidpay.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Earning Maint', 'P', 'pyfearn.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Deduction Maint', 'P', 'pyfded.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Tax Maint', 'P', 'pyftax.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Policy Time Off Maint', 'P', 'pyfpto.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Payment Reconciliation', 'P', 'pyfpayrcn.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Pay Group Maint', 'P', 'pyfpaygrp.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('PR', 'Employee Letter Maint', 'P', 'pyfletter.4ge', 'T', default);



insert into menu_head (menucode, title, prevmenu)
values ('AP', 'Accounts Payable', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Invoice Entry', 'P', 'apeinvce.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Single Payment Entry', 'P', 'apesglpay.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Vendor Invoice Display', 'P', 'apvinvce.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'ACH Entry', 'P', 'aprpayach.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'ACH Payment Report', 'P', 'aprachpay.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Payment Selection', 'P', 'apepaysel.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Payment Selection Report', 'P', 'aprpaysel.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Payables Unpaid Report', 'P', 'aprunpaid.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Remittance Advice Report', 'P', 'aprpayrmt.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Vendor List Report', 'P', 'aprvendor.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Payment Register Report', 'P', 'aprpayreg.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Outstanding Payment Report', 'P', 'aprospay.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Invoice Register Report', 'P', 'aprinvreg.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Form 1099 Report', 'P', 'apr1099.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Aged Payables Report', 'P', 'apragepay.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Vendor Master Maint', 'P', 'apfmastr.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Payment Reconciliation', 'P', 'apfpayrcn.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Vendor Class Maintenance', 'P', 'apfclass.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AP', 'Payment Void', 'P', 'apfvoidpay.4ge', 'T', default);



insert into menu_head (menucode, title, prevmenu)
values ('AR', 'Accounts Receivable', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer Account Display', 'P', 'arvcstbal.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Payment Entry', 'P', 'arepaymt.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'ACH Entry', 'P', 'arrachen.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'ACH Activity Report', 'P', 'arrachact.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Account History Report', 'P', 'arracthis.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Account Statement', 'P', 'arrstmnt.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer List Report', 'P', 'arrcust.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Bal Forward Aging Report', 'P', 'arrbfage.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Open Item Aging Report', 'P', 'arroiage.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer Balance Report', 'P', 'arrcstbal.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Deposit Detail Report', 'P', 'arrdeposit.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Mail Log Report', 'P', 'arrlog.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer Master Maint', 'P', 'arfmastr.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer Alternate Name', 'P', 'arfaltnm.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Bal Forward Consolidation', 'P', 'arpbalfd.4ge', 'P', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Finance Charge Calculation', 'P', 'arpfnchg.4ge', 'P', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Clear Matched Transactions', 'P', 'arpmatch.4ge', 'P', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer Class Maint', 'P', 'arfclass.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Transaction Type Maint', 'P', 'arftype.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Cycle Maint', 'P', 'arfcycle.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Finance Charge Maint', 'P', 'arffnchg.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Statement Comment Maint', 'P', 'arfstcmt.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('AR', 'Customer Email Maint', 'P', 'arfemail.4ge', 'T', default);




insert into menu_head (menucode, title, prevmenu)
values ('RS', 'Retail Sales', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Daily Report Entry', 'P', 'rsedaily.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Import POS Transactions', 'P', 'rspimppos.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Retail Period Sales Report', 'P', 'rsrsales.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Daily Summary Report', 'P', 'rsrdaily.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Retail Invt Control Report', 'P', 'rsrinctl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Inventory Purchase Report', 'P', 'rsrpurch.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'EFT Settle Notice Report', 'P', 'rsreftset.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Book Price Report', 'P', 'rsrbprice.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Promotions List Report', 'P', 'rsrprolst.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Purchase Invoice Report', 'P', 'rsrpurinv.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'PLU Sales Report', 'P', 'rsrplusls.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'POS Transactions Report', 'P', 'rsrpostrn.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Promotion History Report', 'P', 'rsrprohis.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Daily Sales Report', 'P', 'rsrdaysls.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Price Book Maint', 'P', 'rsfpbook.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Import Price Book', 'P', 'rsploadupc.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Price Book Promotions', 'P', 'rsfpromo.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Sales Group Maint', 'P', 'rsfslsgrp.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Department Maint', 'P', 'rsfdept.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Fuel Pump Maint', 'P', 'rsfpump.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Category Maint', 'P', 'rsfcat.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Inventory Detail Maint', 'P', 'rsfcatdet.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Pump Class Maint', 'P', 'rsfpclass.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Category Margin Maint', 'P', 'rsfcatmar.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'G/L Transaction Maint', 'P', 'rsfgltrn.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('RS', 'Price Zone Maint', 'P', 'rsfzone.4ge', 'T', default);





insert into menu_head (menucode, title, prevmenu)
values ('FM', 'Fuel Management', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Movement Entry', 'P', 'fmemove.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Import Fuel Cost', 'P', 'fmrcostul.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Fuel Cost Entry', 'P', 'fmecost.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Fuel Cost Report', 'P', 'fmrfcost.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Movement Detail Report', 'P', 'fmrmvmnt.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Acutal Readings Report', 'P', 'fmrread.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Daily Over/Short Report', 'P', 'fmrfuelos.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Freight Rate Report', 'P', 'fmrfrtcod.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Internal Delivery Report', 'P', 'fmrindel.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Supplier Purchase Report', 'P', 'fmrsuppur.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Perpetual Inventory Report', 'P', 'fmrperinv.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Purchase Detail Report', 'P', 'fmrpurdet.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Unbilled Liabilities Report', 'P', 'fmrunbill.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Fuel Terminal Maint', 'P', 'fmfterm.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Freight Origin-Dest Maint', 'P', 'fmffrtcom.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Freight Rate Maint', 'P', 'fmffrtcd.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Tank Maint', 'P', 'fmftank.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FM', 'Fuel Carrier Maint', 'P', 'fmfcarrier.4ge', 'T', default);



insert into menu_head (menucode, title, prevmenu)
values ('SI', 'Sales', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Invoice Entry', 'P', 'wseinvce.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Invoice Print', 'P', 'wsrinvpr.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Process Invoice', 'P', 'wsesipro.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Picking Slip', 'P', 'sirpicksl.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Delivery Note', 'P', 'sirdelnote.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Customer Sales Report', 'P', 'wsrsales.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Sales Detail Report', 'P', 'sirslsdet.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Invoice Register Report', 'P', 'sirinvreg.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Period Sales Summary Report', 'P', 'sirpersls.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SI', 'Re-use Invoice Number', 'P', 'infnbr.4ge', 'T', default);



insert into menu_head (menucode, title, prevmenu)
values ('IN', 'Inventory', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Receive Inventory', 'P', 'inercver.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Inventory Control Report', 'P', 'inrinctrl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Receiver Report', 'P', 'inrrcver.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Invt Reconciliation Report', 'P', 'inrinvrc.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Inventory On Hand Report', 'P', 'inronhand.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Product Price List Report', 'P', 'inrprice.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Stock Movement Report', 'P', 'inrstockmv.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Inventory Header Maint', 'P', 'infheader.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Inventory Master Maint', 'P', 'infmaster.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Product & Tax Class Maint', 'P', 'infclass.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Product Blending Maint', 'P', 'infblend.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Inventory Count Maint', 'P', 'infinvcnt.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Pricing Formula Maint', 'P', 'infprice.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Tax Class Comnt Maint', 'P', 'inftaxcmt.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Product Comment Maint', 'P', 'infcomnt.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Inventory Location Maint', 'P', 'infloc.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Invoice Text Maint', 'P', 'infivtxt.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('IN', 'Salesman Name Maint', 'P', 'infslsman.4ge', 'T', default);



insert into menu_head (menucode, title, prevmenu)
values ('GL', 'General Ledger', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'General Journal Entry', 'P', 'glegjrnl.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'G/L Activity Report', 'P', 'glrglact.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Accounts Payable Journal', 'P', 'glrapjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Accounts Receivable Journal', 'P', 'glrarjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Fuel Management Journal', 'P', 'glrfmjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'General Journal', 'P', 'glrgnjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Retail Sales Journal', 'P', 'glrrsjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Inventory Journal', 'P', 'glrinjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Payroll Journal', 'P', 'glrpyjrnl.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Chart of Accounts', 'P', 'glrchart.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Trial Balance', 'P', 'glrtrial.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Financial Statements', 'P', 'glrfinstm.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Account Master Maint', 'P', 'glfmaster.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Period Maint', 'P', 'glfperiod.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('GL', 'Year End Processing', 'P', 'glpyear.4ge', 'P', default);



insert into menu_head (menucode, title, prevmenu)
values ('TX', 'Tax Control', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Refund of Excise Tax (8849)', 'P', 'txr8849.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Blender Schedule of Rec/Dis', 'P', 'txrblend.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Sales Tax Report', 'P', 'txrsales.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'VAT Return Report', 'P', 'txrvat.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Michigan Sched of Disburse', 'P', 'txrsalemi.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Tax Table Report', 'P', 'txrtable.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Tax Use Group Report', 'P', 'txrusegrp.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Excise Exempt Cert Report', 'P', 'txrecert.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Tax Schedule Sales Report', 'P', 'txrschsls.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Tax Table Maint', 'P', 'txftable.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('TX', 'Tax Use Group Maint', 'P', 'txfuseg.4ge', 'T', default);



insert into menu_head (menucode, title, prevmenu)
values ('FD', 'Fuel Dispatch', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FD', 'Order Entry', 'P', 'fdeorder.4ge', 'E', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('FD', 'Dispatch Ticket', 'P', 'fdrdsptk.4ge', 'R', default);



insert into menu_head (menucode, title, prevmenu)
values ('SY', 'System Management', 'MM');
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Profit Center List Report', 'P', 'syrpc.4ge', 'R', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Profit Center Maint', 'P', 'syfpc.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Company Maint', 'P', 'syfcompany.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'County Maint', 'P', 'syfcounty.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'State Maint', 'P', 'syfstate.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Country Maint', 'P', 'syfcountry.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Zip/Postal Code Maint', 'P', 'syfzip.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Terms Maint', 'P', 'syfterms.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'System Parameters Maint', 'P', 'syfparm.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Unit of Measure Maint', 'P', 'syfuom.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Bank Maint', 'P', 'syfbank.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Menu Maint', 'P', 'syfmenu.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Menu Security Maint', 'P', 'syfmenusec.4ge', 'T', default);
  insert into menu_field (menucode,itemdesc,exectype,execline,itemgrp,itemlink)
  values ('SY', 'Update Database', 'P', 'sypupdate.4ge', 'T', default);




delete from menu_secure where usercode = 'stansoft';
insert into menu_secure select menu_field.itemlink, 'stansoft' from menu_field;
grant select on menu_head to "public";
grant update on menu_head to "public";
grant select on menu_field to "public";
grant update on menu_field to "public";
grant select on menu_secure to "public";
grant update on menu_secure to "public";
