create database stansoft in datadbs;
database stansoft;
grant dba to public;









{ TABLE ar_class row size = 39 number of columns = 3 index size = 10 }

create table ar_class 
  (
    arc_code char(5),
    arc_glm integer,
    arc_desc char(30)
  );

revoke all on ar_class from "public";

{ TABLE ar_cycle row size = 56 number of columns = 17 index size = 7 }

create table ar_cycle 
  (
    arcy_code smallint,
    arcy_desc char(30),
    arcy_last_date date,
    arcy_next_date date,
    arcy_cutoff_date date,
    arcy_fnchg_stat char(1),
    arcy_trnan_stat char(1),
    arcy_dagel_stat char(1),
    arcy_stmnt_stat char(1),
    arcy_balfd_stat char(1),
    arcy_opncr_stat char(1),
    arcy_fnchg_ord char(1),
    arcy_trnan_ord char(1),
    arcy_dagel_ord char(1),
    arcy_stmnt_ord char(1),
    arcy_balfd_ord char(1),
    arcy_opncr_ord char(1)
  );

revoke all on ar_cycle from "public";

{ TABLE ar_fnc_table row size = 16 number of columns = 4 index size = 15 }

create table ar_fnc_table 
  (
    fc_fnc_code char(4),
    fc_amount decimal(8,2),
    fc_type char(1),
    fc_fin_charge decimal(8)
  );

revoke all on ar_fnc_table from "public";

{ TABLE ar_item row size = 39 number of columns = 10 index size = 35 }

create table ar_item 
  (
    ar_customer integer,
    ar_invoice_nbr integer,
    ar_seq_nbr smallint,
    ar_tran_type char(2),
    ar_tran_dt date,
    ar_amount decimal(10,2),
    ar_due_dt date,
    ar_disc_date date,
    ar_disc_amt decimal(8,2),
    ar_shift_link integer
  );

revoke all on ar_item from "public";

{ TABLE ar_item_tag row size = 54 number of columns = 5 index size = 15 }

create table ar_item_tag 
  (
    art_customer integer,
    art_invoice_nbr integer,
    art_line smallint,
    art_text char(40),
    art_deposit integer
  );

revoke all on ar_item_tag from "public";

{ TABLE ar_type row size = 43 number of columns = 6 index size = 19 }

create table ar_type 
  (
    at_prft_ctr smallint,
    at_type_code char(2),
    at_desc char(30),
    at_oper char(1),
    at_gl_db integer,
    at_gl_cr integer
  );

revoke all on ar_type from "public";

{ TABLE fm_lading row size = 41 number of columns = 9 index size = 26 }

create table fm_lading 
  (
    fml_movement integer,
    fml_bl_nbr integer,
    fml_int_ext char(1),
    fml_vendor integer,
    fml_terminal smallint,
    fml_date date,
    fml_net_gals decimal(8),
    fml_gross_gals decimal(8),
    fml_po_nbr char(10)
  );

revoke all on fm_lading from "public";

{ TABLE fm_terminal row size = 72 number of columns = 4 index size = 7 }

create table fm_terminal 
  (
    fmt_code smallint,
    fmt_zip_code char(10),
    fmt_owner char(10),
    fmt_sp_inst char(50)
  );

revoke all on fm_terminal from "public";

{ TABLE gl_journal row size = 32 number of columns = 9 index size = 24 }

create table gl_journal 
  (
    glj_entry_nbr serial not null ,
    glj_account integer,
    glj_prft_ctr smallint,
    glj_period smallint,
    glj_amount decimal(16,2),
    glj_flag char(1),
    glj_date date,
    glj_shift smallint,
    glj_batch integer
  );

revoke all on gl_journal from "public";

{ TABLE gl_jrnl_ar row size = 34 number of columns = 9 index size = 24 }

create table gl_jrnl_ar 
  (
    gljar_entry_nbr serial not null ,
    gljar_account integer,
    gljar_prft_ctr smallint,
    gljar_period smallint,
    gljar_amount decimal(16,2),
    gljar_flag char(1),
    gljar_invoice integer,
    gljar_tran_date date,
    gljar_customer integer
  );

revoke all on gl_jrnl_ar from "public";

{ TABLE gl_jrnl_fm row size = 40 number of columns = 12 index size = 33 }

create table gl_jrnl_fm 
  (
    gljfm_entry_nbr serial not null ,
    gljfm_account integer,
    gljfm_prft_ctr smallint,
    gljfm_period smallint,
    gljfm_amount decimal(16,2),
    gljfm_flag char(1),
    gljfm_movement integer,
    gljfm_bl_inv integer,
    gljfm_bi char(1),
    gljfm_trn_prodlnk integer,
    gljfm_tp char(1),
    gljfm_tran_date date
  );

revoke all on gl_jrnl_fm from "public";

{ TABLE gl_jrnl_text row size = 78 number of columns = 4 index size = 13 }

create table gl_jrnl_text 
  (
    gljt_link integer,
    gljt_seq smallint,
    gljt_text char(70),
    gljt_src char(2)
  );

revoke all on gl_jrnl_text from "public";

{ TABLE gl_jrnl_ws row size = 45 number of columns = 9 index size = 13 }

create table gl_jrnl_ws 
  (
    gljws_entry_nbr serial not null ,
    gljws_account integer,
    gljws_period smallint,
    gljws_shl integer,
    gljws_amount decimal(16,2),
    gljws_flag char(1),
    gljws_invoice char(16),
    gljws_cust_vnd integer,
    gljws_cv_type char(1)
  );

revoke all on gl_jrnl_ws from "public";

{ TABLE gl_master row size = 195 number of columns = 27 index size = 32 }

create table gl_master 
  (
    glm_series char(5),
    glm_account integer,
    glm_prft_ctr smallint,
    glm_norm_bal char(1),
    glm_description char(30),
    glm_clear_to_acct integer,
    glm_clr_to_prft_ct smallint,
    glm_clear_lvl smallint,
    glm_group char(2),
    glm_amt_period0 decimal(16,2),
    glm_amt_period1 decimal(16,2),
    glm_amt_period2 decimal(16,2),
    glm_amt_period3 decimal(16,2),
    glm_amt_period4 decimal(16,2),
    glm_amt_period5 decimal(16,2),
    glm_amt_period6 decimal(16,2),
    glm_amt_period7 decimal(16,2),
    glm_amt_period8 decimal(16,2),
    glm_amt_period9 decimal(16,2),
    glm_amt_period10 decimal(16,2),
    glm_amt_period11 decimal(16,2),
    glm_amt_period12 decimal(16,2),
    glm_amt_period13 decimal(16,2),
    glm_amt_period14 decimal(16,2),
    glm_roll_account integer,
    glm_roll_level smallint,
    glm_rl_prft_ctr smallint
  );

revoke all on gl_master from "public";

{ TABLE gl_period row size = 21 number of columns = 9 index size = 0 }

create table gl_period 
  (
    glp_series char(5),
    glp_beg_dt date,
    glp_end_dt date,
    glp_refpd smallint,
    glp_glpd smallint,
    glp_status char(1),
    glp_rpt_bal char(1),
    glp_rpt_pl char(1),
    glp_rpt_ja char(1)
  );

revoke all on gl_period from "public";

{ TABLE inv_history row size = 68 number of columns = 12 index size = 15 }

create table inv_history 
  (
    ph_prft_ctr smallint,
    ph_prodlnk integer,
    ph_end_date date,
    ph_salesq decimal(10),
    ph_lostq decimal(8),
    ph_salesd decimal(12,2),
    ph_lostd decimal(10,2),
    ph_cogsd decimal(10,2),
    ph_qty_onhand decimal(10),
    ph_qty_consign decimal(10),
    ph_beg_price decimal(8),
    ph_beg_cost decimal(8)
  );

revoke all on inv_history from "public";

{ TABLE inv_rec_head row size = 52 number of columns = 8 index size = 34 }

create table inv_rec_head 
  (
    po_num integer,
    po_vendor integer,
    po_date date,
    po_date_last date,
    po_freight decimal(8),
    po_carrier integer,
    po_frgt_bill char(10),
    po_rcvr char(16)
  );

revoke all on inv_rec_head from "public";

{ TABLE inv_secndloc row size = 31 number of columns = 7 index size = 27 }

create table inv_secndloc 
  (
    sl_prft_ctr smallint,
    sl_prodlnk integer,
    sl_loc char(5),
    sl_bin char(5),
    sl_qty decimal(10),
    sl_max decimal(10),
    sl_lot_flag char(1)
  );

revoke all on inv_secndloc from "public";

{ TABLE p_checks row size = 37 number of columns = 6 index size = 71 }

create table p_checks 
  (
    pv_check_nbr integer,
    pv_check_vendor integer,
    pv_check_amount decimal(12,2),
    pv_check_paid char(1),
    pv_shl integer,
    pv_account char(17)
  );

revoke all on p_checks from "public";

{ TABLE p_class row size = 35 number of columns = 2 index size = 10 }

create table p_class 
  (
    pcl_code char(5),
    pcl_desc char(30)
  );

revoke all on p_class from "public";

{ TABLE p_item_d row size = 25 number of columns = 8 index size = 9 }

create table p_item_d 
  (
    pd_inv_lnk integer,
    pd_shl integer,
    pd_gl_nbr integer,
    pd_amt decimal(10,2),
    pd_dc_flag char(1),
    pd_mod_lvl smallint,
    pd_line smallint,
    pd_prft_ctr smallint
  );

revoke all on p_item_d from "public";

{ TABLE p_pay_d row size = 19 number of columns = 5 index size = 9 }

create table p_pay_d 
  (
    ppd_seq integer,
    ppd_shl integer,
    ppd_gl_acct integer,
    ppd_dc_flag char(1),
    ppd_amt decimal(10,2)
  );

revoke all on p_pay_d from "public";

{ TABLE rs_pumpcls row size = 35 number of columns = 2 index size = 10 }

create table rs_pumpcls 
  (
    rspc_class char(5),
    rspc_desc char(30)
  );

revoke all on rs_pumpcls from "public";

{ TABLE rs_scat row size = 19 number of columns = 4 index size = 13 }

create table rs_scat 
  (
    rsc_shl integer,
    rsc_catagory char(4),
    rsc_amount decimal(10,2),
    rsc_retail decimal(8,2)
  );

revoke all on rs_scat from "public";

{ TABLE rs_shiftlink row size = 12 number of columns = 4 index size = 22 }

create table rs_shiftlink 
  (
    rssl_prft_ctr smallint,
    rssl_shift smallint,
    rssl_date date,
    rssl_shl serial not null 
  );

revoke all on rs_shiftlink from "public";

{ TABLE rs_summary row size = 83 number of columns = 14 index size = 9 }

create table rs_summary 
  (
    rss_shl integer,
    rss_fuel_gal decimal(10),
    rss_fuel_dol decimal(10),
    rss_inside_dol decimal(10),
    rss_inside_cogs decimal(10),
    rss_ar_amount decimal(10),
    rss_ap_amount decimal(10),
    rss_cash_rec decimal(10),
    rss_cash_pay decimal(10),
    rss_cash_dep decimal(10),
    rss_cash_end decimal(10),
    rss_over_short decimal(10),
    rss_status char(1),
    rss_ap_entry char(1)
  );

revoke all on rs_summary from "public";

{ TABLE si_alt_addr row size = 95 number of columns = 3 index size = 10 }

create table si_alt_addr 
  (
    ia_nbr integer,
    ia_alt_type char(1),
    ia_name_addr char(90)
  );

revoke all on si_alt_addr from "public";

{ TABLE si_inv_text row size = 49 number of columns = 5 index size = 13 }

create table si_inv_text 
  (
    idt_nbr integer,
    idt_line smallint,
    idt_seq smallint,
    idt_type char(1),
    idt_text char(40)
  );

revoke all on si_inv_text from "public";

{ TABLE sih_alt_addr row size = 95 number of columns = 3 index size = 10 }

create table sih_alt_addr 
  (
    iah_nbr integer,
    iah_alt_type char(1),
    iah_name_addr char(90)
  );

revoke all on sih_alt_addr from "public";

{ TABLE sih_batches row size = 8 number of columns = 2 index size = 13 }

create table sih_batches 
  (
    ibh_batch_nbr integer,
    ibh_inv_nbr integer
  );

revoke all on sih_batches from "public";

{ TABLE sih_inv_text row size = 49 number of columns = 5 index size = 13 }

create table sih_inv_text 
  (
    idth_nbr integer,
    idth_line smallint,
    idth_seq smallint,
    idth_type char(1),
    idth_text char(40)
  );

revoke all on sih_inv_text from "public";

{ TABLE sp_excpt_clas row size = 16 number of columns = 4 index size = 14 }

create table sp_excpt_clas 
  (
    cce_cust integer,
    cce_product_cl char(5),
    cce_lvl smallint,
    cce_terms char(5)
  );

revoke all on sp_excpt_clas from "public";

{ TABLE sp_excpt_cust row size = 10 number of columns = 3 index size = 13 }

create table sp_excpt_cust 
  (
    ce_cust integer,
    ce_prodlnk integer,
    ce_lvl smallint
  );

revoke all on sp_excpt_cust from "public";

{ TABLE sp_table row size = 72 number of columns = 7 index size = 19 }

create table sp_table 
  (
    pt_formula char(5),
    pt_lvl smallint,
    pt_quantity decimal(10),
    pt_desc char(50),
    pt_type char(1),
    pt_factor decimal(8),
    pt_operator char(1)
  );

revoke all on sp_table from "public";

{ TABLE sys_county row size = 34 number of columns = 2 index size = 9 }

create table sys_county 
  (
    c_code char(4),
    c_name char(30)
  );

revoke all on sys_county from "public";

{ TABLE tx_cust_prmt row size = 29 number of columns = 4 index size = 13 }

create table tx_cust_prmt 
  (
    txcp_customer integer,
    txcp_trn integer,
    txcp_permit char(20),
    txcp_shw_permit char(1)
  );

revoke all on tx_cust_prmt from "public";

{ TABLE tx_customer row size = 22 number of columns = 7 index size = 22 }

create table tx_customer 
  (
    ta_customer integer,
    ta_prodtcl char(5),
    ta_use_g char(8),
    ta_freq smallint,
    ta_in_price char(1),
    ta_on_invoice char(1),
    ta_show_separate char(1)
  );

revoke all on tx_customer from "public";

{ TABLE tx_use_g row size = 57 number of columns = 4 index size = 9 }

create table tx_use_g 
  (
    tu_use_g char(8),
    tu_prodtcl char(5),
    tu_description char(40),
    tu_link serial not null 
  );

revoke all on tx_use_g from "public";

{ TABLE tx_use_link row size = 13 number of columns = 3 index size = 18 }

create table tx_use_link 
  (
    tul_link integer,
    tul_trn integer,
    tul_sched char(5)
  );

revoke all on tx_use_link from "public";

{ TABLE si_nbr row size = 4 number of columns = 1 index size = 9 }

create table si_nbr 
  (
    in_nbr integer
  );

revoke all on si_nbr from "public";

{ TABLE sys_state row size = 24 number of columns = 4 index size = 7 }

create table sys_state 
  (
    s_code char(2),
    s_name char(20),
    s_county_tax char(1),
    s_city_tax char(1)
  );

revoke all on sys_state from "public";

{ TABLE rs_taxes row size = 41 number of columns = 7 index size = 21 }

create table rs_taxes 
  (
    rstx_shl integer,
    rstx_prodlnk integer,
    rstx_trn integer,
    rstx_ulink integer,
    rstx_amount decimal(16),
    rstx_tunits decimal(16),
    rstx_tax_rate decimal(6)
  );

revoke all on rs_taxes from "public";

{ TABLE fm_movement row size = 26 number of columns = 7 index size = 9 }

create table fm_movement 
  (
    fmm_movement integer,
    fmm_dispatch_flag char(2),
    fmm_carrier integer,
    fmm_car_trail char(10),
    fmm_driver integer,
    fmm_journal char(1),
    fmm_disp_print char(1)
  );

revoke all on fm_movement from "public";

{ TABLE inv_master row size = 142 number of columns = 29 index size = 11 }

create table inv_master 
  (
    invt_prft_ctr smallint,
    invt_prodlnk integer,
    invt_consignee char(1),
    invt_gl_sales integer,
    invt_gl_cost integer,
    invt_commissioned char(2),
    invt_inv_ctl char(1),
    invt_lot char(1),
    invt_price decimal(8),
    invt_cost decimal(8),
    invt_secndloc decimal(10),
    invt_consignor decimal(10),
    invt_rop decimal(8),
    invt_goal decimal(8),
    invt_onorder decimal(10),
    invt_ap_errors decimal(8),
    invt_formula char(5),
    invt_sales_mtdd decimal(12,2),
    invt_sales_mtdq decimal(10),
    invt_sales_ytdd decimal(14,2),
    invt_sales_ytdq decimal(12),
    invt_cost_mtdd decimal(10,2),
    invt_n_min decimal(8),
    invt_n_max decimal(10),
    invt_n_min_cost decimal(8),
    invt_n_max_cost decimal(8),
    invt_gl_invt integer,
    invt_cust_sernbr char(1),
    invt_trk_cust_qoh char(1)
  );

revoke all on inv_master from "public";

{ TABLE sys_lock row size = 16 number of columns = 2 index size = 0 }

create table sys_lock 
  (
    lock_name char(8),
    lock_user char(8)
  );

revoke all on sys_lock from "public";

{ TABLE oe_comment row size = 101 number of columns = 5 index size = 16 }

create table oe_comment 
  (
    oeco_customer integer,
    oeco_type char(1),
    oeco_order integer,
    oeco_seq smallint,
    oeco_text char(90)
  );

revoke all on oe_comment from "public";

{ TABLE fd_comment row size = 71 number of columns = 5 index size = 9 }

create table fd_comment 
  (
    fdco_customer integer,
    fdco_type char(1),
    fdco_movement integer,
    fdco_seq smallint,
    fdco_text char(60)
  );

revoke all on fd_comment from "public";

{ TABLE inv_bilmat row size = 21 number of columns = 6 index size = 18 }

create table inv_bilmat 
  (
    bm_prodlnk integer,
    bm_used_prodlnk integer,
    bm_qty decimal(8),
    bm_uom char(5),
    bm_subst char(1),
    bm_blend_type char(1)
  );

revoke all on inv_bilmat from "public";

{ TABLE si_comment row size = 49 number of columns = 4 index size = 14 }

create table si_comment 
  (
    ico_type char(1),
    ico_prodlnk integer,
    ico_seq integer,
    ico_text char(40)
  );

revoke all on si_comment from "public";

{ TABLE rs_cat_current row size = 26 number of columns = 4 index size = 18 }

create table rs_cat_current 
  (
    rscc_prft_ctr smallint,
    rscc_catagory char(4),
    rscc_beg_cost decimal(16),
    rscc_beg_retail decimal(16)
  );

revoke all on rs_cat_current from "public";

{ TABLE si_certf row size = 49 number of columns = 3 index size = 14 }

create table si_certf 
  (
    iso_class char(5),
    iso_seq integer,
    iso_text char(40)
  );

revoke all on si_certf from "public";

{ TABLE gl_jrnl_rs row size = 32 number of columns = 9 index size = 50 }

create table gl_jrnl_rs 
  (
    gljrs_entry_nbr serial not null ,
    gljrs_account integer,
    gljrs_shl integer,
    gljrs_period smallint,
    gljrs_amount decimal(16,2),
    gljrs_flag char(1),
    gljrs_prft_ctr smallint,
    gljrs_shift smallint,
    gljrs_date date
  );

revoke all on gl_jrnl_rs from "public";

{ TABLE inv_counts row size = 39 number of columns = 9 index size = 30 }

create table inv_counts 
  (
    ic_prft_ctr smallint,
    ic_prodlnk integer,
    ic_date date,
    ic_qty decimal(10),
    ic_location char(5),
    ic_measure char(10),
    ic_therm smallint,
    ic_link serial not null ,
    ic_type_ab char(1)
  );

revoke all on inv_counts from "public";

{ TABLE rs_cat_det row size = 43 number of columns = 8 index size = 20 }

create table rs_cat_det 
  (
    rscd_catagory char(4),
    rscd_prft_ctr smallint,
    rscd_period smallint,
    rscd_totpur_whol decimal(12,2),
    rscd_totpur_retail decimal(12,2),
    rscd_begin_whol decimal(12,2),
    rscd_begin_retail decimal(12,2),
    rscd_totsales decimal(12,2)
  );

revoke all on rs_cat_det from "public";

{ TABLE inv_cost_hist row size = 69 number of columns = 12 index size = 28 }

create table inv_cost_hist 
  (
    ivch_prft_ctr smallint,
    ivch_prodlnk integer,
    ivch_gl_date date,
    ivch_new_avg_cost decimal(8),
    ivch_filing_date date,
    ivch_old_qty_oh decimal(10),
    ivch_old_avg_cost decimal(8),
    ivch_purch_qty decimal(8),
    ivch_purch_cost decimal(8),
    ivch_serial serial not null ,
    ivch_vendor integer,
    ivch_rcvr char(16)
  );

revoke all on inv_cost_hist from "public";

{ TABLE inv_header row size = 177 number of columns = 18 index size = 30 }

create table inv_header 
  (
    ivh_product char(16),
    ivh_link serial not null ,
    ivh_prodtcl char(5),
    ivh_print char(20),
    ivh_xref integer,
    ivh_desc char(40),
    ivh_class char(5),
    ivh_barcode char(15),
    ivh_uom_stock char(5),
    ivh_uom_sales char(5),
    ivh_uom_pricing char(5),
    ivh_brand char(10),
    ivh_uom_purch char(5),
    ivh_assoc_prodlnk integer,
    ivh_weight_item char(16),
    ivh_weight_stock char(16),
    ivh_active char(1),
    ivh_stocking char(1)
  );

revoke all on inv_header from "public";

{ TABLE inv_classes row size = 42 number of columns = 5 index size = 11 }

create table inv_classes 
  (
    icl_code char(5),
    icl_type char(1),
    icl_desc char(30),
    icl_fuel_tax char(1),
    icl_fuel_group char(5)
  );

revoke all on inv_classes from "public";

{ TABLE ar_comment row size = 76 number of columns = 6 index size = 28 }

create table ar_comment 
  (
    ac_customer integer,
    ac_date date,
    ac_seq smallint,
    ac_text char(60),
    ac_next_date date,
    ac_src char(2)
  );

revoke all on ar_comment from "public";

{ TABLE ar_openitem row size = 18 number of columns = 4 index size = 15 }

create table ar_openitem 
  (
    aroi_customer integer,
    aroi_invoice_nbr integer,
    aroi_seq_nbr smallint,
    aroi_source char(8)
  );

revoke all on ar_openitem from "public";

{ TABLE fm_tank row size = 73 number of columns = 14 index size = 12 }

create table fm_tank 
  (
    tk_prft_ctr smallint,
    tk_num char(5),
    tk_length decimal(6),
    tk_diam decimal(6),
    tk_direction char(1),
    tk_capacity decimal(8),
    tk_dtlstchk date,
    tk_installed date,
    tk_tank_id char(8),
    tk_type char(10),
    tk_chkmeth char(10),
    tk_link_to char(5),
    tk_prodlnk integer,
    tk_strt_date date
  );

revoke all on fm_tank from "public";

{ TABLE inv_uom row size = 37 number of columns = 3 index size = 10 }

create table inv_uom 
  (
    inu_code char(5),
    inu_desc char(30),
    inu_rnd smallint
  );

revoke all on inv_uom from "public";

{ TABLE rs_altcat_marg row size = 16 number of columns = 3 index size = 0 }

create table rs_altcat_marg 
  (
    rsam_prft_ctr smallint,
    rsam_cat char(4),
    rsam_margin decimal(16)
  );

revoke all on rs_altcat_marg from "public";

{ TABLE p_altname row size = 478 number of columns = 14 index size = 48 }

create table p_altname 
  (
    pn_alt integer,
    pn_vendor integer,
    pn_name_addr char(180),
    pn_city char(4),
    pn_state char(2),
    pn_phone char(14),
    pn_zip_code char(10),
    pn_name char(30),
    pn_first_name char(30),
    pn_company char(30),
    pn_attn_line char(30),
    pn_addr1 char(30),
    pn_addr2 char(30),
    pn_email_address char(80)
  );

revoke all on p_altname from "public";

{ TABLE inv_sls_cstlr row size = 40 number of columns = 10 index size = 65 }

create table inv_sls_cstlr 
  (
    sclr_prft_ctr smallint not null ,
    sclr_prodlnk integer not null ,
    sclr_sls_lyr integer not null ,
    sclr_type char(1) not null ,
    sclr_sls_date date not null ,
    sclr_unit_cost decimal(8) not null ,
    sclr_qty decimal(10) not null ,
    sclr_pur_lyr integer not null ,
    sclr_serial integer not null ,
    sclr_unique serial not null 
  );

revoke all on inv_sls_cstlr from "public";

{ TABLE fm_purch_term row size = 44 number of columns = 10 index size = 23 }

create table fm_purch_term 
  (
    fmpt_terminal smallint,
    fmpt_vendor integer,
    fmpt_prodlnk integer,
    fmpt_use_g char(8),
    fmpt_terms char(5),
    fmpt_ngu char(1),
    fmpt_date date,
    fmpt_time char(5),
    fmpt_cost decimal(8),
    fmpt_super_fund decimal(7,5)
  );

revoke all on fm_purch_term from "public";

{ TABLE p_payment row size = 82 number of columns = 16 index size = 49 }

create table p_payment 
  (
    pp_inv_lnk integer,
    pp_seq serial not null ,
    pp_due_dt date,
    pp_disc date,
    pp_amt_sch decimal(10,2),
    pp_amt_disc decimal(10,2),
    pp_check_nbr integer,
    pp_shl integer,
    pp_cash_amt decimal(10,2),
    pp_gl_cash_acct integer,
    pp_gl_ap_acct integer,
    pp_ap_amt decimal(10,2),
    pp_check_acct char(17),
    pp_check_draft char(1),
    pp_date_entered date,
    pp_date_paid date
  );

revoke all on p_payment from "public";

{ TABLE iq_salesman_name row size = 49 number of columns = 3 index size = 9 }

create table iq_salesman_name 
  (
    iqsn_code char(4) not null ,
    iqsn_name char(35) not null ,
    iqsn_userlogin char(10)
  );

revoke all on iq_salesman_name from "public";

{ TABLE p_vendor row size = 97 number of columns = 22 index size = 9 }

create table p_vendor 
  (
    pm_vendor integer,
    pm_status char(1),
    pm_fed_id char(11),
    pm_std_disc_term char(5),
    pm_hist_lvl smallint,
    pm_credit_limit decimal(10,2),
    pm_1099 char(1),
    pm_blanket_po integer,
    pm_bpo_exp_date date,
    pm_last_date date,
    pm_last_amt decimal(10,2),
    pm_last_p_date date,
    pm_last_p_amt decimal(10,2),
    pm_last_p_check integer,
    pm_date_opened date,
    pm_ytd_purch decimal(12,2),
    pm_ytd_disc decimal(12,2),
    pm_curr_bal decimal(12,2),
    pm_class char(5),
    pm_remit_lead smallint,
    pm_price_book char(1),
    pm_deliv_lead smallint
  );

revoke all on p_vendor from "public";

{ TABLE rs_b_mass_upd row size = 93 number of columns = 16 index size = 9 }

create table rs_b_mass_upd 
  (
    rsbmu_vendor integer,
    rsbmu_zone integer,
    rsbmu_subzone integer,
    rsbmu_sales_grp integer,
    rsbmu_sales_sub integer,
    rsbmu_chg_type char(2),
    rsbmu_start_date date,
    rsbmu_end_date date,
    rsbmu_cost decimal(8),
    rsbmu_single decimal(8),
    rsbmu_multi decimal(8),
    rsbmu_case decimal(8),
    rsbmu_retail decimal(8),
    rsbmu_discount decimal(8),
    rsbmu_chg_date datetime year to fraction(5),
    rsbmu_user char(16)
  );

revoke all on rs_b_mass_upd from "public";

{ TABLE fd_order row size = 125 number of columns = 19 index size = 0 }

create table fd_order 
  (
    fdo_nbr integer,
    fdo_ship_date date,
    fdo_prft_ctr smallint,
    fdo_ie char(1),
    fdo_dest_code integer,
    fdo_carrier integer,
    fdo_po_nbr char(12),
    fdo_release char(12),
    fdo_status char(1),
    fdo_thru_date date,
    fdo_hold_stat char(1),
    fdo_user_name char(8),
    fdo_hold_date date,
    fdo_movement integer,
    fdo_ship_time char(11),
    fdo_alt_name char(20),
    fdo_alt_phone char(20),
    fdo_time_stamp datetime year to second,
    fdo_disp_print char(1)
  );

revoke all on fd_order from "public";

{ TABLE ar_cust_aging row size = 318 number of columns = 20 index size = 9 }

create table ar_cust_aging 
  (
    ara_customer integer,
    ara_current_lbl char(20),
    ara_current_amt decimal(16,2),
    ara_30_lbl char(20),
    ara_30_amt decimal(16,2),
    ara_60_lbl char(20),
    ara_60_amt decimal(16,2),
    ara_90_lbl char(20),
    ara_90_amt decimal(16,2),
    ara_fc_lbl char(20),
    ara_fc_amt decimal(16,2),
    ara_budget_lbl char(20),
    ara_budget_amt decimal(16,2),
    ara_current_bal decimal(16,2),
    ara_beg_bal decimal(16,2),
    ara_open_credit decimal(16,2),
    ara_status char(1),
    ara_msg char(100),
    ara_date date,
    ara_time char(8)
  );

revoke all on ar_cust_aging from "public";

{ TABLE ar_ach_entries row size = 166 number of columns = 34 index size = 71 }

create table ar_ach_entries 
  (
    aae_pc_cust integer,
    aae_pc_cust_flag char(1),
    aae_inv_gl_nbr integer,
    aae_glp_seq_nbr smallint,
    aae_dc_tran_type char(2),
    aae_tran_dt date,
    aae_amount decimal(16,2),
    aae_credits decimal(16,2),
    aae_due_dt date,
    aae_disc_date date,
    aae_disc_amt decimal(8,2),
    aae_shift_link integer,
    aae_gl_acct_from integer,
    aae_gl_acct_to integer,
    aae_extract_dt date,
    aae_status char(1),
    aae_create_dt date,
    aae_create_time char(8),
    aae_file_mod char(1),
    aae_ach_batch_nbr integer,
    aae_trace_nbr char(15),
    aae_ach_amount decimal(10,2),
    aae_rcv_dfi_id char(8),
    aae_dfi_account char(17),
    aae_ret_datetime datetime year to second,
    aae_ret_code1 char(3),
    aae_ret_code2 char(3),
    aae_ret_code3 char(3),
    aae_new_gl_invoice integer,
    aae_pay_seq_gl integer,
    aae_ach_test_flag char(1),
    aae_batch_nbr integer,
    aae_ref_nbr integer,
    aae_draft_date date
  );

revoke all on ar_ach_entries from "public";

{ TABLE sys_terms row size = 49 number of columns = 8 index size = 10 }

create table sys_terms 
  (
    term_code char(5),
    term_due_operator char(1),
    term_due_date_days smallint,
    term_disc_operator char(1),
    term_disc_date_day smallint,
    term_disc_percent decimal(8),
    term_desc char(30),
    term_nbr_pmnt smallint
  );

revoke all on sys_terms from "public";

{ TABLE ar_customer row size = 471 number of columns = 54 index size = 9 }

create table ar_customer 
  (
    cust_customer integer,
    cust_status char(2),
    cust_cur_bal decimal(12,2),
    cust_ballststmt decimal(12,2),
    cust_lvl smallint,
    cust_pricefactor smallint,
    cust_terms char(5),
    cust_budg_payment decimal(6,2),
    cust_credit_line decimal(10,2),
    cust_salesman char(4),
    cust_fnc_code char(4),
    cust_bkord_flag char(1),
    cust_hi_dunning smallint,
    cust_lst_dunning smallint,
    cust_open_dt date,
    cust_avg_days smallint,
    cust_bank char(20),
    cust_acct_nbr char(17),
    cust_bad_chks smallint,
    cust_last_sale_dat date,
    cust_last_sale_amt decimal(10,2),
    cust_last_pmt_amt decimal(10,2),
    cust_last_pmt_date date,
    cust_cust_class char(5),
    cust_ytd_sales decimal(12,2),
    cust_times_late smallint,
    cust_ytd_disc decimal(8,2),
    cust_ar_grace_days smallint,
    cust_lst_bad_ck_dt date,
    cust_stmt_cycle smallint,
    cust_ytd_fnc decimal(8,2),
    cust_ngu char(1),
    cust_fo_season smallint,
    cust_int_rate decimal(6),
    cust_ytd_int decimal(6),
    cust_days_pay integer,
    cust_invoice_flag char(1),
    cust_inv_filefmt char(1),
    cust_ach_flag char(1),
    cust_fax_number char(20),
    cust_modem_number char(20),
    cust_fax_to_name char(30),
    cust_email_address char(80),
    cust_co_edi_id char(15),
    cust_file_prefix char(10),
    cust_ftp_server char(30),
    cust_ftp_path char(40),
    cust_ftp_login char(20),
    cust_ftp_password char(20),
    cust_sav_chk_flag char(1),
    cust_aba_routing char(9),
    cust_ach_test_flag char(1),
    cust_reason_code char(2),
    cust_reason_date date
  );

revoke all on ar_customer from "public";

{ TABLE rs_cat row size = 61 number of columns = 9 index size = 9 }

create table rs_cat 
  (
    rsct_catagory char(4),
    rsct_description char(40),
    rsct_gl_sales integer,
    rsct_gl_cogs integer,
    rsct_gl_invt integer,
    rsct_type char(1),
    rsct_dept smallint,
    rsct_tax_flag char(1),
    rsct_invt_method char(1) 
        default 'C'
  );

revoke all on rs_cat from "public";

{ TABLE fm_carrier row size = 303 number of columns = 18 index size = 9 }

create table fm_carrier 
  (
    fmrr_nbr integer,
    fmrr_icc char(10),
    fmrr_ins_cert char(10),
    fmrr_ins_agent char(30),
    fmrr_who char(1),
    fmrr_trans_mode char(10),
    fmrr_ticket_flag char(1),
    fmrr_fax_number char(20),
    fmrr_modem_number char(20),
    fmrr_fax_to_name char(30),
    fmrr_email_address char(30),
    fmrr_co_edi_id char(15),
    fmrr_file_prefix char(10),
    fmrr_ftp_server char(30),
    fmrr_ftp_path char(40),
    fmrr_ftp_login char(20),
    fmrr_ftp_password char(20),
    fmrr_cargo_vesl smallint
  );

revoke all on fm_carrier from "public";

{ TABLE fm_freight row size = 17 number of columns = 5 index size = 12 }

create table fm_freight 
  (
    fmf_origin smallint,
    fmf_dest integer,
    fmf_type char(1),
    fmf_code char(8),
    fmf_miles_sd smallint
  );

revoke all on fm_freight from "public";

{ TABLE sys_bank_acct row size = 184 number of columns = 14 index size = 31 }

create table sys_bank_acct 
  (
    aba_rout char(9),
    bnk_acct char(17),
    bnk_acct_lnk serial not null ,
    bnk_name char(22),
    acct_desc char(30),
    gl_bank_acct integer,
    gl_ap_acct integer,
    gl_disc_acct integer,
    sav_chk_flag char(1),
    prft_ctr integer,
    eft_protocol char(5),
    eft_username char(20),
    eft_password char(20),
    eft_host char(40)
  );

revoke all on sys_bank_acct from "public";

{ TABLE co_company_name row size = 311 number of columns = 15 index size = 0 }

create table co_company_name 
  (
    con_name char(30),
    con_attn char(30),
    con_addr1 char(30),
    con_addr2 char(30),
    con_zip_code char(10),
    con_phone char(14),
    con_phone2 char(14),
    con_email_address char(30),
    con_fax_path char(40),
    con_db_path char(40),
    con_ach_return char(1),
    con_ach_origin_id char(10),
    con_bnk_acct_lnk integer,
    con_phone_descr char(14),
    con_phone2_descr char(14)
  );

revoke all on co_company_name from "public";

{ TABLE rs_b_price_change row size = 78 number of columns = 16 index size = 21 }

create table rs_b_price_change 
  (
    rsbpc_bk_lnk integer,
    rsbpc_ic_lnk integer,
    rsbpc_date date,
    rsbpc_cost decimal(8),
    rsbpc_retail decimal(8),
    rsbpc_promo char(1),
    rsbpc_vend_disc decimal(8),
    rsbpc_multi_price decimal(8),
    rsbpc_case_price decimal(8),
    rsbpc_ent_retail decimal(8),
    rsbpc_ending_date date,
    rsbpc_serial integer,
    rsbpc_user_id char(8),
    rsbpc_action char(1),
    rsbpc_date_chg date,
    rsbpc_time_chg char(8)
  );

revoke all on rs_b_price_change from "public";

{ TABLE ar_altname row size = 456 number of columns = 22 index size = 37 }

create table ar_altname 
  (
    an_customer integer,
    an_cust integer,
    an_name_addr char(180),
    an_city char(4),
    an_phone char(14),
    an_priority char(1),
    an_freight char(1),
    an_zip_code char(10),
    an_print_price char(1),
    an_cust_po char(24),
    an_phone2 char(14),
    an_name char(30),
    an_first_name char(30),
    an_company char(30),
    an_attn_line char(30),
    an_addr1 char(30),
    an_addr2 char(30),
    an_extension char(5),
    an_extension2 char(5),
    an_active char(1),
    an_active_chg_dat date,
    an_last_sale_dat date
  );

revoke all on ar_altname from "public";

{ TABLE fm_delivery row size = 67 number of columns = 10 index size = 13 }

create table fm_delivery 
  (
    fmd_movement integer,
    fmd_invoice integer,
    fmd_date date,
    fmd_dest_code integer,
    fmd_dest_flag char(1),
    fmd_net decimal(8),
    fmd_gross decimal(8),
    fmd_prft_ctr smallint,
    fmd_po_nbr char(24),
    fmd_release char(12)
  );

revoke all on fm_delivery from "public";

{ TABLE si_invoice row size = 133 number of columns = 27 index size = 44 }

create table si_invoice 
  (
    ih_nbr integer,
    ih_seq smallint,
    ih_cust integer,
    ih_prft_ctr smallint,
    ih_shift_link integer,
    ih_shipto integer,
    ih_billto integer,
    ih_date date,
    ih_ship_date date,
    ih_salesman char(4),
    ih_inv_status char(1),
    ih_pmnt_type char(1),
    ih_how_shipped char(5),
    ih_terms char(5),
    ih_freight decimal(8),
    ih_srchg decimal(8),
    ih_mfg_ext char(1),
    ih_total_tax decimal(10,2),
    ih_total_price decimal(10,2),
    ih_bkord_flag char(1),
    ih_print_flag char(1),
    ih_total_cost decimal(10,2),
    ih_cust_po char(24),
    ih_oper char(8),
    ih_order_nbr integer,
    ih_cust_rel char(12),
    ih_entry_date date
  );

revoke all on si_invoice from "public";

{ TABLE sih_invoice row size = 133 number of columns = 27 index size = 9 }

create table sih_invoice 
  (
    ihh_nbr integer,
    ihh_seq smallint,
    ihh_cust integer,
    ihh_prft_ctr smallint,
    ihh_shift_link integer,
    ihh_shipto integer,
    ihh_billto integer,
    ihh_date date,
    ihh_ship_date date,
    ihh_salesman char(4),
    ihh_inv_status char(1),
    ihh_pmnt_type char(1),
    ihh_how_shipped char(5),
    ihh_terms char(5),
    ihh_freight decimal(8),
    ihh_srchg decimal(8),
    ihh_mfg_ext char(1),
    ihh_total_tax decimal(10,2),
    ihh_total_price decimal(10,2),
    ihh_bkord_flag char(1),
    ihh_print_flag char(1),
    ihh_total_cost decimal(10,2),
    ihh_cust_po char(24),
    ihh_oper char(8),
    ihh_order_nbr integer,
    ihh_cust_rel char(12),
    ihh_entry_date date
  );

revoke all on sih_invoice from "public";

{ TABLE rs_purcline row size = 70 number of columns = 13 index size = 40 }

create table rs_purcline 
  (
    rsl_shl integer,
    rsl_vendor integer,
    rsl_inv_nbr char(16),
    rsl_line_num smallint,
    rsl_count decimal(8),
    rsl_cost decimal(8),
    rsl_retail decimal(8),
    rsl_ext_cost decimal(8,2),
    rsl_ext_retail decimal(8,2),
    rsl_cat char(4),
    rsl_prodlnk integer,
    rsl_pblnk integer,
    rsl_grp_nbr integer
  );

revoke all on rs_purcline from "public";

{ TABLE rs_purch row size = 34 number of columns = 5 index size = 29 }

create table rs_purch 
  (
    rsh_shl integer,
    rsh_vendor integer,
    rsh_inv_nbr char(16),
    rsh_pay_meth char(5),
    rsh_inv_amt decimal(8,2)
  );

revoke all on rs_purch from "public";

{ TABLE p_item row size = 118 number of columns = 14 index size = 34 }

create table p_item 
  (
    ph_vendor integer,
    ph_invoice char(16),
    ph_lnk serial not null ,
    ph_shl integer,
    ph_inv_dt date,
    ph_inv_amt decimal(10,2),
    ph_paid_amt decimal(10,2),
    ph_adj_amt decimal(10,2),
    ph_terms char(5),
    ph_type char(1),
    ph_ext_nbr char(10),
    ph_print_flag char(1),
    ph_comment char(50),
    ph_status char(1)
  );

revoke all on p_item from "public";

{ TABLE p_nbr row size = 24 number of columns = 3 index size = 34 }

create table p_nbr 
  (
    pno_vendor integer,
    pno_invoice char(16),
    pno_lnk integer
  );

revoke all on p_nbr from "public";

{ TABLE p_openitem row size = 61 number of columns = 12 index size = 74 }

create table p_openitem 
  (
    poi_vendor integer,
    poi_invoice char(16),
    poi_itm_lnk integer,
    poi_inv_dt date,
    poi_inv_amt decimal(10,2),
    poi_pay_lnk integer,
    poi_due_dt date,
    poi_disc_dt date,
    poi_amt_sch decimal(10,2),
    poi_amt_disc decimal(10,2),
    poi_prft_ctr smallint,
    poi_status char(1)
  );

revoke all on p_openitem from "public";

{ TABLE gl_jrnl_ap row size = 58 number of columns = 12 index size = 76 }

create table gl_jrnl_ap 
  (
    gljap_entry_nbr serial not null ,
    gljap_account integer,
    gljap_period smallint,
    gljap_shl integer,
    gljap_amount decimal(16,2),
    gljap_flag char(1),
    gljap_invoice integer,
    gljap_pp_seq integer,
    gljap_vendor integer,
    gljap_prft_ctr smallint,
    gljap_invoice_nbr char(16),
    gljap_date date
  );

revoke all on gl_jrnl_ap from "public";

{ TABLE rs_daily row size = 63 number of columns = 16 index size = 46 }

create table rs_daily 
  (
    rsd_shl integer,
    rsd_prft_ctr smallint,
    rsd_date date,
    rsd_shift smallint,
    rsd_pumpnum smallint,
    rsd_pumpseq smallint,
    rsd_gal decimal(10),
    rsd_dol decimal(10,2),
    rsd_prodlnk integer,
    rsd_tank char(5),
    rsd_blnd_pumpnum smallint,
    rsd_blnd_pumpseq smallint,
    rsd_blnd_prodlnk integer,
    rsd_blnd_class char(5),
    rsd_use_g char(8),
    rsd_serial serial not null 
  );

revoke all on rs_daily from "public";

{ TABLE p_ach row size = 101 number of columns = 6 index size = 9 }

create table p_ach 
  (
    vendor integer,
    bank char(20),
    acct_nbr char(17),
    aba_routing char(9),
    sav_chk_flag char(1),
    addenda char(50)
  );

revoke all on p_ach from "public";

{ TABLE p_ach_sent row size = 86 number of columns = 6 index size = 9 }

create table p_ach_sent 
  (
    vendor integer,
    check_nbr integer,
    bnk_acct char(17),
    effdate date,
    amount decimal(12,2),
    addenda char(50)
  );

revoke all on p_ach_sent from "public";

{ TABLE p_selection row size = 85 number of columns = 15 index size = 50 }

create table p_selection 
  (
    ps_pay_seq integer not null ,
    ps_user_id char(8),
    ps_print_group char(8),
    ps_amt_sch decimal(10),
    ps_vendor integer,
    ps_ph_lnk integer,
    ps_amt_disc decimal(10),
    ps_disc_date date,
    ps_invoice char(12),
    ps_inv_amt decimal(10,2),
    ps_paid_amt decimal(10,2),
    ps_due_dt date,
    ps_new_amt decimal(10,2),
    ps_new_status char(1),
    ps_inv_dt date
  );

revoke all on p_selection from "public";

{ TABLE rs_b_mix row size = 73 number of columns = 9 index size = 26 }

create table rs_b_mix 
  (
    promo_id serial not null ,
    zone integer,
    descr char(40),
    item_list_id integer,
    start_date date,
    stop_date date,
    units integer,
    promo_type char(2),
    promo_amt decimal(12,2)
  );

revoke all on rs_b_mix from "public";

{ TABLE rs_sls_grp row size = 38 number of columns = 3 index size = 9 }

create table rs_sls_grp 
  (
    rssg_sls_grp integer not null ,
    rssg_cat char(4),
    rssg_desc char(30) not null 
  );

revoke all on rs_sls_grp from "public";

{ TABLE rs_pos_tax row size = 22 number of columns = 4 index size = 9 }

create table rs_pos_tax 
  (
    id integer,
    sales_amt decimal(12,2),
    coll_amt decimal(12,2),
    trans_lnk integer
  );

revoke all on rs_pos_tax from "public";

{ TABLE rs_pos_tender row size = 117 number of columns = 6 index size = 9 }

create table rs_pos_tender 
  (
    code char(25),
    amount decimal(12,2),
    chg_flag char(1),
    account_id char(40),
    account_name char(40),
    trans_lnk integer
  );

revoke all on rs_pos_tender from "public";

{ TABLE rs_pos_lnk row size = 39 number of columns = 8 index size = 28 }

create table rs_pos_lnk 
  (
    ctr integer,
    cashier char(12),
    outside_sale char(1),
    trans_id integer,
    register_id smallint,
    business_dt date,
    rec_time char(8),
    trans_lnk serial not null 
  );

revoke all on rs_pos_lnk from "public";

{ TABLE rs_b_purch row size = 43 number of columns = 7 index size = 34 }

create table rs_b_purch 
  (
    vendor integer,
    ctr integer,
    inv_date date,
    eft_date date,
    invnbr char(16),
    invamt decimal(12,2),
    invlnk serial not null 
  );

revoke all on rs_b_purch from "public";

{ TABLE rs_b_purline row size = 96 number of columns = 10 index size = 31 }

create table rs_b_purline 
  (
    invlnk integer,
    line smallint,
    prodnum char(10),
    qty integer,
    unit_cost decimal(12,2),
    uom char(10),
    upc char(15),
    prod_desc char(30),
    adj_amt decimal(12,2),
    ext_price decimal(12,2)
  );

revoke all on rs_b_purline from "public";

{ TABLE rs_b_item row size = 272 number of columns = 40 index size = 82 }

create table rs_b_item 
  (
    rsbi_vendor integer,
    rsbi_code char(15),
    rsbi_desc char(30),
    rsbi_stock_unit char(7),
    rsbi_group char(3),
    rsbi_seq integer,
    rsbi_cat char(4),
    rsbi_upc char(15),
    rsbi_recv_flag char(1),
    rsbi_send_to_reg char(1),
    rsbi_grp_nbr integer,
    rsbi_margin decimal(8),
    rsbi_ic_lnk serial not null ,
    rsbi_ic_mst integer,
    rsbi_packing char(7),
    rsbi_dept integer,
    rsbi_sls_grp integer,
    rsbi_sls_subgrp integer,
    rsbi_scantype char(1),
    rsbi_flag01 char(1),
    rsbi_flag02 char(1),
    rsbi_flag03 char(1),
    rsbi_flag04 char(1),
    rsbi_flag05 char(1),
    rsbi_flag06 char(1),
    rsbi_flag07 char(1),
    rsbi_active char(1),
    rsbi_upc_single char(15),
    rsbi_upc_multi char(15),
    rsbi_upc_case char(15),
    rsbi_single_desc char(18),
    rsbi_multi_desc char(18),
    rsbi_case_desc char(18),
    rsbi_sku_single char(5),
    rsbi_sku_multi char(5),
    rsbi_sku_case char(5),
    rsbi_btm_lvl char(1),
    rsbi_linked_itm char(15),
    rsbi_user char(8),
    rsbi_date_stamp date
  );

revoke all on rs_b_item from "public";

{ TABLE rs_b_price row size = 76 number of columns = 17 index size = 46 }

create table rs_b_price 
  (
    rsbp_bk_lnk integer,
    rsbp_date date,
    rsbp_cost decimal(8),
    rsbp_retail decimal(8),
    rsbp_promo char(1),
    rsbp_act char(1),
    rsbp_status char(1),
    rsbp_vend_disc decimal(8),
    rsbp_qty integer,
    rsbp_multi_price decimal(8),
    rsbp_case_price decimal(8),
    rsbp_ent_retail decimal(8),
    rsbp_ending_date date,
    rsbp_serial serial not null ,
    rsbp_reason char(5),
    rsbp_user char(8),
    rsbp_date_stamp date
  );

revoke all on rs_b_price from "public";

{ TABLE rs_b_exclude row size = 4 number of columns = 1 index size = 0 }

create table rs_b_exclude 
  (
    dept integer
  );

revoke all on rs_b_exclude from "public";

{ TABLE rs_b_hold_delete row size = 8 number of columns = 2 index size = 0 }

create table rs_b_hold_delete 
  (
    item_list_id integer,
    poscode_lnk integer
  );

revoke all on rs_b_hold_delete from "public";

{ TABLE menu_field row size = 77 number of columns = 6 index size = 12 }

create table menu_field 
  (
    menucode char(3),
    itemdesc char(27),
    exectype char(1),
    execline char(40),
    itemgrp char(2),
    itemlink serial not null 
  );

revoke all on menu_field from "public";

{ TABLE menu_secure row size = 14 number of columns = 2 index size = 19 }

create table menu_secure 
  (
    itemlink integer,
    usercode char(10)
  );

revoke all on menu_secure from "public";

{ TABLE menu_head row size = 56 number of columns = 3 index size = 8 }

create table menu_head 
  (
    menucode char(3),
    title char(50),
    prevmenu char(3)
  );

revoke all on menu_head from "public";

{ TABLE sys_parm row size = 62 number of columns = 3 index size = 7 }

create table sys_parm 
  (
    parm_nbr smallint,
    parm_field char(30),
    parm_desc char(30)
  );

revoke all on sys_parm from "public";

{ TABLE p_mchk row size = 18 number of columns = 4 index size = 9 }

create table p_mchk 
  (
    vendor integer,
    chkno integer,
    chkdate date,
    chkamount decimal(10,2)
  );

revoke all on p_mchk from "public";

{ TABLE p_dchk row size = 58 number of columns = 10 index size = 29 }

create table p_dchk 
  (
    vendor integer,
    invoice char(16),
    itm_lnk integer,
    pay_lnk integer,
    invdate date,
    duedate date,
    discdate date,
    payamount decimal(10,2),
    discountamount decimal(10,2),
    netamount decimal(10,2)
  );

revoke all on p_dchk from "public";

{ TABLE pymgrp row size = 24 number of columns = 3 index size = 7 }

create table pymgrp 
  (
    paygroup char(2),
    description char(20),
    payperiods smallint
  );

revoke all on pymgrp from "public";

{ TABLE pyiemp row size = 70 number of columns = 10 index size = 15 }

create table pyiemp 
  (
    empno char(6),
    recno serial not null ,
    relationship char(1),
    lastname char(25),
    middlename char(1),
    firstname char(16),
    birthdate date,
    ssn char(11),
    ins_medical char(1),
    ins_dental char(1)
  );

revoke all on pyiemp from "public";

{ TABLE pympto row size = 243 number of columns = 32 index size = 8 }

create table pympto 
  (
    ptocode char(3),
    description char(25),
    cycledateflag char(1),
    refdateflag char(1),
    carryoverflag char(1),
    rateunit char(1),
    frequency char(1),
    time1 smallint,
    rate1 decimal(16),
    maxcarryover1 decimal(16),
    maxaccrual1 decimal(16),
    maxavail1 decimal(16),
    time2 smallint,
    rate2 decimal(16),
    maxcarryover2 decimal(16),
    maxaccrual2 decimal(16),
    maxavail2 decimal(16),
    time3 smallint,
    rate3 decimal(16),
    maxcarryover3 decimal(16),
    maxaccrual3 decimal(16),
    maxavail3 decimal(16),
    time4 smallint,
    rate4 decimal(16),
    maxcarryover4 decimal(16),
    maxaccrual4 decimal(16),
    maxavail4 decimal(16),
    time5 smallint,
    rate5 decimal(16),
    maxcarryover5 decimal(16),
    maxaccrual5 decimal(16),
    maxavail5 decimal(16)
  );

revoke all on pympto from "public";

{ TABLE sys_zip row size = 49 number of columns = 5 index size = 15 }

create table sys_zip 
  (
    zip_code char(10),
    city char(30),
    county char(4),
    state char(2),
    country char(3)
  );

revoke all on sys_zip from "public";

{ TABLE gl_jrnl_py row size = 30 number of columns = 8 index size = 35 }

create table gl_jrnl_py 
  (
    entry_nbr serial not null ,
    account integer,
    period smallint,
    prft_ctr smallint,
    trandate date,
    amount decimal(16,2),
    flag char(1),
    chk_lnk integer
  );

revoke all on gl_jrnl_py from "public";

{ TABLE pyhchk row size = 58 number of columns = 10 index size = 29 }

create table pyhchk 
  (
    empno char(6),
    recno serial not null ,
    deductperiod smallint,
    paybegin date,
    payend date,
    chkno integer,
    trandate date,
    chkamt decimal(16,2),
    prft_ctr integer,
    bank_acct char(17)
  );

revoke all on pyhchk from "public";

{ TABLE pympto_earn row size = 8 number of columns = 3 index size = 21 }

create table pympto_earn 
  (
    ptocode char(3),
    earncode char(4),
    plan_type char(1)
  );

revoke all on pympto_earn from "public";

{ TABLE pyichk row size = 41 number of columns = 7 index size = 18 }

create table pyichk 
  (
    recno integer,
    paycode char(4),
    paytype char(1),
    payauthority char(4),
    payunits decimal(16),
    payamount decimal(16,2),
    taxable decimal(16,2)
  );

revoke all on pyichk from "public";

{ TABLE pyttax row size = 500 number of columns = 54 index size = 14 }

create table pyttax 
  (
    taxauthority char(4),
    taxcode char(4),
    taxstatus char(1),
    statusdescription char(25),
    allowance money(16,2),
    allowance2 money(16,2),
    base1 money(16,2),
    percent1 decimal(16),
    over1 money(16,2),
    base2 money(16,2),
    percent2 decimal(16),
    over2 money(16,2),
    base3 money(16,2),
    percent3 decimal(16),
    over3 money(16,2),
    base4 money(16,2),
    percent4 decimal(16),
    over4 money(16,2),
    base5 money(16,2),
    percent5 decimal(16),
    over5 money(16,2),
    base6 money(16,2),
    percent6 decimal(16),
    over6 money(16,2),
    base7 money(16,2),
    percent7 decimal(16),
    over7 money(16,2),
    base8 money(16,2),
    percent8 decimal(16),
    over8 money(16,2),
    base9 money(16,2),
    percent9 decimal(16),
    over9 money(16,2),
    base10 money(16,2),
    percent10 decimal(16),
    over10 money(16,2),
    base11 money(16,2),
    percent11 decimal(16),
    over11 money(16,2),
    base12 money(16,2),
    percent12 decimal(16),
    over12 money(16,2),
    base13 money(16,2),
    percent13 decimal(16),
    over13 money(16,2),
    base14 money(16,2),
    percent14 decimal(16),
    over14 money(16,2),
    base15 money(16,2),
    percent15 decimal(16),
    over15 money(16,2),
    base16 money(16,2),
    percent16 decimal(16),
    over16 money(16,2)
  );

revoke all on pyttax from "public";

{ TABLE co_rpt_ctl row size = 647 number of columns = 9 index size = 0 }

create table co_rpt_ctl 
  (
    corc_rpt_num serial not null ,
    corc_rpt_name char(15),
    corc_where_part char(600),
    corc_who char(10),
    corc_sort smallint,
    corc_sel_page smallint,
    corc_lp_name char(10),
    corc_paper_tray smallint,
    corc_copies smallint
  );

revoke all on co_rpt_ctl from "public";

{ TABLE fm_delvr_d row size = 76 number of columns = 14 index size = 24 }

create table fm_delvr_d 
  (
    fmdd_movement integer,
    fmdd_invoice integer,
    fmdd_dt_seq_nbr smallint,
    fmdd_prodlnk integer,
    fmdd_net decimal(8),
    fmdd_gross decimal(8),
    fmdd_cost decimal(16,5),
    fmdd_freight decimal(16,5),
    fmdd_srchg decimal(8),
    fmdd_frgt_inv integer,
    fmdd_price decimal(16,5),
    fmdd_location char(5),
    fmdd_ngu char(1),
    fmdd_serial serial not null 
  );

revoke all on fm_delvr_d from "public";

{ TABLE fd_delivery row size = 37 number of columns = 9 index size = 0 }

create table fd_delivery 
  (
    fdd_nbr integer,
    fdd_line integer,
    fdd_prodlnk integer,
    fdd_qty integer,
    fdd_price decimal(16,5),
    fdd_location char(5),
    fdd_man_price char(1),
    fdd_have_prods char(1),
    fdd_cur_blend integer
  );

revoke all on fd_delivery from "public";

{ TABLE inv_pur_cstlr row size = 55 number of columns = 12 index size = 81 }

create table inv_pur_cstlr 
  (
    pclr_prft_ctr smallint not null ,
    pclr_prodlnk integer not null ,
    pclr_pur_lyr integer not null ,
    pclr_movement integer not null ,
    pclr_lad_del integer not null ,
    pclr_type char(1) not null ,
    pclr_fill_close date not null ,
    pclr_unit_cost decimal(16,5),
    pclr_qty decimal(10) not null ,
    pclr_rem_qty decimal(10) not null ,
    pclr_serial integer not null ,
    pclr_unique serial not null 
  );

revoke all on inv_pur_cstlr from "public";

{ TABLE fm_cost row size = 31 number of columns = 6 index size = 26 }

create table fm_cost 
  (
    fmc_terminal integer,
    fmc_vendor integer,
    fmc_date date,
    fmc_time char(5),
    fmc_prodlnk integer,
    fmc_cost decimal(16,5)
  );

revoke all on fm_cost from "public";

{ TABLE fm_frgt_cd row size = 97 number of columns = 14 index size = 30 }

create table fm_frgt_cd 
  (
    fmfc_code char(8),
    fmfc_vendor integer,
    fmfc_prod_class char(5),
    fmfc_date_start date,
    fmfc_date_end date,
    fmfc_frgt_in decimal(16,5),
    fmfc_srchg_in decimal(8),
    fmfc_frgt_out decimal(16,5),
    fmfc_srchg_out decimal(8),
    fmfc_description char(30),
    fmfc_type_in char(1),
    fmfc_type_out char(1),
    fmfc_dvr_flag char(1),
    fmfc_dvr_pay decimal(10)
  );

revoke all on fm_frgt_cd from "public";

{ TABLE sys_prft_ctr row size = 513 number of columns = 46 index size = 7 }

create table sys_prft_ctr 
  (
    prft_ctr smallint,
    prft_name char(40),
    prft_zip_code char(9),
    prft_lvl smallint,
    prft_terms char(5),
    prft_use_g char(8),
    prft_posted_date date,
    prft_posted_shift smallint,
    prft_proc_date date,
    prft_proc_shift smallint,
    prft_week_mon smallint,
    prft_week_tue smallint,
    prft_week_wed smallint,
    prft_week_thu smallint,
    prft_week_fri smallint,
    prft_week_sat smallint,
    prft_week_sun smallint,
    prft_freq_map char(1),
    prft_type char(1),
    prft_readings char(1),
    prft_unit char(1),
    prft_uqnty char(1),
    prft_owner char(1),
    prft_fuel char(1),
    prft_addr1 char(30),
    prft_addr2 char(30),
    prft_addr3 char(30),
    prft_cstore char(1),
    prft_con_key char(20),
    prft_car_wash char(1),
    prft_phone char(20),
    prft_reg_type char(2),
    prft_cash_acnt integer,
    prft_ach_flag char(1),
    prft_fax_number char(20),
    prft_modem_number char(20),
    prft_fax_to_name char(30),
    prft_email_address char(30),
    prft_fax_path char(40),
    prft_db_path char(40),
    prft_file_prefix char(10),
    prft_ftp_path char(40),
    prft_ftp_login char(20),
    prft_ftp_password char(20),
    prft_ach_test_flag char(1),
    prft_bnk_acct_lnk integer
  );

revoke all on sys_prft_ctr from "public";

{ TABLE rs_b_vnd_xref row size = 44 number of columns = 2 index size = 0 }

create table rs_b_vnd_xref 
  (
    edi_vendor char(40),
    alt_vendor integer
  );

revoke all on rs_b_vnd_xref from "public";

{ TABLE pydemp row size = 93 number of columns = 14 index size = 34 }

create table pydemp 
  (
    empno char(6),
    recno serial not null ,
    deductcode char(4),
    deductperiods char(12),
    amounttype char(1),
    amount decimal(16,2),
    maxamount money(16,2),
    paid money(16,2),
    startdate date,
    enddate date,
    bankaba char(9),
    bankaccount char(17),
    banktype char(1),
    bankmodifydate date
  );

revoke all on pydemp from "public";

{ TABLE rs_pump row size = 145 number of columns = 29 index size = 11 }

create table rs_pump 
  (
    rspf_prft_ctr smallint,
    rspf_pumpnum smallint,
    rspf_pumpseq smallint,
    rspf_make char(10),
    rspf_model char(10),
    rspf_pos_xref char(3),
    rspf_uo_measure char(5),
    rspf_unit_fraction decimal(8),
    rspf_class char(5),
    rspf_cur_price decimal(8,4),
    rspf_serial_nbr char(20),
    rspf_prodlnk integer,
    rspf_tank_nbr char(5),
    rspf_use_g char(8),
    rspf_roll_gal decimal(12),
    rspf_roll_dol decimal(12),
    rspf_last_gal decimal(14),
    rspf_last_dol decimal(14),
    rspf_last_price decimal(8,4),
    rspf_blend char(1),
    rspf_blnd_pumpnum1 smallint,
    rspf_blnd_pumpseq1 smallint,
    rspf_blnd_perc1 smallint,
    rspf_blnd_pumpnum2 smallint,
    rspf_blnd_pumpseq2 smallint,
    rspf_blnd_perc2 smallint,
    rspf_blnd_pumpnum3 smallint,
    rspf_blnd_pumpseq3 smallint,
    rspf_blnd_perc3 smallint
  );

revoke all on rs_pump from "public";

{ TABLE rs_gl_hdr row size = 10 number of columns = 3 index size = 9 }

create table rs_gl_hdr 
  (
    account integer,
    sort smallint,
    taxcode integer
  );

revoke all on rs_gl_hdr from "public";

{ TABLE rs_gl_det row size = 44 number of columns = 2 index size = 49 }

create table rs_gl_det 
  (
    account integer,
    tendercode char(40)
  );

revoke all on rs_gl_det from "public";

{ TABLE rs_pos_payout row size = 91 number of columns = 4 index size = 9 }

create table rs_pos_payout 
  (
    acct_id char(40),
    acct_name char(40),
    amount decimal(12,2),
    trans_lnk integer
  );

revoke all on rs_pos_payout from "public";

{ TABLE rs_pos_promo row size = 30 number of columns = 4 index size = 9 }

create table rs_pos_promo 
  (
    id integer,
    poscode char(15),
    amount decimal(12,2),
    trans_lnk integer
  );

revoke all on rs_pos_promo from "public";

{ TABLE sys_cur_ver row size = 4 number of columns = 1 index size = 0 }

create table sys_cur_ver 
  (
    last_checked_date date
  );

revoke all on sys_cur_ver from "public";

{ TABLE rs_pos_fuel row size = 108 number of columns = 9 index size = 9 }

create table rs_pos_fuel 
  (
    grade char(8),
    descr char(20),
    act_price decimal(12,4),
    sales_qty decimal(12,4),
    sales_amt decimal(12,2),
    promo_id char(24),
    promo_reason char(24),
    promo_amt decimal(12,2),
    trans_lnk integer
  );

revoke all on rs_pos_fuel from "public";

{ TABLE pyach row size = 30 number of columns = 3 index size = 35 }

create table pyach 
  (
    bank_acct char(17),
    dep_date date,
    dep_amount decimal(16,2)
  );

revoke all on pyach from "public";

{ TABLE rs_reading row size = 49 number of columns = 8 index size = 15 }

create table rs_reading 
  (
    rsr_shl integer,
    rsr_pumpnum integer,
    rsr_breading_gal decimal(12),
    rsr_breading_dol decimal(12),
    rsr_price decimal(12,4),
    rsr_ereading_gal decimal(12),
    rsr_ereading_dol decimal(12),
    rsr_pumpseq smallint
  );

revoke all on rs_reading from "public";

{ TABLE fm_lading_d row size = 82 number of columns = 19 index size = 24 }

create table fm_lading_d 
  (
    fmld_movement integer,
    fmld_bl_nbr integer,
    fmld_seq_nbr smallint,
    fmld_prodlnk integer,
    fmld_location char(5),
    fmld_net decimal(8),
    fmld_gross decimal(8),
    fmld_cost decimal(16,5),
    fmld_invoice_nbr integer,
    fmld_bl_valid char(1),
    fmld_freight decimal(16,5),
    fmld_srchg decimal(8),
    fmld_ngu char(1),
    fmld_blnd_flag smallint,
    fmld_frght_inv_lnk integer,
    fmld_freight_stat char(1),
    fmld_serial serial not null ,
    fmld_prod_inv_date date,
    fmld_frght_inv_dat date
  );

revoke all on fm_lading_d from "public";

{ TABLE fm_mv_bal row size = 76 number of columns = 14 index size = 26 }

create table fm_mv_bal 
  (
    fmmb_movement integer,
    fmmb_bl_nbr integer,
    fmmb_bl_prodlnk integer,
    fmmb_bl_line smallint,
    fmmb_bl_vol decimal(8),
    fmmb_frt_in decimal(16,5),
    fmmb_srchg_in decimal(8),
    fmmb_dv_nbr integer,
    fmmb_dv_prodlnk integer,
    fmmb_dv_line smallint,
    fmmb_dv_vol decimal(8),
    fmmb_frt_out decimal(16,5),
    fmmb_srchg_out decimal(8),
    fmmb_ext_cost decimal(12)
  );

revoke all on fm_mv_bal from "public";

{ TABLE fm_lad_tax row size = 42 number of columns = 11 index size = 24 }

create table fm_lad_tax 
  (
    fmldt_movement integer,
    fmldt_bl_nbr integer,
    fmldt_line smallint,
    fmldt_trn integer,
    fmldt_ulink integer,
    fmldt_type char(1),
    fmldt_amount decimal(16,6),
    fmldt_gal decimal(8),
    fmldt_charge char(1),
    fmldt_extn decimal(8,2),
    fmldt_seq smallint
  );

revoke all on fm_lad_tax from "public";

{ TABLE tx_table row size = 84 number of columns = 15 index size = 30 }

create table tx_table 
  (
    tt_code char(5),
    tt_level char(1),
    tt_where char(10),
    tt_order smallint,
    tt_gl_acct integer,
    tt_rate decimal(16,6),
    tt_charge char(1),
    tt_basis char(1),
    tt_limit decimal(8,2),
    tt_lmt_type char(1),
    tt_date date,
    tt_trn serial not null ,
    tt_descr char(30),
    tt_terms char(5),
    tt_chart_nbr smallint
  );

revoke all on tx_table from "public";

{ TABLE rs_b_zone row size = 34 number of columns = 2 index size = 9 }

create table rs_b_zone 
  (
    zone integer,
    descr char(30)
  );

revoke all on rs_b_zone from "public";

{ TABLE rs_b_zonedet row size = 8 number of columns = 2 index size = 13 }

create table rs_b_zonedet 
  (
    zone integer,
    prft_ctr integer
  );

revoke all on rs_b_zonedet from "public";

{ TABLE rs_b_zoneitm row size = 12 number of columns = 3 index size = 39 }

create table rs_b_zoneitm 
  (
    ic_lnk integer,
    zone integer,
    price_lnk integer
  );

revoke all on rs_b_zoneitm from "public";

{ TABLE sih_inv_line row size = 158 number of columns = 30 index size = 0 }

create table sih_inv_line 
  (
    idph_nbr integer,
    idph_seq_nbr smallint,
    idph_prft_ctr smallint,
    idph_prodlnk integer,
    idph_location char(5),
    idph_qty_ord decimal(10),
    idph_how_shipped char(5),
    idph_qty_shipped decimal(10),
    idph_qty_bkord decimal(10),
    idph_core_qty decimal(10),
    idph_core_price decimal(8),
    idph_cost decimal(16,5),
    idph_tax_amount decimal(8,2),
    idph_ovrrid_flag char(1),
    idph_list_price decimal(16,5),
    idph_sale_price decimal(16,5),
    idph_discount decimal(8,2),
    idph_commiss_amt decimal(8,2),
    idph_gl integer,
    idph_text_flag char(1),
    idph_movement_flag integer,
    idph_freight decimal(8,2),
    idph_srchg decimal(8,2),
    idph_extn decimal(10,2),
    idph_fet_amt_ea decimal(8),
    idph_ngu_shipped char(1),
    idph_norg_qty decimal(10),
    idph_pricing_qty decimal(10),
    idph_serial integer,
    idph_base_cost decimal(8)
  );

revoke all on sih_inv_line from "public";

{ TABLE si_inv_line row size = 154 number of columns = 30 index size = 31 }

create table si_inv_line 
  (
    idp_nbr integer,
    idp_seq_nbr smallint,
    idp_prft_ctr smallint,
    idp_prodlnk integer,
    idp_location char(5),
    idp_qty_ord decimal(10),
    idp_how_shipped char(5),
    idp_qty_shipped decimal(10),
    idp_qty_bkord decimal(10),
    idp_core_qty decimal(10),
    idp_core_price decimal(8),
    idp_cost decimal(8),
    idp_tax_amount decimal(8,2),
    idp_ovrrid_flag char(1),
    idp_list_price decimal(16,5),
    idp_sale_price decimal(16,5),
    idp_discount decimal(8,2),
    idp_commiss_amt decimal(8,2),
    idp_gl integer,
    idp_text_flag char(1),
    idp_movement_flag integer,
    idp_freight decimal(8,2),
    idp_srchg decimal(8,2),
    idp_extn decimal(10,2),
    idp_fet_amt_ea decimal(8),
    idp_ngu_shipped char(1),
    idp_norg_qty decimal(10),
    idp_pricing_qty decimal(10),
    idp_serial serial not null ,
    idp_base_cost decimal(8)
  );

revoke all on si_inv_line from "public";

{ TABLE ar_log row size = 154 number of columns = 8 index size = 19 }

create table ar_log 
  (
    usercode char(10),
    customer integer,
    invoice_nbr integer,
    tran_dt date,
    sent_date date,
    sent_time char(8),
    email_addr_from char(60),
    email_addr_to char(60)
  );

revoke all on ar_log from "public";

{ TABLE pyedi row size = 462 number of columns = 8 index size = 0 }

create table pyedi 
  (
    sent_date date,
    sent_time char(8),
    pay_date date,
    username char(10),
    msg_type char(3),
    file_ref char(32),
    sent_status char(1),
    receipt char(400)
  );

revoke all on pyedi from "public";

{ TABLE company_paye row size = 128 number of columns = 9 index size = 0 }

create table company_paye 
  (
    tax_office char(3),
    paye_ref char(7),
    ao_ref char(13),
    econ char(9),
    sautr char(10),
    cotaxref char(10),
    sortcode char(6),
    sender_id char(35),
    sender_password char(35)
  );

revoke all on company_paye from "public";

{ TABLE py_paye_late row size = 5 number of columns = 2 index size = 9 }

create table py_paye_late 
  (
    tranrecno integer,
    reason_code char(1)
  );

revoke all on py_paye_late from "public";

{ TABLE pypemp row size = 59 number of columns = 7 index size = 11 }

create table pypemp 
  (
    empno char(6),
    leaving_date date,
    taxcode char(10),
    non_cumulative char(1),
    pay_ytd decimal(16,2),
    tax_ytd decimal(16,2),
    payid char(20)
  );

revoke all on pypemp from "public";

{ TABLE sys_row_lock row size = 48 number of columns = 5 index size = 9 }

create table sys_row_lock 
  (
    srl_table char(18) not null ,
    srl_prog_id char(10) not null ,
    srl_user_id char(12) not null ,
    srl_criteria integer,
    srl_nbr serial not null 
  );

revoke all on sys_row_lock from "public";

{ TABLE rs_pos_item row size = 136 number of columns = 19 index size = 9 }

create table rs_pos_item 
  (
    ctr integer,
    cashier char(12),
    register_id smallint,
    trans_id integer,
    business_dt date,
    rec_time char(8),
    poscodefmt char(5),
    poscode char(15),
    entry_meth char(18),
    act_sale_price decimal(12,2),
    department integer,
    sell_units integer,
    reg_sale_price decimal(12,2),
    sales_qty integer,
    sales_amt decimal(12,2),
    disc_amt decimal(12,2),
    disc_reason char(16),
    tax_id integer,
    trans_lnk integer
  );

revoke all on rs_pos_item from "public";

{ TABLE pymded row size = 78 number of columns = 7 index size = 20 }

create table pymded 
  (
    deductcode char(4),
    description char(12),
    sequence smallint,
    w2box smallint,
    w2code char(4),
    glcode integer,
    dummy char(50)
  );

revoke all on pymded from "public";

{ TABLE pymearn row size = 91 number of columns = 11 index size = 20 }

create table pymearn 
  (
    earncode char(4),
    description char(12),
    sequence smallint,
    glcode integer,
    includenet char(1),
    include401k char(1),
    fringe char(1),
    ratefactor decimal(16),
    w2box smallint,
    w2code char(4),
    dummy char(50)
  );

revoke all on pymearn from "public";

{ TABLE pymtax row size = 632 number of columns = 81 index size = 13 }

create table pymtax 
  (
    taxauthority char(4),
    authdescription char(20),
    taxcode char(4),
    codedescription char(12),
    internal_taxcode char(4),
    sequence smallint,
    taxid char(15),
    glcode integer,
    glcode2 integer,
    whopays char(1),
    minwage money(16,2),
    fixedpercent decimal(16),
    percent decimal(16),
    maximum money(16,2),
    percentflag char(1),
    e1 char(4),
    e2 char(4),
    e3 char(4),
    e4 char(4),
    e5 char(4),
    e6 char(4),
    e7 char(4),
    e8 char(4),
    d1 char(4),
    d2 char(4),
    d3 char(4),
    d4 char(4),
    d5 char(4),
    d6 char(4),
    d7 char(4),
    d8 char(4),
    wkcm_ovtexempt char(1),
    workcode1 char(4),
    desc1 char(12),
    rate1 money(16,2),
    limit1 money(16,2),
    workcode2 char(4),
    desc2 char(12),
    rate2 money(16,2),
    limit2 money(16,2),
    workcode3 char(4),
    desc3 char(12),
    rate3 money(16,2),
    limit3 money(16,2),
    workcode4 char(4),
    desc4 char(12),
    rate4 money(16,2),
    limit4 money(16,2),
    workcode5 char(4),
    desc5 char(12),
    rate5 money(16,2),
    limit5 money(16,2),
    workcode6 char(4),
    desc6 char(12),
    rate6 money(16,2),
    limit6 money(16,2),
    workcode7 char(4),
    desc7 char(12),
    rate7 money(16,2),
    limit7 money(16,2),
    workcode8 char(4),
    desc8 char(12),
    rate8 money(16,2),
    limit8 money(16,2),
    workcode9 char(4),
    desc9 char(12),
    rate9 money(16,2),
    limit9 money(16,2),
    workcode10 char(4),
    desc10 char(12),
    rate10 money(16,2),
    limit10 money(16,2),
    workcode11 char(4),
    desc11 char(12),
    rate11 money(16,2),
    limit11 money(16,2),
    workcode12 char(4),
    desc12 char(12),
    rate12 money(16,2),
    limit12 money(16,2),
    dummy char(50)
  );

revoke all on pymtax from "public";

{ TABLE pymemp row size = 940 number of columns = 142 index size = 105 }

create table pymemp 
  (
    empno char(6),
    socsecno char(11),
    title char(16),
    lastname char(25),
    middlename char(1),
    firstname char(16),
    address char(30),
    address2 char(30),
    address3 char(30),
    zip char(10),
    phone char(15),
    contact char(18),
    contactphone char(15),
    sex char(1),
    eeo char(1),
    eeo_category char(1),
    licenseno char(15),
    licenseexpire char(8),
    insno char(15),
    insdate char(8),
    birthdate date,
    hiredate date,
    promotiondate date,
    rehireflag char(1),
    division char(3),
    dptno integer,
    dptsubno char(3),
    dptpercent decimal(16),
    startdec char(1),
    empstatus char(1),
    empstatusdate date,
    jobtitle char(40),
    refersource char(1),
    referdescription char(30),
    offpayroll char(1),
    lastreviewdate date,
    lastraisedate date,
    lastraiseamount money(16,2),
    nextreviewdate date,
    ins_dependlife char(1),
    ins_basiclife char(1),
    ins_longdisable char(1),
    ins_medcarrier char(4),
    ins_medical char(1),
    ins_dental char(1),
    p401k_eligible char(1),
    taxcode char(10),
    nicat char(1),
    director char(1),
    non_cumulative char(1),
    scon char(9),
    sld char(1),
    sortcode char(6),
    paymethod char(1),
    payrate decimal(16,3),
    payunit decimal(16),
    payrate2 decimal(16,3),
    payunit2 decimal(16),
    payrate3 money(16,2),
    payunit3 decimal(16),
    paygroup char(2),
    ficaexempt char(1),
    futaexempt char(1),
    sutaexempt char(1),
    otherexempt char(1),
    workcompclass char(4),
    fed_taxauthority char(4),
    state_taxauthority char(4),
    local_taxauthority char(4),
    local2taxauthority char(4),
    local3taxauthority char(4),
    eic_taxauthority char(4),
    fed_taxstatus char(1),
    state_taxstatus char(1),
    local_taxstatus char(1),
    local2_taxstatus char(1),
    local3_taxstatus char(1),
    eic_taxstatus char(1),
    fed_exemptno smallint,
    state_exemptno smallint,
    local_exemptno smallint,
    local2_exemptno smallint,
    local3_exemptno smallint,
    eic_exemptno smallint,
    fed_exemptextra money(16,2),
    state_exemptextra money(16,2),
    local_exemptextra money(16,2),
    local2_exemptextra money(16,2),
    local3_exemptextra money(16,2),
    eic_exemptextra money(16,2),
    fed_exemptfixed money(16,2),
    state_exemptfixed money(16,2),
    local_exemptfixed money(16,2),
    local2_exemptfixed money(16,2),
    local3_exemptfixed money(16,2),
    eic_exemptfixed money(16,2),
    fed_401k char(1),
    fed_pensionplan char(1),
    fed_statutory char(1),
    fed_deceased char(1),
    vacprevious decimal(16),
    vaccurrent decimal(16),
    vacused decimal(16),
    vacstartdate date,
    vacrate decimal(16),
    vacrateunit char(1),
    vacunit char(1),
    vacnextupdate date,
    vacptocode char(3),
    personalprevious decimal(16),
    personalcurrent decimal(16),
    personalused decimal(16),
    personalstartdate date,
    personalrate decimal(16),
    personalrateunit char(1),
    personalunit char(1),
    personalnextupdate date,
    personalptocode char(3),
    sickprevious decimal(16),
    sickcurrent decimal(16),
    sickused decimal(16),
    sickstartdate date,
    sickrate decimal(16),
    sickrateunit char(1),
    sickunit char(1),
    sicknextupdate date,
    sickptocode char(3),
    year1 smallint,
    ytdearn1 money(16,2),
    ytdded1 money(16,2),
    ytdnet1 money(16,2),
    ytdovtpremium1 money(16,2),
    year2 smallint,
    ytdearn2 money(16,2),
    ytdded2 money(16,2),
    ytdnet2 money(16,2),
    ytdovtpremium2 money(16,2),
    year3 smallint,
    ytdearn3 money(16,2),
    ytdded3 money(16,2),
    ytdnet3 money(16,2),
    ytdovtpremium3 money(16,2)
  );

revoke all on pymemp from "public";

{ TABLE pymhis row size = 55 number of columns = 14 index size = 77 }

create table pymhis 
  (
    module char(1),
    postno integer,
    tranrecno serial not null ,
    empno char(6),
    deductperiod smallint,
    paybegin date,
    payend date,
    statusflag char(1),
    chkno integer,
    trandate date,
    dptno integer,
    chkamt money(16,2),
    glcode integer,
    subref char(4)
  );

revoke all on pymhis from "public";

{ TABLE pythis row size = 108 number of columns = 27 index size = 147 }

create table pythis 
  (
    source char(1),
    tranrecno integer,
    recno serial not null ,
    postno integer,
    postdate date,
    tranyear smallint,
    trandate date,
    perioddate date,
    empno char(6),
    sorttype smallint,
    paytype char(1),
    sortauthority smallint,
    payauthority char(4),
    paycode char(4),
    ficaexempt char(1),
    futaexempt char(1),
    sutaexempt char(1),
    otherexempt char(1),
    dptno integer,
    dptsubno char(3),
    nicat char(1),
    scon char(9),
    payrate money(16,2),
    payunits decimal(16),
    payamount money(16,2),
    taxable money(16,2),
    glcode integer
  );

revoke all on pythis from "public";

{ TABLE si_inv_tax row size = 34 number of columns = 7 index size = 9 }

create table si_inv_tax 
  (
    ilt_nbr integer,
    ilt_line smallint,
    ilt_trn integer,
    ilt_ulink integer,
    ilt_amount decimal(8,2),
    ilt_units decimal(10,2),
    ilt_tax_rate decimal(16,6)
  );

revoke all on si_inv_tax from "public";

{ TABLE sih_inv_tax row size = 34 number of columns = 7 index size = 0 }

create table sih_inv_tax 
  (
    ilth_nbr integer,
    ilth_line smallint,
    ilth_trn integer,
    ilth_ulink integer,
    ilth_amount decimal(8,2),
    ilth_units decimal(10,2),
    ilth_tax_rate decimal(16,6)
  );

revoke all on sih_inv_tax from "public";

{ TABLE rs_b_dept row size = 52 number of columns = 8 index size = 9 }

create table rs_b_dept 
  (
    dpt_nbr integer,
    dpt_desc char(30),
    catagory char(4),
    prodlnk integer,
    active_flag char(1),
    network_prod integer,
    tax_strategy_id integer,
    negative_flag char(1)
  );

revoke all on rs_b_dept from "public";

{ TABLE inv_rec_tax row size = 57 number of columns = 9 index size = 27 }

create table inv_rec_tax 
  (
    rcvr_nbr char(16),
    rcvr_line smallint,
    vendor integer,
    trn integer,
    ulink integer,
    charge char(1),
    amount decimal(16,2),
    units decimal(16,2),
    tax_rate float
  );

revoke all on inv_rec_tax from "public";

{ TABLE tx_vendor row size = 17 number of columns = 3 index size = 22 }

create table tx_vendor 
  (
    vendor integer,
    prodtcl char(5),
    use_g char(8)
  );

revoke all on tx_vendor from "public";

{ TABLE tx_vat row size = 12 number of columns = 2 index size = 0 }

create table tx_vat 
  (
    return_box_nbr integer,
    use_g char(8)
  );

revoke all on tx_vat from "public";

{ TABLE tx_vat_return row size = 119 number of columns = 12 index size = 0 }

create table tx_vat_return 
  (
    period_key char(4),
    start_date date,
    end_date date,
    processing_date char(24),
    form_bundle_nbr char(20),
    vat_due_sales decimal(16,2),
    vat_due_acq decimal(16,2),
    vat_recl_purch decimal(16,2),
    total_sales decimal(16,2),
    total_purch decimal(16,2),
    total_goods_supp decimal(16,2),
    total_acq decimal(16,2)
  );

revoke all on tx_vat_return from "public";

{ TABLE co_gov_gateway row size = 50 number of columns = 2 index size = 0 }

create table co_gov_gateway 
  (
    service char(10),
    access_token char(40)
  );

revoke all on co_gov_gateway from "public";

{ TABLE ar_ref_nbr row size = 8 number of columns = 2 index size = 0 }

create table ar_ref_nbr 
  (
    customer integer,
    ref_nbr integer
  );

revoke all on ar_ref_nbr from "public";

{ TABLE prod_packing_xref row size = 25 number of columns = 2 index size = 0 }

create table prod_packing_xref 
  (
    product char(16),
    packet_weight decimal(16,2)
  );

revoke all on prod_packing_xref from "public";

{ TABLE inv_rec_lot row size = 56 number of columns = 7 index size = 27 }

create table inv_rec_lot 
  (
    vendor integer,
    rcvr char(16),
    line_nbr smallint,
    loc char(5),
    lot_nbr char(16),
    qty decimal(16,2),
    expire_dt date
  );

revoke all on inv_rec_lot from "public";

{ TABLE si_inv_lot row size = 40 number of columns = 6 index size = 16 }

create table si_inv_lot 
  (
    inv_nbr integer,
    line_nbr smallint,
    loc char(5),
    lot_nbr char(16),
    qty decimal(16,2),
    expire_dt date
  );

revoke all on si_inv_lot from "public";

{ TABLE inv_cnt_lot row size = 42 number of columns = 6 index size = 9 }

create table inv_cnt_lot 
  (
    countlnk integer,
    prodlnk integer,
    loc char(5),
    lot_nbr char(16),
    qty decimal(16,2),
    expire_dt date
  );

revoke all on inv_cnt_lot from "public";

{ TABLE sys_country row size = 33 number of columns = 2 index size = 8 }

create table sys_country 
  (
    c_code char(3),
    c_name char(30)
  );

revoke all on sys_country from "public";

{ TABLE py_letter row size = 32 number of columns = 2 index size = 7 }

create table py_letter 
  (
    ltr_no smallint,
    ltr_desc char(30)
  );

revoke all on py_letter from "public";

{ TABLE py_let_line row size = 80 number of columns = 3 index size = 11 }

create table py_let_line 
  (
    ltr_no smallint,
    seq integer,
    txt char(74)
  );

revoke all on py_let_line from "public";

{ TABLE inv_rec_line row size = 105 number of columns = 18 index size = 51 }

create table inv_rec_line 
  (
    pol_num integer,
    pol_line smallint,
    pol_prft_ctr smallint,
    pol_prodlnk integer,
    pol_loc char(5),
    pol_qty_ord decimal(10),
    pol_ngu char(1),
    pol_vendor integer,
    pol_date_expct date,
    pol_price decimal(16,3),
    pol_backord decimal(10),
    pol_freight decimal(8),
    pol_rcvr char(16),
    pol_invoice integer,
    pol_purch_qty decimal(10),
    pol_purch_price decimal(16,3),
    pol_purch_extn decimal(13,2),
    pol_inv_date date
  );

revoke all on inv_rec_line from "public";



revoke usage on language SPL from public ;

grant usage on language SPL to public ;


create unique index ar_class_u on ar_class (arc_code) using 
    btree ;
create unique index u_arcy_code on ar_cycle (arcy_code) using 
    btree ;
create unique index ar_fnc_table_p on ar_fnc_table (fc_fnc_code,
    fc_amount,fc_type) using btree ;
create unique index ar_item_p on ar_item (ar_customer,ar_invoice_nbr,
    ar_seq_nbr) using btree ;
create index ar_item_shl on ar_item (ar_customer,ar_shift_link) 
    using btree ;
create index ar_item_type on ar_item (ar_tran_type) using btree 
    ;
create unique index ar_item_tag_p on ar_item_tag (art_customer,
    art_invoice_nbr,art_line) using btree ;
create unique index ar_type_p on ar_type (at_prft_ctr,at_type_code) 
    using btree ;
create unique index at_ndx2 on ar_type (at_prft_ctr,at_type_code,
    at_oper) using btree ;
create unique index fm_lading_p on fm_lading (fml_movement,fml_bl_nbr) 
    using btree ;
create index fm_lading_s on fm_lading (fml_bl_nbr,fml_vendor) 
    using btree ;
create unique index fm_terminal_u on fm_terminal (fmt_code) 
    using btree ;
create index glj_batch_idx on gl_journal (glj_batch) using btree 
    ;
create index glj_idx1 on gl_journal (glj_date,glj_account,glj_prft_ctr) 
    using btree ;
create unique index gl_jrnl_ar_u on gl_jrnl_ar (gljar_entry_nbr) 
    using btree ;
create index gljar_idx1 on gl_jrnl_ar (gljar_tran_date,gljar_account,
    gljar_prft_ctr) using btree ;
create unique index gl_jrnl_fm_u on gl_jrnl_fm (gljfm_entry_nbr) 
    using btree ;
create index gljfm_idx1 on gl_jrnl_fm (gljfm_tran_date,gljfm_account,
    gljfm_prft_ctr) using btree ;
create index gljfm_ndx2 on gl_jrnl_fm (gljfm_movement) using 
    btree ;
create unique index jrnl_text_p on gl_jrnl_text (gljt_src,gljt_link,
    gljt_seq) using btree ;
create index gljws_idx1 on gl_jrnl_ws (gljws_shl,gljws_account) 
    using btree ;
create unique index gl_master_u on gl_master (glm_series,glm_account,
    glm_prft_ctr) using btree ;
create index glm_group_d on gl_master (glm_series,glm_prft_ctr,
    glm_account) using btree ;
create unique index inv_history_p on inv_history (ph_prft_ctr,
    ph_prodlnk,ph_end_date) using btree ;
create unique index inv_rcvr_head on inv_rec_head (po_vendor,
    po_rcvr) using btree ;
create index inv_rec_head_po on inv_rec_head (po_num) using 
    btree ;
create index inv_secl_comp on inv_secndloc (sl_prft_ctr,sl_prodlnk) 
    using btree ;
create unique index inv_secndloc_p on inv_secndloc (sl_prft_ctr,
    sl_prodlnk,sl_loc) using btree ;
create index p_check_v on p_checks (pv_check_vendor,pv_shl) 
    using btree ;
create index p_checks_lnk on p_checks (pv_shl) using btree ;
    
create index p_chk_acct on p_checks (pv_account) using btree 
    ;
create unique index p_chk_anp on p_checks (pv_account,pv_check_nbr,
    pv_check_paid) using btree ;
create unique index i_p_class on p_class (pcl_code) using btree 
    ;
create index p_itemd_lnk on p_item_d (pd_inv_lnk) using btree 
    ;
create index p_payd_seq on p_pay_d (ppd_seq) using btree ;
create unique index rs_pumpcls_u on rs_pumpcls (rspc_class) 
    using btree ;
create unique index rs_scat_p on rs_scat (rsc_shl,rsc_catagory) 
    using btree ;
create unique index rs_shiftlink_u on rs_shiftlink (rssl_shl) 
    using btree ;
create unique index rssl_ndx1 on rs_shiftlink (rssl_prft_ctr,
    rssl_date,rssl_shift) using btree ;
create unique index rss_shl_u on rs_summary (rss_shl) using 
    btree ;
create unique index si_alt_addr_p on si_alt_addr (ia_nbr,ia_alt_type) 
    using btree ;
create unique index si_inv_text_p on si_inv_text (idt_nbr,idt_line,
    idt_seq) using btree ;
create unique index sih_alt_addr_p on sih_alt_addr (iah_nbr,
    iah_alt_type) using btree ;
create unique index sih_batches_u on sih_batches (ibh_batch_nbr,
    ibh_inv_nbr) using btree ;
create unique index sih_inv_text_u on sih_inv_text (idth_nbr,
    idth_line,idth_seq) using btree ;
create unique index sp_excpt_clas_p on sp_excpt_clas (cce_cust,
    cce_product_cl) using btree ;
create unique index sp_excpt_cust_p on sp_excpt_cust (ce_cust,
    ce_prodlnk) using btree ;
create unique index sp_table_p on sp_table (pt_formula,pt_lvl,
    pt_quantity) using btree ;
create unique index sys_county_u on sys_county (c_code) using 
    btree ;
create unique index tx_cust_prmt_p on tx_cust_prmt (txcp_customer,
    txcp_trn) using btree ;
create unique index tx_customer_p on tx_customer (ta_customer,
    ta_prodtcl,ta_use_g) using btree ;
create unique index tx_use_g_u on tx_use_g (tu_link) using btree 
    ;
create index tx_use_link_k1 on tx_use_link (tul_link) using 
    btree ;
create index tx_use_link_k2 on tx_use_link (tul_trn) using btree 
    ;
create unique index si_nbr_u on si_nbr (in_nbr) using btree 
    ;
create unique index sys_state_u on sys_state (s_code) using 
    btree ;
create index rs_taxes_p on rs_taxes (rstx_shl,rstx_prodlnk,rstx_trn,
    rstx_ulink) using btree ;
create unique index fm_movement_u on fm_movement (fmm_movement) 
    using btree ;
create unique index inv_master_p on inv_master (invt_prft_ctr,
    invt_prodlnk) using btree ;
create unique index oe_comment_u on oe_comment (oeco_customer,
    oeco_type,oeco_order,oeco_seq) using btree ;
create index fd_comment_p on fd_comment (fdco_customer) using 
    btree ;
create index inv_bilmat_k1 on inv_bilmat (bm_prodlnk) using 
    btree ;
create index inv_bilmat_k2 on inv_bilmat (bm_used_prodlnk) using 
    btree ;
create index sico_prod on si_comment (ico_type,ico_prodlnk,ico_seq) 
    using btree ;
create index rscc_idx on rs_cat_current (rscc_prft_ctr,rscc_catagory) 
    using btree ;
create index rscc_prft on rs_cat_current (rscc_prft_ctr) using 
    btree ;
create unique index si_crt_ndx on si_certf (iso_class,iso_seq) 
    using btree ;
create index gl_jrnl_rs_shl on gl_jrnl_rs (gljrs_shl) using 
    btree ;
create unique index gl_jrnl_rs_u on gl_jrnl_rs (gljrs_entry_nbr) 
    using btree ;
create index gljrs_idx1 on gl_jrnl_rs (gljrs_prft_ctr,gljrs_account,
    gljrs_date,gljrs_shift) using btree ;
create index gljrs_idx2 on gl_jrnl_rs (gljrs_date,gljrs_account,
    gljrs_prft_ctr) using btree ;
create index i_counts2 on inv_counts (ic_link) using btree ;
    
create unique index idx_counts on inv_counts (ic_prft_ctr,ic_prodlnk,
    ic_location,ic_date,ic_type_ab) using btree ;
create unique index rs_cat_det_p on rs_cat_det (rscd_catagory,
    rscd_prft_ctr,rscd_period) using btree ;
create index rs_cat_det_pd on rs_cat_det (rscd_period) using 
    btree ;
create index inv_ivch_serial on inv_cost_hist (ivch_serial) 
    using btree ;
create unique index ivch_ndx1 on inv_cost_hist (ivch_prft_ctr,
    ivch_prodlnk,ivch_gl_date,ivch_serial) using btree ;
create unique index inv_header_p on inv_header (ivh_link) using 
    btree ;
create unique index inv_header_u on inv_header (ivh_product) 
    using btree ;
create unique index inv_classes_p on inv_classes (icl_code,icl_type) 
    using btree ;
create unique index ac_ndx1 on ar_comment (ac_customer,ac_date,
    ac_src,ac_seq) using btree ;
create index ar_comment_s on ar_comment (ac_src,ac_next_date) 
    using btree ;
create unique index ar_openitem_ndx on ar_openitem (aroi_customer,
    aroi_invoice_nbr,aroi_seq_nbr) using btree ;
create unique index fm_tank_p on fm_tank (tk_prft_ctr,tk_num) 
    using btree ;
create unique index i_inv_uom on inv_uom (inu_code) using btree 
    ;
create unique index p_altname_n on p_altname (pn_name,pn_alt) 
    using btree ;
create unique index p_altname_u on p_altname (pn_alt) using 
    btree ;
create unique index sclr_ndx1 on inv_sls_cstlr (sclr_unique) 
    using btree ;
create index sclr_ndx2 on inv_sls_cstlr (sclr_prft_ctr,sclr_prodlnk,
    sclr_sls_date) using btree ;
create index sclr_ndx3 on inv_sls_cstlr (sclr_prft_ctr,sclr_prodlnk,
    sclr_pur_lyr) using btree ;
create index sclr_ndx4 on inv_sls_cstlr (sclr_type,sclr_serial) 
    using btree ;
create index sclr_ndx5 on inv_sls_cstlr (sclr_prft_ctr,sclr_prodlnk,
    sclr_type,sclr_serial) using btree ;
create unique index fm_purch_term_ndx on fm_purch_term (fmpt_terminal,
    fmpt_vendor,fmpt_prodlnk,fmpt_use_g) using btree ;
create unique index p_pay_p on p_payment (pp_inv_lnk,pp_seq) 
    using btree ;
create unique index p_pay_u on p_payment (pp_seq) using btree 
    ;
create index p_pay_v on p_payment (pp_check_nbr,pp_check_acct,
    pp_check_draft) using btree ;
create unique index iqsn_ndx1 on iq_salesman_name (iqsn_code) 
    using btree ;
create unique index p_vendor_u on p_vendor (pm_vendor) using 
    btree ;
create index rsbmu_ndx on rs_b_mass_upd (rsbmu_vendor) using 
    btree ;
create unique index ara_ndx on ar_cust_aging (ara_customer) 
    using btree ;
create index aae_idx_3 on ar_ach_entries (aae_pc_cust,aae_inv_gl_nbr,
    aae_pc_cust_flag,aae_glp_seq_nbr) using btree ;
create index aae_ndx1 on ar_ach_entries (aae_ach_batch_nbr,aae_trace_nbr,
    aae_extract_dt,aae_create_dt,aae_create_time) using btree 
    ;
create index aae_ndx2 on ar_ach_entries (aae_status,aae_pc_cust_flag,
    aae_pc_cust,aae_inv_gl_nbr) using btree ;
create unique index sys_terms_u on sys_terms (term_code) using 
    btree ;
create unique index ar_customer_u on ar_customer (cust_customer) 
    using btree ;
create unique index rs_cat_u on rs_cat (rsct_catagory) using 
    btree ;
create unique index fm_carrier_u on fm_carrier (fmrr_nbr) using 
    btree ;
create unique index fm_freight_ndx on fm_freight (fmf_origin,
    fmf_dest,fmf_type) using btree ;
create unique index bnkh_ndx1 on sys_bank_acct (aba_rout,bnk_acct) 
    using btree ;
create index rsbpc_ndx1 on rs_b_price_change (rsbpc_bk_lnk,rsbpc_date_chg,
    rsbpc_user_id) using btree ;
create index an_ndx2 on ar_altname (an_phone) using btree ;
create index an_ndx3 on ar_altname (an_cust) using btree ;
create unique index ar_altname_u on ar_altname (an_customer) 
    using btree ;
create unique index fm_delivery_p on fm_delivery (fmd_movement,
    fmd_invoice) using btree ;
create index si_invoice_c1 on si_invoice (ih_cust,ih_nbr) using 
    btree ;
create index si_invoice_d1 on si_invoice (ih_date,ih_nbr) using 
    btree ;
create index si_invoice_k1 on si_invoice (ih_shift_link) using 
    btree ;
create unique index si_invoice_u on si_invoice (ih_nbr) using 
    btree ;
create unique index sih_invoice_u on sih_invoice (ihh_nbr) using 
    btree ;
create index i_rs_purcline2 on rs_purcline (rsl_prodlnk) using 
    btree ;
create index rs_purcline_ndx on rs_purcline (rsl_shl,rsl_vendor,
    rsl_inv_nbr,rsl_line_num) using btree ;
create unique index rs_purch_ndx on rs_purch (rsh_shl,rsh_vendor,
    rsh_inv_nbr) using btree ;
create unique index p_item_cmb on p_item (ph_vendor,ph_invoice) 
    using btree ;
create unique index p_item_lnk on p_item (ph_lnk) using btree 
    ;
create unique index p_nbr_idx on p_nbr (pno_vendor,pno_invoice) 
    using btree ;
create index p_nbr_lnk on p_nbr (pno_lnk) using btree ;
create index p_open1 on p_openitem (poi_status,poi_vendor,poi_invoice) 
    using btree ;
create index p_open2 on p_openitem (poi_pay_lnk) using btree 
    ;
create unique index p_open3 on p_openitem (poi_status,poi_vendor,
    poi_invoice,poi_pay_lnk) using btree ;
create index poi_itm_idx on p_openitem (poi_itm_lnk) using btree 
    ;
create index gl_jap_lnk on gl_jrnl_ap (gljap_shl) using btree 
    ;
create index gljap_idx1 on gl_jrnl_ap (gljap_prft_ctr,gljap_vendor,
    gljap_invoice_nbr,gljap_date,gljap_account) using btree ;
    
create index gljap_idx2 on gl_jrnl_ap (gljap_date,gljap_account,
    gljap_prft_ctr) using btree ;
create index gljap_idx3 on gl_jrnl_ap (gljap_shl,gljap_invoice,
    gljap_pp_seq) using btree ;
create index rs_daily_ndx1 on rs_daily (rsd_shl,rsd_pumpnum,
    rsd_pumpseq) using btree ;
create index rs_daily_ndx2 on rs_daily (rsd_shl,rsd_blnd_pumpnum,
    rsd_blnd_pumpseq) using btree ;
create unique index rs_daily_ndx3 on rs_daily (rsd_serial) using 
    btree ;
create index rs_daily_ndx4 on rs_daily (rsd_prft_ctr,rsd_date) 
    using btree ;
create unique index p_ach_u on p_ach (vendor) using btree ;
create unique index p_ach_sent_u on p_ach_sent (check_nbr) using 
    btree ;
create index p_paysel on p_selection (ps_user_id,ps_print_group,
    ps_pay_seq) using btree ;
create index p_paysel2 on p_selection (ps_user_id,ps_print_group,
    ps_vendor) using btree ;
create index i_rs_b_mix on rs_b_mix (item_list_id,zone,stop_date) 
    using btree ;
create unique index ix4899_1 on rs_b_mix (promo_id) using btree 
    ;
create unique index rssg_main on rs_sls_grp (rssg_sls_grp) using 
    btree ;
create index i_rs_pos_tax on rs_pos_tax (trans_lnk) using btree 
    ;
create index i_rs_pos_tender on rs_pos_tender (trans_lnk) using 
    btree ;
create unique index i_rs_pos_lnk on rs_pos_lnk (ctr,business_dt,
    trans_id,register_id) using btree ;
create unique index i_trans_lnk on rs_pos_lnk (trans_lnk) using 
    btree ;
create unique index i_rs_b_purch on rs_b_purch (invlnk) using 
    btree ;
create index i_rs_b_purch1 on rs_b_purch (invnbr,vendor) using 
    btree ;
create index i_rs_b_purline on rs_b_purline (invlnk,line) using 
    btree ;
create index i_rs_b_purline1 on rs_b_purline (upc) using btree 
    ;
create index i_rs_b_item on rs_b_item (rsbi_sls_grp) using btree 
    ;
create index rsbi_grp on rs_b_item (rsbi_vendor,rsbi_group,rsbi_seq) 
    using btree ;
create unique index rsbi_lnk on rs_b_item (rsbi_ic_lnk) using 
    btree ;
create index rsbi_lnk_cd on rs_b_item (rsbi_ic_lnk,rsbi_code) 
    using btree ;
create unique index rsbi_v_code on rs_b_item (rsbi_vendor,rsbi_code) 
    using btree ;
create index rsbp_bk_edt on rs_b_price (rsbp_bk_lnk,rsbp_ending_date) 
    using btree ;
create index rsbp_bk_stat on rs_b_price (rsbp_bk_lnk,rsbp_status) 
    using btree ;
create index rsbp_main on rs_b_price (rsbp_bk_lnk,rsbp_date,
    rsbp_promo) using btree ;
create index rsbp_serial on rs_b_price (rsbp_serial) using btree 
    ;
create unique index i_menufield on menu_field (itemlink,menucode) 
    using btree ;
create unique index i_menusecure on menu_secure (itemlink,usercode) 
    using btree ;
create unique index i_menuhead on menu_head (menucode) using 
    btree ;
create unique index sys_parm_u on sys_parm (parm_nbr) using 
    btree ;
create unique index p_mchkvendor on p_mchk (vendor) using btree 
    ;
create unique index p_dchkvendor on p_dchk (vendor,invoice,pay_lnk) 
    using btree ;
create unique index pymgrppaygroup on pymgrp (paygroup) using 
    btree ;
create unique index pyiempempno on pyiemp (empno,recno) using 
    btree ;
create unique index pymptoptocode on pympto (ptocode) using 
    btree ;
create unique index i_sys_zip on sys_zip (zip_code) using btree 
    ;
create unique index gljrnlpy1 on gl_jrnl_py (entry_nbr) using 
    btree ;
create index gljrnlpy2 on gl_jrnl_py (trandate,account,prft_ctr) 
    using btree ;
create index gljrnlpy3 on gl_jrnl_py (account,period) using 
    btree ;
create index pyhchk3 on pyhchk (chkno) using btree ;
create unique index pyhchk_empno on pyhchk (empno) using btree 
    ;
create unique index pyhchk_recno on pyhchk (recno) using btree 
    ;
create unique index pymptoearn on pympto_earn (ptocode,earncode) 
    using btree ;
create index pymptoearn2 on pympto_earn (earncode) using btree 
    ;
create index i_pyichk on pyichk (recno,paytype,paycode,payauthority) 
    using btree ;
create unique index pyttaxcode on pyttax (taxauthority,taxcode,
    taxstatus) using btree ;
create unique index fm_delvr_d_p on fm_delvr_d (fmdd_movement,
    fmdd_invoice,fmdd_dt_seq_nbr) using btree ;
create unique index fm_delvr_d_s on fm_delvr_d (fmdd_serial) 
    using btree ;
create unique index pclr_ndx1 on inv_pur_cstlr (pclr_unique) 
    using btree ;
create index pclr_ndx2 on inv_pur_cstlr (pclr_prft_ctr,pclr_prodlnk,
    pclr_fill_close,pclr_rem_qty) using btree ;
create index pclr_ndx3 on inv_pur_cstlr (pclr_prft_ctr,pclr_prodlnk,
    pclr_pur_lyr) using btree ;
create index pclr_ndx4 on inv_pur_cstlr (pclr_type,pclr_serial) 
    using btree ;
create index pclr_ndx5 on inv_pur_cstlr (pclr_movement,pclr_type) 
    using btree ;
create index pclr_ndx6 on inv_pur_cstlr (pclr_prft_ctr,pclr_prodlnk,
    pclr_movement) using btree ;
create unique index fm_cost_p on fm_cost (fmc_terminal,fmc_vendor,
    fmc_date,fmc_time,fmc_prodlnk) using btree ;
create unique index fmfc_ndx1 on fm_frgt_cd (fmfc_code,fmfc_vendor,
    fmfc_prod_class,fmfc_date_start,fmfc_date_end) using btree 
    ;
create unique index sys_prft_ctr_u on sys_prft_ctr (prft_ctr) 
    using btree ;
create unique index pydempempno on pydemp (empno,deductcode) 
    using btree ;
create unique index pydemprecno on pydemp (empno,recno,deductcode) 
    using btree ;
create unique index rs_pump_ndx1 on rs_pump (rspf_prft_ctr,rspf_pumpnum,
    rspf_pumpseq) using btree ;
create unique index i_rs_gl_hdr on rs_gl_hdr (account) using 
    btree ;
create unique index i_rs_gl_det on rs_gl_det (account,tendercode) 
    using btree ;
create index i_rs_pos_payout on rs_pos_payout (trans_lnk) using 
    btree ;
create index i_rs_pos_promo on rs_pos_promo (trans_lnk) using 
    btree ;
create index i_rs_pos_fuel on rs_pos_fuel (trans_lnk) using 
    btree ;
create index i_pyach on pyach (bank_acct,dep_date,dep_amount) 
    using btree ;
create index rs_reading_p on rs_reading (rsr_shl,rsr_pumpnum,
    rsr_pumpseq) using btree ;
create unique index fm_lading_d_p on fm_lading_d (fmld_movement,
    fmld_bl_nbr,fmld_seq_nbr) using btree ;
create unique index fm_lading_d_s on fm_lading_d (fmld_serial) 
    using btree ;
create index mov_bl on fm_mv_bal (fmmb_movement,fmmb_bl_nbr) 
    using btree ;
create index mov_dv on fm_mv_bal (fmmb_movement,fmmb_dv_nbr) 
    using btree ;
create unique index fmldt_ndx on fm_lad_tax (fmldt_movement,
    fmldt_bl_nbr,fmldt_line,fmldt_trn,fmldt_ulink,fmldt_type) 
    using btree ;
create unique index tx_table_p on tx_table (tt_code,tt_level,
    tt_where) using btree ;
create unique index tx_table_u on tx_table (tt_trn) using btree 
    ;
create unique index i_rs_b_zone on rs_b_zone (zone) using btree 
    ;
create unique index i_rs_b_zonedet on rs_b_zonedet (zone,prft_ctr) 
    using btree ;
create index i1_rs_b_zoneitm on rs_b_zoneitm (price_lnk,ic_lnk) 
    using btree ;
create index i2_rs_b_zoneitm on rs_b_zoneitm (zone) using btree 
    ;
create unique index i_rs_b_zoneitm on rs_b_zoneitm (ic_lnk,zone,
    price_lnk) using btree ;
create index si_inv_line_k1 on si_inv_line (idp_prft_ctr,idp_prodlnk) 
    using btree ;
create index si_inv_line_p on si_inv_line (idp_nbr,idp_seq_nbr) 
    using btree ;
create index si_inv_line_s on si_inv_line (idp_serial) using 
    btree ;
create index i_ar_log on ar_log (sent_date,usercode) using btree 
    ;
create index i_pypayelate on py_paye_late (tranrecno) using 
    btree ;
create unique index i_pypemp on pypemp (empno) using btree ;
    
create index srl_ndx1 on sys_row_lock (srl_criteria) using btree 
    ;
create index i_rs_pos_item on rs_pos_item (trans_lnk) using 
    btree ;
create unique index pymdedcode on pymded (deductcode) using 
    btree ;
create unique index pymdedsequence on pymded (sequence,deductcode) 
    using btree ;
create unique index pymearncode on pymearn (earncode) using 
    btree ;
create unique index pymearnsequence on pymearn (sequence,earncode) 
    using btree ;
create unique index pymtaxcode on pymtax (taxauthority,taxcode) 
    using btree ;
create unique index pymempempno on pymemp (empno) using btree 
    ;
create unique index pymempname on pymemp (lastname,firstname,
    empno) using btree ;
create unique index pymempphone on pymemp (phone,empno) using 
    btree ;
create unique index pymempsocsecno on pymemp (socsecno) using 
    btree ;
create unique index pymhis1 on pymhis (glcode,chkno,tranrecno) 
    using btree ;
create unique index pymhisempno on pymhis (postno,empno) using 
    btree ;
create index pymhispayend on pymhis (empno,payend,tranrecno) 
    using btree ;
create index pymhistrandate on pymhis (trandate,tranrecno) using 
    btree ;
create unique index pymhistranrecno on pymhis (postno,tranrecno) 
    using btree ;
create unique index pythisempdate on pythis (empno,trandate,
    paytype,paycode,recno) using btree ;
create unique index pythisempno on pythis (empno,paytype,payauthority,
    paycode,trandate,recno) using btree ;
create unique index pythisperiodate on pythis (perioddate,recno) 
    using btree ;
create unique index pythissort on pythis (empno,sorttype,paytype,
    sortauthority,payauthority,paycode,recno) using btree ;
create unique index pythissorttype on pythis (sorttype,paytype,
    sortauthority,payauthority,paycode,recno) using btree ;
create unique index pythistrandate on pythis (trandate,recno) 
    using btree ;
create unique index pythistranrecno on pythis (tranrecno,empno,
    recno) using btree ;
create index si_inv_tax_k on si_inv_tax (ilt_nbr) using btree 
    ;
create unique index i_rs_b_dept on rs_b_dept (dpt_nbr) using 
    btree ;
create index i_inv_rec_tax on inv_rec_tax (rcvr_nbr,rcvr_line,
    vendor) using btree ;
create unique index i_tx_vendor on tx_vendor (vendor,prodtcl,
    use_g) using btree ;
create index i_inv_rec_lot1 on inv_rec_lot (vendor,rcvr,line_nbr) 
    using btree ;
create index i_si_inv_lot1 on si_inv_lot (inv_nbr,line_nbr,loc) 
    using btree ;
create index i_inv_cnt_lot1 on inv_cnt_lot (countlnk) using 
    btree ;
create unique index i_sys_country on sys_country (c_code) using 
    btree ;
create unique index i_py_letter on py_letter (ltr_no) using 
    btree ;
create unique index i_py_let_line on py_let_line (ltr_no,seq) 
    using btree ;
create index i_inv_rec_line3 on inv_rec_line (pol_prft_ctr,pol_prodlnk,
    pol_date_expct) using btree ;
create unique index inv_rcvr_line on inv_rec_line (pol_vendor,
    pol_rcvr,pol_line) using btree ;
create index inv_rec_line_po on inv_rec_line (pol_num) using 
    btree ;


