
-- Federal Tables
-- www.irs.gov Publication 15 Cat. No. 10000W, or early notice 1036 Cat. 21974B

update pymtax set percent=4.2, maximum = 106800
      where taxauthority = "FE" and taxcode = "FICA";
update pymtax set percent=6.2, maximum = 106800
      where taxauthority = "FE" and taxcode = "FIC2";
update pymtax set percent = 1.45 
      where taxauthority = "FE" and taxcode = "MEDI";
update pymtax set percent = 1.45 
      where taxauthority = "FE" and taxcode = "MED2";

-- FUTA (Federal unemployment) is 0.8 if taxes paid on time otherwise use 6.0%
update pymtax set percent = 0.8, maximum = 7000
where taxauthority = "FE" and taxcode = "FUTA";


-- Publication 15, Table 7 Annual Payroll Period
delete from pyttax where taxauthority = "FE";
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6) values
                    ("FE", "FWH", "S", "Single", 3700,
                            0.00,  10,      2100,
                          850.00,  15,     10600,
                         4750.00,  25,     36600,
                        17025.00,  28,     85700, 
                        42449.00,  33,    176500, 
                       110016.50,  35,    381250
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6) values
                    ("FE", "FWH", "M", "Married", "3700",
                            0.00,  10,      7900,
                         1700.00,  15,     24900,
                         9500.00,  25,     76900,
                        27087.50,  28,    147250,
                        47513.50,  33,    220200,
                       102574.00,  35,    387050
                    );
-- There were no EIC tables in the 2011 Circular E
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "1", "Single Employee filing", 0,
                            0.00,   20.40,      0,
                         1750.00,       0,   8580,
                         1750.00,  -9.588,  15740
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "3", "Married w/Spouse NOT file", 0,
                            0.00,   20.40,      0,
                         1750.00,       0,   8580,
                         1750.00,  -9.588,  18740
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "2", "Married w/Spouse filing", 0,
                            0.00,   20.40,      0,
                          875.00,       0,   4290,
                          875.00,  -9.588,   9370
                    );


