-- May need to add health ins amount to w2 for 2012 it was optional in 2011

-- Federal Tables
-- www.irs.gov Publication 15 Cat. No. 10000W, or early notice 1036 Cat. 21974B

-- pymtax must exist, shouldn't drop and insert because of G/L info
update pymtax set percent=6.2, maximum = 113700
      where taxauthority = "FE" and taxcode = "FICA";
update pymtax set percent=6.2, maximum = 113700
      where taxauthority = "FE" and taxcode = "FIC2";
update pymtax set percent = 1.45 
      where taxauthority = "FE" and taxcode = "MEDI";
update pymtax set percent = 1.45 
      where taxauthority = "FE" and taxcode = "MED2";

-- FUTA (Federal unemployment) has a 5.4% credit if state unemployment tax
-- is paid on time and in full and on the same wages as FUTA. 
-- Federal law provides for a reduction in the FUTA tax credit when a state
-- has outstanding federal loans.  The reduction is 0.3% for the first year,
-- and an additional 0.3% each succeeding year until the loan is repaid. 
-- List of states that have a FUTA Credit Reduction State:
-- http://www.irs.gov/Businesses/Small-Businesses-&-Self-Employed/FUTA-Credit-Reduction
-- http://workforcesecurity.doleta.gov/unemploy/finance.asp
update pymtax set percent = .6, maximum = 7000
where taxauthority = "FE" and taxcode = "FUTA";


-- Publication 15, Percentage Method Table 7 Annual Payroll Period
-- Set w/h allowance, base tax, bracket rate, over wage amount
delete from pyttax where taxauthority = "FE";
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ("FE", "FWH", "S", "Single", 3900,
                            0.00,  10,      2200,
                          892.50,  15,     11125,
                         4991.25,  25,     38450,
                        17891.25,  28,     90050, 
                        44603.25,  33,    185450, 
                       115586.25,  35,    400550,
                       116163.75,  39.6,  402200
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ("FE", "FWH", "M", "Married", "3900",
                            0.00,  10,      8300,
                         1785.00,  15,     26150,
                         9982.50,  25,     80800, 
                        28457.50,  28,    154700, 
                        49919.50,  33,    231350,
                       107768.50,  35,    406650,
                       125846.00,  39.6,  458300
                    );
-- There were no EIC tables in the 2011 Circular E
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "1", "Single Employee filing", 0,
                            0.00,   20.40,      0,
                         1750.00,       0,   8580,
                         1750.00,  -9.588,  15740
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "3", "Married w/Spouse NOT file", 0,
                            0.00,   20.40,      0,
                         1750.00,       0,   8580,
                         1750.00,  -9.588,  18740
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "2", "Married w/Spouse filing", 0,
                            0.00,   20.40,      0,
                          875.00,       0,   4290,
                          875.00,  -9.588,   9370
                    );


