-- May need to add health ins amount to w2 for 2012 it was optional in 2011

-- Federal Tables
-- www.irs.gov Publication 15 Cat. No. 10000W, or early notice 1036 Cat. 21974B

-- pymtax must exist, shouldn't drop and insert because of G/L info
update pymtax set percent=6.2, maximum = 117000
      where taxauthority = "FE" and taxcode = "FICA";
update pymtax set percent=6.2, maximum = 117000
      where taxauthority = "FE" and taxcode = "FIC2";
update pymtax set percent = 1.45 
      where taxauthority = "FE" and taxcode = "MEDI";
update pymtax set percent = 1.45 
      where taxauthority = "FE" and taxcode = "MED2";

-- Need to add an employee additional Medicare tax code with a rate of
-- 0.9% and modify tax maint to include a field using pymtax.minwage
-- and pyechk.4gl to calculate on a minimum wage and w2 to include this tax.

-- FUTA (Federal unemployment) has a 5.4% credit if state unemployment tax
-- is paid on time and in full and on the same wages as FUTA. 
-- Federal law provides for a reduction in the FUTA tax credit when a state
-- has outstanding federal loans.  The reduction is 0.3% for the first year,
-- and an additional 0.3% each succeeding year until the loan is repaid. 
-- List of states that have a FUTA Credit Reduction State:
-- http://www.irs.gov/Businesses/Small-Businesses-&-Self-Employed/FUTA-Credit-Reduction
-- http://workforcesecurity.doleta.gov/unemploy/finance.asp
update pymtax set percent = .6, maximum = 7000
where taxauthority = "FE" and taxcode = "FUTA";


-- Publication 15, Percentage Method Table 7 Annual Payroll Period
-- Set w/h allowance, base tax, bracket rate, over wage amount
delete from pyttax where taxauthority = "FE";
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ("FE", "FWH", "S", "Single", 3950,
                            0.00,  10,      2250,
                          907.50,  15,     11325,
                         5081.25,  25,     39150,
                        18193.75,  28,     91600, 
                        45353.75,  33,    188600, 
                       117541.25,  35,    407350,
                       118118.75,  39.6,  409000
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ("FE", "FWH", "M", "Married", 3950,
                            0.00,  10,      8450,
                         1815.00,  15,     26600,
                        10162.50,  25,     82250, 
                        28925.00,  28,    157300, 
                        50765.00,  33,    235300,
                       109587.50,  35,    413550,
                       127962.50,  39.6,  466050
                    );
-- There were no EIC tables in the 2011 Circular E
{
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "1", "Single Employee filing", 0,
                            0.00,   20.40,      0,
                         1750.00,       0,   8580,
                         1750.00,  -9.588,  15740
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "3", "Married w/Spouse NOT file", 0,
                            0.00,   20.40,      0,
                         1750.00,       0,   8580,
                         1750.00,  -9.588,  18740
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3) values
                    ("FE", "EIC", "2", "Married w/Spouse filing", 0,
                            0.00,   20.40,      0,
                          875.00,       0,   4290,
                          875.00,  -9.588,   9370
                    );
}

