-- Federal Tables
-- www.irs.gov Publication 15 Cat. No. 10000W, or early notice 1036 Cat. 21974B

-- pymtax must exist, shouldn't drop and insert because of G/L info
update pymtax set percent=6.2, maximum = 128400
      where taxauthority = 'FE' and taxcode = 'FICA';
update pymtax set percent=6.2, maximum = 128400
      where taxauthority = 'FE' and taxcode = 'FIC2';
update pymtax set percent = 1.45 
      where taxauthority = 'FE' and taxcode = 'MEDI';
update pymtax set percent = 1.45 
      where taxauthority = 'FE' and taxcode = 'MED2';

-- Need to add an employee additional Medicare tax code with a rate of
-- 0.9% and modify tax maint to include a field using pymtax.minwage
-- and pyechk.4gl to calculate on a minimum wage and w2 to include this tax.

-- FUTA (Federal unemployment) has a 5.4% credit if state unemployment tax
-- is paid on time and in full and on the same wages as FUTA. 
-- Federal law provides for a reduction in the FUTA tax credit when a state
-- has outstanding federal loans.  The reduction is 0.3% for the first year,
-- and an additional 0.3% each succeeding year until the loan is repaid. 
-- List of states that have a FUTA Credit Reduction State:
-- http://www.irs.gov/Businesses/Small-Businesses-&-Self-Employed/FUTA-Credit-Reduction
-- http://workforcesecurity.doleta.gov/unemploy/finance.asp
update pymtax set percent = .6, maximum = 7000
where taxauthority = 'FE' and taxcode = 'FUTA';


-- Publication 15, Percentage Method Table 7 Annual Payroll Period
-- Set w/h allowance, base tax, bracket rate, over wage amount
delete from pyttax where taxauthority = 'FE';
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'S', 'Single', 4150,
                            0.00,  10,      3700,
                          952.50,  12,     13225,
                         4453.50,  22,     42400,
                        14089.50,  24,     86200, 
                        32089.50,  32,    161200, 
                        45689.50,  35,    203700,
                       150689.50,  37,    503700
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'M', 'Married', 4150,
                            0.00,  10,     11550,
                         1905.00,  12,     30600,
                         8907.00,  22,     88950, 
                        28179.00,  24,    176550, 
                        64179.00,  32,    326550,
                        91379.00,  35,    411550,
                       161379.00,  37,    611550
                    );

