-- Federal Tables
-- https://www.irs.gov/forms-pubs/about-publication-15

-- pymtax must exist, cannot drop and insert because of G/L info
update pymtax set percent=6.2, maximum = 137700
      where taxauthority = 'FE' and taxcode = 'FICA';
update pymtax set percent=6.2, maximum = 137700
      where taxauthority = 'FE' and taxcode = 'FIC2';
update pymtax set percent = 1.45 
      where taxauthority = 'FE' and taxcode = 'MEDI';
update pymtax set percent = 1.45 
      where taxauthority = 'FE' and taxcode = 'MED2';

-- Need to add an employee additional Medicare tax code with a rate of
-- 0.9% and modify tax maint to include a field using pymtax.minwage
-- and pyechk.4gl to calculate on a minimum wage and w2 to include this tax.

-- FUTA (Federal unemployment) has a 5.4% credit if state unemployment tax
-- is paid on time and in full and on the same wages as FUTA. 
-- Federal law provides for a reduction in the FUTA tax credit when a state
-- has outstanding federal loans.  The reduction is 0.3% for the first year,
-- and an additional 0.3% each succeeding year until the loan is repaid. 
-- List of states that have a FUTA Credit Reduction State:
-- http://www.irs.gov/Businesses/Small-Businesses-&-Self-Employed/FUTA-Credit-Reduction
update pymtax set percent = .6, maximum = 7000
where taxauthority = 'FE' and taxcode = 'FUTA';


-- https://www.irs.gov/forms-pubs/about-publication-15-t
-- Publication 15T, Annual Percentage Method Tables for Automated Payroll
-- Use the Standard Withholding Rate Schedules, a flag would need to be added
-- to the system to use the Form W-4 Step 2 Checkbox rates.
-- Set w/h allowance, base tax, bracket rate, over wage amount
-- As of 2020 there is no longer a personal exemption amount
delete from pyttax where taxauthority = 'FE';
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'M', 'Married', 0,
                            0.00,  10,     11900,
                         1975.00,  12,     31650,
                         9235.00,  22,     92150,
                        29211.00,  24,    182950,
                        66543.00,  32,    338500,
                        94735.00,  35,    426600,
                       167307.50,  37,    633950
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'S', 'Single', 0,
                            0.00,  10,      3800,
                          987.50,  12,     13675,
                         4617.50,  22,     43925,
                        14605.50,  24,     89325,
                        33271.50,  32,    167100,
                        47367.50,  35,    211150,
                       156235.00,  37,    522200
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'H', 'Head of Household', 0,
                            0.00,  10,     10050,
                         1410.00,  12,     24150,
                         6162.00,  22,     63750,
                        13158.00,  24,     95550,
                        31830.00,  32,    173350,
                        45926.00,  35,    217400,
                       154793.50,  37,    528450
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', '1', 'Married W-4 Checkbox', 0,
                            0.00,  10,     12400,
                          987.50,  12,     22275,
                         4617.50,  22,     52525,
                        14605.50,  24,     97925,
                        33271.50,  32,    175700,
                        47367.50,  35,    219750,
                        83653.75,  37,    323425
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', '2', 'Single W-4 Checkbox', 0,
                            0.00,  10,      6200,
                          493.75,  12,     11138,
                         2308.75,  22,     26263,
                         7302.75,  24,     48963,
                        16635.75,  32,     87850,
                        23683.75,  35,    109875,
                        78117.50,  37,    265400
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', '3', 'Head House W-4 Check', 0,
                            0.00,  10,      9325,
                          705.00,  12,     16375,
                         3081.00,  22,     36175,
                         6579.00,  24,     52075,
                        15915.00,  32,     90975,
                        22963.00,  35,    113000,
                        77396.75,  37,    268525
                    );

