-- Federal Tables
-- https://www.irs.gov/forms-pubs/about-publication-15-t
-- https://www.irs.gov/forms-pubs/about-publication-15

-- pymtax must exist, cannot drop and insert because of G/L info
update pymtax set percent=6.2, maximum = 142800
      where taxauthority = 'FE' and taxcode = 'FICA';
update pymtax set percent=6.2, maximum = 142800
      where taxauthority = 'FE' and taxcode = 'FIC2';
update pymtax set percent = 1.45 
      where taxauthority = 'FE' and taxcode = 'MEDI';
update pymtax set percent = 1.45 
      where taxauthority = 'FE' and taxcode = 'MED2';

-- Need to add an employee additional Medicare tax code with a rate of
-- 0.9% and modify tax maint to include a field using pymtax.minwage
-- and pyechk.4gl to calculate on a minimum wage and w2 to include this tax.

-- FUTA (Federal unemployment) has a 5.4% credit if state unemployment tax
-- is paid on time and in full and on the same wages as FUTA. 
-- Federal law provides for a reduction in the FUTA tax credit when a state
-- has outstanding federal loans. The reduction is 0.3% for the first year,
-- and an additional 0.3% each succeeding year until the loan is repaid. 
-- List of states that have a FUTA Credit Reduction State:
-- http://www.irs.gov/Businesses/Small-Businesses-&-Self-Employed/FUTA-Credit-Reduction
update pymtax set percent = .6, maximum = 7000
where taxauthority = 'FE' and taxcode = 'FUTA';


-- https://www.irs.gov/forms-pubs/about-publication-15-t
-- Publication 15T, Annual Percentage Method Tables for Automated Payroll
-- Use the Standard Withholding Rate Schedules, for tax status M, S, H use
-- Form W-4, Step 2, Checkbox, Withholding Rate Schedules for status 1, 2, 3.
-- Column 'base' is amount to withhold.
-- Column 'over' is amount annual wage exceeds.
-- As of 2020 there is no longer a personal exemption amount
delete from pyttax where taxauthority = 'FE';
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'M', 'Married', 0,
                            0.00,  10,     12200,
                         1990.00,  12,     32100,
                         9328.00,  22,     93250,
                        29502.00,  24,    184950,
                        67206.00,  32,    342050,
                        95686.00,  35,    431050,
                       168993.50,  37,    640500
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'S', 'Single', 0,
                            0.00,  10,      3950,
                          995.00,  12,     13900,
                         4664.00,  22,     44475,
                        14751.00,  24,     90325,
                        33603.00,  32,    168875,
                        47843.00,  35,    213375,
                       157804.25,  37,    527550
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', 'H', 'Head of Household', 0,
                            0.00,  10,     10200,
                         1420.00,  12,     24400,
                         6220.00,  22,     64400,
                        13293.00,  24,     96550,
                        32145.00,  32,    175100,
                        46385.00,  35,    219600,
                       156355.00,  37,    533800
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription, 
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', '1', 'Married W-4 Checkbox', 0,
                            0.00,  10,     12550,
                          995.00,  12,     22500,
                         4664.00,  22,     53075,
                        14751.00,  24,     98925,
                        33603.00,  32,    177475,
                        47843.00,  35,    221975,
                        84496.75,  37,    326700
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', '2', 'Single W-4 Checkbox', 0,
                            0.00,  10,      6275,
                          497.50,  12,     11250,
                         2332.00,  22,     26538,
                         7375.50,  24,     49463,
                        16801.50,  32,     88738,
                        23921.50,  35,    110988,
                        78902.13,  37,    268075
                    );
insert into pyttax (taxauthority, taxcode, taxstatus, statusdescription,
                    allowance,
                    base1, percent1,  over1,
                    base2, percent2,  over2,
                    base3, percent3,  over3,
                    base4, percent4,  over4,
                    base5, percent5,  over5,
                    base6, percent6,  over6,
                    base7, percent7,  over7) values
                    ('FE', 'FWH', '3', 'Head House W-4 Check', 0,
                            0.00,  10,      9400,
                          710.00,  12,     16500,
                         3110.00,  22,     36500,
                         6646.50,  24,     52575,
                        16072.50,  32,     91850,
                        22192.50,  35,    114100,
                        78177.50,  37,    271200
                    );

