-- pymtax must exist, do not drop or user entered info will be lost.
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values 
                    ("HMRC",
                     "HM REVENUE & CUSTOMS",
                     "TX",
                     "INCOME TAX",
                     "E");

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ("HMRC",
                     "HM REVENUE & CUSTOMS",
                     "NI",
                     "EMPLOYEE NI",
                     "E");

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ("HMRC",
                     "HM REVENUE & CUSTOMS",
                     "NI2",
                     "EMPLOYER NI",
                     "C");

-- https://www.gov.uk/rates-and-thresholds-for-employers-2015-to-2016
-- https://www.gov.uk/government/publications/payroll-technical-specifications-national-insurance
delete from pyttax where taxauthority = "HMRC" and taxcode = "TX";
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ("HMRC", "TX", "0", 10600.00, .50,
                             0.00,  20,   31785.00,
                         31786.00,  40,  150000.00,
                        150001.00,  45,       null);


-- Include all NI thresholds LEL, PT, ST, UAP, UEL. Note that there is
-- overlap of PT and ST on employee and employer tables, they don't 
-- list PT for employee and ST for employer. Both of these thresholds
-- need to be included for rounding purposes. For employee ST and UAP 
-- thresholds will use the same rate and for employer PT and ST will 
-- use the same rates.

-- Employee (primary) contribution rates
delete from pyttax where taxauthority = "HMRC" and taxcode = "NI";
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "A", null,
                          5824.00,    0,    8060.00,
                          8061.00,   12,    8112.00,
                          8113.00,   12,   40040.00,
                         40041.00,   12,   42385.00,
                         42386.00,    2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,             
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "B", null,
                          5824.00,     0,    8060.00,
                          8061.00,  5.85,    8112.00,
                          8113.00,  5.85,   40040.00,
                         40041.00,  5.85,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "C", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00,     0,   40040.00,
                         40041.00,     0,   42385.00,
                         42386.00,     0,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "D", null,
                          5824.00,  -1.4,    8060.00,
                          8061.00, 10.60,    8112.00,
                          8113.00, 10.60,   40040.00,
                         40041.00,    12,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "E", null,
                          5824.00,     0,    8060.00,
                          8061.00,  5.85,    8112.00,
                          8113.00,  5.85,   40040.00,
                         40041.00,  5.85,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "I", null,
                          5824.00,  -1.4,    8060.00,
                          8061.00, 10.60,    8112.00,
                          8113.00, 10.60,   40040.00,
                         40041.00,    12,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "J", null,
                          5824.00,     0,    8060.00,
                          8061.00,     2,    8112.00,
                          8113.00,     2,   40040.00,
                         40041.00,     2,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "K", null,
                          5824.00,  -1.4,    8060.00,
                          8061.00,     2,    8112.00,
                          8113.00,     2,   40040.00,
                         40041.00,     2,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "L", null,
                          5824.00,  -1.4,    8060.00,
                          8061.00,     2,    8112.00,
                          8113.00,     2,   40040.00,
                         40041.00,     2,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "M", null,
                          5824.00,     0,    8060.00,
                          8061.00,    12,    8112.00,
                          8113.00,    12,   40040.00,
                         40041.00,    12,   42385.00,
                         42386.00,     2,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI", "Z", null,
                          5824.00,     0,    8060.00,
                          8061.00,     2,    8112.00,
                          8113.00,     2,   40040.00,
                         40041.00,     2,   42385.00,
                         42386.00,     2,       null);


-- Employer (secondary) contribution rates
-- The last two columns on the employer rates page are rebates for the first two
delete from pyttax where taxauthority = "HMRC" and taxcode = "NI2";
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "A", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00, 13.80,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "B", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00, 13.80,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "C", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00, 13.80,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "D", null,
                          5824.00, -3.40,    8060.00,
                          8061.00, -3.40,    8112.00,
                          8113.00, 10.40,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "E", null,
                          5824.00, -3.40,    8060.00,
                          8061.00, -3.40,    8112.00,
                          8113.00, 10.40,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "I", null,
                          5824.00, -3.40,    8060.00,
                          8061.00, -3.40,    8112.00,
                          8113.00, -3.40,   40040.00,
                         40041.00,     0,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "J", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00, 13.80,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "K", null,
                          5824.00, -3.40,    8060.00,
                          8061.00, -3.40,    8112.00,
                          8113.00, -3.40,   40040.00,
                         40041.00,     0,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "L", null,
                          5824.00, -3.40,    8060.00,
                          8061.00, -3.40,    8112.00,
                          8113.00, 10.40,   40040.00,
                         40041.00, 13.80,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "M", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00,     0,   40040.00,
                         40041.00,     0,   42385.00,
                         42386.00, 13.80,       null);

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ("HMRC", "NI2", "Z", null,
                          5824.00,     0,    8060.00,
                          8061.00,     0,    8112.00,
                          8113.00,     0,   40040.00,
                         40041.00,     0,   42385.00,
                         42386.00, 13.80,       null);

