-- pymtax must exist, do not drop or user entered info will be lost.
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values 
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'TX',
                     'INCOME TAX',
                     'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'NI',
                     'EMPLOYEE NI',
                     'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'NI2',
                     'EMPLOYER NI',
                     'C');

-- www.gov.uk/government/collections/rates-and-allowances-hm-revenue-and-customs
-- https://www.gov.uk/government/publications/tax-and-tax-credit-rates-and-thresholds-for-2016-17
-- pyttax.allowance2 is used for the overriding regulatory limit on income tax
-- The limit can be found in 'PAYE tax table routine version 13 (Oct 2014)'
-- https://www.gov.uk/government/publications/payroll-technical-specifications-income-tax
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX', '0', 11000.00, .50,
                             0.00,  20,   32000.00,
                         32001.00,  40,  150000.00,
                        150001.00,  45,       null);


-- https://www.gov.uk/government/publications/payroll-technical-specifications-national-insurance
-- Appendix 1, Earnings bands and NICs percentage rates
-- shaded rates shown in the table are rebates or negative
-- Lower Earnings Limit (LEL)
-- Primary Threshold (PT)
-- Secondary Threshold (ST)
-- Upper Accrual Point (UAP) not used for 16-17
-- Upper Earnings Limit (UEL)

-- Include all NI thresholds LEL, PT, ST, UAP, UEL. Note that there is
-- overlap of PT and ST on employee and employer tables, they don't 
-- list PT for employee and ST for employer. Both of these thresholds
-- need to be included for rounding purposes. For employee ST and UAP 
-- thresholds will use the same rate and for employer PT and ST will 
-- use the same rates.

-- Employee (primary) contribution rates
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'A', null,
                       5824.00,     0,   8060.00,  -- >LEL
                       8061.00,    12,   8112.00,  -- >PT
                       8113.00,    12,  43000.00,  -- >ST
                      43001.00,     2,      null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,             
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'B', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00, 5.85,    8112.00,  -- >PT
                          8113.00, 5.85,   43000.00,  -- >ST
                         43001.00,    2,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'C', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00,    0,   43000.00,  -- >ST
                         43001.00,    0,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'H', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,   12,    8112.00,  -- >PT
                          8113.00,   12,   43000.00,  -- >ST
                         43001.00,    2,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'J', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    2,    8112.00,  -- >PT
                          8113.00,    2,   43000.00,  -- >ST
                         43001.00,    2,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'M', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,   12,    8112.00,  -- >PT
                          8113.00,   12,   43000.00,  -- >ST
                         43001.00,    2,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'Z', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    2,    8112.00,  -- >PT
                          8113.00,    2,   43000.00,  -- >ST
                         43001.00,    2,       null); -- >UEL


-- Employer (secondary) contribution rates
-- The last two columns on the employer rates page are rebates for the first two
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'A', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00, 13.8,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'B', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00, 13.8,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'C', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00, 13.8,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'H', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00,    0,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'J', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00, 13.8,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'M', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00,    0,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'Z', null,
                          5824.00,    0,    8060.00,  -- >LEL
                          8061.00,    0,    8112.00,  -- >PT
                          8113.00,    0,   43000.00,  -- >ST
                         43001.00, 13.8,       null); -- >UEL

