-- pymtax must exist, do not drop or user entered info will be lost.
-- Income tax
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values 
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'TX',
                     'INCOME TAX',
                     'E');

-- Scottish income tax
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'TX2',
                     'INC TAX SCOT',
                     'E');

-- National Insurance employee share
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'NI',
                     'EMPLOYEE NI',
                     'E');

-- National Insurance company share
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'NI2',
                     'EMPLOYER NI',
                     'C');

-- www.gov.uk/government/collections/rates-and-allowances-hm-revenue-and-customs
-- https://www.gov.uk/government/publications/tax-and-tax-credit-rates-and-thresholds-for-2017-18
-- pyttax.allowance2 is used for the overriding regulatory limit on income tax
-- The limit can be found in 'PAYE tax table routines version 15.2 (Feb 2017)'
-- https://www.gov.uk/government/publications/payroll-technical-specifications-income-tax
--
-- https://www.gov.uk/government/publications/p9x-tax-codes
-- https://www.gov.uk/guidance/rates-and-thresholds-for-employers-2017-to-2018
--
-- Income tax bands of taxable income (GBP per year)
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX', '0', 11500.00, .50,-- Allowance & reg limit
                             0.00,  20,  33500.00,    -- Basic rate
                         33501.00,  40, 150000.00,    -- Higher rate
                        150001.00,  45,     null);    -- Additional rate

-- http://www.gov.scot/incometax
-- Use the amounts from UK site the Scot site includes the personal
-- allowance in the band amounts.
-- Scottish income tax
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX2', '0', 11500.00, .50,-- Allowance & reg limit
                             0.00,  20,  31500.00,     -- Basic rate
                         31501.00,  40, 150000.00,     -- Higher rate
                        150001.00,  45,      null);    -- Additional rate


-- https://www.gov.uk/government/publications/payroll-technical-specifications-national-insurance
-- Appendix 1, Earnings bands and NICs percentage rates
-- shaded rates shown in the table are rebates or negative
-- Lower Earnings Limit (LEL)
-- Primary Threshold (PT)
-- Secondary Threshold (ST)
-- Upper Earnings Limit (UEL)

-- Include all NI thresholds LEL, PT, ST, UEL. Note that there is
-- overlap of PT and ST on employee and employer tables, they don't 
-- list PT for employee and ST for employer. Both of these thresholds
-- need to be included for rounding purposes. For employee ST and UAP 
-- thresholds will use the same rate and for employer PT and ST will 
-- use the same rates.

-- NIC earning bands and percentage rates
--
-- Employee (primary) contribution rates
-- If the number of bands is changed also update nic_bands()
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    -- Except for the first band, the lower base amount is set
                    -- in the program to the preceding upper over amount.
                    -- Because the base amount is subtracted off the pay
                    -- the upper amount can be considered the next band.
                    ('HMRC', 'NI', 'A', null,
                       5876.00,     0,   8164.00,  -- LEL+
                       8164.00,    12,  45000.00,  -- PT/ST+
                       -- 0000.00,    00,  00000.00,  -- ST+
                      45000.00,     2,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,             
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'B', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00, 5.85,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00,    2,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'C', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,    0,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00,    0,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'H', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,   12,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00,    2,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'J', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,    2,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00,    2,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'M', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,   12,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00,    2,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI', 'Z', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,    2,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00,    2,       null); -- UEL+



-- Employer (secondary) contribution rates
-- The last two columns on the employer rates page are rebates for the first two
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'A', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00, 13.8,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'B', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00, 13.8,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'C', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00, 13.8,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'H', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,    0,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'J', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00, 13.8,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'M', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,    0,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    --base4, percent4, over4
                    ) values
                    ('HMRC', 'NI2', 'Z', null,
                          5876.00,    0,    8164.00,  -- LEL+
                          8164.00,    0,   45000.00,  -- PT/ST+
                          --0000.00,  0,   00000.00,  -- ST+
                         45000.00, 13.8,       null); -- UEL+

