--
-- UK Paye tax tables for 2019-2020
--
-- The FPS XML namespace is set for the current payroll year, but you can
-- override it by setting the following environment variable:
-- SS_FPS_NS=http://www.govtalk.gov.uk/taxation/PAYE/RTI/FullPaymentSubmission/19-20/1
--

-- pymtax must exist, do not drop or user entered info will be lost.
--
-- Income tax
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values 
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'TX',
                     'INCOME TAX',
                     'E');

-- Scottish income tax
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'TX2',
                     'INC TAX SCOT',
                     'E');

-- Wales income tax
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'TX3',
                     'INC TAX WALE',
                     'E');

-- National Insurance employee share
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'NI',
                     'EMPLOYEE NI',
                     'E');

-- National Insurance company share
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    whopays) values                                             
                    ('HMRC',
                     'HM REVENUE & CUSTOMS',
                     'NI2',
                     'EMPLOYER NI',
                     'C');

-- pyttax.allowance2 is used for the overriding regulatory limit on income tax,
-- the limit can be found in 'PAYE tax table routines version 16.1 (Feb 2018)'
-- https://www.gov.uk/government/publications/payroll-technical-specifications-income-tax
--
-- www.gov.uk/government/collections/rates-and-allowances-hm-revenue-and-customs
-- https://www.gov.uk/guidance/rates-and-thresholds-for-employers-2019-to-2020
-- https://www.gov.uk/government/publications/p9x-tax-codes
--
-- Income tax bands of taxable income (GBP per year)
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX', '0', 12500.00, .50,-- Allowance & reg limit
                             0.00,  20,  37500.00,    -- Basic rate
                         37501.00,  40, 150000.00,    -- Higher rate
                        150001.00,  45,     null);    -- Additional rate

-- http://www.gov.scot/incometax
-- https://www.gov.scot/publications/scottish-income-tax-2019-2020
-- Use the amounts from UK site the Scot site includes the personal
-- allowance in the band amounts.
-- Scottish income tax
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ('HMRC', 'TX2', '0', 12500.00, .50,-- Allowance & reg limit
                             0.00,  19,   2049.00,     -- Starter rate
                          2050.00,  20,  12444.00,     -- Basic rate
                         12445.00,  21,  30930.00,     -- Intermediate rate
                         30931.00,  41, 150000.00,     -- Higher rate
                        150001.00,  46,      null);    -- Top rate

-- Wales income tax
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX3';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX3', '0', 12500.00, .50,-- Allowance & reg limit
                             0.00,  20,  37500.00,     -- Basic rate
                         37501.00,  40, 150000.00,     -- Higher rate
                        150001.00,  45,     null);     -- Additional rate


-- https://www.gov.uk/government/publications/payroll-technical-specifications-national-insurance
-- Appendix 1, Earnings bands and NICs percentage rates
-- shaded rates shown in the table are rebates or negative
-- Lower Earnings Limit (LEL)
-- Primary Threshold (PT)
-- Secondary Threshold (ST)
-- Upper Earnings Limit (UEL)

-- Include all NI thresholds LEL, PT, ST, UEL. Note that there is
-- overlap of PT and ST on employee and employer tables, they don't 
-- list PT for employee and ST for employer. Both of these thresholds
-- need to be included for rounding purposes. For employee ST and UAP 
-- thresholds will use the same rate and for employer PT and ST will 
-- use the same rates.

-- NIC earning bands and percentage rates
--
-- Employee (primary) contribution rates
-- If the number of bands is changed also update nic_bands()
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    -- Except for the first band, the lower base amount is set
                    -- in the program to the preceding upper over amount.
                    -- Because the base amount is subtracted off the pay,
                    -- the upper amount can be considered the next band.
                    ('HMRC', 'NI', 'A', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,    12,  50000.00,  -- PT/ST+
                      50000.00,     2,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,             
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI', 'B', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,  5.85,  50000.00,  -- PT/ST+
                      50000.00,     2,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI', 'C', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,     0,  50000.00,  -- PT/ST+
                      50000.00,     0,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI', 'H', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,    12,  50000.00,  -- PT/ST+
                      50000.00,     2,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI', 'J', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,     2,  50000.00,  -- PT/ST+
                      50000.00,     2,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI', 'M', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,    12,  50000.00,  -- PT/ST+
                      50000.00,     2,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI', 'Z', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,     2,  50000.00,  -- PT/ST+
                      50000.00,     2,      null); -- UEL+


-- Employer (secondary) contribution rates
-- The last two columns on the employer rates page are rebates for the first two
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'A', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,  13.8,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'B', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,  13.8,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'C', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,  13.8,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'H', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,     0,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'J', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,  13.8,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'M', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,     0,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'Z', null,
                       6136.00,     0,   8632.00,  -- LEL+
                       8632.00,     0,  50000.00,  -- PT/ST+
                      50000.00,  13.8,      null); -- UEL+


-- Workplace Pensions auto enrol
-- https://www.gov.uk/workplace-pensions
-- http://www.thepensionsregulator.gov.uk/automatic-enrolment-earnings-threshold.aspx

-- pymtax must exist, cannot drop and insert because of G/L info
insert into pymtax (taxauthority, authdescription, taxcode,
                    codedescription, sequence, whopays) values
                   ('HMRC', 'HM REVENUE & CUSTOMS', 'WPEN',
                    'EMPEE PENS  ', 1, 'E');
insert into pymtax (taxauthority, authdescription, taxcode,
                    codedescription, sequence, whopays) values
                   ('HMRC', 'HM REVENUE & CUSTOMS', 'WPE2',
                    'EMPLR PENS  ', 1, 'C');

delete from pyttax where taxauthority = 'HMRC' and taxcode = 'WPEN';
insert into pyttax (taxauthority, taxcode, taxstatus, 
                    base1, percent1, over1) values
                   ('HMRC', 'WPEN', '0',
                    6136.00, 3.00, null);
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'WPE2';
insert into pyttax (taxauthority, taxcode, taxstatus, 
                    base1, percent1, over1) values
                   ('HMRC', 'WPE2', '0', 
                    6136.00, 2.00, null);

-- Student Loan
-- see email dated Aug 24 2018 from hmrc
-- http://www.studentloanrepayment.co.uk/portal/page?_pageid=93,6678490&_dad=portal
insert into pymtax (taxauthority, authdescription, taxcode,
                    codedescription, sequence, whopays) values
                   ('HMRC', 'HM REVENUE & CUSTOMS', 'STU',
                    'STUDENT LOAN', 1, 'E');

delete from pyttax where taxauthority = 'HMRC' and taxcode = 'STU';
-- Student Loan Plan 1
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'STU', '1',
                   18935.00, 9.00, null);
-- Student Loan Plan 2
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'STU', '2',
                   25725.00, 9.00, null);
-- Postgraduate Loan
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'STU', 'P',
                   21000.00, 6.00, null);


