--
-- UK Paye tax tables for 2020-2021
--
-- The FPS XML namespace is set for the current payroll year, but you can
-- override it by setting the following environment variable:
-- SS_FPS_NS=http://www.govtalk.gov.uk/taxation/PAYE/RTI/FullPaymentSubmission/19-20/1
--

-- pymtax must exist, do not drop or user entered info will be lost.
--
-- To avoid a duplicate key error on insert, use a temp table for the insert
create temp table t1 (taxauthority char(4),
                      authdescription char(20),
                      taxcode char(4),
                      codedescription char(12),
                      sequence smallint, 
                      whopays char(1));

-- Income tax
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'TX',
                       'INCOME TAX',
                        1,
                       'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1 
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- Scottish income tax
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'TX2',
                       'INC TAX SCOT',
                        1,
                       'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- Wales income tax
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'TX3',
                       'INC TAX WALE',
                        1,
                       'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- National Insurance employee share
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'NI',
                       'EMPLOYEE NI',
                        1,
                       'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- National Insurance company share
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'NI2',
                       'EMPLOYER NI',
                        1,
                       'C');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- pyttax.allowance2 is used for the overriding regulatory limit on income tax,
-- the limit can be found in 'PAYE tax table routines version 17.2 (Feb 2019)'
-- Appendix A Maxrate: 50.00%
-- https://www.gov.uk/government/publications/payroll-technical-specifications-income-tax
--
-- www.gov.uk/government/collections/rates-and-allowances-hm-revenue-and-customs
-- https://www.gov.uk/guidance/rates-and-thresholds-for-employers-2020-to-2021
-- https://www.gov.uk/government/publications/p9x-tax-codes
--
-- Income tax bands of taxable income (GBP per year)
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX', '0', 12500.00, .50,-- Allowance & reg limit
                             0.00,  20,  37500.00,    -- Basic rate
                         37501.00,  40, 150000.00,    -- Higher rate
                        150001.00,  45,     null);    -- Additional rate

-- http://www.gov.scot/incometax
-- Use the amounts from UK site the Scot site includes the personal
-- allowance in the band amounts.
-- Scottish income tax
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3,
                    base4, percent4, over4,
                    base5, percent5, over5) values
                    ('HMRC', 'TX2', '0', 12500.00, .50,-- Allowance & reg limit
                             0.00,  19,   2085.00,     -- Starter rate
                          2086.00,  20,  12658.00,     -- Basic rate
                         12659.00,  21,  30930.00,     -- Intermediate rate
                         30931.00,  41, 150000.00,     -- Higher rate
                        150001.00,  46,      null);    -- Top rate

-- Wales income tax
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'TX3';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance, allowance2,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3) values
                    ('HMRC', 'TX3', '0', 12500.00, .50,-- Allowance & reg limit
                             0.00,  20,  37500.00,     -- Basic rate
                         37501.00,  40, 150000.00,     -- Higher rate
                        150001.00,  45,     null);     -- Additional rate


-- https://www.gov.uk/government/publications/payroll-technical-specifications-national-insurance
-- Appendix 1, Earnings bands and NICs percentage rates
-- shaded rates shown in the table are rebates or negative
-- Lower Earnings Limit (LEL)
-- Primary Threshold (PT)
-- Secondary Threshold (ST)
-- Upper Earnings Limit (UEL)

-- Include all NI thresholds LEL, PT, ST, UEL. Note that there is
-- overlap of PT and ST on employee and employer tables, they don't 
-- list PT for employee and ST for employer. Both of these thresholds
-- need to be included for rounding purposes. For employee ST and UAP 
-- thresholds will use the same rate and for employer PT and ST will 
-- use the same rates.
-- PT is used for employee and ST is used for employer, sometimes
-- they are aligned like in 2019-20.

-- NIC earning bands and percentage rates
--
-- Employee (primary) contribution rates
--
-- If the number of bands is changed also update nic_bands()
--
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    -- Except for the first band, the lower base amount is set
                    -- in the program to the preceding upper over amount.
                    -- Because the base amount is subtracted off the pay,
                    -- the upper amount can be considered the next band.
                    -- Use the annual amounts from the table.
                    ('HMRC', 'NI', 'A', null,
                       6240.00,  0.00,  9500.00,  -- LEL+
                       9500.00, 12.00, 50000.00,  -- PT+
                      50000.00,  2.00,     null); -- UEL+

                    -- All NIC letters use the same earning limits
                    -- only the rates are different.
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,             
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'B', allowance,
                           base1, 0.00, over1,
                           base2, 5.85, over2,
                           base3, 2.00, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'C', allowance,
                           base1, 0.00, over1,
                           base2, 0.00, over2,
                           base3, 0.00, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'H', allowance,
                           base1, 0.00, over1,
                           base2,12.00, over2,
                           base3, 2.00, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'J', allowance,
                           base1, 0.00, over1,
                           base2, 2.00, over2,
                           base3, 2.00, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'M', allowance,
                           base1, 0.00, over1,
                           base2,12.00, over2,
                           base3, 2.00, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'Z', allowance,
                           base1, 0.00, over1,
                           base2, 2.00, over2,
                           base3, 2.00, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI'
                     and taxstatus = 'A';



-- Employer (secondary) contribution rates
-- The last two columns on the employer rates page are rebates for the first two
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NI2';
insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    ) values
                    ('HMRC', 'NI2', 'A', null,
                       6240.00,  0.00,  8788.00,  -- LEL+
                       8788.00, 13.80, 50000.00,  -- ST+
                      50000.00, 13.80,     null); -- UEL+

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'B', allowance,
                           base1, 0.00, over1,
                           base2,13.80, over2,
                           base3,13.80, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI2'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'C', allowance,
                           base1, 0.00, over1,
                           base2,13.80, over2,
                           base3,13.80, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI2'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'H', allowance,
                           base1, 0.00, over1,
                           base2, 0.00, over2,
                           base3,13.80, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI2'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'J', allowance,
                           base1, 0.00, over1,
                           base2,13.80, over2,
                           base3,13.80, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI2'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'M', allowance,
                           base1, 0.00, over1,
                           base2, 0.00, over2,
                           base3,13.80, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI2'
                     and taxstatus = 'A';

insert into pyttax (taxauthority, taxcode, taxstatus, allowance,
                    base1, percent1, over1,
                    base2, percent2, over2,
                    base3, percent3, over3
                    )
                    select taxauthority, taxcode, 'Z', allowance,
                           base1, 0.00, over1,
                           base2, 0.00, over2,
                           base3,13.80, over3
                    from pyttax where taxauthority = 'HMRC'
                     and taxcode = 'NI2'
                     and taxstatus = 'A';



-- Workplace Pensions auto enrol
-- https://www.gov.uk/workplace-pensions
-- http://www.thepensionsregulator.gov.uk/automatic-enrolment-earnings-threshold.aspx
-- rates are found at this link
-- https://www.thepensionsregulator.gov.uk/en/employers/new-employers/im-an-employer-who-has-to-provide-a-pension/choose-a-pension-scheme/understanding-your-costs/making-contributions-to-your-pension-scheme-

-- pymtax must exist, cannot drop and insert because of G/L info, so use temp
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'WPEN',
                       'EMPEE PENS  ',
                        1,
                       'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);

delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'WPE2',
                       'EMPLR PENS  ',
                        1,
                       'C');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- pyttax tax tables for workplace pension
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'WPEN';
insert into pyttax (taxauthority, taxcode, taxstatus, 
                    base1, percent1, over1,
                    base2, percent2, over2) values
                   ('HMRC', 'WPEN', '0',
                    6240.00, 5.00, 50000.00,
                   50001.00, 0.00, null);
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'WPE2';
insert into pyttax (taxauthority, taxcode, taxstatus, 
                    base1, percent1, over1,
                    base2, percent2, over2) values
                   ('HMRC', 'WPE2', '0', 
                    6240.00, 3.00, 50000.00,
                   50001.00, 0.00, null);


-- Student Loan
-- HMRC will email a spreadsheet with the thresholds and rates
-- http://www.studentloanrepayment.co.uk/portal/page?_pageid=93,6678490&_dad=portal
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'STU',
                       'STUDENT LOAN',
                        1,
                       'E');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);


-- pyttax tax tables for student loan
delete from pyttax where taxauthority = 'HMRC' and taxcode = 'STU';
-- Student Loan Plan 1
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'STU', '1',
                   19390.00, 9.00, null);
-- Student Loan Plan 2
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'STU', '2',
                   26575.00, 9.00, null);
-- Postgraduate Loan
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'STU', 'P',
                   21000.00, 6.00, null);


-- Class 1A National Insurance: termination awards
-- only employer pays
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'NIAT',
                       'NI 1A TERM',
                        1,
                       'C');
 
insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);

delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NIAT';
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'NIAT', 'A',
                   30001.00, 13.80, null);

-- Class 1A National Insurance: sporting testimonial payments
-- only employer pays
delete from t1;
insert into t1 values ('HMRC',
                       'HM REVENUE & CUSTOMS',
                       'NIAS',
                       'NI 1A SPORT',
                        1,
                       'C');

insert into pymtax (taxauthority,
                    authdescription,
                    taxcode,   
                    codedescription,
                    sequence,
                    whopays)
select * from t1
where t1.taxauthority || t1.taxcode not in
(select pymtax.taxauthority || pymtax.taxcode from pymtax);

delete from pyttax where taxauthority = 'HMRC' and taxcode = 'NIAS';
insert into pyttax (taxauthority, taxcode, taxstatus,
                    base1, percent1, over1) values
                   ('HMRC', 'NIAS', 'A',
                  100001.00, 13.80, null);

