#!/bin/bash

# Root directory
ROOT_DIR="${1:-.}"

SRC_DIR="$ROOT_DIR/src"
LANG_DIR="$ROOT_DIR/language"

# Ensure the language directory exists
mkdir -p "$LANG_DIR"

echo "=== Updating all .po files in $LANG_DIR ==="

for PO_FILE in "$LANG_DIR"/*.po; do
    # Get the base name without extension
    BASENAME=$(basename "$PO_FILE" .po)
    
    # Temporary .ts file
    TS_FILE="$LANG_DIR/$BASENAME.ts"
    
    # Backup the original .po file
    BACKUP_FILE="$PO_FILE.bak"
    cp "$PO_FILE" "$BACKUP_FILE"
    echo "Backup created: $BACKUP_FILE"
    
    echo "=== Processing $PO_FILE ==="
    
    # 1️ Convert .po to .ts (existing translations are preserved)
    lconvert -i "$PO_FILE" -o "$TS_FILE"
    
    # 2️ Run lupdate on the .ts file (updates line numbers, adds new strings)
    lupdate "$SRC_DIR" -ts "$TS_FILE"
    
    # 3️ Convert .ts back to .po
    lconvert -i "$TS_FILE" -o "$PO_FILE"
    
    # 4️ Remove temporary .ts file
    rm -f "$TS_FILE"
    
    echo "=> $PO_FILE updated (translations preserved, line numbers updated)."
done

echo "=== All language files have been updated. ==="
