#---------------------------------------------------
# "UltimateDailyWallpaper" Copyright (C) 2025 Patrice Coni
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#  
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#---------------------------------------------------

VERSION         = 3.4.0
DEFINES         += APP_VERSION=\\\"$$VERSION\\\"

QT              += widgets core gui network xml concurrent sql
CONFIG          += c++17 warn_on
QMAKE_CXXFLAGS  += -Wall -Wextra -Wpedantic

TARGET          = UltimateDailyWallpaper
TEMPLATE        = app
DESTDIR         = ../bin
MOC_DIR         = ../build/moc
RCC_DIR         = ../build/rcc
UI_DIR          = ../build/ui

INSTALL_PATH    = /opt/UltimateDailyWallpaper
BIN_PATH        = $$INSTALL_PATH/bin
PLUGINS_PATH    = $$INSTALL_PATH/plugins
TRANSLATION_PATH = $$INSTALL_PATH/translations
DEFINES         += BINDIR_PATH=\\\"$$BIN_PATH\\\"
DEFINES         += INSTALLATION_PATH=\\\"$$INSTALL_PATH\\\"
DEFINES         += TR_PATH=\\\"$$TRANSLATION_PATH\\\"
DEFINES         += PLUGINS_DIR=\\\"$$PLUGINS_PATH\\\"

unix
{
    OBJECTS_DIR = ../build/o/unix
}

greaterThan(QT_MAJOR_VERSION, 5) {
    DEFINES += QT6_BUILD
} else {
    DEFINES += QT5_BUILD
}

TRANSLATIONS = \
               ../language/UltimateDailyWallpaper_ca.ts \
               ../language/UltimateDailyWallpaper_de.ts \
               ../language/UltimateDailyWallpaper_fr.ts \
               ../language/UltimateDailyWallpaper_it.ts \
               ../language/UltimateDailyWallpaper_es.ts \
               ../language/UltimateDailyWallpaper_fi.ts \
               ../language/UltimateDailyWallpaper_ru.ts \
               ../language/UltimateDailyWallpaper_uk.ts \
               ../language/UltimateDailyWallpaper_ko.ts \
               ../language/UltimateDailyWallpaper_pt.ts

SOURCES += \
    about.cpp \
    main.cpp \
    mainwindow.cpp \
    photobrowser.cpp \
    settingswindow.cpp \
    setwallpaper.cpp \
    itemdelegate.cpp

HEADERS += \
    about.h \
    connection.h \
    interfaces.h \
    itemdelegate.h \
    mainwindow.h \
    photobrowser.h \
    settingswindow.h \
    setwallpaper.h

FORMS += \
    about.ui \
    photobrowser.ui \
    settingswindow.ui

RESOURCES += \
    udw_ressource.qrc


#--------------------------------------------------
# Compile language files
#--------------------------------------------------

TRANSLATIONS_QM = $$replace(TRANSLATIONS, .ts, .qm)

QMAKE_POST_LINK += lrelease $$TRANSLATIONS


#--------------------------------------------------
# Installation
#--------------------------------------------------

# Install executable
target.path = $$INSTALL_PATH/bin
INSTALLS += target

# Install language files (.qm)
dir_qm.commands += mkdir -p $$TRANSLATION_PATH
INSTALLS += dir_qm

files_qm.commands += cp $$TRANSLATIONS_QM $$TRANSLATION_PATH
files_qm.path = $$TRANSLATION_PATH
INSTALLS += files_qm

# Install icon
icon_files.files = icons/ultimatedesktopwallpaper_icon.png
icon_files.path = $$INSTALL_PATH
INSTALLS += icon_files

# Install .desktop file
desktop_file.files = ../UltimateDailyWallpaper.desktop
desktop_file.path = /usr/share/applications
INSTALLS += desktop_file

#--------------------------------------------------
# Uninstall rule (make uninstall)
#--------------------------------------------------

# uninstall.commands += rmdir $$INSTALL_PATH
# uninstall.target = uninstall
# QMAKE_EXTRA_TARGETS += uninstall

