![Icon](src/icons/ultimatedesktopwallpaper_icon.png)

# UltimateDailyWallpaper
UltimateDailyWallpaper is a utility to use the daily picture of a provider as wallpaper on Linux and macOS operating systems. It saves images in a high quality. Further information about each picture can be obtained from the internet with a single click. It integrates with most desktop environments to provide automatically changing wallpaper. It allows a simple integration of external plugins, which allows downloading a daily wallpaper from any one provider.

![UltimateDailyWallpaper](screenshots/UltimateDailyWallpaper.png)

## Features of the application:
 * Allows download the daily picture of Wikimedia Commons (POTD) in a high quality
 * Allows download "pictures of the day" from past days of Wikimedia Commons
 * Allows download the daily wallpaper of Bing in a high quality
 * Allows a simple integration of external plugins to download a daily picture of any provider
 * Supports the most of desktop environments to provide automatically changing wallpaper
 * Allows automatically changing wallpaper on lockscreen of KDE Plasma and GNOME

## Recomment:
* gnome-shell-extension-appindicator - support for legacy tray icons on GNOME 3 -> https://github.com/ubuntu/gnome-shell-extension-appindicator
* gnome-shell-extension-top-icons-plus - https://github.com/phocean/TopIcons-plus

## Installation:

### Linux
UltimateDailyWallpaper is currently available in the repository of:
 * <a href="https://slackbuilds.org/repository/15.0/desktop/UltimateDailyWallpaper/">SlackBuilds.org</a>

#### Installation on Slackware 15+

Sbopkg is required to install UltimateDailyWallpaper on Slackware Linux.

```
sudo sbopkg -B -i UltimateDailyWallpaper
```

## Build from source:
To build UltimateDailyWallpaper from source, you will need:

### Build requirements:
 * Qt 5.14+ or Qt 6.0+
 * Git
 * mesa-libGL
 * make
 * qmake
 * gcc/gcc-c++

### Required packages to use UltimateDailyWallpaper:
 * curl

### Build instructions:

```
git clone https://gitlab.com/pagaco/ultimatedailywallpaper.git
cd ultimatedailywallpaper
qmake
make

(as super user)
make install
```