#include "itemdelegate.h"
#include <QIcon>

ItemDelegate::ItemDelegate(QObject *parent)
    : QStyledItemDelegate(parent), displayRoleEnabled(false)
{
}

void ItemDelegate::initStyleOption(QStyleOptionViewItem *_styleOption, const QModelIndex &_modInd) const
{
    QStyledItemDelegate::initStyleOption(_styleOption, _modInd);

    if (!displayRoleEnabled) {
        _styleOption->features &= ~QStyleOptionViewItem::HasDisplay;
    }
}

void ItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    if (option.state & QStyle::State_Selected) {
        painter->fillRect(option.rect, option.palette.highlight());  // Hintergrund für Auswahl
    }

    if (!index.data(Qt::DecorationRole).isNull()) {
        QIcon icon = qvariant_cast<QIcon>(index.data(Qt::DecorationRole));
        icon.paint(painter, option.rect);
    }
}
