Fehlstart is a small desktop application launcher for Linux and friends, 
inspired by Gnome-Do and Launchy. 
It's main design goals are responsiveness, a minimalistic user interface, and a
reasonable memory footprint.

Usage
-----

Fehlstart can run in two ways. You can add it to your desktop environment's
autostart and keep is runing in the background. This mode is very responsive, 
but is uses some memory even when not used.
Press the hotkey (default is super-space) to bring up the window.

Alternatively you can start it with the `--one-way` flag, for example through
a task-bar launcher. This will cause the window to appear immediately and 
after one use Fehlstart will exit. This mode is slightly less responsive, 
especially on older disk drives, but uses no memory when not in use.

When you see the window, start typing the name of the program or action you 
run. You can use tab or the cursor keys to navigate the list. Hit enter to
run the program or escape to abort. Fehlstart remembers your actions so the
next time you should get there with fewer keyboard strokes.

Note that space has a special meaning. Everything you type after a space will be
used as argument, see Actions for details.

Actions
-------

By default Fehlstart only launches applications that show up in your start menu.
To add custom actions, launch the `Fehlstart Actions` item to open the editor. 

Custom actions can have parameters. Everything entered after the first space will be used as the
command's arguments. This is a very simple mechanism, but it can be extended by
launching a script to do the more sophisticated argument parsing.
```        
# comment
[Action Name]
Exec=executable # can be absolute path or exe in $PATH
Icon=icon       # can be absolute path or default icon name 
```

Example: Lock screen with slock
```
[Lock Screen]
Exec=slock
Icon=lock
```
Example: Search the Web using Firefox. When you type `goo "foo bar"` the executed 
command would be `firefox --search "foo bar"`. 
```
[Search Google]
Exec=firefox --search
Icon= /home/maep/pics/Google_Favicon_2009.svg
```

Settings
--------

Launch `Fehlstart Settings` to edit the config file.


```
[Bindings]
launch=<Super>space
```
Hotkey binding to show window in "background" mode. This can be a combination
like **\<Alt\>x** but also something like **Super_L** for uing the left "Windows"
key. See https://github.com/engla/keybinder for details.


```
[Matching]
executable=true
```
Include executable name when matching. Useful for Gimp, where the full name is
"GNU Image Manipulation Program" won't match, but the executable name is
actually "gimp".


```
[Icons]
show=true
scale=false
```
On underpowered machines icons can cause a lot of lag. Turning them off gives 
maximum responsiveness. Icon scaling looks better for larger window sizes but is
lagy on older processors.


```
[Border]
color=default
width=1
```
Change appearance of the window border. `color` can be a name like **blue** or
a code like **#0000ff**.


```
[Window]
color=default
width=200
height=100
round=true
arch=true
```
Change appearance of window. `round` controls rounded corners. If your window
manager has no compositing this setting has not effect. `arch` controls the
highlight in the background.


```
[Labels]
color=default
size1=14
size2=12
showinput=true
```
Change appearance of text. `size1` is for the application name, `size2` for 
typed text. Note that for long names the size is reduced to fit the window.
`showinput` controls if the typed text should be displayed.

Compiling
---------

Just clone the source and run **make**. You'll need **gtk2** and 
**libkeybinder2**. If you want cutting edge, try the gtk3 branch.

