#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/* */
/*  Copyright (C) 2002-2011 Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; 
*/

static gboolean 
hideshow_f(gpointer data){
    void **arg = data;

    diff_t *diff_p = arg[0];
    gchar *left_folder_label = arg[1];
    gchar *right_folder_label = arg[2];
    GdkPixbuf *pixbuf_left  = arg[3];
    GdkPixbuf *pixbuf_right = arg[4];
    gint patchmake_ready = GPOINTER_TO_INT(arg[5]);
    gint diff_ready = GPOINTER_TO_INT(arg[6]);
    g_free(arg);
    
    // gtk specifics
    gint i;
    for(i = 0; i < PATCH_MENUS; i++){
        if(diff_p->patchM[i]){
                gtk_widget_set_sensitive (diff_p->patchM[i], diff_p->diff_flags & PATCHING);
	}
    }
    for(i = 0; i < DIFF_MENUS; i++){
        if(diff_p->diffM[i]){
	    gtk_widget_set_sensitive (diff_p->diffM[i], !(diff_p->diff_flags & PATCHING));
	}
    }
    gtk_label_set_markup (GTK_LABEL(diff_p->folder_label_left),left_folder_label);
    gtk_label_set_markup (GTK_LABEL(diff_p->folder_label_right),right_folder_label);
    g_free(left_folder_label);
    g_free(right_folder_label);
    GtkWidget *image = gtk_image_new_from_pixbuf(pixbuf_left);
    gtk_button_set_image (GTK_BUTTON(diff_p->label_button_left), image); 
    image = gtk_image_new_from_pixbuf(pixbuf_right);
    gtk_button_set_image (GTK_BUTTON(diff_p->label_button_right), image); 
    
    gtk_widget_set_sensitive(diff_p->diffM[CREATE_PATCH_FILE],  patchmake_ready);
    if (diff_p->diff_flags & DIFF_RUNNING) {
	gtk_widget_set_sensitive(diff_p->button_patchmake,  FALSE);
	gtk_widget_set_sensitive(diff_p->button_apply,  FALSE);
    } else {
	gtk_widget_set_sensitive(diff_p->button_patchmake,  patchmake_ready);
	gtk_widget_set_sensitive(diff_p->button_apply,  diff_ready);
    }
    if (diff_p->diff_flags & DIFF_RUNNING) {
	gtk_widget_set_sensitive(diff_p->button_next_file, FALSE);
	gtk_widget_set_sensitive(diff_p->button_previous_file, FALSE);
    } else if (diff_p->left_count > 1 || diff_p->right_count > 1) {
	gtk_widget_set_sensitive(diff_p->button_next_file, 
		(diff_ready && diff_p->left_index < diff_p->left_count - 1));

	gtk_widget_set_sensitive(diff_p->button_previous_file, 
		(diff_ready && diff_p->left_index > 0));
    } else {
	gtk_widget_set_sensitive(diff_p->button_next_file, FALSE);
	gtk_widget_set_sensitive(diff_p->button_previous_file, FALSE);
    }


    gtk_widget_set_sensitive(diff_p->button_up, diff_p->diffC );
    gtk_widget_set_sensitive(diff_p->button_down, diff_p->diffC );

#ifndef DEBUG
    gtk_widget_hide(diff_p->label_box);
#endif
    return FALSE;
}

// hide show whatever applies.
static void *
hideshow_menus (gpointer data) {
    diff_t *diff_p=data;
    
    const gchar *left_icon_id="xffm/stock_dialog-question";
    const gchar *right_icon_id="xffm/stock_dialog-question";
    gchar *left_folder_label;
    gchar *right_folder_label;
    gboolean diff_ready=(diff_p->right_file && diff_p->left_count &&
	    diff_p->left_file && diff_p->right_count);
    gboolean patchmake_ready = ((diff_p->left_patchmake_count && diff_p->right_patchmake_count)||diff_ready);


    /*gboolean multiple_files=FALSE;
    if ((diff_p->right_file && 
		rfm_g_file_test(diff_p->right_file, G_FILE_TEST_IS_DIR))
	|| (diff_p->left_file &&
		rfm_g_file_test(diff_p->left_file, G_FILE_TEST_IS_DIR)))
    {
	multiple_files=TRUE;
    }*/
    if (diff_p->left_file){
	left_icon_id=MIME_type(diff_p->left_file, NULL);
	if (!left_icon_id) {
	    left_icon_id=MIME_magic(diff_p->left_file);
	}
	gchar *d = g_path_get_dirname(diff_p->left_file);
	
	gchar *chopped_path=g_strdup(d);
	rfm_chop_excess (chopped_path);
	gchar *utf_path=rfm_utf_string(chopped_path);
	g_free(chopped_path);

	left_folder_label=g_strdup_printf(" <b>%s/</b> ", utf_path);
	g_free(utf_path);
	g_free(d);
    } else {
	left_folder_label=g_strdup_printf(" <i>%s</i> ", _("No directory selected."));
    }
    if (diff_p->right_file){
	right_icon_id=MIME_type(diff_p->right_file, NULL);
	if (!right_icon_id) {
	    right_icon_id=MIME_magic(diff_p->right_file);
	}
	gchar *d = g_path_get_dirname(diff_p->right_file);
	
	gchar *chopped_path=g_strdup(d);
	rfm_chop_excess (chopped_path);
	gchar *utf_path=rfm_utf_string(chopped_path);
	g_free(chopped_path);

	right_folder_label=g_strdup_printf(" <b>%s/</b> ", utf_path);
	g_free(d);
	g_free(utf_path);
    } else {
	right_folder_label=g_strdup_printf(" <i>%s</i> ", _("No directory selected."));
    }

    GdkPixbuf *pixbuf_left= rfm_get_pixbuf(left_icon_id, SIZE_BUTTON);
    GdkPixbuf *pixbuf_right= rfm_get_pixbuf(right_icon_id, SIZE_BUTTON);

    void **arg = (void **)malloc(7*sizeof(void *));
    if (!arg) g_error("malloc: %s\n", strerror(errno));
    arg[0] = diff_p;
    arg[1] = left_folder_label;
    arg[2] = right_folder_label;
    arg[3] = pixbuf_left;
    arg[4] = pixbuf_right;
    arg[5] = GINT_TO_POINTER(patchmake_ready);
    arg[6] = GINT_TO_POINTER(diff_ready);

    
    hideshow_f(arg);
    g_object_unref(pixbuf_left);
    g_object_unref(pixbuf_right);
    
    return NULL;
}


static int
cb_wheel (GtkWidget * widget, GdkEventScroll * event, void *data) {
    diff_t *diff_p=data;
    int new_adj;
    new_adj = gtk_adjustment_get_value(GTK_ADJUSTMENT (diff_p->adj));
    if(event->direction == GDK_SCROLL_UP) {
        new_adj -= (3 * diff_p->lineH);
    }
    if(event->direction == GDK_SCROLL_DOWN) {
        new_adj += (3 * diff_p->lineH);
    }
    if(new_adj < 0){
        new_adj = 0;
    }
    gtk_adjustment_set_value (GTK_ADJUSTMENT (diff_p->adj), new_adj);
    return TRUE;
}
static void changedir(diff_t *diff_p, gboolean left){
    gchar *active=NULL;
    GtkTreeIter iter;
    GtkComboBox *combo = (left)?
	GTK_COMBO_BOX(diff_p->combo_left):
	GTK_COMBO_BOX(diff_p->combo_right);
    GtkListStore *store = (left)?diff_p->list_store_left:diff_p->list_store_right;

    if (!gtk_combo_box_get_active_iter (combo, &iter)) return; 
    gtk_tree_model_get (GTK_TREE_MODEL(store), &iter,
	    PATH_COLUMN, &active,
	    -1);
    if (rfm_g_file_test(active, G_FILE_TEST_IS_DIR)){
	gchar *base = g_path_get_basename(active);
	if (strcmp(base, ".") != 0){
	    if (strcmp(base, "..")==0){
		gchar *d = g_path_get_dirname(active);
		gchar *dd = g_path_get_dirname(d);
		g_free(d);
		g_free(active);
		active = dd;
	    }
	    if (left) {
		g_free(diff_p->left_file);
		diff_p->left_file = active;
		diff_p->left_count =
		     update_combo_model(diff_p, left, NULL);
	    } else {
		g_free(diff_p->right_file);
		diff_p->right_file = active;
		diff_p->right_count =
		     update_combo_model(diff_p, left, NULL);
	    }
    hideshow_menus(diff_p);
	}
	TRACE( "base=\"%s\" active=%s\n", base, active);
	g_free(base);
    } else {
	g_free(active);
    }
}

static void
cb_changed_left (GtkComboBox * widget,  void *data) {
    diff_t *diff_p=data;
    gboolean ready=(diff_p->right_file && diff_p->left_file);
	
    diff_p->diff_flags &= (DIFF_IS_DONE^0xffffffff);
    if (diff_p->diff_flags & DIFF_UPDATING_MODEL) return;

    diff_p->left_index=gtk_combo_box_get_active  (GTK_COMBO_BOX(diff_p->combo_left));
    gtk_widget_set_sensitive(diff_p->button_next_file, 
		(ready && diff_p->left_index < diff_p->left_count - 1));
    gtk_widget_set_sensitive(diff_p->button_previous_file, 
		(ready && diff_p->left_index > 0));

    changedir(diff_p, TRUE);
    
    return;
}


static void
cb_changed_right (GtkComboBox * widget,  void *data) {
    diff_t *diff_p=data;
    diff_p->diff_flags &= (DIFF_IS_DONE^0xffffffff);
    if (diff_p->diff_flags & DIFF_UPDATING_MODEL) return;
    diff_p->right_index=gtk_combo_box_get_active  (GTK_COMBO_BOX(diff_p->combo_right));

    changedir(diff_p, FALSE);
    return;
}

static void
 cb_do_diff(GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    cleanTextAreas (diff_p);
    cleanPolygon (diff_p);
    cleanAreaDraw (diff_p);
    do_diff (diff_p);     
}
static void
cb_previous_file (GtkWidget * widget, gpointer data) {
    diff_t *diff_p=data;
    GtkTreeIter iter;
    if (!gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_left), &iter)) return; 
    
    gchar *active_left;

    gint index = diff_p->left_index;
#if GTK_MAJOR_VERSION==2
    GtkTreePath *treepath = 
	gtk_tree_model_get_path (GTK_TREE_MODEL (diff_p->list_store_left), &iter);
    while (gtk_tree_path_prev (treepath))
    {
	index--;
	gtk_tree_model_get_iter (GTK_TREE_MODEL (diff_p->list_store_left), &iter, treepath);
	// this is the same as for gtk3:
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_left), &iter,
	    PATH_COLUMN, &active_left,
	    -1);
	if (!rfm_g_file_test(active_left, G_FILE_TEST_IS_DIR)) break;
	g_free(active_left);
	active_left=NULL;
    }
#else
    while (gtk_tree_model_iter_previous(GTK_TREE_MODEL (diff_p->list_store_left), &iter))
    {
	index--;
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_left), &iter,
	    PATH_COLUMN, &active_left,
	    -1);
	if (!rfm_g_file_test(active_left, G_FILE_TEST_IS_DIR)) break;
	g_free(active_left);
	active_left=NULL;
    }
#endif

    if (active_left){
	diff_p->left_index = index;
	gtk_combo_box_set_active(GTK_COMBO_BOX(diff_p->combo_left), diff_p->left_index);
	if (!set_right_index (diff_p,  diff_p->left_index)) {
	    cleanTextAreas (diff_p);
	    cleanPolygon (diff_p);
	    cleanAreaDraw (diff_p);
	    return;
	}
    hideshow_menus(data);
	cb_do_diff(widget, data);
	g_free(active_left);
    }
}

static void
cb_next_file (GtkWidget * widget, gpointer data) {
    diff_t *diff_p=data;
    GtkTreeIter iter;
    if (!gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_left), &iter)) return; 
    
    gchar *active_left;

    gint index = diff_p->left_index;
    while (gtk_tree_model_iter_next(GTK_TREE_MODEL (diff_p->list_store_left), &iter)){
	index++;
	gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_left), &iter,
	    PATH_COLUMN, &active_left,
	    -1);
	if (!rfm_g_file_test(active_left, G_FILE_TEST_IS_DIR)) break;
	g_free(active_left);
	active_left=NULL;
    }
    if (active_left){
	// If active_left is not NULL, then it points to a non-directory
	diff_p->left_index = index;
	gtk_combo_box_set_active(GTK_COMBO_BOX(diff_p->combo_left), diff_p->left_index);
	if (!set_right_index (diff_p,  diff_p->left_index)) {
	    cleanPolygon (diff_p);
	    cleanAreaDraw (diff_p);
	    cleanTextAreas (diff_p);
	    return;
	}
    hideshow_menus(data);
	cb_do_diff(widget, data);
	g_free(active_left);
    }
}


static void
on_clear_show_diag (GtkWidget * widget, gpointer data) {
    diff_t *diff_p = data;
    GtkTextBuffer * buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (diff_p->view_diag));
    GtkAllocation allocation;
    gtk_widget_get_allocation(diff_p->window, &allocation);
    gtk_text_buffer_set_text (buffer, "", -1);
    
    GtkWidget *vpane = g_object_get_data(G_OBJECT(diff_p->widgets.paper), "vpane");
    gtk_paned_set_position(GTK_PANED(vpane), 0.650 * allocation.height);
}

static void
delete_event (GtkWidget * widget, GdkEvent * event, gpointer data) {
    gtk_main_quit();
    exit(1);
}

static void
get_file_action(gpointer data, gboolean is_directory, gboolean left){
    diff_t *diff_p=data;
    gchar *title;
    gint action=(is_directory)?
	GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER:GTK_FILE_CHOOSER_ACTION_OPEN;
    title=g_strdup_printf("%s (%s)", 
	    (is_directory)?
	    _("Select folder"):_("Select File")
	    , 
	    (left)?
	    _("Left"):_("Right")); 
    gchar *retval=fileselect(title, action);
    g_free(title);
    if (retval){
	if (left) {
	    g_free(diff_p->left_file);
	    diff_p->left_file=retval;
	    diff_p->left_index=0;
	    diff_p->left_count =
		update_combo_model(diff_p, TRUE, NULL);
	} else {
	    g_free(diff_p->right_file);
	    diff_p->right_file=retval;
	    diff_p->right_index=0;
	    diff_p->right_count =
		update_combo_model(diff_p, FALSE, NULL);
	}
	diff_p->diff_flags &= (DIFF_IS_DONE^0xffffffff);
    hideshow_menus(data);
	// clear text boxes
	cleanTextAreas (diff_p);
	// clean polygons
	cleanPolygon (diff_p);
	cleanAreaDraw (diff_p);  
    }
}

static void
cb_get_left_dir (GtkWidget * widget, gpointer data) {
    get_file_action(data, TRUE, TRUE);
}

static void
cb_get_right_dir (GtkWidget * widget, gpointer data) {
    get_file_action(data, TRUE, FALSE);
}


static void
cb_get_left_file (GtkWidget * widget, gpointer data) {
    get_file_action(data, FALSE, TRUE);
}


static void
cb_get_right_file (GtkWidget * widget, gpointer data) {
    get_file_action(data, FALSE, FALSE);
}

///////////////   diff option callbacks ///////////////////////////


static void
toggle_diff_option(diff_t *diff_p, gint option){
    diff_p->diff_flags ^= option;
}

static void
 cb_toggle_filledP(GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, FILLEDP);
     save_defaults(diff_p);
     configure_event (diff_p->drawA, NULL, data);     
}
static void
 cb_toggle_show_lineN(GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, SHOW_LINEN);
     save_defaults(diff_p);
     configure_event (diff_p->drawA, NULL, data);
}

static void
cb_toggle_ignore_case (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, IGNORE_CASE);
     save_defaults(diff_p);
}

static void
cb_toggle_ignore_tab_expansion (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, IGNORE_TAB_EXPANSION);
     save_defaults(diff_p);
}

static void
cb_toggle_ignore_space_change (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, IGNORE_SPACE_CHANGE);
     save_defaults(diff_p);
}

static void
cb_toggle_ignore_all_space (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, IGNORE_ALL_SPACE);
     save_defaults(diff_p);
}

static void
cb_toggle_ignore_blank_lines (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, IGNORE_BLANK_LINES);
     save_defaults(diff_p);
}

static void
cb_toggle_minimal (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, MINIMAL);
     save_defaults(diff_p);
}

static void
cb_toggle_speed_large_files (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, SPEED_LARGE_FILES);
     save_defaults(diff_p);
}

static void
cb_toggle_strip_trailing_cr (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, STRIP_TRAILING_CR);
     save_defaults(diff_p);
}

static void
cb_toggle_expand_tabs (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, EXPAND_TABS);
     save_defaults(diff_p);
}

static void
cb_toggle_initial_tab (GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
    toggle_diff_option(diff_p, INITIAL_TAB);
     save_defaults(diff_p);
}

///////////////   end of diff option callbacks ///////////////////////////
//
static
void
cb_adjust (GtkAdjustment * adj, gpointer data) {
     diff_t *diff_p=data;
    GdkRectangle allocation;
    gtk_widget_get_allocation (diff_p->drawA, &allocation);

    /*("value=%lf",GTK_ADJUSTMENT (adj)->value); */
    gtk_adjustment_set_value (GTK_ADJUSTMENT (diff_p->adjR), 
	    gtk_adjustment_get_value(GTK_ADJUSTMENT (diff_p->adj)));

    /*GdkEventExpose event;
    event.area.x = 0;
    event.area.y = 0;
    event.area.width = allocation.width;
    event.area.height = allocation.height;*/
    configure_event (diff_p->drawA, NULL, data);
}

static
void
cb_adjustR (GtkAdjustment * adjR, gpointer data) {
     diff_t *diff_p=data;
    GdkRectangle allocation;
    gtk_widget_get_allocation (diff_p->drawA, &allocation);

    gtk_adjustment_set_value (GTK_ADJUSTMENT (diff_p->adj), 
	gtk_adjustment_get_value(GTK_ADJUSTMENT (diff_p->adjR)));

    /*GdkEventExpose event;
    event.area.x = 0;
    event.area.y = 0;
    event.area.width = allocation.width;
    event.area.height = allocation.height;*/
    configure_event (diff_p->drawA, NULL, data);
}
#if 0
static void
combo_changed(GtkComboBox *widget, gpointer data){
    diff_t *diff_p=data;
    gint index = gtk_combo_box_get_active(widget);
    gchar *active=NULL;
    GtkTreeIter iter;
    gtk_combo_box_get_active_iter (GTK_COMBO_BOX(diff_p->combo_left), &iter); 
    gtk_tree_model_get (GTK_TREE_MODEL(diff_p->list_store_left), &iter,
	    PATH_COLUMN, &active,
	    -1);
    if (rfm_g_file_test(active, G_FILE_TEST_IS_DIR)){
	g_free(diff_p->left_file);
	diff_p->left_file = active;
	diff_p->left_count =
	     update_combo_model(diff_p, TRUE, NULL);

	TRACE( "reload combobox here...\n");
    } else {
	g_free(active);
    }

}
#endif

static void
cb_stop(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (diff_p->tubo_pid == 0) return;
    gtk_widget_set_sensitive(widget, FALSE);
    kill(diff_p->tubo_pid, SIGUSR1); // SIGTERM
    kill(diff_p->tubo_pid, SIGUSR2); // SIGKILL
    diff_p->tubo_pid = 0;
}

static void
cb_do_patch(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!(diff_p->diff_flags & PATCHING)) {
	cb_do_diff(widget, data);
	return;
    }
}


static void *
hello_world(void *data){
    diff_t *diff_p = data;
    rfm_threaded_diagnostics(&(diff_p->widgets), "rodent-diff",g_strconcat(" ",NULL));
    rfm_threaded_diagnostics(&(diff_p->widgets), "xffm_tag/green", g_strconcat("Hello world! This is rodent-diff. A", NULL));
    rfm_threaded_diagnostics(&(diff_p->widgets), "xffm_tag/blue", g_strconcat(" Rodent ", NULL));
    rfm_threaded_diagnostics(&(diff_p->widgets), "xffm_tag/green", g_strconcat("front end for", NULL));
    rfm_threaded_diagnostics(&(diff_p->widgets), "xffm_tag/blue", g_strconcat(" GNU ", NULL));
    rfm_threaded_diagnostics(&(diff_p->widgets), "xffm_tag/green", g_strconcat("diff.\n", NULL));
    return NULL;
}


static void
 cb_about(GtkWidget * widget, gpointer data){
     // This is a callback, protected by GDK MUTEX automatically
     diff_t *diff_p=data;

     // nerdy part:
 /*    g_object_class_install_property (object_class,
                                 PROP_AUTHORS,
                                 g_param_spec_boxed ("authors",
                                                     _("Authors"),
                                                     _("List of authors"),
                                                     G_TYPE_STRV,
                                                     G_PARAM_READWRITE));*/
     gchar *backend=g_strdup_printf("%s: GNU diff", _("Backend"));
     gchar *authors[] = { "Rodent-diff",
	 "   Edscott Wilson García <edscott@users.sf.net>", 
	 _("Tests"),
	 "   Gregorio Inda",
	 backend,
	 "   Paul  Eggert",
	 "   Mike Haertel",
	 "   David Hayes",
	 "   Richard Stallman",
	 "   Len Tower",
	 " ",
	 NULL };
     gchar *artists[] = {"François Le Clainche <fleclainche at wanadoo.fr>",NULL};
  //   g_object_set (obj, "authors", authors, NULL);
/*     gchar *writers[];
     g_object_get (obj, "authors", &writers, NULL);
     // do something with writers
     g_strfreev (writers);*/

     gchar *g=g_strdup_printf( "Hello world!\nThis is rodent-diff. A Rodent front end for GNU diff.\nBuilt with GTK+-%d.%d.%d,linked with GTK+-%d.%d.%d.\n",
                     GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION,
                     gtk_major_version, gtk_minor_version, gtk_micro_version);
     GdkPixbuf *pixbuf=get_application_pixbuf(BIG_ICON_SIZE);
     gtk_show_about_dialog (GTK_WINDOW(diff_p->window),
	"artists",		artists,
        "authors",		authors,
	"comments",           g,
	"copyright",          COPYRIGHT,
	"license",            GPLV3,
	"logo",               pixbuf,
	"version",            PACKAGE_VERSION,
	"website",            HOMEPAGE,
	NULL);
     g_free(g);
     g_free(backend);
//	"program-name"             gchar*                : Read / Write
//	"translator-credits"       gchar*                : Read / Write

    // hello_world(diff_p);
     g=g_strdup_printf( "\tBuilt with GTK+-%d.%d.%d,linked with GTK+-%d.%d.%d.\n",
                     GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION,
                     gtk_major_version, gtk_minor_version, gtk_micro_version);
     rfm_diagnostics(&(diff_p->widgets), "xffm_tag/red", g, NULL);
     g_free(g);
     g=g_strdup_printf("\tSend bug reports to %s\n", PACKAGE_BUGREPORT);
     rfm_diagnostics(&(diff_p->widgets), "xffm_tag/red", g, NULL);
     g_free(g);
     g=g_strdup_printf("\t%s\n", COPYRIGHT);
     rfm_diagnostics(&(diff_p->widgets), "xffm_tag/red", g, NULL);
     g_free(g);
}

static polygon_t *
get_polygon_head(diff_t *diff_p){
    polygon_t *head = diff_p->polygon_current;
    while (head && head->previous) head = head->previous;
    return head;
}

static gint 
get_polygon_count(diff_t *diff_p){
    polygon_t *head = get_polygon_head(diff_p);

    gint count = 0;
    while (head){ count++; head = head->next;}
    return count;
}

static void
show_current_polygon(diff_t *diff_p){
    if (!diff_p || !(diff_p->polygon_current)) return;
    gint value = (diff_p->polygon_current->topR < diff_p->polygon_current->topL) ? 
        diff_p->polygon_current->topR : diff_p->polygon_current->topL;
    if(value >= diff_p->lineH) value -= diff_p->lineH;
    else value = 0;
    gtk_adjustment_set_value (GTK_ADJUSTMENT (diff_p->adj), value);
    configure_event (diff_p->drawA, NULL, diff_p);
    cb_adjust ((GtkAdjustment *) diff_p->adj, diff_p);
}

static void
cb_next_prev_diff (GtkWidget * widget, gpointer data, gboolean next) {  
    diff_t *diff_p=data;
    if(!diff_p->polygon_current) return;
    gint count = get_polygon_count(diff_p);
    gchar *g = NULL;

    if(next) {
        if(diff_p->polygon_current->next) {
            diff_p->polygon_current = diff_p->polygon_current->next;
            g = g_strdup_printf ("%s: %d/%d", _("Difference"), 
                    diff_p->polygon_current->id, count);
        } else {
            if(diff_p->diff_flags & DIFF_IS_DONE)
                g = g_strdup_printf (_("No more matches for this search direction."));
            else
                g = g_strdup_printf ("%s: diff", _("Running"));
        }
    } else {
        if(diff_p->polygon_current->previous) {
            diff_p->polygon_current = diff_p->polygon_current->previous;
            g = g_strdup_printf ("%s: %d/%d", _("Difference"),
                    diff_p->polygon_current->id, count);
        } else {
            if(diff_p->diff_flags & DIFF_IS_DONE)
                g = g_strdup_printf (_("No more matches for this search direction."));
            else
                g = g_strdup_printf ("%s: diff", _("Running"));
        }
    }
    if(g) {
        rfm_diagnostics(&(diff_p->widgets), "rodent-diff", " ",g, "\n", NULL);
        g_free (g);
    }
    show_current_polygon(diff_p);
}


static void
cb_previous_diff (GtkWidget * widget, gpointer data) {
    cb_next_prev_diff (widget, data, FALSE);
}

static void
cb_next_diff (GtkWidget * widget, gpointer data) {
    cb_next_prev_diff (widget, data, TRUE);
}

static void 
print_layout(diff_t *diff_p, cairo_t *gdk_context, int x, int y, gint number){
    
    gchar *ntext=g_strdup_printf("%d", number);
    PangoLayout *layout = gtk_widget_create_pango_layout (diff_p->drawA, ntext);
    g_free(ntext);
    if (x < 0){
        GdkRectangle allocation;
	gtk_widget_get_allocation (diff_p->drawA, &allocation);
	PangoRectangle logical_rect;
        pango_layout_get_pixel_extents (layout, NULL, &logical_rect);
	gint W = allocation.width;
	x = W - logical_rect.width;
    }

    cairo_set_source_rgb(gdk_context, 0.2, 0.2, 0.9);
    cairo_move_to (gdk_context, x-1, y);
    pango_cairo_show_layout (gdk_context,layout);
    cairo_move_to (gdk_context, x+1, y);
    pango_cairo_show_layout (gdk_context,layout);
    cairo_move_to (gdk_context, x, y-1);
    pango_cairo_show_layout (gdk_context,layout);
    cairo_move_to (gdk_context, x, y+1);
    pango_cairo_show_layout (gdk_context,layout);

    cairo_set_source_rgb(gdk_context, 1.0, 1.0, 0.0);
    cairo_move_to (gdk_context, x, y);
    pango_cairo_show_layout (gdk_context,layout);

    g_object_unref (G_OBJECT (layout));
}

static gint
configure_event (GtkWidget * widget, GdkEventConfigure * event, gpointer data) {
    if(gtk_widget_get_window(widget) == NULL) return FALSE;
    diff_t *diff_p=data;
    GdkRectangle allocation;
    gtk_widget_get_allocation (widget, &allocation);
    Display *display=gdk_x11_display_get_xdisplay(gdk_display_get_default());

    if(diff_p->drawP){
        XFreePixmap (display, diff_p->drawP);
    }
    gint root_d;
    rfm_get_drawable_geometry(gdk_x11_get_default_root_xwindow (),
	    NULL, NULL, NULL, NULL, 
	    &root_d);    
    diff_p->drawP = XCreatePixmap (display, GDK_ROOT_WINDOW (), 
	    allocation.width, allocation.height, root_d);
    Visual *visual = gdk_x11_visual_get_xvisual(gdk_visual_get_system());
    cairo_surface_t *pixmap_surface = 
	cairo_xlib_surface_create (
		display, // Display *
		diff_p->drawP, // Drawable 
		visual, // Visual *
		allocation.width, allocation.height);

    if(cairo_surface_status (pixmap_surface) != CAIRO_STATUS_SUCCESS) {
	g_error ("cairo_surface_status(surface) != CAIRO_STATUS_SUCCESS");
    }
    cairo_t *gdk_context = cairo_create (pixmap_surface);
#if 0
    if(diff_p->drawP)
        g_object_unref (G_OBJECT (diff_p->drawP));
    diff_p->drawP = 
	gdk_pixmap_new (widget->window, allocation.width, height, -1);
    cairo_t *gdk_context=gdk_cairo_create(diff_p->drawP);
#endif
    

    cairo_set_source_rgb(gdk_context, 0.96, 0.96, 0.96);
    cairo_paint(gdk_context);

    gint adj_value = gtk_adjustment_get_value(GTK_ADJUSTMENT (diff_p->adj));
#define Y1 (thisP->topL - adj_value)
#define Y2 (thisP->topR - adj_value)
#define Y3 (thisP->botR - adj_value)
#define Y4 (thisP->botL - adj_value)
#define H  (allocation.height)
#define W  (allocation.width)
    {
        polygon_t *thisP;
        GdkRectangle update_rect;
        GdkPoint pt[4];
        update_rect.x = 0;
        update_rect.y = 0;
        update_rect.width = W;
        update_rect.height = H;
        thisP = diff_p->polygon_head;
        while(thisP) {
            /* is it in the update region? */
            if(((Y1 <= 3 * H) || (Y2 <= 3 * H)) && ((Y3 >= 0) || (Y4 >= 0))) {
                pt[0].x = 0;
                pt[0].y = (Y1 > 3 * H) ? 3 * H : (Y1 < 0) ? 0 : Y1;
                pt[1].x = W;
                pt[1].y = (Y2 > 3 * H) ? 3 * H : (Y2 < 0) ? 0 : Y2;
                pt[2].x = W;
                pt[2].y = (Y3 > 3 * H) ? 3 * H : (Y3 < 0) ? 0 : Y3;
                pt[3].x = 0;
                pt[3].y = (Y4 > 3 * H) ? 3 * H : (Y4 < 0) ? 0 : Y4;

		cairo_set_source_rgb(gdk_context, 0.2, 0.2, 0.9);
		//create cairo closed path...	
		cairo_move_to (gdk_context, pt[0].x, pt[0].y); 
		cairo_line_to (gdk_context, pt[1].x, pt[1].y);
		cairo_line_to (gdk_context, pt[2].x, pt[2].y);
		cairo_line_to (gdk_context, pt[3].x, pt[3].y);
		cairo_close_path (gdk_context);
		cairo_fill(gdk_context);

                if(diff_p->diff_flags & SHOW_LINEN) {
		    print_layout(diff_p, gdk_context, 0, pt[0].y, thisP->topLL);
                    if(pt[3].y >= pt[0].y + diff_p->lineH * 2) {
			print_layout(diff_p, gdk_context, 0, pt[3].y - diff_p->lineH, thisP->botLL);
                    }
		    print_layout(diff_p, gdk_context, -1, pt[1].y, thisP->topLR);
                    if(pt[2].y >= pt[1].y + diff_p->lineH * 2) {
			print_layout(diff_p, gdk_context, -1, pt[2].y - diff_p->lineH, thisP->botLR);
                    }
                }               /* end if in update region */
            }
            thisP = thisP->next;
        }
        gtk_widget_queue_draw_area (diff_p->drawA, 
		update_rect.x, 
		update_rect.y, 
		update_rect.width, 
		update_rect.height);
    }
    cairo_destroy(gdk_context);
    return TRUE;
}

static gint
#if GTK_MAJOR_VERSION==2
expose_event (GtkWidget * widget, GdkEventExpose * event, gpointer data) {
#else
draw_event (GtkWidget * widget, cairo_t *cr, gpointer data) {
#endif
    diff_t *diff_p=data;

    cairo_t *gdk_context=gdk_cairo_create(gtk_widget_get_window(diff_p->drawA));

    // gdk_cairo_set_source_pixmap (gdk_context, diff_p->drawP, 0,0);
    GdkRectangle allocation;
    gtk_widget_get_allocation (diff_p->drawA, &allocation);


    Display *display=gdk_x11_display_get_xdisplay(gdk_display_get_default());
    Visual *visual = gdk_x11_visual_get_xvisual(gdk_visual_get_system());
    cairo_surface_t *pixmap_surface = 
	cairo_xlib_surface_create (
		display, // Display *
		diff_p->drawP, // Drawable 
		visual, // Visual *
		allocation.width, allocation.height);
    cairo_set_source_surface(gdk_context, pixmap_surface, 0, 0);
    cairo_paint(gdk_context);
    cairo_destroy(gdk_context);
    return FALSE;
}

//// dnd
//


static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"STRING", 0, TARGET_STRING}
};

#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))


gboolean
on_drag_motion (GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data) {
    GdkDragAction action;

    action = GDK_ACTION_COPY;

    /* Respond with default drag action (status). First we check
     * the dc's list of actions. If the list only contains
     * move or copy then we select just that, otherwise we return
     * with our default suggested action.
     * If no valid actions are listed then we respond with 0.
     */
#if GTK_MAJOR_VERSION==2
    gint selected_action = dc->actions;
#else
    gint selected_action = gdk_drag_context_get_selected_action(dc);
#endif

    if(selected_action == GDK_ACTION_MOVE)
        gdk_drag_status (dc, GDK_ACTION_MOVE, t);
    else if(selected_action == GDK_ACTION_COPY)
        gdk_drag_status (dc, GDK_ACTION_COPY, t);
    else if(selected_action == GDK_ACTION_LINK)
        gdk_drag_status (dc, GDK_ACTION_LINK, t);
    else if(selected_action & action)
        gdk_drag_status (dc, action, t);
    else
        gdk_drag_status (dc, 0, t);
    /*TRACE("dbg: drag motion done...\n"); */

    return (TRUE);
}

static void
on_drag_data_received (GtkWidget * view,
                       GdkDragContext * context, 
		       gint x, 
		       gint y, 
		       GtkSelectionData * selection_data, 
		       guint info, 
		       guint time, 
		       void *data) {

    gchar *directory = NULL;
    GList *alt_list = NULL;
    diff_t *diff_p=data;


    const guchar *uchar_data = gtk_selection_data_get_data (selection_data);
    if (!uchar_data) {
abort:
        gtk_drag_finish (context, FALSE, TRUE, time);
	DBG( "!uchar_data\n");
	return;
    }
    gchar *text = g_strdup((gchar *)uchar_data);
    gchar **drops = g_strsplit(text, "\n", -1);
    g_free(text);
    if (!drops) goto abort;
    cleanPolygon (diff_p);
    cleanAreaDraw (diff_p);
    cleanTextAreas (diff_p);   gchar **p = drops;
    for (; p && *p; p++){
	if (strncmp(*p, "file:", strlen("file:")) != 0) continue;
	gchar *np = *p + strlen("file:");
	if (strchr(np, 13)) *strchr(np, 13) = 0;
	if (!directory && rfm_g_file_test(np, G_FILE_TEST_IS_DIR)){
	    directory = g_strdup(np);
	//    break;
	}
	alt_list = g_list_prepend(alt_list, g_strdup(np));
    }
    g_strfreev(drops);
    if (directory && g_list_length(alt_list) == 1){
	GList *tmp = alt_list;
	for (; tmp && tmp->data; tmp=tmp->next) g_free(tmp->data);
	g_list_free(alt_list);
	alt_list=NULL;
    } else {
	g_free(directory);
	directory = NULL;
    }
    if (!directory && !alt_list) goto abort;

    if(view == diff_p->view_left) {
	g_free(diff_p->left_file);
	diff_p->left_index=0;
	diff_p->diff_flags &= (DIFF_IS_DONE^0xffffffff);
	if (directory) {
	    diff_p->left_file = directory;
	} else {
	    diff_p->left_file = g_path_get_dirname((gchar *)alt_list->data);
	}
	diff_p->left_count =
	    update_combo_model(diff_p, TRUE, alt_list);
    } else {
	g_free(diff_p->right_file);
	diff_p->right_index=0;
	diff_p->diff_flags &= (DIFF_IS_DONE^0xffffffff);
	if (directory) {
	    diff_p->right_file = directory;
	} else {
	    diff_p->right_file = g_path_get_dirname((gchar *)alt_list->data);
	}
	diff_p->right_count =
	    update_combo_model(diff_p, FALSE, alt_list);
    }


    hideshow_menus(data);

    gtk_drag_finish (context, TRUE, TRUE, time);
}
///////////////////////////  patchmake callbacks  //////////////////////////////

///// output format
static void
select_output_format (diff_t *diff_p, gint option){
    // blank out former format option
    diff_p->patchmake_flags &= OUTPUT_FORMAT_MASK;
    // set new option
    diff_p->patchmake_flags |= option;
     save_defaults(diff_p);
}
static void
 cb_radio_patch_option_u(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, UNIFIED);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, TRUE);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
    }
}

static void
 cb_radio_patch_option_normal(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
	select_output_format(diff_p, NORMAL);
    }
}

static void
 cb_radio_patch_option_e(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, ED);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
    }
}

static void
 cb_radio_patch_option_rcs(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, RCS);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
    }
}

static void
 cb_radio_patch_option_D(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, IFDEF);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, TRUE);
    }
}

static void
 cb_radio_patch_brief(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, BRIEF);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
    }
}

static void
 cb_radio_patch_sidebyside(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, SIDEBYSIDE);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
    }
}

static void
 cb_radio_patch_context(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
	select_output_format(diff_p, CONTEXT);
	gtk_widget_set_sensitive(diff_p->C_spinbutton_box, TRUE);
	gtk_widget_set_sensitive(diff_p->U_spinbutton_box, FALSE);
	gtk_widget_set_sensitive(diff_p->D_entry, FALSE);
    }
}

///// end of output file callbacks

static void
on_off_directory_box(diff_t *diff_p) {
    TRACE("on off function left=%d right=%d\n", 
	    diff_p->patchmake_flags & LEFT_IS_DIR,
	    diff_p->patchmake_flags & RIGHT_IS_DIR
	    );
    GtkWidget *directory_box=g_object_get_data(G_OBJECT(diff_p->window), "directory_box");
    if (diff_p->patchmake_flags & (LEFT_IS_DIR|RIGHT_IS_DIR)) {
	gtk_widget_set_sensitive(directory_box, TRUE);
    } else {
	gtk_widget_set_sensitive(directory_box, FALSE);
    }
}

static void
 cb_radio_patch_directory_left(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (LEFT_IS_DIR^0xffffffff);
    } else {
        diff_p->patchmake_flags |= LEFT_IS_DIR;
    }
    on_off_directory_box(diff_p);
}

static void
 cb_radio_patch_directory_right(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (RIGHT_IS_DIR^0xffffffff);
    } else {
        diff_p->patchmake_flags |= RIGHT_IS_DIR;
    }
    on_off_directory_box(diff_p);
}

static void
 cb_radio_patch_file_left(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (LEFT_IS_DIR^0xffffffff);
    } else {
        diff_p->patchmake_flags |= LEFT_IS_DIR;
    }
    on_off_directory_box(diff_p);
}

static void
 cb_radio_patch_file_right(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (RIGHT_IS_DIR^0xffffffff);
    } else {
        diff_p->patchmake_flags |= RIGHT_IS_DIR;
    }
    on_off_directory_box(diff_p);
}

static void
 cb_check_patch_newfiles(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (NEW_FILE^0xffffffff);
    } else {
        diff_p->patchmake_flags |= NEW_FILE;
    }
     save_defaults(diff_p);
}

static void
 cb_check_patch_unidirectional_new_file(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (UNIDIRECTIONAL_NEW_FILE^0xffffffff);
    } else {
        diff_p->patchmake_flags |= UNIDIRECTIONAL_NEW_FILE;
    }
     save_defaults(diff_p);
}

static void
 cb_check_patch_recursive(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (RECURSIVE^0xffffffff);
    } else {
        diff_p->patchmake_flags |= RECURSIVE;
    }
     save_defaults(diff_p);
}

static void
 cb_check_patch_text(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (TEXT^0xffffffff);
    } else {
        diff_p->patchmake_flags |= TEXT;
    }
     save_defaults(diff_p);
}

static void
 cb_check_patch_ignore_file_name_case(GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (IGNORE_FILE_NAME_CASE^0xffffffff);
    } else {
        diff_p->patchmake_flags |= IGNORE_FILE_NAME_CASE;
    }
     save_defaults(diff_p);
}

static void
cb_check_patch_report_identical_files (GtkWidget * widget, gpointer data){
    diff_t *diff_p=data;
    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(widget))){
        diff_p->patchmake_flags &= (REPORT_IDENTICAL_FILES^0xffffffff);
    } else {
        diff_p->patchmake_flags |= REPORT_IDENTICAL_FILES;
    }
     save_defaults(diff_p);
}


static GtkWidget *
create_directory_file_box(
    diff_t *diff_p, 
    gboolean left, 
    GSList **Ggroup
    ){
    gchar *top_file=(left)?diff_p->left_file:diff_p->right_file;
    GtkWidget *combo_box=(left)?diff_p->combo_left:diff_p->combo_right;
    GtkListStore *list_store=(left)?diff_p->list_store_left:diff_p->list_store_right;
    GtkWidget *radio;
    GtkWidget *image;
    GdkPixbuf *pixbuf;
    GtkWidget *box=rfm_hbox_new(FALSE,6);

    gchar *dir_path=rfm_utf_string(top_file);
    GtkWidget *label;		    
    gchar *icon_id=NULL;

    if (!rfm_g_file_test(top_file, G_FILE_TEST_IS_DIR)) {
	// file icon:
	icon_id=MIME_type(top_file, NULL);
	if (!icon_id) {
	    icon_id=MIME_magic(top_file);
	}
	pixbuf=rfm_get_pixbuf(icon_id, SIZE_BUTTON);
	image=gtk_image_new_from_pixbuf(pixbuf);
	g_object_unref(pixbuf);
	gtk_box_pack_start (GTK_BOX(box), image, FALSE, FALSE, 3);
	// file path
	label=gtk_label_new(rfm_chop_excess(dir_path));		    
	gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 3);

    } else {
	GtkWidget *vbox=rfm_vbox_new(FALSE,6);
	gtk_box_pack_start (GTK_BOX(box), vbox, FALSE, FALSE, 3);

	// directory option
	GtkWidget *hbox1=rfm_hbox_new(FALSE,6);
	gtk_box_pack_start (GTK_BOX(vbox), hbox1, FALSE, FALSE, 3);

	radio = gtk_radio_button_new (Ggroup[0]);
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[0]);
	Ggroup[0] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    (left)?G_CALLBACK (cb_radio_patch_directory_left):G_CALLBACK (cb_radio_patch_directory_right),
	    diff_p);
	gtk_box_pack_start (GTK_BOX(hbox1), radio, FALSE, FALSE, 3);
	// directory icon:
	GdkPixbuf *pixbuf=rfm_get_pixbuf("inode/directory", SIZE_BUTTON);
	GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
	g_object_unref(pixbuf);
	gtk_box_pack_start (GTK_BOX(hbox1), image, FALSE, FALSE, 3);
	// directory path:
	label=gtk_label_new(rfm_chop_excess(dir_path));		    
	gtk_box_pack_start (GTK_BOX(hbox1), label, FALSE, FALSE, 3);


	// file option
	GtkWidget *hbox2=rfm_hbox_new(FALSE,6);
	gtk_box_pack_start (GTK_BOX(vbox), hbox2, FALSE, FALSE, 3);

	//file_radio = 
	    radio = gtk_radio_button_new (Ggroup[0]);
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[0]);
	Ggroup[0] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    (left)?G_CALLBACK (cb_radio_patch_file_left):G_CALLBACK (cb_radio_patch_file_right), 
	    diff_p);
	g_object_set_data(G_OBJECT(diff_p->window), (left)?"file_radio_left":"file_radio_right", radio);
	gtk_box_pack_start (GTK_BOX(hbox2), radio, FALSE, FALSE, 3);
		
	// file path:
	gchar *active=NULL;
	GtkTreeIter iter;
	gtk_combo_box_get_active_iter (GTK_COMBO_BOX(combo_box), &iter); 
	gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter,
	PATH_COLUMN, &active,
	-1);
	// file icon:
	icon_id=MIME_type(active, NULL);
	if (!icon_id) {
	    icon_id=MIME_magic(active);
	}
	pixbuf=rfm_get_pixbuf(icon_id, SIZE_BUTTON);
	image=gtk_image_new_from_pixbuf(pixbuf);
	g_object_unref(pixbuf);
	gtk_box_pack_start (GTK_BOX(hbox2), image, FALSE, FALSE, 3);
	// file path
	gchar *file_path=rfm_utf_string(active);
	g_free(active);
	label=gtk_label_new(rfm_chop_excess(file_path));
	g_free(file_path);
	gtk_box_pack_start (GTK_BOX(hbox2), label, FALSE, FALSE, 3);
	
    }
    g_free(dir_path);
    g_free(icon_id);
    return box;
}

static gchar *
get_patch_options (diff_t *diff_p, gboolean do_directory) {
    /* select file name for output: */
    GSList *group=NULL;
    GtkWidget *options = gtk_dialog_new_with_buttons (
	    _("Options"),
                                                 GTK_WINDOW(diff_p->window),
                                                 GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                                                 _("Ok"),
                                                 GTK_RESPONSE_ACCEPT,
                                                 _("Cancel"),
                                                 GTK_RESPONSE_REJECT,
                                                 NULL);
    gtk_window_set_type_hint(GTK_WINDOW(options), GDK_WINDOW_TYPE_HINT_DIALOG);
    GtkWidget *radio;
    GtkWidget *check;
    GtkWidget *label;
    GtkWidget *box;
    GtkWidget *action_area =  gtk_dialog_get_content_area (GTK_DIALOG(options));  
    GSList *Ggroup[4];
    int i;
    for (i=0; i<4; i++) {
        Ggroup[i]=NULL;
    }
    // _("Directory or file selection")
    gchar *g=g_strdup_printf("<b>%s</b>", _("Input"));
    label=gtk_label_new(g);
    g_free(g);
    gtk_label_set_use_markup (GTK_LABEL(label), TRUE);
    gtk_box_pack_start (GTK_BOX(action_area), label, FALSE, FALSE, 3);
    box=rfm_hbox_new(TRUE,6);
    gtk_box_pack_start (GTK_BOX(action_area), box, FALSE, FALSE, 3);

    gtk_box_pack_start (GTK_BOX(box), 
	    create_directory_file_box(
		diff_p,
		TRUE,
		Ggroup
		),
	    FALSE, FALSE, 3);
    gtk_box_pack_start (GTK_BOX(box), 
	    create_directory_file_box(
		diff_p,
		FALSE,
		Ggroup+1
		),
	    FALSE, FALSE, 3);


    if (do_directory) {
	
	// NEW_FILES	
	GtkWidget *directory_box=rfm_vbox_new(FALSE,3);
	g_object_set_data(G_OBJECT(diff_p->window), "directory_box", directory_box);
	gtk_box_pack_start (GTK_BOX(action_area), directory_box, FALSE, FALSE, 3);

	check=gtk_check_button_new_with_label(_("-N  --new-file  Treat absent files as empty."));
	g_object_set_data(G_OBJECT(diff_p->window), "NEW_FILE", check);
	if(diff_p->patchmake_flags & NEW_FILE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE); }
	g_signal_connect(G_OBJECT(check), "toggled", 
	    G_CALLBACK (cb_check_patch_newfiles), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), check, FALSE, FALSE, 3);

	// UNIDIRECTIONAL_NEW_FILE
	check=gtk_check_button_new_with_label(_("--unidirectional-new-file  Treat absent first files as empty."));
	g_object_set_data(G_OBJECT(diff_p->window), "UNIDIRECTIONAL_NEW_FILE", check);
	if(diff_p->patchmake_flags & UNIDIRECTIONAL_NEW_FILE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE); }
	g_signal_connect(G_OBJECT(check), "toggled", 
	    G_CALLBACK (cb_check_patch_unidirectional_new_file), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), check, FALSE, FALSE, 3);

	// RECURSIVE
	check=gtk_check_button_new_with_label(_("-r  --recursive  Recursively compare any subdirectories found."));
	g_object_set_data(G_OBJECT(diff_p->window), "RECURSIVE", check);
	if(diff_p->patchmake_flags & RECURSIVE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE);}
	g_signal_connect(G_OBJECT(check), "toggled", 
	    G_CALLBACK (cb_check_patch_recursive), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), check, FALSE, FALSE, 3);

	// TEXT
	check=gtk_check_button_new_with_label(_("-a  --text  Treat all files as text."));
	g_object_set_data(G_OBJECT(diff_p->window), "TEXT", check);
	if(diff_p->patchmake_flags & TEXT) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE); }
	g_signal_connect(G_OBJECT(check), "toggled", 
	    G_CALLBACK (cb_check_patch_text), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), check, FALSE, FALSE, 3);
	

	// IGNORE_FILE_NAME_CASE
	check=gtk_check_button_new_with_label(_("--ignore-file-name-case  Ignore case when comparing file names."));
	g_object_set_data(G_OBJECT(diff_p->window), "IGNORE_FILE_NAME_CASE", check);
	if(diff_p->patchmake_flags & IGNORE_FILE_NAME_CASE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE); }
	g_signal_connect(G_OBJECT(check), "toggled", 
	    G_CALLBACK (cb_check_patch_ignore_file_name_case), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), check, FALSE, FALSE, 3);

	// REPORT_IDENTICAL_FILES
	check=gtk_check_button_new_with_label(_("-s  --report-identical-files  Report when two files are the same."));
	g_object_set_data(G_OBJECT(diff_p->window), "REPORT_IDENTICAL_FILES", check);
	if(diff_p->patchmake_flags & REPORT_IDENTICAL_FILES) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE); }
	g_signal_connect(G_OBJECT(check), "toggled", 
	    G_CALLBACK (cb_check_patch_report_identical_files), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), check, FALSE, FALSE, 3);

#if 0
	// requires entry box:
	// EXCLUDE
	// radio group 3
	radio=gtk_radio_button_new_with_label(Ggroup[2],
		_("-x PAT  --exclude=PAT  Exclude files that match PAT."));
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[2]);
	Ggroup[2] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	if(diff_p->patchmake_flags & EXCLUDE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); }
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_EXCLUDE), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), radio, FALSE, FALSE, 3);

	// requires entry box:
	// EXCLUDE_FROM
	radio=gtk_radio_button_new_with_label(Ggroup[2],
		_( "-X FILE  --exclude-from=FILE  Exclude files that match any pattern in FILE."));
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[2]);
	Ggroup[2] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	if(diff_p->patchmake_flags & EXCLUDE_FROM) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); }
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_EXCLUDE_FROM), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), radio, FALSE, FALSE, 3);

	// requires file selector button
	// radio group 4
	// STARTING_FILE
	radio=gtk_radio_button_new_with_label(Ggroup[3],
		_("-S FILE  --starting-file=FILE  Start with FILE when comparing directories."));
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[3]);
	Ggroup[3] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	if(diff_p->patchmake_flags & STARTING_FILE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); }
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_STARTING_FILE), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), radio, FALSE, FALSE, 3);
#if 0
	these are not aplicable, since rfm-diff only processes right and left, not multiple paths
	// requires file selector button
	// FROM_FILE
	radio=gtk_radio_button_new_with_label(Ggroup[3],
		_("--from-file=FILE1  Compare FILE1 to all operands.  FILE1 can be a directory."));
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[3]);
	Ggroup[3] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	if(diff_p->patchmake_flags & FROM_FILE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); }
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_FROM_FILE), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), radio, FALSE, FALSE, 3);

	// requires file selector button
	// TO_FILE
	radio=gtk_radio_button_new_with_label(Ggroup[3],
		_("--to-file=FILE2  Compare all operands to FILE2.  FILE2 can be a directory."));
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), Ggroup[3]);
	Ggroup[3] = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
	if(diff_p->patchmake_flags & TO_FILE) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); }
	g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_TO_FILE), diff_p);
	gtk_box_pack_start (GTK_BOX(directory_box), radio, FALSE, FALSE, 3);
#endif
#endif
	// set default show/hide :

	if(diff_p->patchmake_flags & NEW_FILE) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "NEW_FILE")), 
		    TRUE);
	}
	if(diff_p->patchmake_flags & UNIDIRECTIONAL_NEW_FILE) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "UNIDIRECTIONAL_NEW_FILE")), 
		    TRUE);
	}
	if(diff_p->patchmake_flags & RECURSIVE) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "RECURSIVE")), 
		    TRUE);
	}
	if(diff_p->patchmake_flags & TEXT) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "TEXT")), 
		    TRUE);
	}
	if(diff_p->patchmake_flags & IGNORE_FILE_NAME_CASE) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "IGNORE_FILE_NAME_CASE")), 
		    TRUE);
	}
	if(diff_p->patchmake_flags & REPORT_IDENTICAL_FILES) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "REPORT_IDENTICAL_FILES")), 
		    TRUE);
	}
	// if button was not toggled, run the toggle function:
	radio=g_object_get_data(G_OBJECT(diff_p->window), "file_radio_right");
	if (radio) cb_radio_patch_file_right(radio, diff_p);
	radio=g_object_get_data(G_OBJECT(diff_p->window), "file_radio_left");
	if (radio) cb_radio_patch_file_right(radio, diff_p);
    } else {
	g_object_set_data(G_OBJECT(diff_p->window), "directory_box", NULL);
    }

    g=g_strdup_printf("<b>%s</b>", _("Output file"));
    label=gtk_label_new(g);
    g_free(g);
    gtk_label_set_use_markup (GTK_LABEL(label), TRUE);
    gtk_box_pack_start (GTK_BOX(action_area), label, FALSE, FALSE, 3);

// default option
    // normal
    radio = gtk_radio_button_new_with_label (group, _("--normal  Output a normal diff."));
    g_object_set_data(G_OBJECT(diff_p->window), "NORMAL", radio);
    gtk_box_pack_start (GTK_BOX(action_area), radio, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    if(diff_p->patchmake_flags & NORMAL) { gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); }
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_option_normal), diff_p);

    // unified
    box=rfm_hbox_new(FALSE,3);
    gtk_box_pack_start (GTK_BOX(action_area), box, FALSE, FALSE, 3);
    radio = gtk_radio_button_new_with_label (group, "-u ");
    g_object_set_data(G_OBJECT(diff_p->window), "UNIFIED", radio);
    g=g_strdup_printf("%s.", _("Unified diff format"));
    label = gtk_label_new (g);
    g_free(g);
    gtk_box_pack_start (GTK_BOX(box), radio, FALSE, FALSE, 3);
    gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_option_u), diff_p);
    diff_p->U_spinbutton_box=rfm_hbox_new(FALSE,3);
    gtk_box_pack_start (GTK_BOX(box), diff_p->U_spinbutton_box, FALSE, FALSE, 3);

    label=gtk_label_new(_("Lines:"));
    gtk_box_pack_start (GTK_BOX(diff_p->U_spinbutton_box), label, FALSE, FALSE, 3);
    GtkAdjustment *adjustment=GTK_ADJUSTMENT(gtk_adjustment_new  (3.0, 0.0, 99.0, 1.0, 3.0, 0));
    diff_p->U_spinbutton=gtk_spin_button_new  (adjustment, 1.0, 0);
    gtk_box_pack_start (GTK_BOX(diff_p->U_spinbutton_box), diff_p->U_spinbutton, FALSE, FALSE, 3);

    // context
    box=rfm_hbox_new(FALSE,3);
    gtk_box_pack_start (GTK_BOX(action_area), box, FALSE, FALSE, 3);
    radio = gtk_radio_button_new_with_label (group, "-c ");
    g_object_set_data(G_OBJECT(diff_p->window), "CONTEXT", radio);
    g=g_strdup_printf("%s.", _("Show in Context"));
    label = gtk_label_new (g);
    g_free(g);
    gtk_box_pack_start (GTK_BOX(box), radio, FALSE, FALSE, 3);
    gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_context), diff_p);
    diff_p->C_spinbutton_box=rfm_hbox_new(FALSE,3);
    gtk_box_pack_start (GTK_BOX(box), diff_p->C_spinbutton_box, FALSE, FALSE, 3);

    label=gtk_label_new(_("Lines:"));
    gtk_box_pack_start (GTK_BOX(diff_p->C_spinbutton_box), label, FALSE, FALSE, 3);
    adjustment=GTK_ADJUSTMENT(gtk_adjustment_new  (3.0, 0.0, 99.0, 1.0, 3.0, 0));
    diff_p->C_spinbutton=gtk_spin_button_new  (adjustment, 1.0, 0);
    gtk_box_pack_start (GTK_BOX(diff_p->C_spinbutton_box), diff_p->C_spinbutton, FALSE, FALSE, 3);

    
    // ed
    radio = gtk_radio_button_new_with_label (group, _("-e  --ed  Output an ed script."));
    g_object_set_data(G_OBJECT(diff_p->window), "ED", radio);
    gtk_box_pack_start (GTK_BOX(action_area), radio, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_option_e), diff_p);
    
    // rcs
    radio = gtk_radio_button_new_with_label (group, _("-n  --rcs  Output an RCS format diff."));
    g_object_set_data(G_OBJECT(diff_p->window), "RCS", radio);
    gtk_box_pack_start (GTK_BOX(action_area), radio, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_option_rcs), diff_p);
   
    // ifdef
    box=rfm_hbox_new(FALSE,3);
    gtk_box_pack_start (GTK_BOX(action_area), box, FALSE, FALSE, 3);
    radio = gtk_radio_button_new_with_label (group, "-D");
    g_object_set_data(G_OBJECT(diff_p->window), "IFDEF", radio);
    gtk_box_pack_start (GTK_BOX(box), radio, FALSE, FALSE, 3);
    
    diff_p->D_entry=gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(diff_p->D_entry), _("NAME"));
    gtk_box_pack_start (GTK_BOX(box), diff_p->D_entry, FALSE, FALSE, 3);
    gtk_widget_set_sensitive (diff_p->D_entry, FALSE);
    
    label = gtk_label_new (_("-D NAME  --ifdef=NAME  Output merged file to show `#ifdef NAME' diffs."));
    gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_option_D), diff_p);
    
    // brief
    radio = gtk_radio_button_new_with_label (group, 
	    _("-q  --brief  Output only whether files differ."));
    g_object_set_data(G_OBJECT(diff_p->window), "BRIEF", radio);
    gtk_box_pack_start (GTK_BOX(action_area), radio, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_brief), diff_p);
	    
   // this item requires a spinbutton for width and two check boxes
   // for --left-column  and --suppress-common-lines
    radio = gtk_radio_button_new_with_label (group, 
	    _("Side-by-side merge of file differences."));
    g_object_set_data(G_OBJECT(diff_p->window), "SIDEBYSIDE", radio);
    gtk_box_pack_start (GTK_BOX(action_area), radio, FALSE, FALSE, 3);
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio), group);
    group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
    g_signal_connect(G_OBJECT(radio), "toggled", 
	    G_CALLBACK (cb_radio_patch_sidebyside), diff_p);

    // set default options for sensitivities:

    if(diff_p->patchmake_flags & NORMAL) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "NORMAL")), 
		    TRUE);
	    cb_radio_patch_option_normal(GTK_WIDGET (g_object_get_data(G_OBJECT(diff_p->window), "NORMAL")), diff_p);
    }
    if(diff_p->patchmake_flags & UNIFIED) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "UNIFIED")), 
		    TRUE);
    }
    if(diff_p->patchmake_flags & ED) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "ED")), 
		    TRUE);
    }
    if(diff_p->patchmake_flags & RCS) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "RCS")), 
		    TRUE);
    }
    if(diff_p->patchmake_flags & IFDEF) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "IFDEF")), 
		    TRUE);
    }
    if(diff_p->patchmake_flags & BRIEF) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "BRIEF")), 
		    TRUE);
    }
    if(diff_p->patchmake_flags & SIDEBYSIDE) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "SIDEBYSIDE")), 
		    TRUE);
    }
    
    if(diff_p->patchmake_flags & CONTEXT) { 
	    gtk_toggle_button_set_active (
		    GTK_TOGGLE_BUTTON (g_object_get_data(G_OBJECT(diff_p->window), "CONTEXT")), 
		    TRUE);
    }

    gtk_widget_show_all(options);
    
    int result=gtk_dialog_run (GTK_DIALOG (options));
    if (result != GTK_RESPONSE_ACCEPT){
	gtk_widget_destroy(options);
	return NULL;
    }
    gchar *patchmake_options=NULL;
    if (diff_p->patchmake_flags & IFDEF){
	const gchar *g=gtk_entry_get_text(GTK_ENTRY(diff_p->D_entry));
	patchmake_options=g_strdup_printf("--ifdef=%s",g);
    }
    else if (diff_p->patchmake_flags & UNIFIED){
	gint value=gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(diff_p->U_spinbutton));
	if (value != 3) {
	    patchmake_options=g_strdup_printf("--unified=%d",value);
	} else {
	    patchmake_options=g_strdup_printf("-u");
	}
    }
    else if (diff_p->patchmake_flags & CONTEXT){
	gint value=gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(diff_p->C_spinbutton));
	if (value != 3) {
	    patchmake_options=g_strdup_printf("--context=%d",value);
	} else {
	    patchmake_options=g_strdup("-c");
	}
    }
    else if (diff_p->patchmake_flags & BRIEF){
        patchmake_options=g_strdup("--brief");
    }
    else if (diff_p->patchmake_flags & NORMAL){
        patchmake_options=g_strdup("--normal");
    }
    else if (diff_p->patchmake_flags & RCS){
        patchmake_options=g_strdup("--rcs");
    }
    else if (diff_p->patchmake_flags & SIDEBYSIDE){
        patchmake_options=g_strdup("--side-by-side");
    }
    else if (diff_p->patchmake_flags & ED){
        patchmake_options=g_strdup("--ed");
    }
    else {
	 patchmake_options=g_strdup("");
    }
    // directory specific flags    
    if (do_directory) {
	if (diff_p->patchmake_flags & RECURSIVE) {
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf("--recursive %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & NEW_FILE) {
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf("--new-file %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & IGNORE_FILE_NAME_CASE) {
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf("--ignore-file-name-case %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & REPORT_IDENTICAL_FILES) {
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf("--report-identical-files %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & TEXT) {
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf("--text %s", f);
	    g_free(f);
	}
	/* // the following require a entry box, each 
	if (diff_p->patchmake_flags & EXCLUDE) { // --exclude=PAT
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf(" %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & EXCLUDE_FROM) { // --exclude-from=FILE
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf(" %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & STARTING_FILE) { // --starting-file=FILE
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf(" %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & FROM_FILE) { // --from-file=FILE
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf(" %s", f);
	    g_free(f);
	}
	if (diff_p->patchmake_flags & TO_FILE) { // --to-file=FILE2
	    gchar *f=patchmake_options;
	    patchmake_options=g_strdup_printf(" %s", f);
	    g_free(f);
	}*/

    }
    // destroy
    gtk_widget_destroy(options);
    return patchmake_options;
}

/* this function should only be called from diff mode.*/
static void
cb_patchmake (GtkWidget * widget, gpointer data) {
    diff_t *diff_p=data;
    gchar *patch_src_left;
    gchar *patch_src_right;

    gboolean do_directory=FALSE;

    if (rfm_g_file_test(diff_p->left_file, G_FILE_TEST_IS_DIR) &&
	rfm_g_file_test(diff_p->right_file, G_FILE_TEST_IS_DIR) &&
	strcmp(diff_p->left_file,diff_p->right_file)!=0){
	struct stat st_left;
	struct stat st_right;
        gint result_left = stat(diff_p->left_file, &st_left);
        gint result_right = stat(diff_p->right_file, &st_right);
        if (result_left==0 && result_right==0) {
            if (st_left.st_ino != st_right.st_ino || st_left.st_dev != st_right.st_dev){
                do_directory=TRUE;
            }
        }
    }
    gchar *patch_options=get_patch_options(diff_p, do_directory);
    if (patch_options==NULL){
	return;
    }

    if (!(diff_p->patchmake_flags & LEFT_IS_DIR) ){
	patch_src_left = 
	    get_combo_file(diff_p->combo_left, diff_p->list_store_left);
    } else {
	patch_src_left = rfm_esc_string(diff_p->left_file);
    }

    if (!(diff_p->patchmake_flags & RIGHT_IS_DIR)){
	patch_src_right =
	    get_combo_file(diff_p->combo_right, diff_p->list_store_right);

    } else {
	patch_src_right = rfm_esc_string(diff_p->right_file);
    }

    gchar *patch_output = NULL;
    if (rfm_confirm(&(diff_p->widgets),GTK_MESSAGE_INFO,
	    _("Please select a name for the patch file in the next dialog."),
	    _("standard output"), _("Output to File...")))
    {
	patch_output = fileselect(_("Create Patch"), GTK_FILE_CHOOSER_ACTION_SAVE);
	if (!patch_output){
	    g_free(patch_src_left);
	    g_free(patch_src_right);
	    return;
	}
    }
    
    gchar *command=g_strdup_printf("diff %s %s %s %c %s\n", 
	patch_options,
	patch_src_left, patch_src_right, 
	(patch_output)?'>':' ',
	(patch_output)?patch_output:"");

    rfm_diagnostics(&(diff_p->widgets), "xffm_tag/green", _("Create Patch"),":\n", NULL);
    rfm_diagnostics(&(diff_p->widgets), "xffm_tag/blue", patch_output, "\n", NULL);

    gchar *workdir=g_get_current_dir();
    RFM_THREAD_RUN (&(diff_p->widgets), command, FALSE);
    if (chdir(workdir) < 0) {
	DBG("chdir(%s): %s\n", workdir, strerror(errno));
    }
    g_free(workdir);
	
    g_free(patch_src_left);
    g_free(patch_src_right);
    g_free(patch_output);
    g_free(patch_options);
    return;
}


//

#ifdef PATCHMODE

// patchmode, available in rodent-alpha, is disabled in rodent-beta
// as part of the un-nerdification process.
static void
 cb_toggle_verbose(GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
     if (diff_p->verbose == 0) {
	 diff_p->verbose = 1;
     } else {
	 diff_p->verbose =0;
     }
     save_defaults(diff_p);
     
}

static void
 cb_toggle_reversed(GtkWidget * widget, gpointer data){
}

static void
 cb_toggle_autostrip(GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
     diff_p->autostrip = !diff_p->autostrip; 
     TRACE("toggling--->%d\n",diff_p->autostrip);
    hideshow_menus(data);


}

static void
 cb_radio_strip(GtkWidget * widget, gpointer data){
}

static void
 cb_radio_strip(GtkWidget * widget, gpointer data){
}

static void
 cb_patchapply(GtkWidget * widget, gpointer data){
}

static void
cb_get_fileD (GtkWidget * widget, gpointer data) {
}

static void
cb_get_fileP (GtkWidget * widget, gpointer data) {
}

static void
 cb_toggle_mode(GtkWidget * widget, gpointer data){
     diff_t *diff_p=data;
     diff_p->diff_flags ^= PATCHING;
    hideshow_menus(data);

}



#endif

