

#ifndef RFM_DIFF_H
#define RFM_DIFF_H
#include "gplv3.h"

enum {
    SELECT_LEFT_FILE,
    SELECT_RIGHT_FILE,
    SELECT_LEFT_DIRECTORY,
    SELECT_RIGHT_DIRECTORY,
    SWITCH_TO_PATCH_MODE,
    DIFF_SETTINGS,
    VIEW_DIFFERENCES,
    CREATE_PATCH_FILE,
    SHOW_DIFFERENCES,

    DIFF_MENUS
};

enum {
    LIST_P_COLUMN,
    PIXBUF_COLUMN,
    BASENAME_COLUMN,
    PATH_COLUMN,
    DATE_COLUMN,
    COMBO_COLUMNS
};
 

enum {
    SELECT_PATCH_FILE,
    SELECT_DIRECTORY_TO_PATCH,
    SWITCH_TO_DIFF_MODE,
    PATCH_SETTINGS,
    ASSUME_PATCH_IS_REVERSED,
    AUTO_STRIP_LEVEL,
    VIEW_PATCH_CREATED_DIFFERENCES,
    EMPTY_PATCH_MENUITEM,
    APPLY_PATCH_TO_HARD_DRIVE,
    UNDO_PATCH_TO_HARD_DRIVE,
    PATCH_MENUS
};
#define STRIP_LEVELS 10


typedef struct polygon_t {
    int topR;
    int botR;
    int topL;
    int botL;
    int topLR;
    int botLR;
    int topLL;
    int botLL;
    struct polygon_t *next;
    struct polygon_t *previous;
    int id;
} polygon_t;

// diff options
#define PATCHING 		(0x01)
#define REVERSED 		(0x01<<1)
#define AUTOSTRIP 		(0x01<<2)

#define VERBOSE 		(0x01<<3)
#define SILENT 			(0x01<<4)
#define DIFF_IS_DONE 		(0x01<<5)
#define DIFF_RUNNING 		(0x01<<6)

#define FILLEDP 		(0x01<<9)
#define SHOW_LINEN 		(0x01<<10)


#define IGNORE_CASE 		(0x01<<11)
#define IGNORE_TAB_EXPANSION 	(0x01<<12)
#define IGNORE_SPACE_CHANGE 	(0x01<<13)
#define IGNORE_ALL_SPACE 	(0x01<<14)
#define IGNORE_BLANK_LINES 	(0x01<<15)
#define IGNORE_MATCHING_LINES 	(0x01<<16)
#define MINIMAL 		(0x01<<17)
#define SPEED_LARGE_FILES	(0x01<<18)
#define STRIP_TRAILING_CR 	(0x01<<19)
#define EXPAND_TABS 		(0x01<<20)
#define INITIAL_TAB 		(0x01<<21)
#define TABSIZE 		(0x01<<22)
#define DIFF_UPDATING_MODEL	(0x01<<23)

#define DO_DIRECTORY 		(0x01<<1)
# define UNIDIRECTIONAL_NEW_FILE (0x01<<2)
# define NEW_FILE 		(0x01<<3)
# define RECURSIVE 		(0x01<<4)
# define IGNORE_FILE_NAME_CASE 	(0x01<<5)
# define REPORT_IDENTICAL_FILES (0x01<<6)
# define EXCLUDE 		(0x01<<7)
# define EXCLUDE_FROM 		(0x01<<8)
# define STARTING_FILE 		(0x01<<9)
# define FROM_FILE 		(0x01<<10)
# define TO_FILE 		(0x01<<11)
# define TEXT 			(0x01<<12)
# define LEFT_IS_DIR		(0x01<<13)
# define RIGHT_IS_DIR		(0x01<<14)
// output format:
#define OUTPUT_FORMAT_MASK 	((BRIEF|UNIFIED|NORMAL|RCS|SIDEBYSIDE|ED|IFDEF|CONTEXT)^0xffffffff)
#define BRIEF 			(0x01<<15)
#define UNIFIED 		(0x01<<16)
#define NORMAL 			(0x01<<17)
#define RCS 			(0x01<<18)
#define SIDEBYSIDE 		(0x01<<19)
#define ED 			(0x01<<20)
#define IFDEF 			(0x01<<21)
#define CONTEXT 		(0x01<<22)

typedef struct diff_t {
    GThread *self;
    pid_t tubo_pid;
    gint serial;
    GMutex *serial_mutex;
    GHashTable *hash[2];
    GtkWidget *window;
    GtkWidget *view_left;
    GtkWidget *view_right;
    GtkWidget *view_diag;
    GtkWidget *drawA;
    widgets_t widgets;

    GtkWidget *label_box;
    GtkWidget *label_button_left;
    GtkWidget *label_button_right;
    GtkWidget *folder_label_left;
    GtkWidget *folder_label_right;
    GtkWidget *left_select_dir_button;
    GtkWidget *right_select_dir_button;

    GtkWidget *button_stop;
    GtkWidget *button_next_file;
    GtkWidget *button_previous_file;
    GtkWidget *button_up;
    GtkWidget *button_down;
    GtkWidget *button_apply;
    GtkWidget *button_patchmake;
    GtkWidget *clear_button;
    GtkWidget *exit_button;
    GtkWidget *D_entry;
	
    GtkWidget *combo_box;
    GtkWidget *combo_left;
    GtkWidget *combo_right;
    GtkWidget *U_spinbutton;
    GtkWidget *U_spinbutton_box;
    GtkWidget *C_spinbutton;
    GtkWidget *C_spinbutton_box;
    GtkListStore *list_store_left;
    GtkListStore *list_store_right;

    GList *left_list;
    GList *right_list;

    GtkWidget *patchM[PATCH_MENUS];
    GtkWidget *diffM[DIFF_MENUS];
    GtkWidget *stripM[STRIP_LEVELS];
    GtkTextBuffer *text_buffer[2];
    Pixmap drawP;

    GtkAdjustment *adj;
    GtkAdjustment *adjR;

    FILE *skip_file[2];
    
    gchar *left_file;
    gchar *right_file;
    gchar *patch_file;
    gchar *patch_dir;
    gint diff_flags;
    gint patchmake_flags;
    gint left_index;
    gint right_index;
    gint left_count;
    gint right_count;
    gint left_patchmake_count;
    gint right_patchmake_count;
    gint lineW;
    gint lineH;
    gint sizeL;
    gint sizeR;
    gint sizeH;
    gint strip;

    gint difference_found; 
    gint diff_section; 
    gint diff_subsection; 

    gint polygon_ids;
    gint diffC;
    gint addedR;
    gint addedL;
    gint current_buffer_line;
    gint top_bufferline[2];
    gint bottom_bufferline[2];
    gint current_line[2];

    gint sync_count;
    gint file_line_number[2];
    gint file_skiplines[2];
     

    polygon_t *polygon_head;
    polygon_t *polygon_current;

} diff_t;

typedef struct list_t {
    GdkPixbuf *pixbuf;
    gchar *name;
    gchar *path;
    gchar *date;
    gchar *mimetype;
    GtkTreePath *treepath;
    size_t size;
} list_t;

#endif
