#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

/*
 * this could be useful, maybe...
G_MODULE_EXPORT
void set_drag_copy(view_t *view_p, gboolean will_copy){
    if (will_copy) drag_action = GDK_ACTION_COPY;
    else drag_action = GDK_ACTION_MOVE;
}
*/
/***************** GTK callbacks **************************/

static gboolean
destroy_event (
    GtkWidget * widget,
    GdkEvent * event,
    gpointer data
) {
    rfm_rational(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(QUIT_ACTIVATE), NULL, "callback");
    return TRUE;
}

static gboolean
on_configure (
    GtkWidget * widget,
    GdkEventConfigure * event,
    gpointer user_data
) {
    NOOP (stderr, "configure event\n");
    rfm_set_allocation();

    return TRUE;
}

static gboolean
on_size (
    GtkWidget * widget,
    GtkAllocation * allocation_p,
    gpointer user_data
) {
    NOOP(stderr, "on_size(paper): w=%d, h=%d\n", allocation_p->width, allocation_p->height);

    rfm_set_allocation();
    return TRUE;
}

static void
signal_on_size_window(GtkWidget *widget, GdkRectangle *allocation, void *data){
    NOOP(stderr, "size-allocate (window): w=%d, h=%d\n", allocation->width, allocation->height);
return;
// FIXME ...
// This needs to address i3 window size changes...
#if 0
    view_t *view_p = data;
    on_size(NULL, allocation, data);
    
	g_free(view_p->eyecandy.desktop_bg_file);
	view_p->eyecandy.desktop_bg_file = NULL;
       record_entry_t *en = NULL;
       if (!view_p->module && view_p->desktop_dir) {
         en = rfm_stat_entry(view_p->desktop_dir, (view_p->en)?view_p->en->type:0);
       }
	 
	 if (rodent_refresh(&(view_p->widgets), en)) {
	     TRACE( "rodent desk-monitor hard refresh done!\n");
	     // reload did not fail 
	     g_free (view_p->desktop_dir);
	     view_p->desktop_dir = g_strdup (getenv ("RFM_DESKTOP_DIR"));
	 } else {
	     TRACE( "desk-monitor reload failed!\n");
	     //reload failed 
	     //so we will try again in next timeout
	     rfm_destroy_entry(en);
	 }
#endif
#if 0
	record_entry_t *en = rfm_copy_entry (view_p->en);
	if (!rodent_refresh (widgets_p, en)){ rfm_destroy_entry(en); }
	return NULL;	
#endif
}

static void
child_constructor ( widgets_t * widgets_p, gchar *in_path) {
    rodent_new_gridview(widgets_p, in_path);
}

static void 
recreate_bg_surface(view_t *view_p, const gchar *desktop_bg_file){
	// Eliminate old surface, if any.
	if (view_p->eyecandy.bg_surface){
	    cairo_surface_destroy(view_p->eyecandy.bg_surface);
	    view_p->eyecandy.bg_surface = NULL;
	    g_free(view_p->eyecandy.desktop_bg_file);
	    view_p->eyecandy.desktop_bg_file = NULL;
	}
	if (!desktop_bg_file || !g_file_test(desktop_bg_file, G_FILE_TEST_EXISTS)){
	    return;
	}
	g_free(view_p->eyecandy.desktop_bg_file);
	view_p->eyecandy.desktop_bg_file = g_strdup(desktop_bg_file);

	GtkAllocation allocation;
	gtk_widget_get_allocation(view_p->widgets.paper, &allocation);
	GdkPixbuf *pixbuf = 
		rfm_create_background_pixbuf (desktop_bg_file, 
			allocation.width, allocation.height);

	// Create new surface
	if (pixbuf){
	    gdouble x = allocation.width - gdk_pixbuf_get_width(pixbuf);
	    gdouble y = allocation.height - gdk_pixbuf_get_height(pixbuf);
	    if (x < 0) x = 0.0; else x /= 2.0;
	    if (y < 0) y = 0.0; else y /= 2.0;
	    cairo_t *gdk_context =  
		    gdk_cairo_create(gtk_widget_get_window(view_p->widgets.paper));
	    //view_p->eyecandy.bg_surface = get_view_surface(view_p, gdk_context);
	    cairo_reference(gdk_context);
	    cairo_surface_t *surface = cairo_surface_create_similar(
		    cairo_get_target(gdk_context),
		    CAIRO_CONTENT_COLOR_ALPHA, 
		    allocation.width, allocation.height);    
	    cairo_surface_reference(surface);
	    cairo_destroy(gdk_context);
	    gdk_context=cairo_create(surface);
	    cairo_reference(gdk_context);
	    // Render pixbuf into surface.
	    // Clean rectangle here should paint in background color if
	    // surface is set to NULL.
	    rodent_clean_rectangle (view_p, 0, 0, allocation.width, allocation.height,
		gdk_context);
	    gdk_cairo_set_source_pixbuf(gdk_context, pixbuf, x,y);
            cairo_paint (gdk_context); 

	    view_p->eyecandy.bg_surface = surface;
	    cairo_destroy(gdk_context);
	    if (view_p->bg_pixbuf) g_object_unref(view_p->bg_pixbuf);
	    view_p->bg_pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE, 8, 
		    allocation.width, allocation.height );
	    cairo_t *p_cr = pixbuf_cairo_create( view_p->bg_pixbuf);
	    cairo_set_source_surface (p_cr, surface, 0, 0);
            cairo_paint (p_cr); 
	    pixbuf_cairo_destroy(p_cr, view_p->bg_pixbuf);
     
	    g_object_unref(pixbuf);


	} else if (view_p->eyecandy.desktop_bg_file) {
	    DBG("cannot create pixbuf from %s \n", view_p->eyecandy.desktop_bg_file);
	}
}
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=10
static gboolean
signal_on_draw_vport (
    GtkWidget * widget,
    cairo_t *cr,
    gpointer data
) {
    view_t *view_p = data;
    widgets_t *widgets_p = &(view_p->widgets);

    cairo_t *gdk_context = gdk_cairo_create(gtk_widget_get_window(widgets_p->paper));    
    rodent_draw(widget, gdk_context, data);
    cairo_destroy(gdk_context);
    
   return FALSE;
}
static gboolean
signal_on_draw_paper (
    GtkWidget * widget,
    cairo_t *cr,
    gpointer data
) {
    return FALSE;
}

#endif

static gchar *desktop_color = NULL;
static gchar *desktop_bg_file = NULL;
static gdouble margins[4]={0,0,0,0};

// Deskview_monitor:
static  void *
watch_preferences_f (view_t *view_p) {
   //return NULL;
    rfm_global_t *rfm_global_p = rfm_global();
    static gint old_w=-1;
    static gint old_h=-1;

    gint width, height;
    rfm_get_drawable_geometry (rfm_global_p->root_Xwindow, NULL, NULL, 
	    &width, &height, NULL);
    if (old_w < 0 || old_h < 0){
        old_w = width;
        old_h = height;
    } else if (old_w != width || old_h != height){
        // FIXME: this needs to work differently in i3wm...
        execvp(rfm_global_p->argv[0], rfm_global_p->argv);
        _exit(123);
    }

    NOOP(stderr, "root_w=%d, root:h=%d\n",  width, height);
    NOOP(stderr, "watch_preferences_f... RFM_DESKTOP_DIR =%s, was %s (desktop_dir)\n", getenv ("RFM_DESKTOP_DIR"), view_p->desktop_dir);
#if 0
    time_t time_v = time(NULL);
    gchar *at = g_strdup(ctime(&time_v));
    if (strchr(at, '\n')) *strchr(at, '\n')=0;
    static gint m_c=0;
    struct rusage usage;
    static long last_rss=0;
    if (getrusage(RUSAGE_SELF, &usage)<0);
    ++m_c;
    if (last_rss != usage.ru_maxrss){
        TRACE ("watch_root() [%d-%s]: RSS changes %ld --> %ld  +%ld\n",
	    m_c,  at,
	    last_rss, usage.ru_maxrss, usage.ru_maxrss-last_rss);
	last_rss = usage.ru_maxrss;
    }
    g_free(at);
#endif

    widgets_t *widgets_p = &(view_p->widgets);
    g_mutex_lock(view_p->mutexes.status_mutex);
    gboolean status = view_p->flags.status;
    g_mutex_unlock(view_p->mutexes.status_mutex);
    if (status == STATUS_EXIT) return NULL;


    // thread safe:
    rodent_icontheme_test();
    
    // This is thread safe. An expose signal may be generated,
    // but the signal is done in a thread.
    //rfm_view_thread_create (NULL, rodent_bookmark_monitor, view_p, "rodent_bookmark_monitor");
    //rodent_bookmark_monitor(view_p);
    rfm_threadqueue_push(rfm_global_p->thread_queue, BOOKMARK_MONITOR, view_p, NULL);
    

    if(getenv ("RFM_ENABLE_DESKTOP_DIAGNOSTICS") && 
	    strlen (getenv ("RFM_ENABLE_DESKTOP_DIAGNOSTICS"))) {
	if (view_p->widgets.diagnostics_window == NULL) {
	    rfm_create_diagnostics_window (widgets_p);
	} else if (view_p->widgets.diagnostics_window) {
	    gtk_widget_show_all((view_p->widgets.diagnostics_window));
	}
    } else if (view_p->widgets.diagnostics_window){
        gtk_widget_hide((view_p->widgets.diagnostics_window));
    }

    gboolean reload = FALSE;
    gboolean regen_background = FALSE;
        
    // Watch out for changes in server window size
    // (non-i3)
    gint root_w;
    gint root_h;
    rfm_layout_get_root_parameters(view_p, &root_w, &root_h, NULL);
    rfm_layout_set_root_parameters(view_p);
    gint root_w2;
    gint root_h2;
    rfm_layout_get_root_parameters(view_p, &root_w2, &root_h2, NULL);
    
    rfm_get_drawable_geometry (rfm_global_p->root_Xwindow, 
	    NULL, NULL, &root_w, &root_h, NULL);
    if (root_w != root_w2 || root_h != root_h2) {
	TRACE( "Root window has been reconfigured...\n");
	gtk_window_resize (GTK_WINDOW(rfm_global_p->window), root_w2, root_h2);
	g_free(view_p->eyecandy.desktop_bg_file);
	view_p->eyecandy.desktop_bg_file = NULL;
	reload=TRUE;
#if 0
	record_entry_t *en = rfm_copy_entry (view_p->en);
	if (!rodent_refresh (widgets_p, en)){ rfm_destroy_entry(en); }
	return NULL;	
#endif
    }

    gint i;
    environ_t *environ_v = rfm_get_environ();
    for (i = RFM_DESKTOP_TOP_MARGIN; i <= RFM_DESKTOP_LEFT_MARGIN; i++){
      gdouble value;
      if (getenv(environ_v[i].env_var) && strlen(getenv(environ_v[i].env_var)))
      {
	value = atof(getenv(environ_v[i].env_var));
      } else {
	  value=margins[i-RFM_DESKTOP_TOP_MARGIN];
      }
      if (value != margins[i-RFM_DESKTOP_TOP_MARGIN]){
	TRACE( "Reload on Margin changed: %s = %lf\n", environ_v[i].env_var, value);
	margins[i-RFM_DESKTOP_TOP_MARGIN]=value;
	switch (i){
	    case RFM_DESKTOP_TOP_MARGIN:
		rfm_layout_set_margin_top(view_p, value);
		break;
	    case RFM_DESKTOP_BOTTOM_MARGIN:
		rfm_layout_set_margin_bottom(view_p, value);
		break;
	    case RFM_DESKTOP_RIGHT_MARGIN:
		rfm_layout_set_margin_right(view_p , value);
		break;
	    case RFM_DESKTOP_LEFT_MARGIN:
		rfm_layout_set_margin_left(view_p, value);
		break;
	}
	reload = TRUE;
	//record_entry_t *en = rfm_copy_entry (view_p->en);
	//if (!rodent_refresh (widgets_p, en)){ rfm_destroy_entry(en); }
	//return NULL;
      }
    }
    /* this is necesary when wm is twm... maybe others as well (xmingw), 
     * but will dunk under nautilus desktop if running... */
    //XLowerWindow(GDK_DISPLAY(),GDK_WINDOW_XID(((GtkWidget *)rfm_global_p->window)->window));

    if(getenv ("RFM_NAVIGATE_DESKTOP")
       && strlen (getenv ("RFM_NAVIGATE_DESKTOP"))) {
        view_p->child_constructor = NULL;
    } else {
        view_p->child_constructor = child_constructor;
    }




    if(getenv ("RFM_DESKTOP_COLOR") && strlen (getenv ("RFM_DESKTOP_COLOR"))) {
        if(!desktop_color || strcmp (desktop_color, getenv ("RFM_DESKTOP_COLOR"))) {
            NOOP(stderr, "DESK: watch_root now reloading RFM_DESKTOP_COLOR %s\n", getenv ("RFM_DESKTOP_COLOR"));
            g_free (desktop_color);
            desktop_color = g_strdup (getenv ("RFM_DESKTOP_COLOR"));
	    if (getenv ("RFM_DESKTOP_IMAGE") && 
		    strlen (getenv ("RFM_DESKTOP_IMAGE"))) {
		g_free (desktop_bg_file);
		desktop_bg_file = g_strdup (getenv ("RFM_DESKTOP_IMAGE"));
		recreate_bg_surface(view_p, desktop_bg_file);
	    }
            regen_background = TRUE;
        }
    }
    if(getenv ("RFM_DESKTOP_IMAGE") && strlen (getenv ("RFM_DESKTOP_IMAGE"))) {
        if(!desktop_bg_file || strcmp (desktop_bg_file, getenv ("RFM_DESKTOP_IMAGE"))) {
            NOOP ("DESK: watch_root got RFM_DESKTOP_IMAGE=%s\n", getenv ("RFM_DESKTOP_IMAGE"));
            g_free (desktop_bg_file);
            desktop_bg_file = g_strdup (getenv ("RFM_DESKTOP_IMAGE"));
	    recreate_bg_surface(view_p, desktop_bg_file);
            regen_background = TRUE;
        }
    } else if (desktop_bg_file != NULL) {
	g_free(desktop_bg_file);
	desktop_bg_file=NULL;
	    recreate_bg_surface(view_p, desktop_bg_file);
            regen_background = TRUE;
    }

#if 10
 	static gint first = TRUE;
	if (first){
	    first = FALSE;
	    record_entry_t *en = rfm_copy_entry(view_p->en);
	    rodent_full_reload_view (view_p, en);
	    return NULL;
	}
#endif

#if 10
    if(getenv ("RFM_DESKTOP_DIR") && strlen (getenv ("RFM_DESKTOP_DIR"))) {
	if (!view_p->desktop_dir || strcmp(getenv ("RFM_DESKTOP_DIR"), view_p->desktop_dir))
	{
	    TRACE( "Reload on change of RFM_DESKTOP_DIR\n");
	    g_free(view_p->desktop_dir);
	    view_p->desktop_dir = g_strdup(getenv ("RFM_DESKTOP_DIR"));
	    reload=TRUE;
	}
    }
#endif


    if(getenv ("RFM_PASTEBOARD_SERIAL") && strlen (getenv ("RFM_PASTEBOARD_SERIAL"))) {
	//NOOP("got pasteboard serial=%s\n",getenv ("RFM_PASTEBOARD_SERIAL"));
	errno = 0;
	long value = strtol (getenv ("RFM_PASTEBOARD_SERIAL"), NULL, 0);
	if(errno != 0 || value != view_p->flags.pasteboard_serial) {
	    view_p->flags.pasteboard_serial = value;
	    // thread safe...
	    rfm_update_pasteboard (view_p);
	    // This is thread safe. An expose signal may be generated, 
	    // but the signal is done in its own thread.
	    rodent_update_cut_icons (view_p);
	}
    }

    if(!reload && regen_background) {
	NOOP(stderr, "REload on regen_background\n");
        // just an expose is necesary.
	rodent_expose_all(view_p);
    }



    if(reload) {
	    
       NOOP(stderr, "refresh... RFM_DESKTOP_DIR =%s, was %s (desktop_dir)\n", getenv ("RFM_DESKTOP_DIR"), view_p->desktop_dir);
	/*    
	 *    this is a hard reload: directory has changed!.
	 *    */
       record_entry_t *en = NULL;
       if (!view_p->module && view_p->desktop_dir) {
         en = rfm_stat_entry(view_p->desktop_dir, (view_p->en)?view_p->en->type:0);
       }
	 
	 if (rodent_refresh(&(view_p->widgets), en)) {
	     TRACE( "rodent desk-monitor hard refresh done!\n");
	     // reload did not fail 
	     g_free (view_p->desktop_dir);
	     view_p->desktop_dir = g_strdup (getenv ("RFM_DESKTOP_DIR"));
	 } else {
	     TRACE( "desk-monitor reload failed!\n");
	     //reload failed 
	     //so we will try again in next timeout
	     rfm_destroy_entry(en);
	 }
	NOOP ("DESK: watch_root RFM_DESKTOP_DIR returns\n");


    }
    return NULL;

}


// Deskview_monitor:
static gboolean
watch_root ( gpointer data) {

    rfm_global_t *rfm_global_p = rfm_global();
    if (!rfm_rw_lock_reader_trylock (&(rfm_global_p->setup_lock))){
	TRACE("watch_root: setup_lock not available yet...\n");
	return TRUE;
    }
    rfm_rw_lock_reader_unlock (&(rfm_global_p->setup_lock));
    g_mutex_lock(rfm_global_p->status_mutex);
    gint status = rfm_global_p->status;
    g_mutex_unlock(rfm_global_p->status_mutex);
    g_cond_signal(rfm_global_p->janitor_signal);
    if (status == STATUS_EXIT) return FALSE;
    watch_preferences_f (data);
    //rfm_threadqueue_push(rfm_global_p->thread_queue, WATCH_PREFERENCES, data, NULL);
    return TRUE;
}

static gboolean
signal_on_leave (GtkWidget * widget, GdkEventCrossing * event, gpointer data) {
    NOOP ("signal_on_leave...\n");
    rodent_on_leave(data);
    return FALSE;
}

