/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */



#define GRIDVIEW_C

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE 

view_t *create_iconview (record_entry_t * en, GtkWidget *window);
static view_t *create_view (GtkWidget *window, gchar **argv, gint argc);

/* private symbols */
static gboolean lp_is_key(GdkEventKey * event);
static gboolean lp_get_active(widgets_t *widgets_p);
static void lp_set_active(widgets_t *widgets_p, gboolean state);
static void status_grab_focus (view_t * view_p, int keyval);
static gchar *get_current_text (GtkTextView * textview);
static view_t *create_notebook_page (GtkWidget * window, record_entry_t * en);

//#define TESTING

#include "gridview-keybindings.i"
#include "gridview-callbacks.i"
#include "gridview-lpterm.i"
#include "gridview-notebook.i"



static 
view_t *
load(GtkWidget * window, record_entry_t *en){
    NOOP("en=0x%x\n", GPOINTER_TO_INT(en));

    view_t *view_p = create_iconview (en, window);
    
    if(en){
        view_p->module = en->module;
    }
    NOOP ("module=%s", view_p->module);
    view_preferences_t *view_preferences_p = 
	rfm_get_view_preferences (view_p->flags.type, en);
    rfm_set_view_preferences (view_p, view_preferences_p);
    g_free(view_preferences_p);
    TRACE( "load() calling rodent_full_reload_view\n");
#ifndef TESTING
    rodent_full_reload_view (view_p, en);
#endif
    return view_p;
}



/* public symbols (listed in gridview_lib.h) */
static view_t *
create_view ( GtkWidget * window, gchar **argv, gint argc) {

    view_t *view_p = NULL;
    gint type =  __ROOT_TYPE;
    record_entry_t *en = NULL;
    gchar *exec = g_path_get_basename (argv[0]);
    gint i;

#ifdef DEBUG_TRACE
    TRACE ("create_gridview(): exec is %s, argc=%d\n",exec,argc);
    for (i=0;i<argc; i++){
	TRACE("%d: %s\n", i, argv[i]);
    }
#endif

    if(exec && strcmp (exec, "rodent-plug")==0) {
        const gchar *module_name = argv[1];
	if (!argv[1] || !strlen(argv[1])){
	    g_warning("%s must specify plugin to load\n", exec);
	    exit(1);
	}
        if (!rfm_void(PLUGIN_DIR, module_name, "module_active")){
            g_warning("Module %s is not active\n", module_name);
            exit(1);
        }
        en = rfm_mk_entry (type);
        en->module = rfm_void (PLUGIN_DIR, module_name, "module_name");
	en->path = rfm_void (PLUGIN_DIR, en->module, "module_label");
	if (argv[2] != NULL){
	    // Allow modules to specify internals on the command line.
	    NOOP("argv[1]=%s\n", argv[1]);
	    rfm_rational(PLUGIN_DIR, en->module, en, 
		    argv, "module_argv");
	} 
	view_p = load(window, en);
        g_free(exec);
	return view_p;
    }

    if (argc == 1 && exec && strcmp (exec, "rodent-fm")==0) {
        en = rfm_stat_entry (g_get_home_dir(), 0);
    }

    else if(argc >= 2  ) {
	NOOP("argv[1]=%s \n",argv[1]);
        if(rfm_g_file_test (argv[1], G_FILE_TEST_IS_DIR)) {
	    // strip trailing slash (hack)
	    if (strlen(argv[1]) > 1 && 
		argv[1][strlen(argv[1])-1]=='/'){
		argv[1][strlen(argv[1])-1]=0;
	    }
	    en = rfm_stat_entry (argv[1], 0);
	} else { 
	    // specified directory does not exist.
	    if (exec && strcmp (exec, "rodent")==0){ // rodent defaults plugin root
		TRACE ("Rodent defaults to plugin root\n");
	    } else if (exec && strcmp (exec, "rodent-fm")==0){ 
                // rodent-fm, defaults to homedir
		gchar *wd = g_get_current_dir ();
		gchar *path = g_build_filename (wd, argv[1], NULL);
		g_free (wd);
		if(!rfm_g_file_test (path, G_FILE_TEST_IS_DIR)) {
		    NOOP (stderr, _("%s does not exist."), path);
		    NOOP (stderr, "\n");
		    en = rfm_stat_entry (g_get_home_dir(), 0);
		} else {
		    en = rfm_stat_entry (path, 0);
		}
		g_free (path);
	    } else {
                g_warning("symlink %s is deprecated. Please remove it.\n",exec);
                exit(1);
            }
	} 
    }

    g_free (exec);
    NOOP(stderr, "loading...\n");
  

    view_p=load(window, en);
    // This is a hack to get text buffer online.
    rfm_diagnostics(&(view_p->widgets),"rodent", "This is Rodent-",VERSION,"\n", NULL);

    // create extra tabs (if applicable)
    //
    if (view_p && argc > 2) {
	for (i=2; i<argc; i++){
	    NOOP("tab for %s\n",argv[i]);
	    if (rfm_g_file_test(argv[i], G_FILE_TEST_EXISTS)){
		record_entry_t *new_en=rfm_stat_entry(argv[i], 0);
		new_en->path=g_strdup(argv[i]);
		view_count++;
		view_t *v_p = create_notebook_page (window, new_en);

		view_preferences_t *view_preferences_p = 
		    rfm_get_view_preferences (v_p->flags.type, en);
		rfm_set_view_preferences (v_p, view_preferences_p);
		g_free(view_preferences_p);
    
		TRACE( "create_gridview() calling rodent_full_reload_view\n");

		rodent_full_reload_view (v_p, new_en);
	    }
	}
    }
    NOOP(stderr, "load done...\n");
    
    return view_p;
}

GtkWidget *
create_gridview ( void) {
    rfm_global_t *rfm_global_p = rfm_global();
    rfm_global_p->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    GtkWidget *window = rfm_global_p->window;
    gtk_widget_set_has_tooltip (window, TRUE);

    rfm_global_p->thread_queue = rfm_thread_queue_new(rodent_queue_f, NULL, 1);
#if 0
    // Test code for dual view: does not work, yet...
    GtkWidget *hpane = rfm_hpaned_new();
    GtkWidget *right = rfm_vbox_new(FALSE, 0);
    GtkWidget *left = rfm_vbox_new(FALSE, 0);

    gtk_paned_add1 (GTK_PANED(hpane), left);
    gtk_paned_add2 (GTK_PANED(hpane), right);
    gtk_widget_show(hpane);
    gtk_widget_show(left);
    gtk_widget_show(right);
    g_object_set_data(G_OBJECT(window), "right", right);
    g_object_set_data(G_OBJECT(window), "left", left);
    g_object_set_data(G_OBJECT(window), "hpane", hpane);
    gtk_paned_set_position (GTK_PANED (hpane), 400);
    
#endif

    view_t *view_p = create_view(window, rfm_global_p->argv, rfm_global_p->argc);

    g_signal_connect (G_OBJECT (window), "query-tooltip", G_CALLBACK (rodent_tip_function), NULL);
    g_signal_connect (G_OBJECT (window), "destroy_event", G_CALLBACK (signal_destroy_event), NULL);
    g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (signal_destroy_event), NULL);
    /* pointer events */
    g_signal_connect (G_OBJECT (window), "configure-event", G_CALLBACK (signal_on_configure_window), NULL);

    /* set minimum window size: */
    gtk_widget_set_size_request ((GtkWidget *) window, 1.3 * SMALL_ICON_SIZE, 1.5 * SMALL_ICON_SIZE);

    gtk_widget_grab_focus (view_p->widgets.paper);
    view_geometry_t *iconview_geometry_p = rodent_get_view_geometry_p (view_p);
    if(iconview_geometry_p) {
        gtk_window_set_default_size ((GtkWindow *) window, iconview_geometry_p->w, iconview_geometry_p->h);
        NOOP ("window... default size=%d,%d\n", iconview_geometry_p->w, iconview_geometry_p->h);
	g_free(iconview_geometry_p);
    } else {
        gtk_window_set_default_size ((GtkWindow *) window, DEFAULT_WIDTH, DEFAULT_HEIGHT);
        NOOP ("window... default size=%d,%d\n", DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }
    gtk_window_set_resizable ((GtkWindow *) window, TRUE);
    gtk_widget_realize (window);
    gtk_widget_show (window);
    g_timeout_add_seconds (1, watch_preferences, window);

    NOOP ("POP_SEM:  sem_init(&(view_p->population_sem),0,1)\n");
    gdk_flush();
#ifndef TESTING
    // fireoff popup creation thread here.
    rodent_create_popup_bythread();
#endif
    return (window);
}


#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<20
 // Not available with gtk+ < 2.20
#else
static void
add_toolbar_button(GtkWindow *window, RodentButtonDefinition *callback_p){
    GtkBox *bb;
    if (g_object_get_data(G_OBJECT(window), "vertical_toolbar")){
        bb = g_object_get_data(G_OBJECT(window), "tb_box");
    } else {
        bb = g_object_get_data(G_OBJECT(window), "tbh_box");
    }

    rfm_global_t *rfm_global_p = rfm_global();
    if (BUTTON_OVERFLOW_ID >= 64){
	g_error ("add_toolbar_button(): too many bit flags\n");
    }
    gint64 toolbar_preferences = DEFAULT_TOOLBAR_BUTTONS;
    const gchar *rfm_toolbar_s = getenv("RFM_TOOLBAR");
    if (rfm_toolbar_s && strlen(rfm_toolbar_s)){
	errno = 0;
	toolbar_preferences = strtoll(rfm_toolbar_s, NULL, 16);
	if (errno){
	    DBG("t_callback(): %s\n", strerror(errno));
	    toolbar_preferences = DEFAULT_TOOLBAR_BUTTONS;
	}
    }
    GtkWidget *button = gtk_toggle_button_new ();
    if (callback_p->button_name && strlen(callback_p->button_name)) {
	g_object_set_data(G_OBJECT(rfm_global_p->window), callback_p->button_name, button);
    }
    GdkPixbuf *pb = NULL;
    if (callback_p->callback.icon) {
	pb = rfm_get_pixbuf (callback_p->callback.icon, 12);
	GtkWidget *image = gtk_image_new_from_pixbuf (pb);
	g_object_unref(pb);
	gtk_widget_show (image);
	gtk_container_add (GTK_CONTAINER (button), image);
    } else if (callback_p->text) {
	GtkWidget *label = gtk_label_new("");
	gchar *markup = g_strdup_printf("<span  foreground=\"black\" background=\"white\" size=\"xx-small\">%s</span>", _(callback_p->text));
	gtk_label_set_markup(GTK_LABEL(label), markup);
	g_free(markup);
	gtk_widget_show (label);
	gtk_container_add (GTK_CONTAINER (button), label);
    }

    rfm_add_custom_tooltip(button, pb, _(callback_p->callback.string));

    g_object_set (button, "can-focus", FALSE, "relief", GTK_RELIEF_NONE, NULL);
    if (toolbar_preferences &(ONE64<<callback_p->id)) gtk_widget_show (button);
    g_signal_connect (G_OBJECT (button), "button-release-event", G_CALLBACK (button_callback), GINT_TO_POINTER(callback_p->callback.function_id));
    gtk_box_pack_start (bb, button, FALSE, FALSE, 0);
  
}
#endif

view_t *
create_iconview ( record_entry_t * en, GtkWidget *window) {
    //test_pango();
    NOOP (">> create_iconview\n");
     
    GtkWidget *main_hbox = rfm_hbox_new (FALSE, 0);
    GtkWidget *right = g_object_get_data(G_OBJECT(window), "right");
    GtkWidget *left = g_object_get_data(G_OBJECT(window), "left");
    GtkWidget *hpane = g_object_get_data(G_OBJECT(window), "hpane");
    if (hpane && right) {
        gtk_container_add (GTK_CONTAINER (window), hpane);
        gtk_box_pack_start (GTK_BOX (right), main_hbox, TRUE, TRUE, 0);
        GtkWidget *test = gtk_label_new("test left...");
        gtk_widget_show(test);
        gtk_container_add (GTK_CONTAINER (left), test);

    } else {
        gtk_container_add (GTK_CONTAINER (window), main_hbox);
    }
    GtkWidget *vbox1 = rfm_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_hbox), vbox1, TRUE, TRUE, 0);
    GtkWidget *tb_box = rfm_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_hbox), tb_box, FALSE, FALSE, 0);
    g_object_set_data(G_OBJECT(window), "tb_box", tb_box);
    gtk_widget_show(tb_box);
    gtk_widget_show(main_hbox);

// NOTEBOOK creation
    GtkWidget *notebook = gtk_notebook_new ();
    g_object_set_data(G_OBJECT(window), "notebook", notebook);
    //   gtk_notebook_set_tab_pos ((GtkNotebook *)notebook, GTK_POS_BOTTOM);
    gtk_notebook_popup_disable ((GtkNotebook *) notebook);
    gtk_notebook_set_scrollable ((GtkNotebook *) notebook, TRUE);
    g_object_set (notebook,
                  //"enable-popup", TRUE, 
                  "can-focus", FALSE,
                  "scrollable", TRUE, 
                 // "homogeneous", FALSE, 
                  "show-border", FALSE,
                  "show-tabs", 
                  TRUE, "tab-pos",
                  GTK_POS_TOP, NULL);

    //   g_object_set (notebook,  "show-tabs", FALSE, NULL);
    //   g_object_set (notebook,  "homogeneous", TRUE, NULL); 
    //   "tab-label"

    gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);
    gtk_widget_show (vbox1);
    gtk_widget_show (notebook);
// end NOTEBOOK creation
//
// add contents to notebook page
//
    view_t *view_p = create_notebook_page (window, en);
    
    rfm_set_widget(&(view_p->widgets), "widgets_p");
    g_signal_connect (notebook, "switch-page", G_CALLBACK (switch_page), window);

    if(getenv ("RFM_TRANSPARENCY") && strlen (getenv ("RFM_TRANSPARENCY"))) {
        errno = 0;
        double value = strtod (getenv ("RFM_TRANSPARENCY"), NULL);
        if(errno != 0 || value < 0.0) {
            value = 0.0;
        } else if(value > 0.75)
            value = 0.75;
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=8
	gtk_widget_set_opacity (GTK_WIDGET(window), 1.00 - value);
#else
	gtk_window_set_opacity (GTK_WINDOW(window), 1.00 - value);
#endif
    }

// NOTEBOOK toolbar buttons
//
//
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<20
#else
    GtkWidget *tbh_box = rfm_hbox_new (FALSE, 0);
    gtk_notebook_set_action_widget (GTK_NOTEBOOK (notebook), tbh_box, GTK_PACK_END);
    gtk_widget_show(tbh_box);
    g_object_set_data(G_OBJECT(window), "tbh_box", tbh_box);

    const gchar *vbar = getenv("RFM_VERTICAL_TOOLBAR");
    if (vbar && strlen(vbar)){
        g_object_set_data(G_OBJECT(window), "vertical_toolbar", window);
    }
    GSList *list = NULL;
    RodentButtonDefinition *callback_p = rodent_get_button_definitions();
    for (; callback_p && callback_p->id >= 0; callback_p++){
        if (g_object_get_data(G_OBJECT(window), "vertical_toolbar")) {
            list = g_slist_prepend(list, callback_p);
        } else {
            list = g_slist_append(list, callback_p);
        }
    }

    GSList *l = list;
    for (; l && l->data; l = l->next){
        add_toolbar_button(GTK_WINDOW(window), (RodentButtonDefinition *)(l->data));
    }
    g_slist_free(list);
#endif    

// NOTEBOOK end
    g_signal_connect (G_OBJECT (window), "key-press-event", G_CALLBACK (signal_keyboard_event), NULL);
    g_signal_connect(G_OBJECT(window), "size-allocate", G_CALLBACK(signal_on_size_window), view_p); 

    return view_p;
}
