# RPM spec file for SUSE OpenSUSE created by configure script.
Summary: Advanced user file manager for Linux and BSD systems	
Name: rodent-fm
Version: 5.3.16.3
Release: 1
License: GPL-3.0
URL: http://xffm.org/rodent-fm.html
Source0: %{name}-%{version}.tar.gz
Group: System/GUI/Other 
BuildRoot: %{_tmppath}/%{name}-root
Requires: librfm5 >= 5.3.16.3
Conflicts: rodent
BuildRequires: librfm5-devel >= 5.3.16.3
BuildRequires: fdupes
BuildRequires: update-desktop-files

%changelog
* Fri Nov 22 2013  <edscott@users.sf.net> 5.3.16.3-1
- RPM release


%description
Rodent is fast, small and powerful parallel file manager. All operations are
done in threads, and command are inherited from the GNU or BSD operating
systems to reduce the possibility of bugs to a minimum.

%prep
%setup -q

%build
%configure
make -j4
strip -s Build/modules/.libs/libgridview.so
strip -s Build/modules/.libs/libdeskview.so
strip -s Build/bin/rodent-root
strip -s Build/bin/rodent-anim
strip -s Build/bin/rodent

%clean
rm -rf $RPM_BUILD_ROOT
%if 0%{?suse_version} >= 1140
%post
%desktop_database_post
%endif

%if 0%{?suse_version} >= 1140
%postun
%desktop_database_postun
%endif


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT mandir=%{_mandir}
%if 0%{?suse_version} >= 1140
# create hardlinks for binaries
%fdupes %buildroot/%_bindir
%fdupes %buildroot/%_datadir
%fdupes %buildroot/%_mandir
%endif
rm -rf  %buildroot/%_libdir/rfm/modules/*.la



%find_lang %{name}

%files  -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README 
%{_mandir}/man1/rodent.1.gz
%{_mandir}/man1/rodent-fm.1.gz
%{_mandir}/man1/rodent-desk.1.gz
%{_mandir}/man1/rodent-getpass.1.gz
%{_mandir}/man1/rodent-plug.1.gz
%{_mandir}/man1/rodent-anim.1.gz
%{_mandir}/man1/rodent-root.1.gz
%{_datadir}/doc/rodent/RTFM.pdf
%{_datadir}/icons/rfm/48x48/apps/rodent.png
%{_datadir}/icons/rfm/48x48/apps/rodent-root.png
%{_datadir}/icons/rfm/animated/rodent-160.gif
%{_datadir}/icons/rfm/animated/rodent-96.gif
%{_datadir}/icons/rfm/animated/rodent_animate_logo.gif
%{_datadir}/icons/hicolor/scalable/apps/rodent.svg
# symlinks 
%{_datadir}/pixmaps/rodent.svg

%{_bindir}/rodent
%{_bindir}/rodent-root
%{_bindir}/rodent-anim

%{_bindir}/rodent-fm
%{_bindir}/rodent-desk
%{_bindir}/rodent-plug
%{_bindir}/rodent-getpass

%{_datadir}/applications/Rodent.desktop
%{_datadir}/applications/Rodent-root.desktop

%{_datadir}/appdata/Rodent.appdata.xml
%{_libdir}/rfm/modules/libgridview.so
%{_libdir}/rfm/modules/libdeskview.so




