#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
// ecryptfs submodule option dialog window.
/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
/////////////////////////////////////////////////////////////////////////////////////
void *
mount_url (widgets_t *widgets_p, const gchar *url);
static void
save_extra_option(GtkWidget *dialog, const gchar *url,
	const gchar *option_id, gchar *extra_option_id){ 
    gchar *entry_id = g_strconcat(option_id, "Entry", NULL);
    GtkWidget *entry;
    GtkToggleButton *button = g_object_get_data(G_OBJECT(dialog), option_id);
    if (gtk_toggle_button_get_active(button)){
	// override last set value
	entry = g_object_get_data(G_OBJECT(dialog), entry_id);
    } else {
	entry = g_object_get_data(G_OBJECT(dialog), extra_option_id);
    }
    const gchar *c = gtk_entry_get_text (GTK_ENTRY(entry));
    if (c && strlen(c)){
	  group_options_set_key_value (url, extra_option_id, (gchar *)c);
    }
    return;
}

gchar *
accept (fuse_data_t *fuse_data_p, const gchar *url){
    // url is the keyfile group
    fuse_data_p->url = url;
    fuse_data_p->computer = "";
    GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FUSE_MOUNT_POINT");
    const gchar *c =  gtk_entry_get_text (GTK_ENTRY(entry));
    if (!c || strlen(c)==0) {
	GtkWidget *entry2 = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FUSE_REMOTE_PATH");
	c =  gtk_entry_get_text (GTK_ENTRY(entry2));
	if (c) {
	     gtk_entry_set_text (GTK_ENTRY(entry), c);
	}
    }
    if (!fuse_get_login_info (fuse_data_p)) return NULL;
    // FLAG_0 is done.

    // FLAG_1: fuse options.    
    // FLAG_2: module options
    // FLAG_3:
    // FLAG_4: ftp options (submodule specific)
    // FLAG_5: curlftpfs options (submodule specific)
    //
    // FLAG_6: mount options 
    fuse_data_p->flag_id = 6;
    fuse_data_p->options_p = mount_options;
    fuse_data_p->options_keys_p = &mount_option_keys;
    FUSE_set_options(fuse_data_p);   
    // FLAG_12: efs  options 
    fuse_data_p->flag_id = 12;
    fuse_data_p->options_p = efs_options;
    fuse_data_p->options_keys_p = &efs_option_keys;
    FUSE_set_options(fuse_data_p);
    
    gchar *new_url = FUSE_save_keyfile(fuse_data_p);

    save_extra_option(fuse_data_p->dialog, new_url, 
	    "_oecryptfs_sig_", "ECRYPTFS_SIG");
    save_extra_option(fuse_data_p->dialog, new_url, 
	    "_oecryptfs_fnek_sig_", "ECRYPTFS_FNEK_SIG");
    return new_url;
}



static void 
togglebutton_f(GtkToggleButton *togglebutton , gpointer data){
    GtkWidget *dialog = data;
    GtkToggleButton *in_b;
    GtkToggleButton *out_b;
    GtkEntry *out_e;
    gchar *entry_txt;

    in_b = g_object_get_data(G_OBJECT(dialog), "EPS_ENABLE_FILENAME_CRYPTO");
    out_b = g_object_get_data(G_OBJECT(dialog), "_oecryptfs_enable_filename_crypto_");
    out_e = g_object_get_data(G_OBJECT(dialog), "_oecryptfs_enable_filename_crypto_Entry");
    entry_txt = (gtk_toggle_button_get_active(in_b))? "yes": "no";
    gtk_entry_set_text(out_e, entry_txt);
    gtk_toggle_button_set_active(out_b, TRUE);
    // Requires fnek signature:
    out_b = g_object_get_data(G_OBJECT(dialog), "_oecryptfs_fnek_sig_");
    gtk_toggle_button_set_active(out_b, gtk_toggle_button_get_active(in_b));

    in_b = g_object_get_data(G_OBJECT(dialog), "EPS_PASSTHROUGH");
    out_b = g_object_get_data(G_OBJECT(dialog), "_oecryptfs_passthrough_");
    out_e = g_object_get_data(G_OBJECT(dialog), "_oecryptfs_passthrough_Entry");
    entry_txt = (gtk_toggle_button_get_active(in_b))? "yes": "no";
    gtk_entry_set_text(out_e, entry_txt);
    gtk_toggle_button_set_active(out_b, TRUE);

}

static
fuse_data_t *
confirm_efs_host_dialog (const gchar *url) {
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    fuse_data_t *fuse_data_p = (fuse_data_t *)fuse_data_new(NULL);
    if (!fuse_data_p) g_error("cannot allocate fuse_data_p\n");

    fuse_data_p->widgets_p = widgets_p;
    fuse_data_p->url = url;
    fuse_data_p->info1 = EFS_INFO1;
    fuse_data_p->info2 = EFS_INFO2;

    fuse_data_p->dialog = FUSE_init_dialog(fuse_data_p);

    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "fuse_data_p", fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "url_template", "efs");

    GtkWidget *hbox;

    fuse_data_p->item_string = EFS_REMOTE_PATH;
    fuse_data_p->item_id = "FUSE_REMOTE_PATH";
    FUSE_add_entry(fuse_data_p);

    fuse_data_p->item_string = FUSE_MOUNT_POINT;
    fuse_data_p->item_id = "FUSE_MOUNT_POINT";
    hbox = FUSE_add_entry(fuse_data_p);
    gtk_widget_set_sensitive(hbox, TRUE);
    GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog),
	    "FUSE_MOUNT_POINT");
    gtk_widget_set_sensitive(hbox, FALSE);

    fuse_data_p->item_string = ECRYPTFS_SIG;
    fuse_data_p->item_id = "ECRYPTFS_SIG";
    hbox = FUSE_add_entry(fuse_data_p);
    gtk_widget_set_sensitive(hbox, FALSE);

    fuse_data_p->item_string = ECRYPTFS_FNEK_SIG;
    fuse_data_p->item_id = "ECRYPTFS_FNEK_SIG";
    hbox = FUSE_add_entry(fuse_data_p);
    gtk_widget_set_sensitive(hbox, FALSE);

    fuse_data_p->item_string = FUSE_URL;
    fuse_data_p->item_id = "FUSE_URL";
    FUSE_add_entry(fuse_data_p);
    entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FUSE_URL");

    const gchar *url_template = g_object_get_data(G_OBJECT(fuse_data_p->dialog),"url_template");
    gchar *u =g_strconcat(url_template, "://", NULL);
    gtk_entry_set_text(GTK_ENTRY(entry), u);
    g_free(u);
    gtk_widget_set_sensitive(entry, FALSE);
    
    fuse_data_p->extra_text = EPS_REQUIRES_SIGNATURE;
    fuse_data_p->item_string = EPS_ENABLE_FILENAME_CRYPTO;
    fuse_data_p->item_id = "EPS_ENABLE_FILENAME_CRYPTO";
    FUSE_add_check(fuse_data_p);
    
    fuse_data_p->default_state = TRUE;
    fuse_data_p->extra_text = NULL;
    fuse_data_p->item_string = EPS_PASSTHROUGH;
    fuse_data_p->item_id = "EPS_PASSTHROUGH";
    FUSE_add_check(fuse_data_p);
    fuse_data_p->default_state = FALSE;

    fuse_data_p->label = _("Mount");
    fuse_data_p->options_p = mount_options;
    fuse_data_p->flag_id = 6;
    FUSE_add_option_page(fuse_data_p);

    fuse_data_p->label = _("EcryptFS");
    fuse_data_p->options_p = efs_options;
    fuse_data_p->flag_id = 12;
    FUSE_add_option_page(fuse_data_p);
 
    // set some site specific defaults:
    gchar *sig = group_options_get_key_value (url, "ECRYPTFS_SIG");
    if (sig) {
	GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "_oecryptfs_sig_Entry");
	gtk_entry_set_text (GTK_ENTRY(entry),sig);	
    }
    gchar *sig2 = group_options_get_key_value (url, "ECRYPTFS_FNEK_SIG");
    if (sig2 && strlen(sig2)) {
	GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "_oecryptfs_fnek_sig_Entry");
	gtk_entry_set_text (GTK_ENTRY(entry),sig2);	
    } else
    if (sig) {
	GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "_oecryptfs_fnek_sig_Entry");
	gtk_entry_set_text (GTK_ENTRY(entry),sig);	
    } 
    g_free(sig);
    g_free(sig2);

    GtkToggleButton *togglebutton1 = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "EPS_ENABLE_FILENAME_CRYPTO");
    GtkToggleButton *togglebutton2 = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "EPS_PASSTHROUGH");
    g_signal_connect (G_OBJECT(togglebutton1), "toggled", G_CALLBACK (togglebutton_f), 
		fuse_data_p->dialog);
    g_signal_connect (G_OBJECT(togglebutton2), "toggled", G_CALLBACK (togglebutton_f), 
		fuse_data_p->dialog);
    GtkWidget *togglebutton3 = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "_oecryptfs_fnek_sig_");
    gtk_widget_set_sensitive(togglebutton3, FALSE);

    togglebutton_f (NULL, (fuse_data_p->dialog));
    FUSE_reset_url_field(fuse_data_p);
                                                     
    return fuse_data_p;
}

#if 0

static gboolean
confirm_efs_host (const gchar *url) {
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    GCond *signal = fuse_hold_monitor();
    fuse_data_t *fuse_data_p = confirm_efs_host_dialog (url);
    if(!fuse_data_p || !fuse_data_p->dialog){
        return FALSE;
    }
    gint response;
retry:
    response = rfm_dialog_run_response(fuse_data_p->dialog);
    gtk_widget_hide (fuse_data_p->dialog);

    gboolean retval;
    if(response == GTK_RESPONSE_YES || response == GTK_RESPONSE_APPLY){
	gchar *new_url = accept(fuse_data_p, url);
	if (!new_url) {
	    gtk_widget_show (fuse_data_p->dialog);
	    goto retry;
	}
	if(response == GTK_RESPONSE_YES) {
	    mount_url(widgets_p, new_url);
	}
	gtk_widget_destroy (fuse_data_p->dialog);
	view_t *view_p = widgets_p->view_p;
	record_entry_t *t_en = rfm_copy_entry(view_p->en);
	if(!rodent_refresh (widgets_p, t_en)) {
	    rfm_destroy_entry(t_en);
	}
	g_free(new_url);
        retval = TRUE;
    } else {
	gtk_widget_destroy (fuse_data_p->dialog);
        retval = FALSE;
    }
    g_cond_signal(signal);
    return retval;
}
#endif
