#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif

static gchar *emerge=NULL;

static gchar *chop_version(gchar *package){
    gchar *q = g_strdup(package);
//return q;
    gchar *p = strchr(q, '-');
    if (!p) return q;
    while (p && !isdigit(*(p+1))) p = strchr(p+1, '-');
    if (!p) return q;
    *p = 0;
    return q;
}

static GSList *add_emerge_item(GSList *pkg_list, gchar *line){
    if (!strchr(line,'\n')) return pkg_list;
    // fprintf(stderr, "DBG:%s", line);
    *strchr(line,'\n')=0;
    gchar **a = g_strsplit(line, G_DIR_SEPARATOR_S, -1);
    if (!a[5]) {
        g_strfreev(a);
        return pkg_list;
    }

    record_entry_t *en=rfm_mk_entry(0);

    en->path = chop_version(a[5]);
    NOOP("a4=%s, chopped=%s line=%s",a[5], en->path, line);
    
    en->type=0; /* remove local-type attributes */
    SET_LOCAL_TYPE(en->type);
    en->st = (struct stat *)malloc(sizeof(struct stat));
    if (!en->st) g_error("malloc: %s\n", strerror(errno));
    memset(en->st,0,sizeof(struct stat));

    g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n(%s)\n", a[5], a[4]));
    en->module=MODULE_NAME;
    pkg_list=g_slist_prepend(pkg_list,en);
    g_strfreev(a);
    return pkg_list;
}

static GSList *add_emerge_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){
    gchar *tip = NULL;
    if (!strchr(line,'\n')) return pkg_list;
 //   fprintf(stderr, "DBG:%s", line);
//     rfm_threaded_diagnostics(widgets_p,NULL,g_strdup(line));
    *strchr(line,'\n')=0;
    if (*line =='*'){
      /*  if (tip){
            record_entry_t *en = pkg_list->data;
            g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(tip));
            g_free(tip);
            tip = NULL;
        }*/
        gchar *q = line+1;
        while (*q==' ') q++;
        record_entry_t *en=rfm_mk_entry(0);
        en->path = g_strdup(q);
        if (strstr(en->path, " [ Masked ]")) *(strstr(en->path, " [ Masked ]")) = 0;
        en->type=0; /* remove local-type attributes */
        en->st = (struct stat *)malloc(sizeof(struct stat));
        if (!en->st) g_error("malloc: %s\n", strerror(errno));
        memset(en->st,0,sizeof(struct stat));
        en->module=MODULE_NAME;
        pkg_list=g_slist_prepend(pkg_list,en);
        SET_LOCAL_TYPE(en->type);
        g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(en->path));

    } else if (pkg_list && pkg_list->data){
        //the rest is tooltip material
        record_entry_t *en = pkg_list->data;
        if (strstr(line, "[ Not Installed ]")){  
            UNSET_LOCAL_TYPE(en->type);
        }
        tip = g_hash_table_lookup(installed_hash, en->path);
        gchar *new_tip = g_strconcat ((tip)?tip:"", line, "\n", NULL);
        g_hash_table_replace(installed_hash, g_strdup(en->path), new_tip);
    }
    /*if (tip){
        record_entry_t *en = pkg_list->data;
	g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(tip));
        g_free(tip);
    }*/
    return pkg_list;
}
/*
static 
void
emerge_search_option(GtkMenuItem *m, gpointer data){
    NOOP("emerge_search_option: (gchar *)data=%s cmds=%p\n",(gchar *)data, xml_cmds);
    gchar *command = data;
    if (!command) return;
    widgets_t *widgets_p = rfm_get_widget ("widgets_p");
    pkg_command_t *c=xml_cmds;
    
    gint flags = 0;
    for(; c && c->pkg; c++){
        if (!c->cmd) continue;
        NOOP("%s==%s\n", command, c->cmd);
        if (strcmp(command, c->cmd)==0) {
            gchar *response = rfm_context_function(pkg_confirm_f, c);
            g_object_set_data(G_OBJECT(widgets_p->paper), "flags", NULL);
            if (response){
                view_t *view_p = widgets_p->view_p;
                record_entry_t *en = rfm_copy_entry(view_p->en);
                g_free (en->path);
                g_strstrip(response);
                en->path = g_strdup_printf("%s", response);
                DBG("command will be \"emerge %s\" \n", en->path);
                rodent_refresh (widgets_p, en);
                // This would open a new window, which annoys me:
                // gchar * cmd = g_strdup_printf("rodent-plug pkg %s", response);
                // g_free(cmd);
                flags = c->flags;
                DBG("do it --> %s\n", c->cmd);
                g_free(response);
                break;
            }
        }
    }
    return;
}

static 
void
emerge_process_cmd(GtkMenuItem *m, gpointer data){
    TRACE("process_cmd\n");
    pkg_command_t *c = data;
    if (!c) return;
    widgets_t *widgets_p = rfm_get_widget ("widgets_p");
    gint flags = 0;
    DBG("pkg:%s cmd:%s\n", c->pkg, c->cmd);
    gchar *response = rfm_context_function(pkg_confirm_f, c);
    g_object_set_data(G_OBJECT(widgets_p->paper), "flags", NULL);
    gchar *cmd=NULL;
    if (response){
        DBG("response=%s\n", response);
        if (strcmp(c->cmd, "search")){
            view_t *view_p = widgets_p->view_p;
            record_entry_t *en = rfm_copy_entry(view_p->en);
            g_free (en->path);
            g_strstrip(response);
            en->path = g_strdup_printf("%s", response);
            DBG("command will be \"emerge %s\" \n", en->path);
            rodent_refresh (widgets_p, en);
            // This would open a new window, which annoys me:
            // gchar * cmd = g_strdup_printf("rodent-plug pkg %s", response);
            // g_free(cmd);
            flags = c->flags;
            g_free(response);
            return;
        }
        
        const gchar *sudo;
        if (geteuid() == 0 || (c->flags & ACCESS_READ)) sudo=" ";
        else sudo = "sudo -A ";
        cmd = g_strdup_printf("%s%s %s", sudo, c->pkg, response);
        g_object_set_data(G_OBJECT(widgets_p->paper), "flags", GINT_TO_POINTER(c->flags));
        flags = c->flags;
        rfm_diagnostics(widgets_p, "xffm_tag/blue", cmd, "\n", NULL);	
        DBG("do it --> %s\n", cmd);
        g_free(response);
    }
        
    do_it(widgets_p, cmd, flags);
    g_free(cmd);
    return;
}
*/
