#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

static void *
zap_passfile(void *data){
    if (!data) return NULL;
    sleep(3);
    unlink((gchar *)data);
    g_free(data);
    return NULL;
}

// clear smb-user to requery
//
static gchar *
get_passfile(widgets_t *widgets_p, const gchar *user, 
	const gchar *password, const gchar *domain){
    if (!password ||strlen(password)==0) return NULL;
    gint fd = -1;
    gchar *passfile = NULL;
    time_t seconds;
    time (&seconds);
    gint try=0;
retry:
    srand ((unsigned)seconds);
    gint divide = RAND_MAX / 10000;
    //if (divide == 0) divide++;
    // This call to rand is not security related. It is just to generate 
    // a temporary file name and can be ignored by coverity.
    // coverity[dont_call : FALSE]
    if((seconds = rand () / divide) > 100000L){
	seconds = 50001;
    }
    passfile = g_strdup_printf("%s/.smb-%ld", 
	    g_get_home_dir(), (long)seconds);
    // if the file exists, retry with a different seudo-random number...
    if (rfm_g_file_test(passfile, G_FILE_TEST_EXISTS)){
	if (seconds > 0) seconds--;
	else seconds++;
	if (try++ < 300) {
	    g_free(passfile);
	    goto retry;
	} else {
	    g_error("This is a what some people call \"a bean that weighs a pound\"\n");
	}
    }
    NOOP(stderr, "passfile=%s on try %d\n", passfile, try);

    fd = open (passfile, O_CREAT|O_TRUNC|O_RDWR, 0600);
    if (fd >= 0) {
	if (write(fd, (void *)"username = ", strlen("username = ")) < 0){
	    DBG("write %s: %s\n", passfile, strerror(errno));
	}
	if (write(fd, (void *)user, strlen(user)) < 0){
	    DBG("write %s: %s\n", passfile, strerror(errno));
	}
	
	if (write(fd, (void *)"\npassword = ", strlen("\npassword = ")) < 0)
	{
	    DBG("write %s: %s\n", passfile, strerror(errno));
	}
	if (write(fd, (void *)password, strlen(password)) < 0){
	    DBG("write %s: %s\n", passfile, strerror(errno));
	}

	if (domain && strlen(domain)){
	  if (write(fd, (void *)"\ndomain   = ", strlen("\ndomain   = ")) < 0)
	  {
	    DBG("write %s: %s\n", passfile, strerror(errno));
	  }
	  if (write(fd, (void *)domain, strlen(domain)) < 0){
	    DBG("write %s: %s\n", passfile, strerror(errno));
	  }
	}
	if (write(fd, (void *)"\n", strlen("\n")) < 0){
	    DBG("write %s: %s\n", passfile, strerror(errno));
	}
	close(fd);
    } else {
	DBG("cannot open %s: %s\n", passfile, strerror(errno));
    }
    return passfile;
}

static
void *
passfile_double_click(void * p, void *q){
    rfm_global_t *rfm_global_p = rfm_global();
    if (p == NULL){
	DBG("passfile_double_click: widgets_p cannot be null\n");
	return NULL;
    }
    widgets_t *widgets_p = p;
    record_entry_t *en = q;
    if (en && strcmp(en->module, "workgroup") && strcmp(en->module, "shares")){
	//return NULL;
    }
    if (en && IS_UP_TYPE(en->type)) return NULL;
    gchar *user = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-user");
    gchar *password = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-password");
    gchar *domain = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-domain");

    if (!user) {
	user = g_object_get_data(G_OBJECT(rfm_global_p->window), 
	    "smb-user");
	if (user) g_object_set_data(G_OBJECT(widgets_p->paper), "smb-user", g_strdup(user));
    }
    if (!password) {
	password = g_object_get_data(G_OBJECT(rfm_global_p->window), 
	    "smb-password");
	if (password) g_object_set_data(G_OBJECT(widgets_p->paper), "smb-password", g_strdup(password));
    }
    if (!domain) {
	domain = g_object_get_data(G_OBJECT(rfm_global_p->window), 
	    "smb-domain");
	if (domain) g_object_set_data(G_OBJECT(widgets_p->paper), "smb_workgroup", g_strdup(domain));
    }

    const gchar *default_user = getenv("USER");
    if (!default_user) default_user = getenv("LOGNAME");
    if (!default_user) default_user = "GUEST";

    if (!user) {
	user = rfm_get_response (widgets_p,
	    _("User ID; leave blank for anonymous / nonauthenticated"),
	    default_user, FALSE);
	if (!user){
	    user = g_strdup("GUEST");
	}
	g_object_set_data(G_OBJECT(widgets_p->paper), "smb-user", user);
	g_object_set_data(G_OBJECT(rfm_global_p->window), "smb-user", (user)?
		g_strdup(user):NULL);
	if (user && strlen(user) && strcmp(user,"GUEST")) {
	    g_free(password);
	    gchar *string = g_strdup_printf("%s:", _("Enter password"));
	    password = rfm_get_response (widgets_p, string, NULL, TRUE);
	    g_free(string);
	    g_object_set_data(G_OBJECT(widgets_p->paper), "smb-password", password);
	    g_object_set_data(G_OBJECT(rfm_global_p->window), "smb-password", (password)?
		    g_strdup(password):NULL);
	}
	if (password && strlen(password)) {
	    g_free(domain);
	    gchar *t = g_strconcat(_("Optional information:"), " ",
		    _("Authentication domain"),"\n", _("Domain:"), NULL);
	    domain = rfm_get_response (widgets_p, t, NULL, FALSE);
	    g_free(t);
	    g_object_set_data(G_OBJECT(widgets_p->paper), "smb-domain", domain);
	    g_object_set_data(G_OBJECT(rfm_global_p->window), "smb-domain", (domain)?
		    g_strdup(domain):NULL);
	}
    }
    view_t *view_p = widgets_p->view_p;
    gchar *passfile = g_object_get_data(G_OBJECT(widgets_p->paper), "passfile");
    if (passfile) rfm_view_thread_create(view_p, zap_passfile, g_strdup(passfile), "zap_passfile");
    g_object_set_data(G_OBJECT(widgets_p->paper), "passfile", NULL);
    g_free(passfile);
    passfile=NULL;
    if (user && password) {
	passfile = 
	    get_passfile(widgets_p, user, password, domain);
	g_object_set_data(G_OBJECT(widgets_p->paper), "passfile", passfile);
	NOOP( "SET passfile=%s\n", passfile);
    }
  
    return  NULL;
}


static 
void reset_user_credentials(GtkMenuItem *m, gpointer data){
    widgets_t *widgets_p=rfm_get_widget("widgets_p");
    //widgets_t *widgets_p = data;
    // Clear out data elements for user, password and domain
    gchar *items[]={"smb-user", "smb-password", "smb-domain", NULL};
    gchar **p=items;
    rfm_global_t *rfm_global_p = rfm_global();
    for (p=items; p && *p; p++){
	void *q=g_object_get_data(G_OBJECT(widgets_p->paper), *p);
	g_free(q);
	q=g_object_get_data(G_OBJECT(rfm_global_p->window), *p);
	g_free(q);
	g_object_set_data(G_OBJECT(widgets_p->paper), *p, NULL);
	g_object_set_data(G_OBJECT(rfm_global_p->window), *p, NULL);
    }
    //
    // Fire up password dialog
    passfile_double_click(widgets_p, NULL);
    //
    // That's all, folks.
}

