/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.dialog;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class TemplatesTreeViewer
extends TreeViewer {
    public TemplatesTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new TemplatesTreeViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TemplatesTreeViewerLabelProvider());
        this.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
    }

    private class TemplatesTreeViewerContentProvider
    implements ITreeContentProvider {
        private TemplatesTreeViewerContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (parentElement instanceof ITemplateGroup) {
                return ((ITemplateGroup)parentElement).getTemplates().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITemplateGroup) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }
    }

    private class TemplatesTreeViewerLabelProvider
    extends LabelProvider {
        private TemplatesTreeViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITemplateGroup) {
                return ((ITemplateGroup)element).getName();
            }
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof ITemplateGroup) {
                return IArchiImages.ImageFactory.getImage("img/folder-default.png");
            }
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getImage();
            }
            return null;
        }
    }
}

