/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.impl.model;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.Logger;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.templates.ArchiTemplatesPlugin;
import com.archimatetool.templates.impl.model.ArchimateModelTemplate;
import com.archimatetool.templates.impl.model.Messages;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.graphics.Image;

public class ArchimateTemplateManager
extends TemplateManager {
    public static final String ARCHIMATE_TEMPLATE_FILE_EXTENSION = ".architemplate";

    @Override
    protected ITemplateGroup loadInbuiltTemplates() {
        TemplateGroup group = new TemplateGroup(Messages.ArchimateTemplateManager_0);
        File folder = ArchiTemplatesPlugin.getInstance().getTemplatesFolder();
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(ARCHIMATE_TEMPLATE_FILE_EXTENSION)) {
                    try {
                        group.addTemplate(this.createTemplate(file));
                    }
                    catch (IOException ex) {
                        Logger.logError((String)"Error loading template", (Throwable)ex);
                    }
                }
                ++n2;
            }
        }
        return group;
    }

    @Override
    public File getUserTemplatesManifestFile() {
        return new File(ArchiPlugin.getInstance().getWorkspaceFolder(), "templates.xml");
    }

    @Override
    public String getTemplateFileExtension() {
        return ARCHIMATE_TEMPLATE_FILE_EXTENSION;
    }

    @Override
    public ITemplate createTemplate(File file) throws IOException {
        return new ArchimateModelTemplate(file);
    }

    @Override
    public Image getMainImage() {
        return IArchiImages.ImageFactory.getImage("img/models.png");
    }
}

