/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.impl.wizard;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.templates.impl.wizard.Messages;
import com.archimatetool.templates.model.TemplateManager;
import com.archimatetool.templates.wizard.ModelViewsTreeViewer;
import com.archimatetool.templates.wizard.TemplateUtils;
import java.io.File;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SaveArchimateModelAsTemplateWizardPage
extends WizardPage {
    private static String HELP_ID = "com.archimatetool.help.SaveArchimateModelAsTemplateWizardPage";
    private IArchimateModel fModel;
    private Text fFileTextField;
    private Text fNameTextField;
    private Text fDescriptionTextField;
    private ModelViewsTreeViewer fModelViewsTreeViewer;
    private Label fPreviewLabel;
    private Button fButtonIncludeThumbs;
    private TemplateManager fTemplateManager;
    private static final String PREFS_LAST_FOLDER = "SaveArchimateModelAsTemplateLastFolder";

    public SaveArchimateModelAsTemplateWizardPage(IArchimateModel model, TemplateManager templateManager) {
        super("SaveModelAsTemplateWizardPage");
        this.setTitle(Messages.SaveArchimateModelAsTemplateWizardPage_2);
        this.setDescription(Messages.SaveArchimateModelAsTemplateWizardPage_3);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/new_wiz.png"));
        this.fModel = model;
        this.fTemplateManager = templateManager;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Group fileComposite = new Group(container, 0);
        fileComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        fileComposite.setLayout((Layout)layout);
        Label label = new Label((Composite)fileComposite, 0);
        label.setText(Messages.SaveArchimateModelAsTemplateWizardPage_4);
        this.fFileTextField = UIUtils.createSingleTextControl((Composite)fileComposite, (int)2048, (boolean)false);
        this.fFileTextField.setLayoutData((Object)new GridData(768));
        String defaultFileName = Messages.SaveArchimateModelAsTemplateWizardPage_5 + ".architemplate";
        String lastFolderName = ArchiPlugin.getInstance().getPreferenceStore().getString(PREFS_LAST_FOLDER);
        File lastFolder = new File(lastFolderName);
        if (lastFolder.exists() && lastFolder.isDirectory()) {
            this.fFileTextField.setText(new File(lastFolder, defaultFileName).getPath());
        } else {
            this.fFileTextField.setText(new File(System.getProperty("user.home"), defaultFileName).getPath());
        }
        this.fFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveArchimateModelAsTemplateWizardPage.this.validateFields();
            }
        });
        Button fileButton = new Button((Composite)fileComposite, 8);
        fileButton.setText(Messages.SaveArchimateModelAsTemplateWizardPage_6);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = SaveArchimateModelAsTemplateWizardPage.this.chooseFile();
                if (file != null) {
                    SaveArchimateModelAsTemplateWizardPage.this.fFileTextField.setText(file.getPath());
                }
            }
        });
        Group fieldGroup = new Group(container, 0);
        fieldGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        fieldGroup.setLayout((Layout)layout);
        label = new Label((Composite)fieldGroup, 0);
        label.setText(Messages.SaveArchimateModelAsTemplateWizardPage_7);
        this.fNameTextField = UIUtils.createSingleTextControl((Composite)fieldGroup, (int)2048, (boolean)false);
        this.fNameTextField.setLayoutData((Object)new GridData(768));
        if (StringUtils.isSet((String)this.fModel.getName())) {
            this.fNameTextField.setText(this.fModel.getName());
        }
        this.fNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveArchimateModelAsTemplateWizardPage.this.validateFields();
            }
        });
        label = new Label((Composite)fieldGroup, 0);
        label.setText(Messages.SaveArchimateModelAsTemplateWizardPage_8);
        GridData gd = new GridData(0, 128, false, false);
        label.setLayoutData((Object)gd);
        this.fDescriptionTextField = new Text((Composite)fieldGroup, 2626);
        gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 550;
        this.fDescriptionTextField.setLayoutData((Object)gd);
        if (StringUtils.isSet((String)this.fModel.getPurpose())) {
            this.fDescriptionTextField.setText(this.fModel.getPurpose());
        }
        boolean thumbsEnabled = !this.fModel.getDiagramModels().isEmpty();
        Group thumbsGroup = new Group(container, 0);
        thumbsGroup.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        thumbsGroup.setLayout((Layout)layout);
        this.fButtonIncludeThumbs = new Button((Composite)thumbsGroup, 32);
        this.fButtonIncludeThumbs.setText(Messages.SaveArchimateModelAsTemplateWizardPage_9);
        this.fButtonIncludeThumbs.setSelection(thumbsEnabled);
        this.fButtonIncludeThumbs.setEnabled(thumbsEnabled);
        this.fButtonIncludeThumbs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveArchimateModelAsTemplateWizardPage.this.fModelViewsTreeViewer.getControl().setEnabled(SaveArchimateModelAsTemplateWizardPage.this.fButtonIncludeThumbs.getSelection());
                SaveArchimateModelAsTemplateWizardPage.this.fPreviewLabel.setEnabled(SaveArchimateModelAsTemplateWizardPage.this.fButtonIncludeThumbs.getSelection());
            }
        });
        label = new Label((Composite)thumbsGroup, 0);
        label.setText(Messages.SaveArchimateModelAsTemplateWizardPage_10);
        label.setEnabled(thumbsEnabled);
        Composite thumbContainer = new Composite((Composite)thumbsGroup, 0);
        thumbContainer.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        thumbContainer.setLayout((Layout)layout);
        this.fModelViewsTreeViewer = new ModelViewsTreeViewer(thumbContainer, 0);
        this.fModelViewsTreeViewer.setInput(this.fModel.getFolder(FolderType.DIAGRAMS));
        gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 140;
        this.fModelViewsTreeViewer.getControl().setLayoutData((Object)gd);
        this.fModelViewsTreeViewer.getControl().setEnabled(thumbsEnabled);
        this.fPreviewLabel = new Label(thumbContainer, 2048);
        this.fPreviewLabel.setBackground(new Color(255, 255, 255));
        gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 150;
        this.fPreviewLabel.setLayoutData((Object)gd);
        this.fPreviewLabel.setAlignment(0x1000000);
        this.fPreviewLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SaveArchimateModelAsTemplateWizardPage.this.disposePreviewImage();
            }
        });
        this.fModelViewsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (o instanceof IDiagramModel) {
                    TemplateUtils.createThumbnailPreviewImage((IDiagramModel)o, SaveArchimateModelAsTemplateWizardPage.this.fPreviewLabel);
                } else {
                    SaveArchimateModelAsTemplateWizardPage.this.disposePreviewImage();
                }
            }
        });
        this.fModelViewsTreeViewer.expandAll();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem[] treeItemArray = SaveArchimateModelAsTemplateWizardPage.this.fModelViewsTreeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    Object o = item.getData();
                    if (o instanceof IDiagramModel) {
                        SaveArchimateModelAsTemplateWizardPage.this.fModelViewsTreeViewer.setSelection((ISelection)new StructuredSelection(o));
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.validateFields();
    }

    public String getFileName() {
        return this.fFileTextField.getText();
    }

    public String getTemplateName() {
        return this.fNameTextField.getText();
    }

    public String getTemplateDescription() {
        return this.fDescriptionTextField.getText();
    }

    public boolean includeThumbnails() {
        return this.fButtonIncludeThumbs.getSelection();
    }

    public IDiagramModel getSelectedDiagramModel() {
        Object o = ((IStructuredSelection)this.fModelViewsTreeViewer.getSelection()).getFirstElement();
        if (o instanceof IDiagramModel) {
            return (IDiagramModel)o;
        }
        return null;
    }

    private File chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.SaveArchimateModelAsTemplateWizardPage_11);
        if (!PlatformUtils.isMac()) {
            dialog.setFilterExtensions(new String[]{"*" + this.fTemplateManager.getTemplateFileExtension(), "*.*"});
        }
        File file = new File(this.fFileTextField.getText());
        dialog.setFileName(file.getName());
        dialog.setOverwrite(false);
        Object path = dialog.open();
        if (path != null) {
            if (dialog.getFilterIndex() == 0 && !((String)path).endsWith(".architemplate")) {
                path = (String)path + ".architemplate";
            }
            return new File((String)path);
        }
        return null;
    }

    private void validateFields() {
        String fileName = this.getFileName();
        if (!StringUtils.isSetAfterTrim((String)fileName)) {
            this.updateStatus(Messages.SaveArchimateModelAsTemplateWizardPage_14);
            return;
        }
        String name = this.getTemplateName();
        if (!StringUtils.isSetAfterTrim((String)name)) {
            this.updateStatus(Messages.SaveArchimateModelAsTemplateWizardPage_15);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void disposePreviewImage() {
        if (this.fPreviewLabel != null && this.fPreviewLabel.getImage() != null) {
            this.fPreviewLabel.getImage().dispose();
            this.fPreviewLabel.setImage(null);
        }
    }

    void storePreferences() {
        File parentFile = new File(this.getFileName()).getAbsoluteFile().getParentFile();
        if (parentFile != null) {
            ArchiPlugin.getInstance().getPreferenceStore().setValue(PREFS_LAST_FOLDER, parentFile.getAbsolutePath());
        }
    }
}

