/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.model;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.editor.utils.ZipUtils;
import com.archimatetool.jdom.JDOMUtils;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateXMLTags;
import com.archimatetool.templates.model.Messages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.graphics.Image;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class AbstractTemplate
implements ITemplate,
ITemplateXMLTags {
    private String fID;
    private String fName = "";
    private String fDescription = "";
    private String fKeyThumbnailPath;
    private File fFile;
    private Map<Integer, Image> fThumbnails = new HashMap<Integer, Image>();
    private int fThumbnailCount = -1;

    public AbstractTemplate() {
    }

    public AbstractTemplate(File file) throws IOException {
        this.setFile(file);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = StringUtils.safeString((String)name);
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setDescription(String description) {
        this.fDescription = StringUtils.safeString((String)description);
    }

    @Override
    public int getThumbnailCount() {
        if (this.fThumbnailCount == -1) {
            this.fThumbnailCount = 0;
            try {
                for (String s : ZipUtils.getZipFileEntryNames((File)this.fFile)) {
                    if (!s.endsWith(".png")) continue;
                    ++this.fThumbnailCount;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.fThumbnailCount;
    }

    @Override
    public void setKeyThumbnailPath(String path) {
        this.fKeyThumbnailPath = path;
    }

    @Override
    public Image getKeyThumbnail() {
        if (this.fKeyThumbnailPath != null) {
            try {
                String imageNumber = this.fKeyThumbnailPath.replaceAll("[^0-9]+", "");
                int index = Integer.parseInt(imageNumber);
                return this.getThumbnail(index);
            }
            catch (Exception exception) {}
        }
        return IArchiImages.ImageFactory.getImage("img/default_model_thumb.png");
    }

    @Override
    public Image getThumbnail(int index) {
        Image image = this.fThumbnails.get(index);
        if (image == null && (image = this.loadThumbnailImage(this.getThumbnailEntryName(index))) != null) {
            this.fThumbnails.put(index, image);
        }
        return image;
    }

    @Override
    public File getFile() {
        return this.fFile;
    }

    @Override
    public void setFile(File file) throws IOException {
        this.fFile = file;
        this.loadManifest(file);
    }

    @Override
    public String getID() {
        if (this.fID == null) {
            this.fID = UUID.randomUUID().toString();
        }
        return this.fID;
    }

    @Override
    public void setID(String id) {
        this.fID = id;
    }

    @Override
    public void save() throws IOException {
        if (this.fFile == null || !this.fFile.exists()) {
            return;
        }
        File tmpFolder = Files.createTempDirectory("architemplate", new FileAttribute[0]).toFile();
        ZipUtils.unpackZip((File)this.fFile, (File)tmpFolder);
        JDOMUtils.write2XMLFile((Document)this.createManifestDocument(), (File)new File(tmpFolder, "manifest.xml"));
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.fFile)));){
            ZipUtils.addFolderToZip((File)tmpFolder, (ZipOutputStream)zOut, null, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FileUtils.deleteFolder((File)tmpFolder);
    }

    @Override
    public String createManifest() throws IOException {
        return JDOMUtils.write2XMLString((Document)this.createManifestDocument());
    }

    private Document createManifestDocument() {
        Document doc = new Document();
        Element root = new Element("manifest");
        doc.setRootElement(root);
        root.setAttribute("type", this.getType());
        root.setAttribute("timestamp", Long.toString(System.currentTimeMillis()));
        Element elementName = new Element("name");
        elementName.setText(this.getName());
        root.addContent((Content)elementName);
        Element elementDescription = new Element("description");
        elementDescription.setText(this.getDescription());
        root.addContent((Content)elementDescription);
        if (this.fKeyThumbnailPath != null) {
            Element elementKeyThumb = new Element("key-thumbnail");
            elementKeyThumb.setText(this.fKeyThumbnailPath);
            root.addContent((Content)elementKeyThumb);
        }
        return doc;
    }

    private void loadManifest(File file) throws IOException {
        Element keyThumbnailElement;
        if (file == null || !file.exists()) {
            throw new IOException(Messages.AbstractTemplate_0);
        }
        String manifest = ZipUtils.extractZipEntry((File)file, (String)"manifest.xml", (Charset)Charset.forName("UTF-8"));
        if (manifest == null) {
            throw new IOException(Messages.AbstractTemplate_2);
        }
        Document doc = null;
        try {
            doc = JDOMUtils.readXMLString((String)manifest);
        }
        catch (JDOMException ex) {
            throw new IOException(ex);
        }
        Element rootElement = doc.getRootElement();
        String attType = rootElement.getAttributeValue("type");
        if (attType != null && !Objects.equals(this.getType(), attType)) {
            throw new IOException(Messages.AbstractTemplate_1);
        }
        Element nameElement = rootElement.getChild("name");
        if (nameElement != null) {
            this.fName = nameElement.getText();
        }
        Element descriptionElement = rootElement.getChild("description");
        if (nameElement != null) {
            this.fDescription = descriptionElement.getText();
        }
        if ((keyThumbnailElement = rootElement.getChild("key-thumbnail")) != null) {
            this.fKeyThumbnailPath = keyThumbnailElement.getText();
        }
    }

    private Image loadThumbnailImage(String imgName) {
        if (this.fFile != null && this.fFile.exists() && imgName != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream stream = ZipUtils.getZipEntryStream((File)this.fFile, (String)imgName);){
                    if (stream != null) {
                        return new Image(null, stream);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private String getThumbnailEntryName(int index) {
        return "Thumbnails/" + index + ".png";
    }

    @Override
    public void dispose() {
        if (this.fThumbnails != null) {
            for (Image image : this.fThumbnails.values()) {
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
        }
        this.fThumbnails = null;
    }
}

