/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.model;

import com.archimatetool.editor.Logger;
import com.archimatetool.jdom.JDOMUtils;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.ITemplateXMLTags;
import com.archimatetool.templates.model.Messages;
import com.archimatetool.templates.model.TemplateGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class TemplateManager
implements ITemplateXMLTags {
    public static final String ZIP_ENTRY_MANIFEST = "manifest.xml";
    public static final String ZIP_ENTRY_MODEL = "model.archimate";
    public static final String ZIP_ENTRY_THUMBNAILS = "Thumbnails/";
    public static final int THUMBNAIL_WIDTH = 512;
    public static final int THUMBNAIL_HEIGHT = 512;
    public ITemplateGroup AllUserTemplatesGroup = new TemplateGroup(Messages.TemplateManager_0){

        @Override
        public List<ITemplate> getTemplates() {
            return TemplateManager.this.getUserTemplates();
        }
    };
    private ITemplateGroup fInbuiltTemplateGroup;
    private List<ITemplate> fUserTemplates;
    private List<ITemplateGroup> fUserTemplateGroups;

    public void addTemplateEntry(File templateFile, ITemplateGroup group) throws IOException {
        if (this.hasTemplateFile(templateFile, group)) {
            return;
        }
        ITemplate template = this.createTemplate(templateFile);
        this.addUserTemplate(template);
        if (group != null) {
            group.addTemplate(template);
        }
        this.saveUserTemplatesManifest();
    }

    public ITemplateGroup getInbuiltTemplateGroup() {
        if (this.fInbuiltTemplateGroup == null) {
            this.fInbuiltTemplateGroup = this.loadInbuiltTemplates();
        }
        return this.fInbuiltTemplateGroup;
    }

    public List<ITemplate> getUserTemplates() {
        if (this.fUserTemplates == null) {
            this.loadUserTemplates();
        }
        return this.fUserTemplates;
    }

    public List<ITemplateGroup> getUserTemplateGroups() {
        if (this.fUserTemplateGroups == null) {
            this.loadUserTemplates();
        }
        return this.fUserTemplateGroups;
    }

    public void reset() {
        this.disposeUserTemplates();
        this.fUserTemplates = null;
        this.fUserTemplateGroups = null;
    }

    public boolean hasTemplateFile(File templateFile, ITemplateGroup group) {
        if (templateFile == null) {
            return false;
        }
        if (group == null) {
            group = this.AllUserTemplatesGroup;
        }
        for (ITemplate template : group.getTemplates()) {
            if (!templateFile.equals(template.getFile())) continue;
            return true;
        }
        return false;
    }

    protected void loadUserTemplates() {
        this.fUserTemplates = new ArrayList<ITemplate>();
        this.fUserTemplateGroups = new ArrayList<ITemplateGroup>();
        if (!this.getUserTemplatesManifestFile().exists()) {
            return;
        }
        Document doc = null;
        try {
            doc = JDOMUtils.readXMLFile((File)this.getUserTemplatesManifestFile());
        }
        catch (Exception ex) {
            Logger.logError((String)"Error loading templates manifest", (Throwable)ex);
            return;
        }
        HashMap<String, ITemplate> userTemplateMap = new HashMap<String, ITemplate>();
        Element rootElement = doc.getRootElement();
        for (Element templateElement : rootElement.getChildren("template")) {
            File file;
            String id = templateElement.getAttributeValue("id");
            String path = templateElement.getAttributeValue("file");
            if (id == null || path == null || !(file = new File(path)).exists()) continue;
            try {
                ITemplate template = this.createTemplate(file);
                template.setID(id);
                this.fUserTemplates.add(template);
                userTemplateMap.put(id, template);
            }
            catch (IOException ex) {
                Logger.logError((String)"Error loading template", (Throwable)ex);
            }
        }
        for (Element groupElement : rootElement.getChildren("group")) {
            TemplateGroup templateGroup = new TemplateGroup();
            templateGroup.setName(groupElement.getAttributeValue("name"));
            this.fUserTemplateGroups.add(templateGroup);
            for (Element templateRefElement : groupElement.getChildren("template-ref")) {
                ITemplate template;
                String ref = templateRefElement.getAttributeValue("ref");
                if (ref == null || (template = (ITemplate)userTemplateMap.get(ref)) == null) continue;
                templateGroup.addTemplate(template);
            }
        }
    }

    public void saveUserTemplatesManifest() throws IOException {
        if (this.fUserTemplates == null || this.fUserTemplateGroups == null) {
            return;
        }
        Document doc = new Document();
        Element rootElement = new Element("manifest");
        doc.setRootElement(rootElement);
        for (ITemplate template : this.fUserTemplates) {
            Element templateElement = new Element("template");
            rootElement.addContent((Content)templateElement);
            templateElement.setAttribute("type", template.getType());
            templateElement.setAttribute("id", template.getID());
            templateElement.setAttribute("file", template.getFile().getAbsolutePath());
        }
        for (ITemplateGroup group : this.fUserTemplateGroups) {
            Element groupElement = new Element("group");
            rootElement.addContent((Content)groupElement);
            groupElement.setAttribute("name", group.getName());
            for (ITemplate template : group.getTemplates()) {
                Element templateRefElement = new Element("template-ref");
                groupElement.addContent((Content)templateRefElement);
                templateRefElement.setAttribute("ref", template.getID());
            }
        }
        JDOMUtils.write2XMLFile((Document)doc, (File)this.getUserTemplatesManifestFile());
    }

    public void addUserTemplate(ITemplate template) {
        if (template != null && !this.getUserTemplates().contains(template)) {
            this.getUserTemplates().add(template);
        }
    }

    public void dispose() {
        this.disposeInbuiltTemplates();
        this.disposeUserTemplates();
    }

    protected void disposeInbuiltTemplates() {
        if (this.fInbuiltTemplateGroup != null) {
            for (ITemplate template : this.fInbuiltTemplateGroup.getTemplates()) {
                template.dispose();
            }
        }
    }

    protected void disposeUserTemplates() {
        if (this.fUserTemplates != null) {
            for (ITemplate template : this.fUserTemplates) {
                template.dispose();
            }
        }
    }

    protected abstract ITemplateGroup loadInbuiltTemplates();

    public abstract String getTemplateFileExtension();

    public abstract ITemplate createTemplate(File var1) throws IOException;

    public abstract File getUserTemplatesManifestFile();

    public abstract Image getMainImage();
}

