/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.wizard;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.INameable;
import java.text.Collator;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ModelViewsTreeViewer
extends TreeViewer {
    public ModelViewsTreeViewer(Composite parent, int style) {
        super(parent, style | 0x800);
        this.setContentProvider((IContentProvider)new ModelViewsTreeViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ModelViewsTreeViewerLabelProvider());
        this.setComparator(new ViewerComparator(Collator.getInstance()){

            public int category(Object element) {
                if (element instanceof IFolder) {
                    return 0;
                }
                if (element instanceof EObject) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private class ModelViewsTreeViewerContentProvider
    implements ITreeContentProvider {
        private ModelViewsTreeViewerContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IFolder) {
                ArrayList list = new ArrayList();
                list.addAll(((IFolder)parentElement).getFolders());
                list.addAll(((IFolder)parentElement).getElements());
                return list.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFolder) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }
    }

    private class ModelViewsTreeViewerLabelProvider
    extends LabelProvider {
        private ModelViewsTreeViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INameable) {
                return ((INameable)element).getName();
            }
            return "";
        }

        public Image getImage(Object element) {
            return ArchiLabelProvider.INSTANCE.getImage(element);
        }
    }
}

