/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.templates.wizard;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedWizardDialog;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.templates.dialog.TemplateManagerDialog;
import com.archimatetool.templates.impl.model.ArchimateTemplateManager;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import com.archimatetool.templates.wizard.Messages;
import com.archimatetool.templates.wizard.TemplateGroupsTableViewer;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class NewModelFromTemplateWizardPage
extends WizardPage {
    protected Gallery fGallery;
    protected GalleryItem fGalleryRoot;
    protected StyledText fDescriptionText;
    protected TemplateManager fTemplateManager;
    protected TableViewer fInbuiltTableViewer;
    protected TableViewer fUserTableViewer;
    protected ITemplate fSelectedTemplate;
    protected TableViewer fLastViewerFocus;
    protected int DEFAULT_GALLERY_ITEM_SIZE = 120;
    protected static final String OPEN = Messages.NewModelFromTemplateWizardPage_0;
    protected static final String MANAGE = Messages.NewModelFromTemplateWizardPage_1;

    public NewModelFromTemplateWizardPage(String pageName, TemplateManager templateManager) {
        super(pageName);
        this.fTemplateManager = templateManager;
        this.init();
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/new_wiz.png"));
    }

    protected abstract void init();

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, this.getHelpID());
        SashForm sash1 = new SashForm(container, 256);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 800;
        gd.heightHint = 500;
        sash1.setLayoutData((Object)gd);
        Composite tableComposite = new Composite((Composite)sash1, 2048);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        tableComposite.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, false);
        this.fInbuiltTableViewer = this.createGroupsTableViewer(tableComposite, Messages.NewModelFromTemplateWizardPage_2, gd);
        this.fInbuiltTableViewer.setInput((Object)new Object[]{this.fTemplateManager.getInbuiltTemplateGroup(), OPEN, MANAGE});
        this.fInbuiltTableViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object o = ((IStructuredSelection)NewModelFromTemplateWizardPage.this.fInbuiltTableViewer.getSelection()).getFirstElement();
                if (o == OPEN) {
                    NewModelFromTemplateWizardPage.this.handleOpenAction();
                } else if (o == MANAGE) {
                    NewModelFromTemplateWizardPage.this.handleManageTemplatesAction();
                }
            }
        });
        gd = new GridData(4, 4, true, true);
        this.fUserTableViewer = this.createGroupsTableViewer(tableComposite, Messages.NewModelFromTemplateWizardPage_3, gd);
        this.fUserTableViewer.setComparator(new ViewerComparator(Collator.getInstance()){

            public int category(Object element) {
                if (element == NewModelFromTemplateWizardPage.this.fTemplateManager.AllUserTemplatesGroup) {
                    return 0;
                }
                return 1;
            }
        });
        this.fUserTableViewer.setInput((Object)this.fTemplateManager);
        SashForm sash2 = new SashForm((Composite)sash1, 512);
        Composite galleryComposite = new Composite((Composite)sash2, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        galleryComposite.setLayout((Layout)layout);
        this.fGallery = new Gallery(galleryComposite, 2560);
        this.fGallery.setLayoutData((Object)new GridData(1808));
        final NoGroupRenderer groupRenderer = new NoGroupRenderer();
        groupRenderer.setItemSize(this.DEFAULT_GALLERY_ITEM_SIZE, this.DEFAULT_GALLERY_ITEM_SIZE);
        groupRenderer.setAutoMargin(true);
        groupRenderer.setMinMargin(10);
        this.fGallery.setGroupRenderer((AbstractGalleryGroupRenderer)groupRenderer);
        final DefaultGalleryItemRenderer itemRenderer = new DefaultGalleryItemRenderer();
        itemRenderer.setDropShadows(true);
        itemRenderer.setDropShadowsSize(7);
        itemRenderer.setShowRoundedSelectionCorners(false);
        this.fGallery.setItemRenderer((AbstractGalleryItemRenderer)itemRenderer);
        this.fGalleryRoot = new GalleryItem(this.fGallery, 0);
        final Scale scale = new Scale(galleryComposite, 256);
        gd = new GridData(0x1000008, 0, false, false);
        gd.widthHint = 120;
        scale.setLayoutData((Object)gd);
        scale.setMaximum(480);
        scale.setMinimum(64);
        scale.setIncrement(8);
        scale.setPageIncrement(64);
        scale.setSelection(this.DEFAULT_GALLERY_ITEM_SIZE);
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int inc = scale.getSelection();
                itemRenderer.setDropShadows(inc >= NewModelFromTemplateWizardPage.this.DEFAULT_GALLERY_ITEM_SIZE);
                groupRenderer.setItemSize(inc, inc);
            }
        });
        this.fDescriptionText = new StyledText((Composite)sash2, 2632);
        this.fGallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof GalleryItem) {
                    ITemplate template = (ITemplate)e.item.getData();
                    NewModelFromTemplateWizardPage.this.updateWizard(template);
                } else {
                    NewModelFromTemplateWizardPage.this.updateWizard(null);
                }
            }
        });
        this.fGallery.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                GalleryItem item = NewModelFromTemplateWizardPage.this.fGallery.getItem(new Point(event.x, event.y));
                if (item != null) {
                    ((ExtendedWizardDialog)NewModelFromTemplateWizardPage.this.getContainer()).finishPressed();
                }
            }
        });
        this.registerMouseMoveHandler();
        this.selectFirstTableItem();
        sash1.setWeights(new int[]{30, 70});
        sash2.setWeights(new int[]{70, 30});
        this.setPageComplete(true);
    }

    public ITemplate getSelectedTemplate() {
        return this.fSelectedTemplate;
    }

    protected TemplateGroupsTableViewer createGroupsTableViewer(Composite parent, String labelText, GridData gd) {
        CLabel label = new CLabel(parent, 0);
        label.setText(labelText);
        label.setImage(this.fTemplateManager.getMainImage());
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayout((Layout)new TableColumnLayout());
        tableComp.setLayoutData((Object)gd);
        final TemplateGroupsTableViewer tableViewer = new TemplateGroupsTableViewer(tableComp, 0);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                NewModelFromTemplateWizardPage.this.handleTableItemSelected(o);
                NewModelFromTemplateWizardPage.this.deFocusTable(tableViewer);
            }
        });
        return tableViewer;
    }

    private void deFocusTable(TableViewer viewer) {
        if (this.fLastViewerFocus != null && !this.fLastViewerFocus.getControl().isDisposed() && this.fLastViewerFocus != viewer) {
            this.fLastViewerFocus.getTable().deselectAll();
        }
        this.fLastViewerFocus = viewer;
    }

    protected void handleTableItemSelected(Object item) {
        if (item instanceof ITemplateGroup) {
            this.clearGallery();
            this.updateGallery((ITemplateGroup)item);
        }
    }

    protected void handleOpenAction() {
        this.getContainer().getShell().setVisible(false);
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.NewModelFromTemplateWizardPage_4);
        dialog.setFilterExtensions(new String[]{"*" + this.fTemplateManager.getTemplateFileExtension(), "*.*"});
        String path = dialog.open();
        if (path == null) {
            this.selectFirstTableItem();
            this.getContainer().getShell().setVisible(true);
            return;
        }
        File file = new File(path);
        BusyIndicator.showWhile(null, () -> {
            try {
                this.fSelectedTemplate = this.fTemplateManager.createTemplate(file);
                ((ExtendedWizardDialog)this.getContainer()).finishPressed();
            }
            catch (IOException ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewModelFromTemplateWizardPage_5, (String)ex.getMessage());
                this.selectFirstTableItem();
                this.getContainer().getShell().setVisible(true);
            }
        });
    }

    protected void handleManageTemplatesAction() {
        this.getContainer().getShell().setVisible(false);
        TemplateManagerDialog dialog = this.createTemplateManagerDialog();
        if (dialog.open() == 0) {
            this.fTemplateManager.reset();
            this.fUserTableViewer.refresh();
        }
        this.selectFirstTableItem();
        this.getContainer().getShell().setVisible(true);
    }

    protected TemplateManagerDialog createTemplateManagerDialog() {
        return new TemplateManagerDialog(this.getShell(), new ArchimateTemplateManager());
    }

    private void selectFirstTableItem() {
        TableViewer tableViewer = !this.fTemplateManager.getUserTemplates().isEmpty() ? this.fUserTableViewer : this.fInbuiltTableViewer;
        Object o = tableViewer.getElementAt(0);
        if (o != null) {
            tableViewer.setSelection((ISelection)new StructuredSelection(o));
            tableViewer.getControl().setFocus();
        }
    }

    private void registerMouseMoveHandler() {
        this.fGallery.addMouseMoveListener(new MouseMoveListener(){
            int mouse_movement_factor = 6;
            int index = 1;
            GalleryItem selectedItem;
            int last_x;

            public void mouseMove(MouseEvent event) {
                ITemplate template;
                GalleryItem item = NewModelFromTemplateWizardPage.this.fGallery.getItem(new Point(event.x, event.y));
                if (item != null && (template = (ITemplate)item.getData()).getThumbnailCount() <= 1) {
                    return;
                }
                if (item != this.selectedItem) {
                    if (this.selectedItem != null) {
                        template = (ITemplate)this.selectedItem.getData();
                        this.selectedItem.setImage(template.getKeyThumbnail());
                    }
                    this.selectedItem = item;
                    this.index = 1;
                    this.last_x = event.x;
                }
                if (item != null) {
                    template = (ITemplate)item.getData();
                    if (event.x < this.last_x - this.mouse_movement_factor) {
                        if (--this.index < 1) {
                            this.index = template.getThumbnailCount();
                        }
                    } else if (event.x > this.last_x + this.mouse_movement_factor) {
                        if (++this.index > template.getThumbnailCount()) {
                            this.index = 1;
                        }
                    } else {
                        return;
                    }
                    this.last_x = event.x;
                    item.setImage(template.getThumbnail(this.index));
                }
            }
        });
    }

    protected void clearGallery() {
        if (this.fGalleryRoot != null && !this.fGallery.isDisposed() && this.fGallery.getItemCount() > 0) {
            while (this.fGalleryRoot.getItemCount() > 0) {
                GalleryItem item = this.fGalleryRoot.getItem(0);
                this.fGalleryRoot.remove(item);
            }
        }
    }

    protected void updateGallery(ITemplateGroup group) {
        for (ITemplate template : group.getSortedTemplates()) {
            GalleryItem item = new GalleryItem(this.fGalleryRoot, 0);
            item.setText(StringUtils.safeString((String)template.getName()));
            item.setImage(template.getKeyThumbnail());
            item.setData((Object)template);
        }
        if (this.fGalleryRoot.getItem(0) != null) {
            this.fGallery.setSelection(new GalleryItem[]{this.fGalleryRoot.getItem(0)});
            this.updateWizard((ITemplate)this.fGalleryRoot.getItem(0).getData());
        } else {
            this.updateWizard(null);
        }
    }

    protected void updateWizard(ITemplate template) {
        this.fSelectedTemplate = template;
        if (template == null) {
            this.fDescriptionText.setText("");
            this.setPageComplete(false);
        } else {
            String text = StringUtils.safeString((String)template.getDescription());
            String desc = StringUtils.safeString((String)template.getName()) + ":";
            this.fDescriptionText.setText(desc + "   " + text);
            StyleRange style = new StyleRange();
            style.start = 0;
            style.length = desc.length();
            style.fontStyle = 1;
            this.fDescriptionText.setStyleRange(style);
            this.setPageComplete(true);
        }
    }

    protected abstract String getHelpID();
}

