/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.jasperreports.JasperReportsExporter;
import com.archimatetool.jasperreports.JasperReportsPlugin;
import com.archimatetool.jasperreports.commandline.Messages;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class JasperReportsProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.JasperReportsProvider_0;
    static final String OPTION_JASPER_CREATE_REPORT = "jasper.createReport";
    static final String OPTION_JASPER_FILENAME = "jasper.filename";
    static final String OPTION_JASPER_TITLE = "jasper.title";
    static final String OPTION_JASPER_TEMPLATE = "jasper.template";
    static final String OPTION_JASPER_LOCALE = "jasper.locale";
    static final String OPTION_JASPER_FORMAT = "jasper.format";

    public void run(CommandLine commandLine) throws Exception {
        if (!this.hasCorrectOptions(commandLine)) {
            return;
        }
        IArchimateModel model = CommandLineState.getModel();
        if (model == null) {
            throw new IOException(Messages.JasperReportsProvider_1);
        }
        String path = commandLine.getOptionValue(OPTION_JASPER_CREATE_REPORT);
        if (!StringUtils.isSet((String)path)) {
            this.logError(Messages.JasperReportsProvider_2);
            return;
        }
        File folderOutput = new File(path);
        folderOutput.mkdirs();
        if (!folderOutput.exists()) {
            this.logError(NLS.bind((String)Messages.JasperReportsProvider_3, (Object)folderOutput.getPath()));
            return;
        }
        String filename = commandLine.getOptionValue(OPTION_JASPER_FILENAME);
        if (!StringUtils.isSet((String)filename)) {
            this.logError(Messages.JasperReportsProvider_4);
            return;
        }
        File templateFile = new File(JasperReportsPlugin.getInstance().getJasperReportsFolder(), Messages.JasperReportsProvider_20 + "/main.jrxml");
        String template = commandLine.getOptionValue(OPTION_JASPER_TEMPLATE);
        if (StringUtils.isSet((String)template) && !(templateFile = new File(template)).exists()) {
            this.logError(NLS.bind((String)Messages.JasperReportsProvider_5, (Object)templateFile.getPath()));
            return;
        }
        String title = commandLine.getOptionValue(OPTION_JASPER_TITLE);
        if (!StringUtils.isSet((String)title)) {
            this.logError(Messages.JasperReportsProvider_6);
            return;
        }
        Locale locale = null;
        String loc = commandLine.getOptionValue(OPTION_JASPER_LOCALE);
        if (StringUtils.isSet((String)loc)) {
            locale = Locale.forLanguageTag(loc.replace('_', '-'));
        }
        int exportOptions = 0;
        String format = commandLine.getOptionValue(OPTION_JASPER_FORMAT);
        if (StringUtils.isSet((String)format)) {
            exportOptions |= (format = format.toLowerCase()).contains("pdf") ? 2 : 0;
            exportOptions |= format.contains("html") ? 1 : 0;
            exportOptions |= format.contains("rtf") ? 16 : 0;
            exportOptions |= format.contains("ppt") ? 8 : 0;
            exportOptions |= format.contains("odt") ? 32 : 0;
            exportOptions |= format.contains("docx") ? 4 : 0;
        }
        if (exportOptions == 0) {
            exportOptions = 2;
        }
        this.logMessage(NLS.bind((String)Messages.JasperReportsProvider_7, (Object)model.getName(), (Object)folderOutput.getPath()));
        JasperReportsExporter exporter = new JasperReportsExporter(model, folderOutput, filename, templateFile, title, locale, exportOptions);
        exporter.export((IProgressMonitor)new NullProgressMonitor(){

            public void subTask(String name) {
                JasperReportsProvider.this.logMessage(name);
            }
        });
        this.logMessage(Messages.JasperReportsProvider_8);
    }

    protected String getLogPrefix() {
        return PREFIX;
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_JASPER_CREATE_REPORT).hasArg().argName(Messages.JasperReportsProvider_9).desc(Messages.JasperReportsProvider_10).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_JASPER_FILENAME).hasArg().argName(Messages.JasperReportsProvider_11).desc(Messages.JasperReportsProvider_12).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_JASPER_TITLE).hasArg().argName(Messages.JasperReportsProvider_13).desc(Messages.JasperReportsProvider_14).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_JASPER_TEMPLATE).hasArg().argName("main.jrxml").desc(Messages.JasperReportsProvider_15).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_JASPER_LOCALE).hasArg().argName(Messages.JasperReportsProvider_16).desc(Messages.JasperReportsProvider_17).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_JASPER_FORMAT).hasArg().argName(Messages.JasperReportsProvider_18).desc(Messages.JasperReportsProvider_19).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_JASPER_CREATE_REPORT);
    }
}

