/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class XMLExchangePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.opengroup.archimate.xmlexchange";
    public static final String XSD_FOLDER = "xsd/";
    public static final String ARCHIMATE3_DIAGRAM_XSD = "archimate3_Diagram.xsd";
    public static final String ARCHIMATE3_MODEL_XSD = "archimate3_Model.xsd";
    public static final String ARCHIMATE3_VIEW_XSD = "archimate3_View.xsd";
    public static final String DUBLINCORE_XSD = "dc.xsd";
    public static final String XML_XSD = "xml.xsd";
    private static XMLExchangePlugin instance;

    public static XMLExchangePlugin getInstance() {
        return instance;
    }

    public XMLExchangePlugin() {
        instance = this;
    }

    public void copyXSDFile(String xsdFile, File outputFile) throws IOException {
        InputStream in = this.getBundleInputStream(XSD_FOLDER + xsdFile);
        Files.copy(in, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        in.close();
    }

    public InputStream getBundleInputStream(String bundleFileName) throws IOException {
        URL url = this.getBundle().getEntry(bundleFileName);
        return url.openStream();
    }
}

