/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public final class XMLExchangeUtils {
    public static final Point getNegativeOffsetForDiagram(IDiagramModel dm) {
        Point extremePoint = new Point();
        for (IDiagramModelObject dmo : dm.getChildren()) {
            IBounds bounds = dmo.getBounds().getCopy();
            extremePoint.x = Math.min(bounds.getX(), extremePoint.x);
            extremePoint.y = Math.min(bounds.getY(), extremePoint.y);
            TreeIterator iter = dmo.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelConnection)) continue;
                IDiagramModelConnection connection = (IDiagramModelConnection)eObject;
                List points = DiagramModelUtils.getAbsoluteBendpointPositions((IDiagramModelConnection)connection);
                for (Point pt : points) {
                    extremePoint.x = Math.min(extremePoint.x, pt.x);
                    extremePoint.y = Math.min(extremePoint.y, pt.y);
                }
            }
        }
        return extremePoint;
    }
}

