/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.jdom.JDOMUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAccessRelationship;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IAssociationRelationship;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelNote;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IFontAttribute;
import com.archimatetool.model.IIdentifier;
import com.archimatetool.model.IInfluenceRelationship;
import com.archimatetool.model.ILineObject;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.UUIDFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.opengroup.archimate.xmlexchange.IXMLExchangeGlobals;
import org.opengroup.archimate.xmlexchange.XMLExchangePlugin;
import org.opengroup.archimate.xmlexchange.XMLExchangeUtils;
import org.opengroup.archimate.xmlexchange.XMLTypeMapper;

public class XMLModelExporter
implements IXMLExchangeGlobals {
    private IArchimateModel fModel;
    private Map<String, String> fPropertyDefsList;
    private Map<String, String> fMetadata;
    private boolean fDoSaveOrganisation;
    private boolean fIncludeXSD;
    private String fLanguageCode;
    private Point fCurrentDiagramNegativeOffset;

    public void exportModel(IArchimateModel model, File outputFile) throws IOException {
        this.fModel = model;
        Document doc = this.createDocument();
        Element rootElement = this.createRootElement(doc);
        this.writeModel(rootElement);
        JDOMUtils.write2XMLFile((Document)doc, (File)outputFile);
        if (this.fIncludeXSD) {
            File file1 = new File(outputFile.getParentFile(), "archimate3_Model.xsd");
            XMLExchangePlugin.getInstance().copyXSDFile("archimate3_Model.xsd", file1);
            File file2 = new File(outputFile.getParentFile(), "archimate3_View.xsd");
            XMLExchangePlugin.getInstance().copyXSDFile("archimate3_View.xsd", file2);
            File file3 = new File(outputFile.getParentFile(), "archimate3_Diagram.xsd");
            XMLExchangePlugin.getInstance().copyXSDFile("archimate3_Diagram.xsd", file3);
        }
    }

    public void setMetadata(Map<String, String> metadata) {
        this.fMetadata = metadata;
    }

    boolean hasMetadata() {
        if (this.fMetadata != null) {
            for (String value : this.fMetadata.values()) {
                if (!StringUtils.isSet((String)value)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSaveOrganisation(boolean set) {
        this.fDoSaveOrganisation = set;
    }

    public void setIncludeXSD(boolean set) {
        this.fIncludeXSD = set;
    }

    public void setLanguageCode(String languageCode) {
        this.fLanguageCode = languageCode;
    }

    Document createDocument() {
        return new Document();
    }

    Element createRootElement(Document doc) {
        Element rootElement = new Element("model", ARCHIMATE3_NAMESPACE);
        doc.setRootElement(rootElement);
        rootElement.addNamespaceDeclaration(JDOMUtils.XSI_Namespace);
        if (this.hasMetadata()) {
            rootElement.addNamespaceDeclaration(DC_NAMESPACE);
        }
        StringBuffer schemaLocationURI = new StringBuffer();
        schemaLocationURI.append(rootElement.getNamespace().getURI());
        schemaLocationURI.append(" ");
        schemaLocationURI.append("http://www.opengroup.org/xsd/archimate/3.1/archimate3_Diagram.xsd");
        if (this.hasMetadata()) {
            schemaLocationURI.append(" ");
            schemaLocationURI.append(DC_NAMESPACE.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append("http://www.opengroup.org/xsd/archimate/3.1/dc.xsd");
        }
        rootElement.setAttribute(JDOMUtils.XSI_SchemaLocation, schemaLocationURI.toString(), JDOMUtils.XSI_Namespace);
        return rootElement;
    }

    private void writeModel(Element rootElement) {
        rootElement.setAttribute("identifier", this.checkID((IIdentifier)this.fModel));
        this.fPropertyDefsList = this.getAllUniquePropertyKeysForModel();
        this.writeTextToElement(this.fModel.getName(), rootElement, "name", true);
        this.writeTextToElement(this.fModel.getPurpose(), rootElement, "documentation", false);
        this.writeProperties((IProperties)this.fModel, rootElement);
        this.writeMetadata(rootElement);
        this.writeModelElements(rootElement);
        this.writeModelRelationships(rootElement);
        if (this.fDoSaveOrganisation) {
            this.writeOrganizations(rootElement);
        }
        this.writeModelPropertiesDefinitions(rootElement);
        this.writeViews(rootElement);
    }

    Element writeMetadata(Element rootElement) {
        if (!this.hasMetadata()) {
            return null;
        }
        Element mdElement = new Element("metadata", ARCHIMATE3_NAMESPACE);
        rootElement.addContent((Content)mdElement);
        Element schemaElement = new Element("schema", ARCHIMATE3_NAMESPACE);
        schemaElement.setText("Dublin Core");
        mdElement.addContent((Content)schemaElement);
        Element schemaVersionElement = new Element("schemaversion", ARCHIMATE3_NAMESPACE);
        schemaVersionElement.setText("1.1");
        mdElement.addContent((Content)schemaVersionElement);
        for (Map.Entry<String, String> entry : this.fMetadata.entrySet()) {
            if (!StringUtils.isSet((String)entry.getKey()) || !StringUtils.isSet((String)entry.getValue())) continue;
            Element element = new Element(entry.getKey(), DC_NAMESPACE);
            element.setText(entry.getValue());
            mdElement.addContent((Content)element);
        }
        return null;
    }

    Element writeModelElements(Element rootElement) {
        Element elementsElement = new Element("elements", ARCHIMATE3_NAMESPACE);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.STRATEGY), elementsElement);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.BUSINESS), elementsElement);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.APPLICATION), elementsElement);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.TECHNOLOGY), elementsElement);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.MOTIVATION), elementsElement);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.IMPLEMENTATION_MIGRATION), elementsElement);
        this.writeModelElementsFolder(this.fModel.getFolder(FolderType.OTHER), elementsElement);
        if (!elementsElement.getChildren().isEmpty()) {
            rootElement.addContent((Content)elementsElement);
            return elementsElement;
        }
        return null;
    }

    private void writeModelElementsFolder(IFolder folder, Element elementsElement) {
        if (folder == null) {
            return;
        }
        ArrayList<EObject> list = new ArrayList<EObject>();
        this.getElements(folder, list);
        for (EObject eObject : list) {
            if (!(eObject instanceof IArchimateElement)) continue;
            this.writeModelElement((IArchimateElement)eObject, elementsElement);
        }
    }

    Element writeModelElement(IArchimateElement element, Element elementsElement) {
        Element elementElement = new Element("element", ARCHIMATE3_NAMESPACE);
        elementsElement.addContent((Content)elementElement);
        elementElement.setAttribute("identifier", this.checkID((IIdentifier)element));
        elementElement.setAttribute("type", XMLTypeMapper.getArchimateConceptName((IArchimateConcept)element), XSI_NAMESPACE);
        this.writeTextToElement(element.getName(), elementElement, "name", true);
        this.writeTextToElement(element.getDocumentation(), elementElement, "documentation", false);
        this.writeProperties((IProperties)element, elementElement);
        return elementElement;
    }

    private void getElements(IFolder folder, List<EObject> list) {
        if (folder == null) {
            return;
        }
        for (EObject object : folder.getElements()) {
            list.add(object);
        }
        for (IFolder f : folder.getFolders()) {
            this.getElements(f, list);
        }
    }

    Element writeModelRelationships(Element rootElement) {
        Element relationshipsElement = new Element("relationships", ARCHIMATE3_NAMESPACE);
        this.writeModelRelationshipsFolder(this.fModel.getFolder(FolderType.RELATIONS), relationshipsElement);
        if (!relationshipsElement.getChildren().isEmpty()) {
            rootElement.addContent((Content)relationshipsElement);
            return relationshipsElement;
        }
        return null;
    }

    private void writeModelRelationshipsFolder(IFolder folder, Element relationshipsElement) {
        if (folder == null) {
            return;
        }
        ArrayList<EObject> list = new ArrayList<EObject>();
        this.getElements(folder, list);
        for (EObject eObject : list) {
            if (!(eObject instanceof IArchimateRelationship)) continue;
            this.writeModelRelationship((IArchimateRelationship)eObject, relationshipsElement);
        }
    }

    Element writeModelRelationship(IArchimateRelationship relationship, Element relationshipsElement) {
        Element relationshipElement = new Element("relationship", ARCHIMATE3_NAMESPACE);
        relationshipsElement.addContent((Content)relationshipElement);
        relationshipElement.setAttribute("identifier", this.checkID((IIdentifier)relationship));
        relationshipElement.setAttribute("source", this.checkID((IIdentifier)relationship.getSource()));
        relationshipElement.setAttribute("target", this.checkID((IIdentifier)relationship.getTarget()));
        relationshipElement.setAttribute("type", XMLTypeMapper.getArchimateConceptName((IArchimateConcept)relationship), JDOMUtils.XSI_Namespace);
        if (relationship.eClass() == IArchimatePackage.eINSTANCE.getInfluenceRelationship()) {
            String strength = ((IInfluenceRelationship)relationship).getStrength();
            if (this.hasSomeText(strength)) {
                relationshipElement.setAttribute("modifier", strength);
            }
        } else if (relationship.eClass() == IArchimatePackage.eINSTANCE.getAccessRelationship()) {
            int accessType = ((IAccessRelationship)relationship).getAccessType();
            switch (accessType) {
                case 1: {
                    relationshipElement.setAttribute("accessType", "Read");
                    break;
                }
                case 3: {
                    relationshipElement.setAttribute("accessType", "ReadWrite");
                    break;
                }
                case 2: {
                    relationshipElement.setAttribute("accessType", "Access");
                    break;
                }
                default: {
                    relationshipElement.setAttribute("accessType", "Write");
                    break;
                }
            }
        } else if (relationship.eClass() == IArchimatePackage.eINSTANCE.getAssociationRelationship() && ((IAssociationRelationship)relationship).isDirected()) {
            relationshipElement.setAttribute("isDirected", "true");
        }
        this.writeTextToElement(relationship.getName(), relationshipElement, "name", false);
        this.writeTextToElement(relationship.getDocumentation(), relationshipElement, "documentation", false);
        this.writeProperties((IProperties)relationship, relationshipElement);
        return relationshipElement;
    }

    Element writeOrganizations(Element rootElement) {
        Element organizationsElement = new Element("organizations", ARCHIMATE3_NAMESPACE);
        for (IFolder folder : this.fModel.getFolders()) {
            if (folder.getElements().isEmpty() && folder.getFolders().isEmpty()) continue;
            this.writeFolder(folder, organizationsElement);
        }
        if (!organizationsElement.getChildren().isEmpty()) {
            rootElement.addContent((Content)organizationsElement);
            return organizationsElement;
        }
        return null;
    }

    Element writeFolder(IFolder folder, Element parentElement) {
        Element itemElement = new Element("item", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)itemElement);
        this.writeTextToElement(folder.getName(), itemElement, "label", false);
        this.writeTextToElement(folder.getDocumentation(), itemElement, "documentation", false);
        for (IFolder subFolder : folder.getFolders()) {
            this.writeFolder(subFolder, itemElement);
        }
        for (EObject eObject : folder.getElements()) {
            if (!(eObject instanceof IIdentifier) || eObject instanceof IDiagramModel && !(eObject instanceof IArchimateDiagramModel)) continue;
            IIdentifier component = (IIdentifier)eObject;
            Element itemChildElement = new Element("item", ARCHIMATE3_NAMESPACE);
            itemElement.addContent((Content)itemChildElement);
            itemChildElement.setAttribute("identifierRef", this.checkID(component));
        }
        return itemElement;
    }

    Element writeModelPropertiesDefinitions(Element rootElement) {
        if (this.fPropertyDefsList.isEmpty()) {
            return null;
        }
        Element propertiesDefinitionsElement = new Element("propertyDefinitions", ARCHIMATE3_NAMESPACE);
        rootElement.addContent((Content)propertiesDefinitionsElement);
        for (Map.Entry<String, String> entry : this.fPropertyDefsList.entrySet()) {
            Element propertyDefElement = new Element("propertyDefinition", ARCHIMATE3_NAMESPACE);
            propertiesDefinitionsElement.addContent((Content)propertyDefElement);
            propertyDefElement.setAttribute("identifier", entry.getValue());
            propertyDefElement.setAttribute("type", "string");
            Element propertyNameElement = new Element("name", ARCHIMATE3_NAMESPACE);
            propertyNameElement.setText(entry.getKey());
            propertyDefElement.addContent((Content)propertyNameElement);
        }
        return propertiesDefinitionsElement;
    }

    Map<String, String> getAllUniquePropertyKeysForModel() {
        TreeMap<String, String> list = new TreeMap<String, String>();
        String id = "propid-";
        int idCount = 1;
        TreeIterator iter = this.fModel.eAllContents();
        while (iter.hasNext()) {
            String name;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IProperty) || (name = ((IProperty)element).getKey()) == null || list.containsKey(name)) continue;
            list.put(name, id + idCount++);
        }
        return list;
    }

    Element writeProperties(IProperties properties, Element parentElement) {
        Element propertiesElement = new Element("properties", ARCHIMATE3_NAMESPACE);
        for (IProperty property : properties.getProperties()) {
            String propertyRefID;
            String name = property.getKey();
            String value = property.getValue();
            if (!this.hasSomeText(name) || (propertyRefID = this.fPropertyDefsList.get(name)) == null) continue;
            this.writePropertyValue(propertiesElement, propertyRefID, value);
        }
        if (propertiesElement.getChildren().size() > 0) {
            parentElement.addContent((Content)propertiesElement);
        }
        return propertiesElement;
    }

    Element writePropertyValue(Element propertiesElement, String propertyRefID, String propertyValue) {
        Element propertyElement = new Element("property", ARCHIMATE3_NAMESPACE);
        propertiesElement.addContent((Content)propertyElement);
        propertyElement.setAttribute("propertyDefinitionRef", propertyRefID);
        Element valueElement = new Element("value", ARCHIMATE3_NAMESPACE);
        propertyElement.addContent((Content)valueElement);
        this.writeElementTextWithLanguageCode(valueElement, propertyValue);
        return propertyElement;
    }

    Element writeViews(Element rootElement) {
        EList views = this.fModel.getDiagramModels();
        if (views.isEmpty()) {
            return null;
        }
        Element viewsElement = new Element("views", ARCHIMATE3_NAMESPACE);
        rootElement.addContent((Content)viewsElement);
        Element diagramsElement = new Element("diagrams", ARCHIMATE3_NAMESPACE);
        viewsElement.addContent((Content)diagramsElement);
        for (IDiagramModel dm : views) {
            if (!(dm instanceof IArchimateDiagramModel)) continue;
            this.fCurrentDiagramNegativeOffset = XMLExchangeUtils.getNegativeOffsetForDiagram(dm);
            this.writeView((IArchimateDiagramModel)dm, diagramsElement);
        }
        return viewsElement;
    }

    Element writeView(IArchimateDiagramModel dm, Element viewsElement) {
        Element viewElement = new Element("view", ARCHIMATE3_NAMESPACE);
        viewsElement.addContent((Content)viewElement);
        viewElement.setAttribute("identifier", this.checkID((IIdentifier)dm));
        viewElement.setAttribute("type", "Diagram", XSI_NAMESPACE);
        String viewPointName = XMLTypeMapper.getViewpointName(dm.getViewpoint());
        if (StringUtils.isSet((String)viewPointName)) {
            viewElement.setAttribute("viewpoint", viewPointName);
        }
        this.writeTextToElement(dm.getName(), viewElement, "name", true);
        this.writeTextToElement(dm.getDocumentation(), viewElement, "documentation", false);
        this.writeProperties((IProperties)dm, viewElement);
        this.writeNodes((IDiagramModel)dm, viewElement);
        this.writeConnections((IDiagramModel)dm, viewElement);
        return viewElement;
    }

    void writeNodes(IDiagramModel dm, Element viewElement) {
        for (IDiagramModelObject child : dm.getChildren()) {
            this.writeNode(child, viewElement);
        }
    }

    void writeNode(IDiagramModelObject dmo, Element parentElement) {
        if (dmo instanceof IDiagramModelArchimateObject) {
            this.writeArchimateNode((IDiagramModelArchimateObject)dmo, parentElement);
        } else if (dmo instanceof IDiagramModelGroup) {
            this.writeGroupNode((IDiagramModelGroup)dmo, parentElement);
        } else if (dmo instanceof IDiagramModelNote) {
            this.writeNoteNode((IDiagramModelNote)dmo, parentElement);
        } else if (dmo instanceof IDiagramModelReference) {
            this.writeViewReferenceNode((IDiagramModelReference)dmo, parentElement);
        }
    }

    Element writeArchimateNode(IDiagramModelArchimateObject dmo, Element parentElement) {
        Element nodeElement = new Element("node", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)nodeElement);
        nodeElement.setAttribute("identifier", this.checkID((IIdentifier)dmo));
        IArchimateElement element = dmo.getArchimateElement();
        nodeElement.setAttribute("elementRef", this.checkID((IIdentifier)element));
        nodeElement.setAttribute("type", "Element", XSI_NAMESPACE);
        this.writeAbsoluteBounds((IDiagramModelObject)dmo, nodeElement);
        this.writeNodeStyle((IDiagramModelObject)dmo, nodeElement);
        for (IDiagramModelObject child : dmo.getChildren()) {
            this.writeNode(child, nodeElement);
        }
        return nodeElement;
    }

    Element writeGroupNode(IDiagramModelGroup group, Element parentElement) {
        Element nodeElement = new Element("node", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)nodeElement);
        nodeElement.setAttribute("identifier", this.checkID((IIdentifier)group));
        this.writeAbsoluteBounds((IDiagramModelObject)group, nodeElement);
        nodeElement.setAttribute("type", "Container", XSI_NAMESPACE);
        this.writeTextToElement(group.getName(), nodeElement, "label", false);
        this.writeTextToElement(group.getDocumentation(), nodeElement, "documentation", false);
        this.writeNodeStyle((IDiagramModelObject)group, nodeElement);
        for (IDiagramModelObject child : group.getChildren()) {
            this.writeNode(child, nodeElement);
        }
        return nodeElement;
    }

    Element writeNoteNode(IDiagramModelNote note, Element parentElement) {
        Element nodeElement = new Element("node", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)nodeElement);
        nodeElement.setAttribute("identifier", this.checkID((IIdentifier)note));
        nodeElement.setAttribute("type", "Label", XSI_NAMESPACE);
        this.writeAbsoluteBounds((IDiagramModelObject)note, nodeElement);
        this.writeTextToElement(note.getContent(), nodeElement, "label", false);
        this.writeNodeStyle((IDiagramModelObject)note, nodeElement);
        return nodeElement;
    }

    Element writeViewReferenceNode(IDiagramModelReference ref, Element parentElement) {
        Element nodeElement = new Element("node", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)nodeElement);
        nodeElement.setAttribute("identifier", this.checkID((IIdentifier)ref));
        nodeElement.setAttribute("type", "Label", XSI_NAMESPACE);
        this.writeAbsoluteBounds((IDiagramModelObject)ref, nodeElement);
        this.writeTextToElement(ref.getName(), nodeElement, "label", false);
        this.writeNodeStyle((IDiagramModelObject)ref, nodeElement);
        if (ref.getReferencedModel() instanceof IArchimateDiagramModel) {
            Element viewRefElement = new Element("viewRef", ARCHIMATE3_NAMESPACE);
            viewRefElement.setAttribute("ref", this.checkID((IIdentifier)ref.getReferencedModel()));
            nodeElement.addContent((Content)viewRefElement);
        }
        return nodeElement;
    }

    Element writeNodeStyle(IDiagramModelObject dmo, Element nodeElement) {
        Element styleElement = new Element("style", ARCHIMATE3_NAMESPACE);
        nodeElement.addContent((Content)styleElement);
        this.writeFillColor(dmo, styleElement);
        this.writeLineColor((ILineObject)dmo, styleElement);
        this.writeFont((IFontAttribute)dmo, styleElement);
        return styleElement;
    }

    Element writeFillColor(IDiagramModelObject dmo, Element parentElement) {
        Color color;
        Element fillColorElement = null;
        RGB rgb = ColorFactory.convertStringToRGB((String)dmo.getFillColor());
        if (rgb == null && (color = ColorFactory.getDefaultFillColor((Object)dmo)) != null) {
            rgb = color.getRGB();
        }
        if (rgb != null) {
            fillColorElement = new Element("fillColor", ARCHIMATE3_NAMESPACE);
            parentElement.addContent((Content)fillColorElement);
            this.writeRGBAttributes(rgb, dmo.getAlpha(), fillColorElement);
        }
        return fillColorElement;
    }

    void writeConnections(IDiagramModel dm, Element parentElement) {
        TreeIterator iter = dm.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof IDiagramModelArchimateConnection) {
                if (this.isNestedConnection((IDiagramModelArchimateConnection)eObject)) continue;
                this.writeConnection((IDiagramModelConnection)eObject, parentElement);
                continue;
            }
            if (!(eObject instanceof IDiagramModelConnection)) continue;
            this.writeConnection((IDiagramModelConnection)eObject, parentElement);
        }
    }

    boolean isNestedConnection(IDiagramModelArchimateConnection connection) {
        if (connection.getSource() instanceof IDiagramModelArchimateObject && connection.getTarget() instanceof IDiagramModelArchimateObject) {
            IDiagramModelArchimateObject src = (IDiagramModelArchimateObject)connection.getSource();
            IDiagramModelArchimateObject tgt = (IDiagramModelArchimateObject)connection.getTarget();
            return src.getChildren().contains((Object)tgt) || tgt.getChildren().contains((Object)src);
        }
        return false;
    }

    Element writeConnection(IDiagramModelConnection connection, Element parentElement) {
        Element connectionElement = new Element("connection", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)connectionElement);
        connectionElement.setAttribute("identifier", this.checkID((IIdentifier)connection));
        if (connection instanceof IDiagramModelArchimateConnection) {
            connectionElement.setAttribute("relationshipRef", this.checkID((IIdentifier)((IDiagramModelArchimateConnection)connection).getArchimateRelationship()));
            connectionElement.setAttribute("type", "Relationship", XSI_NAMESPACE);
        } else {
            connectionElement.setAttribute("type", "Line", XSI_NAMESPACE);
        }
        connectionElement.setAttribute("source", this.checkID((IIdentifier)connection.getSource()));
        connectionElement.setAttribute("target", this.checkID((IIdentifier)connection.getTarget()));
        this.writeConnectionStyle(connection, connectionElement);
        this.writeConnectionBendpoints(connection, connectionElement);
        return connectionElement;
    }

    void writeConnectionBendpoints(IDiagramModelConnection connection, Element connectionElement) {
        if (connection.getSource() instanceof IDiagramModelConnection || connection.getTarget() instanceof IDiagramModelConnection) {
            return;
        }
        List points = DiagramModelUtils.getAbsoluteBendpointPositions((IDiagramModelConnection)connection);
        for (Point pt : points) {
            Element bendpointElement = new Element("bendpoint", ARCHIMATE3_NAMESPACE);
            connectionElement.addContent((Content)bendpointElement);
            pt.x -= this.fCurrentDiagramNegativeOffset.x;
            pt.y -= this.fCurrentDiagramNegativeOffset.y;
            bendpointElement.setAttribute("x", Integer.toString(pt.x));
            bendpointElement.setAttribute("y", Integer.toString(pt.y));
        }
    }

    Element writeConnectionStyle(IDiagramModelConnection connection, Element parentElement) {
        Element styleElement = new Element("style", ARCHIMATE3_NAMESPACE);
        parentElement.addContent((Content)styleElement);
        int lineWidth = connection.getLineWidth();
        if (lineWidth != 1) {
            styleElement.setAttribute("lineWidth", Integer.toString(lineWidth));
        }
        this.writeLineColor((ILineObject)connection, styleElement);
        this.writeFont((IFontAttribute)connection, styleElement);
        return styleElement;
    }

    Element writeLineColor(ILineObject lineObject, Element parentElement) {
        Color color;
        Element lineColorElement = null;
        RGB rgb = ColorFactory.convertStringToRGB((String)lineObject.getLineColor());
        if (rgb == null && (color = ColorFactory.getDefaultLineColor((Object)lineObject)) != null) {
            rgb = color.getRGB();
        }
        if (rgb != null) {
            lineColorElement = new Element("lineColor", ARCHIMATE3_NAMESPACE);
            parentElement.addContent((Content)lineColorElement);
            if (lineObject instanceof IDiagramModelObject) {
                this.writeRGBAttributes(rgb, ((IDiagramModelObject)lineObject).getLineAlpha(), lineColorElement);
            } else {
                this.writeRGBAttributes(rgb, -1, lineColorElement);
            }
        }
        return lineColorElement;
    }

    Element writeFont(IFontAttribute fontObject, Element styleElement) {
        Element fontElement = new Element("font", ARCHIMATE3_NAMESPACE);
        try {
            FontData fontData = null;
            String fontString = fontObject.getFont();
            fontData = fontString != null ? new FontData(fontString) : FontFactory.getDefaultUserViewFontData();
            fontElement.setAttribute("name", fontData.getName());
            fontElement.setAttribute("size", Integer.toString(fontData.getHeight()));
            int style = fontData.getStyle();
            Object styleString = "";
            if ((style & 1) == 1) {
                styleString = (String)styleString + "bold";
            }
            if ((style & 2) == 2) {
                if (StringUtils.isSet((String)styleString)) {
                    styleString = (String)styleString + " ";
                }
                styleString = (String)styleString + "italic";
            }
            if (this.hasSomeText((String)styleString)) {
                fontElement.setAttribute("style", (String)styleString);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String fontColorString = fontObject.getFontColor();
        RGB rgb = ColorFactory.convertStringToRGB((String)fontColorString);
        Element fontColorElement = new Element("color", ARCHIMATE3_NAMESPACE);
        fontElement.addContent((Content)fontColorElement);
        this.writeRGBAttributes(rgb, -1, fontColorElement);
        if (this.hasElementContent(fontElement)) {
            styleElement.addContent((Content)fontElement);
        }
        return fontElement;
    }

    void writeRGBAttributes(RGB rgb, int alpha, Element colorElement) {
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        colorElement.setAttribute("r", Integer.toString(rgb.red));
        colorElement.setAttribute("g", Integer.toString(rgb.green));
        colorElement.setAttribute("b", Integer.toString(rgb.blue));
        if (alpha != -1) {
            int newValue = Math.round((float)alpha / 255.0f * 100.0f);
            colorElement.setAttribute("a", Integer.toString(newValue));
        }
    }

    void writeAbsoluteBounds(IDiagramModelObject dmo, Element element) {
        IBounds bounds = DiagramModelUtils.getAbsoluteBounds((IDiagramModelObject)dmo);
        int x = bounds.getX() - this.fCurrentDiagramNegativeOffset.x;
        int y = bounds.getY() - this.fCurrentDiagramNegativeOffset.y;
        element.setAttribute("x", Integer.toString(x));
        element.setAttribute("y", Integer.toString(y));
        element.setAttribute("w", Integer.toString(bounds.getWidth()));
        element.setAttribute("h", Integer.toString(bounds.getHeight()));
    }

    Element writeTextToElement(String text, Element parentElement, String childElementName, boolean mandatory) {
        if (text == null) {
            text = "";
        }
        Element element = null;
        if (mandatory || this.hasSomeText(text)) {
            element = new Element(childElementName, ARCHIMATE3_NAMESPACE);
            parentElement.addContent((Content)element);
            this.writeElementTextWithLanguageCode(element, text);
        }
        return element;
    }

    private void writeElementTextWithLanguageCode(Element element, String text) {
        element.setText(text);
        if (this.fLanguageCode != null) {
            element.setAttribute("lang", this.fLanguageCode, Namespace.XML_NAMESPACE);
        }
    }

    private boolean hasSomeText(String string) {
        return string != null && !string.isEmpty();
    }

    private boolean hasElementContent(Element element) {
        return element != null && (element.hasAttributes() || !element.getChildren().isEmpty());
    }

    private String checkID(IIdentifier identifier) {
        Object id = identifier.getId();
        if (id == null) {
            id = UUIDFactory.createID((IIdentifier)identifier);
        }
        if (Character.isDigit(((String)id).charAt(0))) {
            id = "id-" + (String)id;
        }
        return id;
    }
}

