/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengroup.archimate.xmlexchange.XMLExchangePlugin;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class XMLValidator {
    public void validateXML(File xmlInstance) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new ResourceResolver());
        Schema schema = factory.newSchema(new Source[]{new StreamSource(XMLExchangePlugin.getInstance().getBundleInputStream("xsd/archimate3_Diagram.xsd")), new StreamSource(XMLExchangePlugin.getInstance().getBundleInputStream("xsd/dc.xsd"))});
        Validator validator = schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try (FileInputStream in = new FileInputStream(xmlInstance);){
            try {
                validator.validate(new StreamSource(in));
            }
            catch (SAXException ex) {
                if (!ex.getMessage().contains("The matching wildcard is strict, but no declaration can be found")) {
                    throw ex;
                }
                in.close();
            }
        }
    }

    static class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }

    static class ResourceResolver
    implements LSResourceResolver {
        ResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            if ("http://www.w3.org/2001/xml.xsd".equals(systemId)) {
                try {
                    InputStream is = XMLExchangePlugin.getInstance().getBundleInputStream("xsd/xml.xsd");
                    return new Input(publicId, systemId, is);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if ("archimate3_View.xsd".equals(systemId) || "archimate3_Model.xsd".equals(systemId)) {
                try {
                    InputStream is = XMLExchangePlugin.getInstance().getBundleInputStream("xsd/" + systemId);
                    return new Input(publicId, systemId, is);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }
    }
}

