/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.reports.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.reports.commandline.Messages;
import com.archimatetool.reports.html.HTMLReportExporter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class HTMLReportProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.HTMLReportProvider_0;
    static final String OPTION_CREATE_HTML_REPORT = "html.createReport";

    public void run(CommandLine commandLine) throws Exception {
        if (!this.hasCorrectOptions(commandLine)) {
            return;
        }
        String sOutput = commandLine.getOptionValue(OPTION_CREATE_HTML_REPORT);
        if (!StringUtils.isSet((String)sOutput)) {
            this.logError(Messages.HTMLReportProvider_1);
            return;
        }
        File folderOutput = new File(sOutput);
        folderOutput.mkdirs();
        if (!folderOutput.exists()) {
            this.logError(NLS.bind((String)Messages.HTMLReportProvider_2, (Object)sOutput));
            return;
        }
        IArchimateModel model = CommandLineState.getModel();
        if (model == null) {
            throw new IOException(Messages.HTMLReportProvider_3);
        }
        this.logMessage(NLS.bind((String)Messages.HTMLReportProvider_4, (Object)model.getName(), (Object)sOutput));
        HTMLReportExporter ex = new HTMLReportExporter(model);
        ex.createReport(folderOutput, "index.html", (IProgressMonitor)new NullProgressMonitor(){

            public void subTask(String name) {
                HTMLReportProvider.this.logMessage(name);
            }
        });
        this.logMessage(Messages.HTMLReportProvider_5);
    }

    protected String getLogPrefix() {
        return PREFIX;
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_CREATE_HTML_REPORT).hasArg().argName(Messages.HTMLReportProvider_6).desc(Messages.HTMLReportProvider_7).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_CREATE_HTML_REPORT);
    }
}

