/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.csv.commandline.Messages;
import com.archimatetool.csv.importer.CSVImporter;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.osgi.util.NLS;

public class ImportCSVProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.ImportCSVProvider_0;
    static final String OPTION_IMPORT_CSV = "csv.import";

    public void run(CommandLine commandLine) throws Exception {
        if (!this.hasCorrectOptions(commandLine)) {
            return;
        }
        IArchimateModel model = CommandLineState.getModel();
        if (model == null) {
            throw new IOException(Messages.ImportCSVProvider_1);
        }
        String value = commandLine.getOptionValue(OPTION_IMPORT_CSV);
        if (!StringUtils.isSet((String)value)) {
            this.logError(Messages.ImportCSVProvider_2);
            return;
        }
        File csvFile = new File(value);
        if (!csvFile.exists()) {
            this.logError(NLS.bind((String)Messages.ImportCSVProvider_3, (Object)value));
            return;
        }
        this.logMessage(NLS.bind((String)Messages.ImportCSVProvider_4, (Object)csvFile.getPath(), (Object)model.getName()));
        CSVImporter importer = new CSVImporter(model);
        importer.doImport(csvFile);
        this.logMessage(Messages.ImportCSVProvider_5);
    }

    protected String getLogPrefix() {
        return PREFIX;
    }

    public int getPriority() {
        return 20;
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_IMPORT_CSV).hasArg().argName(Messages.ImportCSVProvider_6).desc(Messages.ImportCSVProvider_7).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_IMPORT_CSV);
    }
}

