/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.validation.issues.WarningType;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimatePackage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class DuplicateElementChecker
implements IChecker {
    final String NAME = Messages.DuplicateElementChecker_0;
    final String DESCRIPTION = Messages.DuplicateElementChecker_1;
    final String EXPLANATION = Messages.DuplicateElementChecker_2;
    private List<IArchimateElement> fArchimateElements;

    public DuplicateElementChecker(List<IArchimateElement> archimateElements) {
        this.fArchimateElements = archimateElements;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findDuplicateNamesElements();
    }

    List<IIssue> findDuplicateNamesElements() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        LinkedHashSet<IArchimateElement> dupes = new LinkedHashSet<IArchimateElement>();
        int i = 0;
        while (i < this.fArchimateElements.size()) {
            int j = i + 1;
            while (j < this.fArchimateElements.size()) {
                IArchimateElement element2;
                IArchimateElement element1 = this.fArchimateElements.get(i);
                if (this.isDuplicate(element1, element2 = this.fArchimateElements.get(j))) {
                    dupes.add(element1);
                    dupes.add(element2);
                }
                ++j;
            }
            ++i;
        }
        for (IArchimateElement element : dupes) {
            String description = NLS.bind((String)this.DESCRIPTION, (Object[])new Object[]{element.getName(), ArchiLabelProvider.INSTANCE.getDefaultName(element.eClass())});
            WarningType issue = new WarningType(this.NAME, description, this.EXPLANATION, element);
            issues.add(issue);
        }
        return issues;
    }

    private boolean isDuplicate(IArchimateElement element1, IArchimateElement element2) {
        String name2;
        if (element1.eClass() == IArchimatePackage.eINSTANCE.getJunction() && element2.eClass() == IArchimatePackage.eINSTANCE.getJunction()) {
            return false;
        }
        String name1 = StringUtils.safeString((String)element1.getName());
        return name1.equals(name2 = StringUtils.safeString((String)element2.getName())) && element1.eClass() == element2.eClass();
    }
}

