/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.ErrorType;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;

public class InvalidRelationsChecker
implements IChecker {
    final String fName = Messages.InvalidRelationsChecker_0;
    final String fDescription = Messages.InvalidRelationsChecker_1;
    final String fExplanation = Messages.InvalidRelationsChecker_2 + Messages.InvalidRelationsChecker_3;
    private List<IArchimateRelationship> fRelations;

    public InvalidRelationsChecker(List<IArchimateRelationship> relations) {
        this.fRelations = relations;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findInvalidRelations();
    }

    List<IIssue> findInvalidRelations() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        for (IArchimateRelationship relation : this.fRelations) {
            boolean valid = ArchimateModelUtils.isValidRelationship((IArchimateConcept)relation.getSource(), (IArchimateConcept)relation.getTarget(), (EClass)relation.eClass());
            if (valid) continue;
            String className = ArchiLabelProvider.INSTANCE.getDefaultName(relation.eClass());
            String description = NLS.bind((String)this.fDescription, (Object[])new Object[]{className, ArchiLabelProvider.INSTANCE.getLabel((Object)relation.getSource()), ArchiLabelProvider.INSTANCE.getLabel((Object)relation.getTarget())});
            String explanation = NLS.bind((String)this.fExplanation, (Object[])new Object[]{className, ArchiLabelProvider.INSTANCE.getDefaultName(relation.getSource().eClass()), ArchiLabelProvider.INSTANCE.getDefaultName(relation.getTarget().eClass())});
            ErrorType issue = new ErrorType(this.fName, description, explanation, relation);
            issues.add(issue);
        }
        return issues;
    }
}

