/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.ErrorType;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class JunctionsChecker
implements IChecker {
    final String NAME = Messages.JunctionsChecker_0;
    final String DESCRIPTION = Messages.JunctionsChecker_1;
    final String EXPLANATION = Messages.JunctionsChecker_2;
    private List<IArchimateElement> fArchimateElements;

    public JunctionsChecker(List<IArchimateElement> archimateElements) {
        this.fArchimateElements = archimateElements;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findBogusJunctions();
    }

    List<IIssue> findBogusJunctions() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        block0: for (IArchimateElement element : this.fArchimateElements) {
            if (!(element instanceof IJunction)) continue;
            IArchimateRelationship rel = null;
            for (IArchimateRelationship relation : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)element)) {
                if (rel != null && rel.eClass() != relation.eClass()) {
                    String name = ArchiLabelProvider.INSTANCE.getLabel((Object)element);
                    String description = NLS.bind((String)this.DESCRIPTION, (Object)name);
                    String explanation = NLS.bind((String)this.EXPLANATION, (Object)name);
                    ErrorType issue = new ErrorType(this.NAME, description, explanation, element);
                    issues.add(issue);
                    continue block0;
                }
                rel = relation;
            }
        }
        return issues;
    }
}

