/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.AdviceType;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.model.IAccessRelationship;
import com.archimatetool.model.IAggregationRelationship;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IAssignmentRelationship;
import com.archimatetool.model.ICompositionRelationship;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.IRealizationRelationship;
import com.archimatetool.model.ISpecializationRelationship;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class NestedElementsChecker
implements IChecker {
    final String fName = Messages.NestedElementsChecker_0;
    final String fDescription = Messages.NestedElementsChecker_1;
    final String fExplanation = Messages.NestedElementsChecker_2 + Messages.NestedElementsChecker_3;
    private List<IArchimateDiagramModel> fViews;

    public NestedElementsChecker(List<IArchimateDiagramModel> views) {
        this.fViews = views;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findWrongNestedElements();
    }

    List<IIssue> findWrongNestedElements() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        for (IArchimateDiagramModel dm : this.fViews) {
            TreeIterator iter = dm.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelArchimateObject)) continue;
                IDiagramModelArchimateObject parent = (IDiagramModelArchimateObject)eObject;
                for (IDiagramModelObject dmoChild : parent.getChildren()) {
                    IDiagramModelArchimateObject child;
                    if (!(dmoChild instanceof IDiagramModelArchimateObject) || !this.isNestedWithoutValidRelation(parent, child = (IDiagramModelArchimateObject)dmoChild)) continue;
                    String description = NLS.bind((String)this.fDescription, (Object[])new Object[]{child.getName(), parent.getName()});
                    AdviceType issue = new AdviceType(this.fName, description, this.fExplanation, child);
                    issues.add(issue);
                }
            }
        }
        return issues;
    }

    private boolean isNestedWithoutValidRelation(IDiagramModelArchimateObject parent, IDiagramModelArchimateObject child) {
        IArchimateElement parentElement = parent.getArchimateElement();
        IArchimateElement childElement = child.getArchimateElement();
        if (childElement instanceof IJunction) {
            return false;
        }
        ArrayList connections = new ArrayList(parent.getSourceConnections());
        connections.addAll(parent.getTargetConnections());
        for (IDiagramModelConnection connection : connections) {
            if (!(connection instanceof IDiagramModelArchimateConnection) || connection.getSource() != child && connection.getTarget() != child) continue;
            IArchimateRelationship relation = ((IDiagramModelArchimateConnection)connection).getArchimateRelationship();
            if (!this.isNestedTypeRelationship(relation)) {
                return true;
            }
            if (!(relation instanceof ISpecializationRelationship ? relation.getTarget() == childElement : relation.getSource() == childElement && this.isNestedTypeRelationship(relation))) continue;
            return true;
        }
        for (IArchimateRelationship relation : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)parentElement)) {
            if (relation.getTarget() != childElement && relation.getSource() != childElement || !this.isNestedTypeRelationship(relation)) continue;
            return false;
        }
        return true;
    }

    private boolean isNestedTypeRelationship(IArchimateRelationship relation) {
        return relation instanceof ICompositionRelationship || relation instanceof ISpecializationRelationship || relation instanceof IAggregationRelationship || relation instanceof IAssignmentRelationship || relation instanceof IRealizationRelationship || relation instanceof IAccessRelationship;
    }
}

