/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.validation.checkers;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.checkers.IChecker;
import com.archimatetool.hammer.validation.checkers.Messages;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.validation.issues.WarningType;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class ViewpointChecker
implements IChecker {
    final String fName = Messages.ViewpointChecker_0;
    final String fDescription = Messages.ViewpointChecker_1;
    final String fExplanation = Messages.ViewpointChecker_2 + Messages.ViewpointChecker_3;
    private List<IArchimateDiagramModel> fViews;

    public ViewpointChecker(List<IArchimateDiagramModel> views) {
        this.fViews = views;
    }

    @Override
    public List<IIssue> getIssues() {
        return this.findComponentsInWrongViewpoints();
    }

    List<IIssue> findComponentsInWrongViewpoints() {
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        for (IArchimateDiagramModel dm : this.fViews) {
            String id = dm.getViewpoint();
            IViewpoint viewPoint = ViewpointManager.INSTANCE.getViewpoint(id);
            TreeIterator iter = dm.eAllContents();
            while (iter.hasNext()) {
                IDiagramModelArchimateObject dmo;
                IArchimateElement element;
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelArchimateObject) || viewPoint.isAllowedConcept((element = (dmo = (IDiagramModelArchimateObject)eObject).getArchimateElement()).eClass())) continue;
                IIssue issue = this.createIssue(dmo, dm.getName(), viewPoint.getName());
                issues.add(issue);
            }
        }
        return issues;
    }

    IIssue createIssue(Object object, String viewName, String viewpointName) {
        String type;
        String concept;
        String description = NLS.bind((String)this.fDescription, (Object[])new Object[]{ArchiLabelProvider.INSTANCE.getLabel(object), viewName, viewpointName});
        if (object instanceof IDiagramModelArchimateObject) {
            concept = ArchiLabelProvider.INSTANCE.getDefaultName(((IDiagramModelArchimateObject)object).getArchimateElement().eClass());
            type = Messages.ViewpointChecker_4;
        } else {
            concept = ArchiLabelProvider.INSTANCE.getDefaultName(((IDiagramModelArchimateConnection)object).getArchimateRelationship().eClass());
            type = Messages.ViewpointChecker_5;
        }
        String explanation = NLS.bind((String)this.fExplanation, (Object[])new Object[]{concept, viewpointName, type});
        return new WarningType(this.fName, description, explanation, object);
    }
}

