/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.view;

import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.hammer.IHammerImages;
import com.archimatetool.hammer.validation.Validator;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.view.IValidatorView;
import com.archimatetool.hammer.view.Messages;
import com.archimatetool.hammer.view.ValidatorViewer;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ValidatorView
extends ViewPart
implements IValidatorView,
ISelectionListener,
IContextProvider,
ITabbedPropertySheetPageContributor,
PropertyChangeListener {
    private ValidatorViewer fViewer;
    private IAction fActionValidate;
    private IAction fActionExplain;
    private IAction fActionSelectObjects;
    private IAction fActionShowPreferences;
    private IArchimateModel fModel;

    public void createPartControl(Composite parent) {
        Composite treeComp = new Composite(parent, 0);
        treeComp.setLayout((Layout)new TreeColumnLayout());
        treeComp.setLayoutData((Object)new GridData(1808));
        this.fViewer = new ValidatorViewer(treeComp, 0);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValidatorView.this.selectObjects((IStructuredSelection)event.getSelection());
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValidatorView.this.updateMenuItems((IStructuredSelection)event.getSelection());
            }
        });
        this.makeActions();
        this.registerGlobalActions();
        this.makeLocalToolBar();
        this.hookContextMenu();
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.validatorViewHelp");
        IEditorModelManager.INSTANCE.addPropertyChangeListener((PropertyChangeListener)this);
        this.selectionChanged(this.getSite().getWorkbenchWindow().getPartService().getActivePart(), this.getSite().getWorkbenchWindow().getSelectionService().getSelection());
        this.validateModel();
    }

    private void makeActions() {
        this.fActionValidate = new Action(Messages.ValidatorView_0){

            public void run() {
                ValidatorView.this.validateModel();
            }

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return IHammerImages.ImageFactory.getImageDescriptor("img/icon.png");
            }
        };
        this.fActionValidate.setEnabled(false);
        this.fActionExplain = new Action(Messages.ValidatorView_1){

            public void run() {
                ViewManager.showViewPart((String)"com.archimatetool.help.hintsView", (boolean)false);
            }

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return ResourceLocator.imageDescriptorFromBundle((String)"com.archimatetool.help", (String)"img/hint.png").orElse(null);
            }
        };
        this.fActionExplain.setEnabled(false);
        this.fActionSelectObjects = new Action(Messages.ValidatorView_2){

            public void run() {
                ValidatorView.this.selectObjects((IStructuredSelection)ValidatorView.this.getViewer().getSelection());
            }

            public String getToolTipText() {
                return this.getText();
            }
        };
        this.fActionShowPreferences = new Action(Messages.ValidatorView_4){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)ValidatorView.this.getSite().getShell(), (String)"com.archimatetool.hammer.preferences.ValidatorPreferencePage", null, null);
                dialog.open();
            }

            public String getToolTipText() {
                return this.getText();
            }
        };
    }

    private void registerGlobalActions() {
    }

    private void makeLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add(this.fActionValidate);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionExplain);
        IMenuManager menuManager = bars.getMenuManager();
        menuManager.add(this.fActionShowPreferences);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#ValidatorViewPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ValidatorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        manager.add(this.fActionValidate);
        manager.add((IContributionItem)new Separator());
        if (this.isIssueObjectSelected(selection)) {
            manager.add(this.fActionSelectObjects);
        }
        if (this.isIssueSelected(selection)) {
            manager.add(this.fActionExplain);
        }
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionShowPreferences);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getControl().setFocus();
        }
    }

    public ValidatorViewer getViewer() {
        return this.fViewer;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this || part == null) {
            return;
        }
        IArchimateModel model = (IArchimateModel)part.getAdapter(IArchimateModel.class);
        if (model != null) {
            this.fModel = model;
        }
        this.fActionValidate.setEnabled(this.fModel != null);
    }

    void selectObjects(IStructuredSelection selection) {
        if (selection != null) {
            ITreeModelView view;
            ArrayList<IArchimateConcept> treeList = new ArrayList<IArchimateConcept>();
            ArrayList<IDiagramModel> viewList = new ArrayList<IDiagramModel>();
            ArrayList<IDiagramModelComponent> viewComponentList = new ArrayList<IDiagramModelComponent>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof IIssue) {
                    IIssue issue = (IIssue)o;
                    if (issue.getObject() instanceof IArchimateConcept) {
                        treeList.add((IArchimateConcept)issue.getObject());
                    } else if (issue.getObject() instanceof IDiagramModel) {
                        viewList.add((IDiagramModel)issue.getObject());
                    } else if (issue.getObject() instanceof IDiagramModelComponent) {
                        viewList.add(((IDiagramModelComponent)issue.getObject()).getDiagramModel());
                        viewComponentList.add((IDiagramModelComponent)issue.getObject());
                    }
                }
                ++n2;
            }
            if (!treeList.isEmpty() && (view = (ITreeModelView)ViewManager.showViewPart((String)"com.archimatetool.editor.treeModelView", (boolean)false)) != null) {
                view.getViewer().setSelection((ISelection)new StructuredSelection(treeList), true);
            }
            if (!viewList.isEmpty()) {
                for (IDiagramModel dm : viewList) {
                    IDiagramModelEditor editor = EditorManager.openDiagramEditor((IDiagramModel)dm, (boolean)false);
                    if (editor == null) continue;
                    this.getSite().getShell().getDisplay().asyncExec(() -> editor.selectObjects(viewComponentList.toArray()));
                }
            }
        }
    }

    @Override
    public void validateModel() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ValidatorView.this.updateStatusBar();
                Validator validator = new Validator(ValidatorView.this.fModel);
                List<Object> result = validator.validate();
                ValidatorView.this.fViewer.setInput(result);
                ValidatorView.this.fViewer.expandAll();
            }
        });
    }

    private void updateStatusBar() {
        if (this.fModel != null) {
            this.getViewSite().getActionBars().getStatusLineManager().setMessage(ArchiLabelProvider.INSTANCE.getImage((Object)this.fModel), ArchiLabelProvider.INSTANCE.getLabel((Object)this.fModel));
        } else {
            this.getViewSite().getActionBars().getStatusLineManager().setMessage(null, "");
        }
    }

    private void updateMenuItems(IStructuredSelection selection) {
        this.fActionExplain.setEnabled(this.isIssueSelected(selection));
    }

    private boolean isIssueSelected(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IIssue) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isIssueObjectSelected(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IIssue && ((IIssue)o).getObject() != null && ((IIssue)o).getObject() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        return (T)super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "com.archimatetool.editor";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (propertyName == "IEditorModelManager.model.removed" && this.fModel == newValue) {
            this.fModel = null;
            this.fViewer.setInput(null);
            this.fActionValidate.setEnabled(false);
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        IEditorModelManager.INSTANCE.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.validatorViewHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.ValidatorView_3;
    }
}

